/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.animator.PerformableAction;
import animal.misc.AnimalTranslator;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalAction
extends Animator {
    public static final int DOCUMENTATION_ACTION = 1;
    private static final String DOCUMENTATION_LABEL = "Documentation";
    public static final int QUESTION_ACTION = 2;
    private static final String QUESTION_LABEL = "Question";
    public static final String TYPE_LABEL = "ExternalAction";
    private static final long serialVersionUID = 4275863619518931027L;
    private static Hashtable<String, PerformableAction> CurrentActions;
    private String actionKey = null;
    private int type = 1;
    public boolean used = false;

    public ExternalAction() {
    }

    public ExternalAction(int step, int theType, String key, PerformableAction action) {
        super(step, new int[]{-1});
        if (CurrentActions == null) {
            CurrentActions = new Hashtable(53);
        }
        this.actionKey = key;
        CurrentActions.put(key, action);
        this.type = theType;
    }

    @Override
    public void action(long time, double ticks) {
        this.execute();
    }

    public static PerformableAction getActionNamed(String name) throws IllegalArgumentException {
        if (CurrentActions.containsKey(name)) {
            return CurrentActions.get(name);
        }
        throw new IllegalArgumentException(AnimalTranslator.translateMessage("noSuchKeyException", new Object[]{name}));
    }

    @Override
    public String getAnimatorName() {
        if (this.type == 1) {
            return DOCUMENTATION_LABEL;
        }
        if (this.type == 2) {
            return QUESTION_LABEL;
        }
        if (this.actionKey != null && CurrentActions.containsKey(this.actionKey)) {
            return CurrentActions.get(this.actionKey).toString();
        }
        return TYPE_LABEL;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    public String getActionKey() {
        return this.actionKey;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    public int getTypeID() {
        return this.type;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{QUESTION_LABEL, DOCUMENTATION_LABEL, TYPE_LABEL};
    }

    @Override
    public void discard() {
        super.discard();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("external action");
        if (this.actionKey != null && CurrentActions.containsKey(this.actionKey)) {
            sb.append(": ").append(CurrentActions.get(this.actionKey).toString());
        } else {
            sb.append(" to ").append(this.actionKey).append(" on ").append(super.toString());
        }
        return sb.toString();
    }

    public static void clearActions() {
        if (CurrentActions == null) {
            CurrentActions = new Hashtable();
        }
        CurrentActions.clear();
    }

    public static void resetActions() {
    }

    public static Hashtable<String, PerformableAction> getCurrentActions() {
        return CurrentActions;
    }
}

