/*
 * Decompiled with CFR 0.152.
 */
package algorithm.search;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.animalTranslator.codeItems.Hidden;
import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Off;
import algorithm.animalTranslator.codeItems.Pos;
import algorithm.animalTranslator.codeItems.TimeOffset;
import algorithm.animalTranslator.codeItems.Timing;
import algorithm.animalTranslator.codeItems.WithinTiming;

public class BinarySearch {
    private AnimalTranslator at;
    private int[] intA;
    private int toSearch;
    private boolean initialized = false;
    private String arrayName;
    private String javaCodeName;
    private String algorithmName;
    private String markerLName;
    private String markerRName;
    private String markerMidElemName;
    private String legendeLName;
    private String legendeMidElemName;
    private String legendeRName;
    private int l;
    private int r;
    private int midElem;
    private int[] markedLinesInAlgorithm;
    private int[] markedLinesInJavaCode;
    private boolean interpolation = false;
    private boolean javaCode = false;
    private int counterNebenRechnung = 0;

    public BinarySearch(AnimalTranslator newAT, boolean displayJavaCode) {
        this(newAT, false, displayJavaCode);
    }

    public BinarySearch() {
    }

    BinarySearch(AnimalTranslator newAT, boolean interpolationSearch, boolean displayJavaCode) {
        this.at = newAT;
        this.interpolation = interpolationSearch;
        this.javaCode = displayJavaCode;
    }

    public void initialize(int[] intArrayToSort, int toBeSearched) {
        this.intA = intArrayToSort;
        this.toSearch = toBeSearched;
        this.arrayName = this.interpolation ? "InterpolationSearchArray" : "BinarySearchArray";
        this.javaCodeName = this.interpolation ? "CodeGroup_IntSearchIterativ" : "CodeGroup_BinSearchIterativ";
        this.algorithmName = "CodeGroup_Algorithm";
        this.markerLName = "l";
        this.markerRName = "r";
        this.markerMidElemName = "midElem";
        this.legendeLName = "legendeL";
        this.legendeMidElemName = "legendeMidElem";
        this.legendeRName = "legendeR";
        this.l = -1;
        this.r = -1;
        this.midElem = -1;
        this.initialized = true;
    }

    public int generateAnimation() throws Exception {
        if (!this.initialized) {
            throw new Exception("Instance of BinarySearch has not been initialized!");
        }
        this.at.advancedAddHeaderMM(this.interpolation ? "Interpolationssuche" : "Binaere Suche");
        this.displayInitialScreen();
        this.displaySortingScreen();
        return this.binSearchIterativ(this.intA, this.toSearch);
    }

    private void displayInitialScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("initial screen");
        this.at.advancedCreateWorkSheet();
        this.at.addText("sollSortiert", this.interpolation ? "Interpolationssuche" : "Binaere Suche", new Pos(400, 150), "color black size 40 bold", null);
        this.at.compositeStepEnd();
        this.at.compositeStepStart();
        this.at.addText("sollSortiert2", "funktioniert nur auf", new Off(-200, 150, "sollSortiert", "S"), "color red size 40", null);
        this.at.addText("sollSortiert3", "vorsortierten Daten!!", new Off(0, 60, "sollSortiert2", "SW"), "color red size 40", null);
        this.at.addText("sollSortiert4", "(ansonsten wird gesuchtes Element in der Regel nicht gefunden)", new Off(-100, 50, "sollSortiert3", "SW"), "color red size 20", null);
        if (this.interpolation) {
            this.at.addText("comment1", "Die Interpolationssuche entspricht konzeptuell der Suche im Telefonbuch", new Off(-200, 100, "sollSortiert4", "SW"), "color black size 25", null);
            this.at.addText("comment2", "- Aufschlagen einer m\u00c3\u00b6glichen Seite und schauen, wo man sich befindet", new Off(0, 40, "comment1", "SW"), "color black size 25", null);
            this.at.addText("comment3", "- Je nach Entfernung des gew\u00c3\u00bcnschten Eintrags vom aktuellen bl\u00c3\u00a4ttert", new Off(0, 40, "comment2", "SW"), "color black size 25", null);
            this.at.addText("comment4", "  man entsprechend weit vor bzw. zur\u00c3\u00bcck.", new Off(0, 25, "comment3", "SW"), "color black size 25", null);
        }
        this.at.compositeStepEnd();
    }

    private void displaySortingScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("searching screen");
        this.at.hide(new String[]{"sollSortiert", "sollSortiert2", "sollSortiert3", "sollSortiert3a", "sollSortiert3b", "sollSortiert4", "comment1", "comment2", "comment3", "comment4"}, null);
        this.at.advancedTextLine("headline", new Pos(300, 70), "color black size 30 bold", null, String.valueOf(this.interpolation ? "Interpolationssuche" : "Binaere Suche") + " nach dem Element: " + this.toSearch);
        this.at.advancedArrayReduction(this.arrayName, (Node)new Off(-200, 120, "headline", "NW"), this.intA);
        this.at.addArrayMarker(this.markerLName, this.arrayName, 0, "color blue", new Hidden());
        this.at.addArrayMarker(this.markerRName, this.arrayName, this.intA.length - 1, "color green3", new Hidden());
        this.at.addArrayMarker(this.markerMidElemName, this.arrayName, this.intA.length - 1, "color red", new Hidden());
        this.at.advancedTextLine(this.legendeLName, new Off(0, -25, this.arrayName, "NW"), "color blue size 15", null, "(l) linke Grenze betrachtetes Feld");
        this.at.advancedTextLine(this.legendeMidElemName, new Off(30, 0, this.legendeLName, "NE"), "color red size 15", null, this.interpolation ? "(midElem) interpolierte Position des gesuchen Elements" : "(midElem) mittleres Element des betrachteten Feldes");
        this.at.advancedTextLine(this.legendeRName, new Off(30, 0, this.legendeMidElemName, "NE"), "color green3 size 15", null, "(r) rechte Grenze betrachtetes Feld");
        this.at.hide(new String[]{this.legendeLName, this.legendeMidElemName, this.legendeRName}, null);
        if (!this.javaCode) {
            this.at.advancedCodeGroupStandard(this.algorithmName, new Off(15, 75, this.arrayName, "SW"), new TimeOffset(0), new String[]{"1. Betrachte zun\u00ef\u00bf\u00bdchst das gesamte Feld", this.interpolation ? "2. interpoliere Position des gesuchten Elements im Feld" : "2. Bestimme die mittlere Posistion des (Teil-)Feldes", this.interpolation ? "   midElem = l + ((x - a[l]) * (r - l)) / (a[r] - a[l]);" : "   midElem = (l + r) / 2;", this.interpolation ? "3. Ist das interpolierte Element gleich dem gesuchten?" : "3. Ist das Element in der Mitte gleich dem gesuchten?", "   - Falls ja, weiter bei Schritt 7 (gefunden)", "4. Ist das betrachtete Feld weiter teilbar? (min. 2 Elemente)", "   - falls nein, weiter bei Schritt 7 (nicht gefunden)", this.interpolation ? "5. Ist das gesuchte Element kleiner als das interpolierte?" : "5. Ist das gesuchte Element kleiner als das mittlere?", "   - Falls ja, betrachte nun das linke Teilfeld", "   - Andernfalls betrachte das rechte Teilfeld", "6. Gehe zu Schritt 2 mit dem neuen Teilfeld", "7. Gib den entsprechenden Wert zur\u00ef\u00bf\u00bdck", "   - (-1) falls nicht gefunden", this.interpolation ? "   - Ansonsten wurde das Element an der interpolierten Position im" : "   - Ansonsten wurde das Element an der mittleren Position des", this.interpolation ? "     zuletzt betrachteten Teilfeld gefunden." : "     zuletzt betrachteten Teilfeldes gefunden."});
            this.at.addText("nebenrechnung", "Nebenrechnung zu Punkt 2:", new Off(50, 33, this.algorithmName, "NE"), "color black size 20", null);
        } else {
            int[] nArray = new int[19];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 1;
            nArray[4] = 1;
            nArray[5] = 1;
            nArray[6] = 2;
            nArray[7] = 3;
            nArray[8] = 2;
            nArray[9] = 3;
            nArray[10] = 2;
            nArray[11] = 2;
            nArray[12] = 1;
            nArray[13] = 1;
            nArray[14] = 2;
            nArray[15] = 1;
            nArray[16] = 2;
            nArray[17] = 1;
            this.at.advancedCodeGroupStandard(this.javaCodeName, new Off(15, 75, this.arrayName, "SW"), new TimeOffset(0), new String[]{"private int binSearchIterativ(int[] a, int x) {", "if (a == null || a.length == 0) {", "return -1;", "}", this.interpolation ? "int l = 0, r = a.length - 1, midElem = l + ((x - a[l]) * (r - l)) / (a[r] - a[l]);" : "int l = 0, r = a.length - 1, midElem = (l + r) / 2;", "while (a[midElem] != x && r > l) {", "if (x < a[midElem]) {", "r = midElem - 1;", "} else {", "l = midElem + 1;", "}", this.interpolation ? "midElem = l + ((x - a[l]) * (r - l)) / (a[r] - a[l]);" : "midElem = (l + r) / 2;", "}", "if (a[midElem] == x) {", "return midElem;", "} else {", "return -1;", "}", "}"}, nArray);
            this.at.addText("nebenrechnung", "Nebenrechnung zur Berechnung von midElem:", new Off(-20, 150, this.javaCodeName, "NE"), "color black size 20", null);
        }
        this.at.compositeStepEnd();
    }

    private int binSearchIterativ(int[] a, int x) {
        if (a == null || a.length == 0) {
            return this.returnResult(-1);
        }
        this.setL(0);
        this.setR(a.length - 1);
        if (!this.interpolation) {
            this.setMidElem((this.l + this.r) / 2, a, x);
        } else {
            this.setMidElem(this.l + (x - a[this.l]) * (this.r - this.l) / (a[this.r] - a[this.l]), a, x);
        }
        while (a[this.midElem] != x && this.r > this.l) {
            this.codeMarkingForWhile();
            if (x < a[this.midElem]) {
                this.setR(this.midElem - 1);
            } else {
                this.setL(this.midElem + 1);
            }
            if (!this.interpolation) {
                this.setMidElem((this.l + this.r) / 2, a, x);
                continue;
            }
            this.setMidElem(this.l + (x - a[this.l]) * (this.r - this.l) / (a[this.r] - a[this.l]), a, x);
        }
        if (a[this.midElem] == x) {
            return this.returnResult(this.midElem);
        }
        return this.returnResult(-1);
    }

    private void setL(int newValue) {
        this.at.compositeStepStart();
        if (this.l == -1) {
            this.at.show(this.legendeLName, null);
            this.at.moveArrayMarker(this.markerLName, newValue, (Timing)new WithinTiming(0));
            this.at.show(this.markerLName, null);
            this.markLines(new int[1], new int[]{4});
            this.l = newValue;
            this.at.compositeStepEnd();
        } else {
            this.at.moveArrayMarker(this.markerLName, newValue, (Timing)new WithinTiming(1000));
            this.markLines(new int[]{7, 9}, new int[]{6, 8, 9});
            this.at.advancedHighlightArrayCells(this.arrayName, this.l, newValue - 1);
            this.l = newValue;
            this.at.compositeStepEnd();
            this.markLines(new int[]{10}, null);
        }
    }

    private void setR(int newValue) {
        this.at.compositeStepStart();
        if (this.r == -1) {
            this.at.show(this.legendeRName, null);
            this.at.moveArrayMarker(this.markerRName, newValue, (Timing)new WithinTiming(0));
            this.at.show(this.markerRName, null);
            this.r = newValue;
            this.at.compositeStepEnd();
        } else {
            this.at.moveArrayMarker(this.markerRName, newValue, (Timing)new WithinTiming(1000));
            this.markLines(new int[]{7, 8}, new int[]{6, 7});
            this.at.advancedHighlightArrayCells(this.arrayName, newValue + 1, this.r);
            this.r = newValue;
            this.at.compositeStepEnd();
            this.markLines(new int[]{10}, null);
        }
    }

    private void setMidElem(int newValue, int[] a, int x) {
        this.at.compositeStepStart();
        if (this.midElem == -1) {
            this.at.show(this.legendeMidElemName, null);
            this.at.highlightArrayElem(this.arrayName, newValue, null, null);
            this.at.moveArrayMarker(this.markerMidElemName, newValue, (Timing)new WithinTiming(0));
            this.at.show(this.markerMidElemName, null);
            this.markLines(new int[]{1, 2}, null);
        } else {
            this.at.advancedHighlightArrayElemSwitch(this.arrayName, this.midElem, newValue);
            this.at.moveArrayMarker(this.markerMidElemName, newValue, (Timing)new WithinTiming(1000));
            this.markLines(new int[]{1, 2}, new int[]{11});
        }
        if (this.interpolation) {
            this.displayNebenrechnung(String.valueOf(this.l) + " + ((" + x + " - " + a[this.l] + ") * (" + this.r + " - " + this.l + ")) / (" + a[this.r] + " - " + a[this.l] + "))", "= " + this.l + " + " + (x - a[this.l]) * (this.r - this.l) + " / " + (a[this.r] - a[this.l]) + " = " + newValue);
        } else {
            this.displayNebenrechnung("(" + this.l + " + " + this.r + ") / 2", "= " + newValue);
        }
        this.midElem = newValue;
        this.at.compositeStepEnd();
    }

    private void codeMarkingForWhile() {
        this.markLines(new int[]{3}, new int[]{5});
        this.markLines(new int[]{5}, null);
        this.markLines(new int[]{7}, new int[]{6});
    }

    private int returnResult(int result) {
        if (result == -1) {
            this.markLines(new int[]{3}, new int[]{5});
            this.markLines(new int[]{5}, null);
            this.at.compositeStepStart();
            this.at.advancedHighlightArrayCell(this.arrayName, this.midElem);
            this.markLines(new int[]{5, 6}, new int[]{13});
            this.at.compositeStepEnd();
            this.at.compositeStepStart();
            this.markLines(new int[]{11, 12}, new int[]{13, 15, 16});
            if (!this.javaCode) {
                this.at.advancedTextLine("Ergebnis", new Off(130, 100, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde nicht gefunden!");
            } else {
                this.at.advancedTextLine("Ergebnis", new Off(130, 100, this.javaCodeName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde nicht gefunden!");
            }
            this.at.compositeStepEnd();
        } else {
            this.markLines(new int[]{3}, new int[]{5});
            this.markLines(new int[]{3, 4}, new int[]{13});
            this.at.compositeStepStart();
            this.markLines(new int[]{11, 13, 14}, new int[]{13, 14});
            if (!this.javaCode) {
                this.at.advancedTextLine("Ergebnis", new Off(130, 50, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde bei index " + this.midElem + " gefunden!");
            } else {
                this.at.advancedTextLine("Ergebnis", new Off(130, 50, this.javaCodeName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde bei index " + this.midElem + " gefunden!");
            }
            this.at.advancedTextLine("Ergebnis2", new Off(200, 15, "Ergebnis", "SW"), "color blue size 15", new TimeOffset(0), "(der index beginnt bei 0 und geht bis a.length - 1)");
            this.at.compositeStepEnd();
        }
        this.at.addLabel("SortingResult");
        return result;
    }

    private void markLines(int[] linesInAlgorithm, int[] linesInJavaCode) {
        if (linesInAlgorithm == null && linesInJavaCode == null) {
            System.out.println("useless call of markLines in Binary-Search - all parameters null");
        } else if (!(linesInAlgorithm == null && !this.javaCode || linesInJavaCode == null && this.javaCode)) {
            int i;
            this.at.compositeStepStart();
            if (this.markedLinesInAlgorithm == null) {
                this.markedLinesInAlgorithm = new int[0];
            }
            if (this.markedLinesInJavaCode == null) {
                this.markedLinesInJavaCode = new int[0];
            }
            if (linesInAlgorithm != null && !this.javaCode) {
                i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.unhighlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
                this.markedLinesInAlgorithm = linesInAlgorithm;
                i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.highlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
            }
            if (linesInJavaCode != null && this.javaCode) {
                i = 0;
                while (i < this.markedLinesInJavaCode.length) {
                    this.at.unhighlightCode(this.javaCodeName, this.markedLinesInJavaCode[i], "", null);
                    ++i;
                }
                this.markedLinesInJavaCode = linesInJavaCode;
                i = 0;
                while (i < this.markedLinesInJavaCode.length) {
                    this.at.highlightCode(this.javaCodeName, this.markedLinesInJavaCode[i], "", null);
                    ++i;
                }
            }
            this.at.compositeStepEnd();
        }
    }

    private void displayNebenrechnung(String txt1, String txt2) {
        if (this.counterNebenRechnung > 0) {
            this.at.hide("Nebenrechnung" + this.counterNebenRechnung, null);
            this.at.hide("NebenrechnungZwei" + this.counterNebenRechnung, null);
        }
        ++this.counterNebenRechnung;
        this.at.addText("Nebenrechnung" + this.counterNebenRechnung, txt1, new Off(0, 20, "nebenrechnung", "SW"), "color black size 20", null);
        this.at.addText("NebenrechnungZwei" + this.counterNebenRechnung, txt2, new Off(0, 20, "Nebenrechnung" + this.counterNebenRechnung, "SW"), "color black size 20", null);
    }
}

