/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.fileHandler.FileHandler;
import algorithm.search.BinarySearch;
import algorithm.search.InterpolationSearch;
import algorithm.search.SequentialSearch;
import algorithm.stringSearch.BMStringSearch;
import algorithm.stringSearch.BruteForceStringSearch;
import algorithm.stringSearch.KMPStringSearch;

public class AlgorithmGenerator {
    private FileHandler fh;
    private AnimalTranslator at;

    public void setFileName(String fileName) {
        this.fh.setFileName(fileName);
    }

    public void saveToFile() {
        this.fh.save();
    }

    public void saveToFile(String fileName) {
        this.fh.setFileName(fileName);
        this.saveToFile();
    }

    public AlgorithmGenerator() {
        try {
            this.fh = new FileHandler();
            this.at = new AnimalTranslator(this.fh);
            System.out.println("AlgorithmGenerator initialized");
        }
        catch (Exception ex) {
            System.out.println("error initializing AlgorithmGenerator:");
            System.out.println("     " + ex.getMessage());
        }
    }

    public AlgorithmGenerator(String fileName) {
        try {
            this.fh = new FileHandler(fileName);
            this.at = new AnimalTranslator(this.fh);
            System.out.println("AlgorithmGenerator initialized");
        }
        catch (Exception ex) {
            System.out.println("error initializing AlgorithmGenerator:");
            System.out.println("     " + ex.getMessage());
        }
    }

    public void generateBinarySearch(int[] dataArray, int toSearch, boolean displayJava) {
        try {
            BinarySearch binS = new BinarySearch(this.at, displayJava);
            binS.initialize(dataArray, toSearch);
            binS.generateAnimation();
            System.out.println("BinarySearch-animation created");
        }
        catch (Exception ex) {
            System.out.println("error creating algorithm for binary search:");
            System.out.println("     " + ex.getMessage());
        }
    }

    public void generateInterpolationSearch(int[] dataArray, int toSearch, boolean displayJava) {
        try {
            InterpolationSearch itS = new InterpolationSearch(this.at, displayJava);
            itS.initialize(dataArray, toSearch);
            itS.generateAnimation();
            System.out.println("InterpolationSearch-animation created");
        }
        catch (Exception ex) {
            System.out.println("error creating algorithm for interpolation-search:");
            System.out.println("     " + ex.getMessage());
        }
    }

    public void generateSequentialSearch(int[] dataArray, int toSearch, boolean displayJava) {
        try {
            SequentialSearch seqS = new SequentialSearch(this.at, displayJava);
            seqS.initialize(dataArray, toSearch);
            seqS.generateAnimation();
            System.out.println("SequentialSearch-animation created");
        }
        catch (Exception ex) {
            System.out.println("error creating algorithm for sequential search:");
            System.out.println("     " + ex.getMessage());
        }
    }

    public void generateBruteForceStringSearch(String text, String toSearch) {
        try {
            BruteForceStringSearch bfSS = new BruteForceStringSearch(this.at);
            bfSS.initialize(text, toSearch);
            bfSS.generateAnimation();
            System.out.println("BruteforceStringSearch-animation created");
        }
        catch (Exception ex) {
            System.out.println("error creating algorithm for bruteforceStringSearch:");
            System.out.println("     " + ex.getMessage());
        }
    }

    public void generateKMPStringSearch(String text, String toSearch) {
        try {
            KMPStringSearch kMPSS = new KMPStringSearch(this.at);
            kMPSS.initialize(text, toSearch);
            kMPSS.generateAnimation();
            System.out.println("KMP-StringSearch-animation created");
        }
        catch (Exception ex) {
            System.out.println("error creating algorithm for KMP-StringSearch:");
            System.out.println("     " + ex.getMessage());
        }
    }

    public void generateBMStringSearch(String text, String toSearch) {
        try {
            BMStringSearch bMSS = new BMStringSearch(this.at);
            bMSS.initialize(text, toSearch);
            bMSS.generateAnimation();
            System.out.println("BM-StringSearch-animation created");
        }
        catch (Exception ex) {
            System.out.println("error creating algorithm for BM-StringSearch:");
            System.out.println("     " + ex.getMessage());
        }
    }
}

