/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import translator.Debug;
import translator.ResourceLocator;
import translator.Translator;

public class ExtendedResourceBundle {
    public static final String ASCII_FORMAT = "ascii";
    public static final String PROPERTY_FORMAT = "properties";
    private Translator translator = null;
    PropertyResourceBundle bundle = null;
    Vector<ExtendedResourceBundle> componentBundles = new Vector(22);

    public ExtendedResourceBundle(String filename) {
        this(filename, PROPERTY_FORMAT);
    }

    public ExtendedResourceBundle(String filename, String formatName) {
        try {
            InputStream in = ResourceLocator.getResourceLocator().getResourceStream(filename);
            if (PROPERTY_FORMAT.equalsIgnoreCase(formatName)) {
                this.bundle = new PropertyResourceBundle(new BufferedReader(new InputStreamReader(in)));
            }
            if (this.bundle != null) {
                Enumeration<String> keys = this.bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.startsWith("@import")) continue;
                    ExtendedResourceBundle newBundle = new ExtendedResourceBundle(this.bundle.getString(key));
                    this.componentBundles.add(newBundle);
                }
            }
        }
        catch (IOException ioException) {
            Debug.printlnMessage(this.getTranslator().translateMessage("verboseException", new Object[]{"(String) [constructor]", this.getClass().getName(), ioException.getMessage(), "(no information available)", ioException.getClass().getName()}));
        }
        catch (IllegalArgumentException illArg) {
            System.err.println(illArg.getMessage());
        }
    }

    public String[] getKeys() {
        Vector<String> v = new Vector<String>(128);
        String key = null;
        if (this.componentBundles != null) {
            for (ExtendedResourceBundle partBundle : this.componentBundles) {
                String[] defaultKeys;
                String[] stringArray = defaultKeys = partBundle.getKeys();
                int n = defaultKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String localKey = stringArray[n2];
                    v.addElement(localKey);
                    ++n2;
                }
            }
        }
        Enumeration<String> e = this.bundle.getKeys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            if (v.contains(key)) continue;
            v.addElement(key);
        }
        String[] result = new String[v.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)v.elementAt(i);
            ++i;
        }
        return result;
    }

    public String getMessage(String key) {
        return this.getMessage(key, true);
    }

    public String getMessage(String key, boolean warnOnError) {
        String message;
        block5: {
            message = null;
            try {
                if (this.bundle != null && this.bundle.handleGetObject(key) != null) {
                    message = this.bundle.getString(key);
                }
                if (message != null || this.componentBundles == null) break block5;
                for (ExtendedResourceBundle additionalBundle : this.componentBundles) {
                    message = additionalBundle.getMessage(key, false);
                    if (message == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (this.bundle == null || !warnOnError || "noSuchKeyException".equalsIgnoreCase(key)) break block5;
                Debug.printlnMessage("A:" + this.getTranslator().translateMessage("noSuchKeyException", new Object[]{key}));
            }
        }
        return message;
    }

    public Translator getTranslator() {
        if (this.translator == null) {
            this.translator = new Translator("en", Locale.US);
        }
        return this.translator;
    }

    public void printProperties() {
        this.printProperties(System.out);
    }

    public void printProperties(PrintStream outputStream) {
        if (this.bundle == null) {
            return;
        }
        String[] keys = this.getKeys();
        String key = null;
        if (keys != null) {
            int nrKeys = keys.length;
            int i = 0;
            while (i < nrKeys) {
                key = keys[i];
                outputStream.println("key: '" + key + "' entry: '" + this.getMessage(key) + "'");
                ++i;
            }
        }
    }

    public void setTranslator(Translator trans) {
        this.translator = trans == null ? new Translator() : trans;
    }
}

