/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

import animal.misc.XProperties;

public abstract class StringArraySupport {
    static int arrayCode = 0;
    protected String[] arrayData = null;
    protected String arrayName = "array";
    protected XProperties props = new XProperties();
    protected int nrAssignments = 0;
    protected int nrComparisons = 0;
    protected StringBuilder sbuf = null;
    protected String assCounterID = null;
    protected String compCounterID = null;

    public StringArraySupport(StringBuilder outputBuffer, String[] arrayParam) {
        this(outputBuffer, "array" + arrayCode++, arrayParam);
    }

    public StringArraySupport(StringBuilder outputBuffer, String label, String[] arrayParam) {
        this(outputBuffer, label, arrayParam, new StringBuilder(Short.MAX_VALUE));
    }

    public StringArraySupport(StringBuilder outputBuffer, String label, String[] theArray, StringBuilder targetBuffer) {
        this(outputBuffer, label, theArray, targetBuffer, "black", "white", "black", "blue", "gray");
    }

    public StringArraySupport(StringBuilder outputBuffer, String label, String[] theArray, StringBuilder targetBuffer, String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor) {
        this(outputBuffer, label, theArray, targetBuffer, outlineColor, fillColor, elementColor, elementHighlightColor, cellHighlightColor, 20, 80);
    }

    public StringArraySupport(StringBuilder outputBuffer, String label, String[] theArray, StringBuilder targetBuffer, String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor, int x, int y) {
        this.sbuf = outputBuffer;
        if (this.sbuf == null) {
            this.sbuf = new StringBuilder(32768);
        }
        this.setArrayName(label);
        this.arrayData = new String[theArray.length];
        System.arraycopy(theArray, 0, this.arrayData, 0, theArray.length);
        this.setLocalBuffer(targetBuffer);
        this.installBasicArray(outlineColor, fillColor, elementColor, elementHighlightColor, cellHighlightColor, x, y);
    }

    public void installBasicArray() {
        this.installBasicArray("black", "white", "black", "blue", "gray");
    }

    public void installBasicArray(String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor) {
        this.installBasicArray(outlineColor, fillColor, elementColor, elementHighlightColor, cellHighlightColor, 20, 80);
    }

    public abstract void installBasicArray(String var1, String var2, String var3, String var4, String var5, int var6, int var7);

    public int getLength() {
        if (this.arrayData == null) {
            return 0;
        }
        return this.arrayData.length;
    }

    public int getNrAssignments() {
        return this.nrAssignments;
    }

    public int getNrComparisons() {
        return this.nrComparisons;
    }

    public void incrementAssignments() {
        this.incrementAssignments(1);
    }

    public void incrementAssignments(int howMuch) {
        this.nrAssignments += howMuch;
    }

    public void incrementComparisons() {
        this.incrementComparisons(1);
    }

    public void incrementComparisons(int howMuch) {
        this.nrComparisons += howMuch;
    }

    public void setLocalBuffer(StringBuilder targetBuffer) {
        this.sbuf = targetBuffer;
    }

    public String getArrayName() {
        if (this.arrayName == null) {
            this.arrayName = "array" + arrayCode;
            ++arrayCode;
        }
        return this.arrayName;
    }

    public void setArrayName(String name) {
        this.arrayName = name;
    }

    public StringBuilder getLocalBuffer() {
        if (this.sbuf == null) {
            this.sbuf = new StringBuilder(32768);
        }
        return this.sbuf;
    }

    public void swap(int firstIndex, int secondIndex) {
        this.swap(firstIndex, secondIndex, 10);
    }

    public void swap(int firstIndex, int secondIndex, int duration) {
        int length = this.getLength();
        if (length == 0 || firstIndex < 0 || firstIndex > length || secondIndex < 0 || secondIndex > length) {
            return;
        }
        String tmp = this.arrayData[secondIndex];
        this.arrayData[secondIndex] = this.arrayData[firstIndex];
        this.arrayData[firstIndex] = tmp;
        this.incrementAssignments(3);
    }

    public void putElement(String newVal, int position, int offset, int duration) {
        if (position < 0 || position >= this.getLength()) {
            return;
        }
        this.arrayData[position] = newVal;
        this.incrementAssignments();
    }

    public void putElement(String newVal, int position) {
        this.putElement(newVal, position, 0, 0);
    }

    public String getElementAt(int index) {
        if (this.arrayData == null || index < 0 || index > this.arrayData.length) {
            return "";
        }
        return this.arrayData[index];
    }

    public void printArray() {
        int length = this.getLength();
        if (length > 0) {
            StringBuilder sbuf2 = new StringBuilder(length << 3);
            sbuf2.append("array values: [");
            int i = 0;
            while (i < length - 1) {
                sbuf2.append(this.arrayData[i]).append(", ");
                ++i;
            }
            sbuf2.append(this.arrayData[length - 1]).append("]");
            System.err.println(sbuf2.toString());
            Object var2_2 = null;
        }
    }

    public void highlightArrayCell(int position) {
        this.markPosition(position, position, true, true);
    }

    public void highlightArrayCell(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, true, true);
    }

    public void unhighlightArrayCell(int position) {
        this.markPosition(position, position, true, false);
    }

    public void unhighlightArrayCell(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, true, false);
    }

    public void highlightArrayElement(int position) {
        this.markPosition(position, position, false, true);
    }

    public void highlightArrayElement(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, false, true);
    }

    public void unhighlightArrayElement(int position) {
        this.markPosition(position, position, false, false);
    }

    public void unhighlightArrayElement(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, false, false);
    }

    public void markPosition(int position, boolean turnOn) {
        this.markPosition(position, position, true, turnOn);
    }

    public abstract void markPosition(int var1, int var2, boolean var3, boolean var4);

    public void setCounterIDs(String assignmentID, String comparisonID) {
        this.assCounterID = assignmentID;
        this.compCounterID = comparisonID;
    }
}

