/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

import net.algoanim.aads.StepCounter;

public abstract class IntArraySupport {
    protected StepCounter stepCounter = null;
    static int arrayCode = 0;
    protected int[] arrayData = null;
    protected String arrayName = "array";
    protected int nrAssignments = 0;
    protected int nrComparisons = 0;
    protected StringBuilder sbuf = null;
    protected String assCounterID = null;
    protected String compCounterID = null;

    public IntArraySupport(StringBuilder outputBuffer, String label, int[] theArray, StringBuilder aTargetBuffer, String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor, int x, int y) {
        this.sbuf = outputBuffer;
        if (this.sbuf == null) {
            this.sbuf = new StringBuilder(32768);
        }
        this.setArrayName(label);
        this.arrayData = new int[theArray.length];
        System.arraycopy(theArray, 0, this.arrayData, 0, theArray.length);
        this.installBasicArray(outlineColor, fillColor, elementColor, elementHighlightColor, cellHighlightColor, x, y);
    }

    public abstract void installBasicArray(String var1, String var2, String var3, String var4, String var5, int var6, int var7);

    public int getLength() {
        if (this.arrayData == null) {
            return 0;
        }
        return this.arrayData.length;
    }

    public int getNrAssignments() {
        if (this.stepCounter != null) {
            return this.stepCounter.getNrAssignments();
        }
        return 0;
    }

    public int getNrComparisons() {
        if (this.stepCounter != null) {
            return this.stepCounter.getNrComparisons();
        }
        return 0;
    }

    public void incrementAssignments() {
        if (this.stepCounter != null) {
            this.stepCounter.incrementAssignments(1);
        }
    }

    public void incrementAssignments(int howMuch) {
        if (this.stepCounter != null) {
            this.stepCounter.incrementAssignments(howMuch);
        }
    }

    public void incrementComparisons() {
        if (this.stepCounter != null) {
            this.stepCounter.incrementComparisons(1);
        }
    }

    public void incrementComparisons(int howMuch) {
        if (this.stepCounter != null) {
            this.stepCounter.incrementComparisons(howMuch);
        }
    }

    public void setLocalBuffer(StringBuilder targetBuffer) {
        this.sbuf = targetBuffer;
    }

    public String getArrayName() {
        if (this.arrayName == null) {
            this.arrayName = "array" + arrayCode;
            ++arrayCode;
        }
        return this.arrayName;
    }

    public void setArrayName(String name) {
        this.arrayName = name;
    }

    public StringBuilder getLocalBuffer() {
        if (this.sbuf == null) {
            this.sbuf = new StringBuilder(32768);
        }
        return this.sbuf;
    }

    public void swap(int firstIndex, int secondIndex) {
        this.swap(firstIndex, secondIndex, 10);
    }

    public void swap(int firstIndex, int secondIndex, int duration) {
        int length = this.getLength();
        if (length == 0 || firstIndex < 0 || firstIndex > length || secondIndex < 0 || secondIndex > length) {
            return;
        }
        int tmp = this.arrayData[secondIndex];
        this.arrayData[secondIndex] = this.arrayData[firstIndex];
        this.arrayData[firstIndex] = tmp;
        this.incrementAssignments(3);
    }

    public void putElement(int newVal, int position, int offset, int duration) {
        if (position < 0 || position >= this.getLength()) {
            return;
        }
        this.arrayData[position] = newVal;
        this.incrementAssignments();
    }

    public void putElement(int newVal, int position) {
        this.putElement(newVal, position, 0, 0);
    }

    public int getElementAt(int index) {
        if (this.arrayData == null || index < 0 || index > this.arrayData.length) {
            return Integer.MIN_VALUE;
        }
        return this.arrayData[index];
    }

    public void printArray() {
        int length = this.getLength();
        if (length > 0) {
            StringBuilder sbuf2 = new StringBuilder(length << 3);
            sbuf2.append("array values: [");
            int i = 0;
            while (i < length - 1) {
                sbuf2.append(this.arrayData[i]).append(", ");
                ++i;
            }
            sbuf2.append(this.arrayData[length - 1]).append("]");
            System.err.println(sbuf2.toString());
            Object var2_2 = null;
        }
    }

    public void highlightArrayCell(int position) {
        this.markPosition(position, position, true, true);
    }

    public void highlightArrayCell(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, true, true);
    }

    public void unhighlightArrayCell(int position) {
        this.markPosition(position, position, true, false);
    }

    public void unhighlightArrayCell(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, true, false);
    }

    public void highlightArrayElement(int position) {
        this.markPosition(position, position, false, true);
    }

    public void highlightArrayElement(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, false, true);
    }

    public void unhighlightArrayElement(int position) {
        this.markPosition(position, position, false, false);
    }

    public void unhighlightArrayElement(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, false, false);
    }

    public void markPosition(int position, boolean turnOn) {
        this.markPosition(position, position, true, turnOn);
    }

    public void setStepCounter(StepCounter counterInstance) {
        this.stepCounter = counterInstance;
    }

    public abstract void markPosition(int var1, int var2, boolean var3, boolean var4);

    public void setCounterIDs(String assignmentID, String comparisonID) {
        this.assCounterID = assignmentID;
        this.compCounterID = comparisonID;
    }
}

