/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.parser;

import gfgaa.gui.graphs.AbstractGraph;
import java.io.StreamTokenizer;
import java.util.ArrayList;

public final class ParserUnit {
    public int modus;
    public static final int MODUS_READ_AS_GRAPH = 1;
    public static final int MODUS_READ_AS_MATRIX = 2;
    public int state = -1;
    public static final int STATE_INACTIVE = -1;
    public static final int STATE_LOADING_INFO = 1;
    public static final int STATE_LOADING_NODE = 2;
    public static final int STATE_LOADING_EDGE = 3;
    public static final int STATE_LOADING_MATRIX = 4;
    public static final int STATE_LOADING_OBEREECKE = 5;
    public static final int STATE_LOADING_StartKnoten = 8;
    public static final int STATE_LOADING_ZielKnoten = 9;
    public static final int STATE_FINISHED_PARSING = 6;
    public static final int STATE_PARSING_CANCELD = 7;
    private int nSize;
    private int cSize;
    public int nrNodes;
    public int give;
    public int done;
    public int[] nVal;
    public char[] cVal;
    public int[][] matrix;
    public AbstractGraph graph;
    public ArrayList<String> errorMessages;

    public ParserUnit(int nSize, int cSize) {
        this.nSize = nSize;
        this.cSize = cSize;
    }

    public void init() {
        this.state = 1;
        this.nVal = new int[this.nSize];
        this.cVal = new char[this.cSize];
        this.matrix = null;
        this.errorMessages = new ArrayList();
        this.give = 0;
        this.done = 0;
    }

    public void addErrorMessage(StreamTokenizer tok, int errorId) {
        String sMes;
        switch (errorId) {
            case 1: {
                sMes = "Graph size error -> The graph has already achieved his maximum size.";
                break;
            }
            case 2: {
                sMes = "Graph size error -> The graph size has been increased to " + this.nrNodes + ".";
                break;
            }
            case 3: {
                sMes = "x-axis position invalid -> xPos has been increased to " + this.nVal[0] + ".";
                break;
            }
            case 4: {
                sMes = "x-axis position invalid -> xPos has been decreased to " + this.nVal[0] + ".";
                break;
            }
            case 5: {
                sMes = "y-axis position invalid -> yPos has been increased to " + this.nVal[1] + ".";
                break;
            }
            case 6: {
                sMes = "y-axis position invalid -> yPos has been decreased to " + this.nVal[1] + ".";
                break;
            }
            case 7: {
                sMes = "Group value invalid -> groupId has been adjusted to 0";
                break;
            }
            case 8: {
                sMes = "Function value invalid -> function has been adjusted to <leiter>";
                break;
            }
            case 9: {
                sMes = "Weight invalid -> Weight was increased to " + this.nVal[0] + ".";
                break;
            }
            case 10: {
                sMes = "Weight invalid -> Weight was decreased to " + this.nVal[0] + ".";
                break;
            }
            case 11: {
                sMes = "Capacity invalid -> Capacity was increased to " + this.nVal[0] + ".";
                break;
            }
            case 12: {
                sMes = "Capacity invalid -> Capacity was decreased to " + this.nVal[0] + ".";
                break;
            }
            case 13: {
                sMes = "Flow invalid -> Flow was increased to " + this.nVal[1] + ".";
                break;
            }
            case 14: {
                sMes = "Flow invalid -> Flow was decreased to " + this.nVal[1] + ".";
                break;
            }
            case 15: {
                sMes = "Invalid Edge Entry -> Edge already exist -> Line ignored";
                break;
            }
            case 16: {
                sMes = "Invalid Edge Entry -> similar Edge already exist -> Line ignored";
                break;
            }
            case 17: {
                sMes = "Graph size error -> The size of the graph must be in the interval [2, " + this.graph.maxsize() + "].";
                break;
            }
            case 18: {
                sMes = "Invalid Node Tag -> Node was already contained -> Line ignored";
                break;
            }
            case 19: {
                sMes = "Invalid Node Tag -> Node Tag out of Range -> Line ignored";
                break;
            }
            case 20: {
                sMes = "Invalid Edge Entry -> One of the Nodes is unknown -> Line ignored";
                break;
            }
            case 21: {
                sMes = "Invalid Node Tag -> Invalid tag Length -> Only first char is used";
                break;
            }
            default: {
                sMes = "Internal Error -> Unknown Error Id";
            }
        }
        this.errorMessages.add("Error in Line " + tok.lineno() + "\t-> " + sMes + "\n");
    }
}

