/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.parser;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Graph;
import algoanim.primitives.generators.Language;
import algoanim.properties.GraphProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class GraphReader {
    public boolean isdirected;
    public boolean isweighted;
    String filename;
    Node[] node;
    int[][] matrix;
    String[] labels;
    int obenlinksx;
    int obenlinksy;
    int NodeAnzahl;
    int xCoordinates;
    int yCoordinates;
    protected Language lang;
    GraphProperties graphprops;
    Graph graph;
    public String startKnoten;
    public String zielKnoten;
    public Node start;
    public Node ziel;

    public GraphReader(String filename) {
        this.filename = filename;
    }

    public Graph readFile() {
        this.lang = new AnimalScript("Warshall Animation", "Madieha und Bouchra", 620, 480);
        this.graphprops = new GraphProperties();
        this.graph = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.filename));
            String eingeleseneZeile = br.readLine();
            eingeleseneZeile = br.readLine();
            while ((eingeleseneZeile = br.readLine()) != null) {
                String name;
                StringTokenizer tokenizer = new StringTokenizer(eingeleseneZeile, " ");
                if (eingeleseneZeile.contains("graphcoordinates")) {
                    tokenizer.nextToken().trim();
                    tokenizer.nextToken().trim();
                    String x = tokenizer.nextToken().trim();
                    this.obenlinksx = Integer.parseInt(x);
                    String y = tokenizer.nextToken().trim();
                    this.obenlinksy = Integer.parseInt(y);
                    eingeleseneZeile = br.readLine();
                }
                if (eingeleseneZeile.contains("graph")) {
                    String s;
                    tokenizer = new StringTokenizer(eingeleseneZeile, " ");
                    tokenizer.nextToken().trim();
                    String dire = tokenizer.nextToken().trim();
                    this.NodeAnzahl = Integer.parseInt(dire);
                    this.node = new Node[this.NodeAnzahl];
                    this.labels = new String[this.NodeAnzahl];
                    this.matrix = new int[this.NodeAnzahl][this.NodeAnzahl];
                    int time = tokenizer.countTokens();
                    if (time != 0 && (s = tokenizer.nextToken().trim()) != null && s.contains("directed")) {
                        this.isdirected = true;
                        this.graphprops.set("directed", true);
                    }
                    if ((time = tokenizer.countTokens()) != 0 && (s = tokenizer.nextToken().trim()) != null && s.contains("weighted")) {
                        this.isweighted = true;
                        this.graphprops.set("weighted", true);
                    }
                }
                if (eingeleseneZeile.contains("startknoten")) {
                    tokenizer = new StringTokenizer(eingeleseneZeile, " ");
                    tokenizer.nextToken().trim();
                    this.startKnoten = tokenizer.nextToken().trim();
                }
                if (eingeleseneZeile.contains("zielknoten")) {
                    tokenizer = new StringTokenizer(eingeleseneZeile, " ");
                    tokenizer.nextToken().trim();
                    this.zielKnoten = tokenizer.nextToken().trim();
                } else {
                    int indexnode = 0;
                    while (eingeleseneZeile.contains("node")) {
                        String KnotenName;
                        tokenizer = new StringTokenizer(eingeleseneZeile, " ");
                        tokenizer.nextToken().trim();
                        this.labels[indexnode] = KnotenName = tokenizer.nextToken().trim();
                        tokenizer.nextToken().trim();
                        name = tokenizer.nextToken().trim();
                        this.xCoordinates = Integer.parseInt(name) + this.obenlinksx;
                        name = tokenizer.nextToken().trim();
                        this.yCoordinates = Integer.parseInt(name) + this.obenlinksy;
                        this.node[indexnode] = new Coordinates(this.xCoordinates, this.yCoordinates);
                        if (KnotenName.equals(this.startKnoten)) {
                            this.start = this.node[indexnode];
                        }
                        if (KnotenName.equals(this.zielKnoten)) {
                            this.ziel = this.node[indexnode];
                        }
                        eingeleseneZeile = br.readLine();
                        ++indexnode;
                    }
                }
                int indexnode = 0;
                int indexzielnode = 0;
                while (eingeleseneZeile != null && eingeleseneZeile.contains("edge")) {
                    String s;
                    tokenizer = new StringTokenizer(eingeleseneZeile, " ");
                    tokenizer.nextToken().trim();
                    name = tokenizer.nextToken().trim();
                    indexnode = this.getNodeByName(name);
                    name = tokenizer.nextToken().trim();
                    indexzielnode = this.getNodeByName(name);
                    int time = tokenizer.countTokens();
                    if (time != 0 && (s = tokenizer.nextToken().trim()) != null && s.contains("weight")) {
                        name = tokenizer.nextToken().trim();
                        int temp = Integer.parseInt(name);
                        if (indexnode != -1 && indexzielnode != -1) {
                            this.matrix[indexnode][indexzielnode] = temp;
                        }
                    } else if (indexnode != -1 && indexzielnode != -1) {
                        this.matrix[indexnode][indexzielnode] = 1;
                    }
                    eingeleseneZeile = br.readLine();
                }
            }
            br.close();
            if (this.matrix != null && this.node != null && this.matrix.length == this.node.length) {
                this.graph = this.lang.newGraph("graph", this.matrix, this.node, this.labels, null, this.graphprops);
                this.graph.setStartKnoten(this.start);
                this.graph.setZielKnoten(this.ziel);
                this.graph.getProperties().set("weighted", this.isweighted);
                this.graph.getProperties().set("directed", this.isdirected);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.graph;
    }

    public int getNodeByName(String name) {
        int index = -1;
        int i = 0;
        while (i < this.labels.length) {
            if (name.equals(this.labels[i])) {
                index = i;
            }
            ++i;
        }
        return index;
    }
}

