/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.graphs.basic;

import gfgaa.gui.EditGraphPanel;
import gfgaa.gui.GraphAlgController;
import gfgaa.gui.components.IntegerTextFieldEx;
import gfgaa.gui.components.SComponent;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.graphs.AbstractEdge;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.AbstractNode;
import gfgaa.gui.graphs.MatrixPanelInterface;
import gfgaa.gui.graphs.basic.Edge;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class MatrixPanel
extends SPanel
implements MatrixPanelInterface {
    private static final long serialVersionUID = -1138675616899090047L;
    final GraphAlgController mainclass;
    int anzKnoten;
    IntegerTextFieldEx[][] weightFields;
    char[] cTab;
    private JLabel sup;
    JButton sizeButton;
    private JButton applyChanges;
    private JButton reset;

    public MatrixPanel(final GraphAlgController mainclass) {
        this.mainclass = mainclass;
        this.mainclass.addPanel(5, this);
        this.anzKnoten = mainclass.getGraph().maxsize();
        this.weightFields = new IntegerTextFieldEx[this.anzKnoten][this.anzKnoten];
        this.cTab = new char[this.anzKnoten];
        this.setLayout(null);
        this.sup = new JLabel();
        this.sup.setFont(new Font("Serif", 1, 18));
        this.sup.setBounds(90, 0, 150, 25);
        this.add(new SComponent(this.sup, new String[]{"Adjazenzmatrix", "Adjacencymatrix"}));
        this.add(this.sup);
        this.add(this.createResetButton());
        this.add(this.createApplyButton());
        this.add(this.createSizeButton());
        int a = 0;
        while (a < this.anzKnoten) {
            int b = 0;
            while (b < this.anzKnoten) {
                this.weightFields[a][b] = new IntegerTextFieldEx(0, 99);
                this.add(this.weightFields[a][b]);
                ++b;
            }
            ++a;
        }
        this.setMatrixVisibility();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
                EditGraphPanel sp = (EditGraphPanel)mainclass.getPanel(1);
                sp.setStaticSplitEnabled(true);
                MatrixPanel.this.refreshPanelComponents();
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                EditGraphPanel sp = (EditGraphPanel)mainclass.getPanel(1);
                MatrixPanel.this.sizeButton.setText("<<");
                String[] text = new String[]{"\u0192ndert die Gr\u02c6\ufb02e des Matrix Panels.", "Changes the size of the matrix panel."};
                MatrixPanel.this.sizeButton.setToolTipText(text[mainclass.getLanguageSettings()]);
                sp.resetSplit();
                sp.setStaticSplitEnabled(false);
            }
        });
        this.changeLanguageSettings(mainclass.getLanguageSettings());
    }

    private JButton createApplyButton() {
        this.applyChanges = new JButton();
        this.applyChanges.setBounds(15, 420, 100, 25);
        this.add(new SComponent(this.applyChanges, new String[]{"Anpassen", "Apply"}, new String[]{"Passt den Graphen anhand der Matrix-Daten an.", "Applys the matrix settings to the graph."}));
        this.applyChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MatrixPanel.this.mainclass.showUserMessage(0)) {
                    AbstractGraph graph = MatrixPanel.this.mainclass.getGraph();
                    int a = 0;
                    while (a < MatrixPanel.this.anzKnoten) {
                        AbstractNode nodeB = graph.getNode(MatrixPanel.this.cTab[a]);
                        int b = 0;
                        while (b < MatrixPanel.this.anzKnoten) {
                            int val = MatrixPanel.this.weightFields[a][b].getValue();
                            AbstractNode nodeA = graph.getNode(MatrixPanel.this.cTab[b]);
                            AbstractEdge edgeAB = nodeA.getEdgeTo(nodeB);
                            if (edgeAB != null) {
                                if (val > 0) {
                                    edgeAB.setWeight(val);
                                } else {
                                    graph.removeEdge(edgeAB);
                                }
                            } else if (val > 0) {
                                edgeAB = new Edge(nodeA, nodeB, val);
                                nodeA.addEdge(edgeAB);
                                nodeB.addAgainstEdge(edgeAB);
                            }
                            ++b;
                        }
                        ++a;
                    }
                    MatrixPanel.this.mainclass.repaint();
                }
            }
        });
        return this.applyChanges;
    }

    private JButton createResetButton() {
        this.reset = new JButton();
        this.reset.setBounds(147, 420, 100, 25);
        this.add(new SComponent(this.reset, new String[]{"Reset", "Reset"}, new String[]{"L\u2030dt die aktuellen Matrix-Daten erneut.", "Resets the matrix settings."}));
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MatrixPanel.this.mainclass.showUserMessage(0)) {
                    MatrixPanel.this.setCurrentWeights();
                }
            }
        });
        return this.reset;
    }

    private JButton createSizeButton() {
        this.sizeButton = new JButton("<<");
        this.sizeButton.setBounds(15, 420, 50, 25);
        this.sizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditGraphPanel sp = (EditGraphPanel)MatrixPanel.this.mainclass.getPanel(1);
                if (MatrixPanel.this.sizeButton.getText().equals("<<")) {
                    MatrixPanel.this.sizeButton.setText(">>");
                    sp.setMaxSplit();
                } else {
                    MatrixPanel.this.sizeButton.setText("<<");
                    sp.resetSplit();
                }
            }
        });
        return this.sizeButton;
    }

    @Override
    public void paint(Graphics g) {
        this.setMatrixVisibility();
        Image offImage = this.createImage(this.getSize().width, this.getSize().height);
        Graphics offGraphics = offImage.getGraphics();
        AbstractGraph aktuGraph = this.mainclass.getGraph();
        offGraphics.setFont(new Font("Serif", 1, 15));
        int size = this.getSize().width / 2;
        int xpos = size - 10 * this.anzKnoten + 10;
        int xpos2 = size - 10 * this.anzKnoten - 10;
        this.sup.setLocation(size - 60, 0);
        this.reset.setLocation(size + 29, 420);
        this.applyChanges.setLocation(size - 75, 420);
        this.sizeButton.setLocation(size - 129, 420);
        int a = 0;
        while (a < aktuGraph.getNumberOfNodes()) {
            AbstractNode node = aktuGraph.getNode(a);
            this.cTab[a] = node.getTag();
            offGraphics.drawString("" + node.getTag(), xpos + 20 * a, 40);
            offGraphics.drawString("" + node.getTag(), xpos2, 60 + 20 * a);
            ++a;
        }
        super.printComponents(offGraphics);
        g.drawImage(offImage, 0, 0, this);
    }

    @Override
    public void refreshPanelComponents() {
        AbstractGraph aktuGraph = this.mainclass.getGraph();
        int a = 0;
        while (a < aktuGraph.getNumberOfNodes()) {
            AbstractNode node = aktuGraph.getNode(a);
            this.cTab[a] = node.getTag();
            ++a;
        }
        this.setMatrixVisibility();
        this.setCurrentWeights();
        String[] text = new String[]{"\u0192ndert die Gr\u02c6\ufb02e des Matrix Panels.", "Changes the size of the matrix panel."};
        this.sizeButton.setToolTipText(text[this.mainclass.getLanguageSettings()]);
    }

    void setCurrentWeights() {
        AbstractGraph currentGraph = this.mainclass.getGraph();
        int a = 0;
        while (a < this.anzKnoten) {
            int b = 0;
            while (b < this.anzKnoten) {
                this.weightFields[b][a].setText("0");
                ++b;
            }
            AbstractNode node = currentGraph.getNode(a);
            int anz = node.getNumberOfEdges();
            b = 0;
            while (b < anz) {
                AbstractEdge edge = node.getEdge(b);
                char cKennung = edge.getTarget().getTag();
                this.weightFields[this.getNodeTabPosition(cKennung)][a].setText("" + edge.getWeight());
                ++b;
            }
            ++a;
        }
    }

    private void setMatrixVisibility() {
        this.anzKnoten = this.mainclass.getGraph().getNumberOfNodes();
        int xpos = this.getSize().width / 2 - 10 * this.anzKnoten + 8;
        AbstractGraph graph = this.mainclass.getGraph();
        boolean gerichtet = graph.isDirected();
        int size = graph.maxsize();
        int a = 0;
        while (a < size) {
            int b = 0;
            while (b < size) {
                this.weightFields[a][b].setBounds(xpos + a * 20, 45 + b * 20, 20, 20);
                this.weightFields[a][b].setVisible(b < this.anzKnoten && a < this.anzKnoten && (gerichtet || !gerichtet && b <= a));
                ++b;
            }
            ++a;
        }
    }

    @Override
    public int[][] getAdjacencyMatrix() {
        this.refreshPanelComponents();
        int anz = this.mainclass.getGraph().getNumberOfNodes();
        int[][] matrix = new int[anz][anz];
        int i = 0;
        while (i < anz) {
            int j = 0;
            while (j < anz) {
                matrix[i][j] = this.weightFields[i][j].getValue();
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    private int getNodeTabPosition(char cTag) {
        int a = 0;
        while (a < this.anzKnoten) {
            if (this.cTab[a] == cTag) {
                return a;
            }
            ++a;
        }
        return -1;
    }
}

