/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.graphs;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.GraphScriptPanel;
import gfgaa.gui.GraphScriptWriter;
import gfgaa.gui.components.FileChooserGSF;
import gfgaa.gui.components.IntegerTextFieldEx;
import gfgaa.gui.components.SComponent;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.AbstractNode;
import gfgaa.gui.graphs.KantenPanelInterface;
import gfgaa.gui.graphs.basic.Uppercorner;
import gfgaa.gui.parser.GraphScriptParser;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class CreateGraphPanel
extends SPanel {
    private static final long serialVersionUID = -4134589278462198483L;
    public GraphAlgController mainclass;
    protected JRadioButton gerichtet;
    protected JRadioButton ungerichtet;
    protected JRadioButton gewichtet;
    protected JRadioButton ungewichtet;
    private JLabel typLabel;
    private JLabel labRadius;
    JComboBox radBox;
    protected JButton clearGraph;
    private JButton transferGraph;
    protected JButton saveFile;
    private JButton loadFileButton;
    private JLabel graphObenLinksLab;
    IntegerTextFieldEx graphObenLinksX;
    IntegerTextFieldEx graphObenLinksY;
    private JComboBox nodeBox;
    JComboBox startNodeBox;
    JComboBox zielNodeBox;
    private JLabel startNodeLab;
    private JLabel zielNodeLab;

    public CreateGraphPanel(GraphAlgController mainclass) {
        this.mainclass = mainclass;
        this.mainclass.addPanel(3, this);
        this.setLayout(null);
        this.add(this.createTransferButton());
        this.add(this.createSaveButton());
        this.add(this.createLoadButton());
        this.createGraphCoordinats();
        this.createRadioButtons1(this);
        this.createRadioButtons2(this);
        this.createRadiusComboBox(this);
        this.createStartZielGraph();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                CreateGraphPanel.this.refreshPanelComponents();
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }
        });
    }

    protected abstract JButton createClearButton();

    private JButton createLoadButton() {
        this.loadFileButton = new JButton();
        this.loadFileButton.setBounds(45, 370, 200, 25);
        this.add(new SComponent(this.loadFileButton, new String[]{"Vorlage laden", "Load Graph"}, new String[]{"L\u2030dt einen neuen Graphen aus einer Datei.", "Loads a new Graph from a File."}));
        this.loadFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateGraphPanel.this.loadFile();
            }
        });
        return this.loadFileButton;
    }

    private void createRadioButtons1(Container cont) {
        this.typLabel = new JLabel();
        this.typLabel.setSize(130, 20);
        this.typLabel.setFont(new Font("Serif", 1, 18));
        this.add(new SComponent(this.typLabel, new String[]{"Art des Graphen", "Graph Type"}));
        cont.add(this.typLabel);
        this.gerichtet = new JRadioButton();
        this.gerichtet.setBounds(90, 50, 100, 20);
        this.gerichtet.setSelected(true);
        this.add(new SComponent(this.gerichtet, new String[]{"Gerichtet", "Directed"}));
        this.ungerichtet = new JRadioButton();
        this.ungerichtet.setBounds(90, 70, 100, 20);
        this.ungerichtet.setSelected(false);
        this.add(new SComponent(this.ungerichtet, new String[]{"Ungerichtet", "Not Directed"}));
        ActionListener toggleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateGraphPanel.this.ungerichtet == e.getSource()) {
                    boolean sel = CreateGraphPanel.this.gerichtet.isSelected();
                    CreateGraphPanel.this.ungerichtet.setSelected(!sel);
                    CreateGraphPanel.this.gerichtet.setSelected(sel);
                    if (sel) {
                        if (CreateGraphPanel.this.mainclass.showUserMessage(0)) {
                            CreateGraphPanel.this.ungerichtet.setSelected(sel);
                            CreateGraphPanel.this.gerichtet.setSelected(!sel);
                        }
                    } else {
                        CreateGraphPanel.this.ungerichtet.setSelected(sel);
                        CreateGraphPanel.this.gerichtet.setSelected(!sel);
                    }
                } else if (CreateGraphPanel.this.gerichtet == e.getSource()) {
                    boolean sel = CreateGraphPanel.this.ungerichtet.isSelected();
                    CreateGraphPanel.this.gerichtet.setSelected(!sel);
                    CreateGraphPanel.this.ungerichtet.setSelected(sel);
                    if (!sel) {
                        if (CreateGraphPanel.this.mainclass.showUserMessage(0)) {
                            CreateGraphPanel.this.gerichtet.setSelected(sel);
                            CreateGraphPanel.this.ungerichtet.setSelected(!sel);
                        }
                    } else {
                        CreateGraphPanel.this.gerichtet.setSelected(sel);
                        CreateGraphPanel.this.ungerichtet.setSelected(!sel);
                    }
                }
                CreateGraphPanel.this.mainclass.getGraph().setDirected(CreateGraphPanel.this.gerichtet.isSelected());
                CreateGraphPanel.this.mainclass.repaint();
            }
        };
        this.gerichtet.addActionListener(toggleListener);
        this.ungerichtet.addActionListener(toggleListener);
        cont.add(this.gerichtet);
        cont.add(this.ungerichtet);
    }

    private void createRadioButtons2(Container cont) {
        this.gewichtet = new JRadioButton();
        this.gewichtet.setBounds(90, 100, 100, 20);
        this.gewichtet.setSelected(true);
        this.add(new SComponent(this.gewichtet, new String[]{"Gewichtet", "Weighted"}));
        this.ungewichtet = new JRadioButton();
        this.ungewichtet.setBounds(90, 120, 120, 20);
        this.ungewichtet.setSelected(false);
        this.add(new SComponent(this.ungewichtet, new String[]{"Ungewichtet", "Not weighted"}));
        ActionListener toggleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateGraphPanel.this.gewichtet == e.getSource()) {
                    boolean sel = CreateGraphPanel.this.ungewichtet.isSelected();
                    CreateGraphPanel.this.gewichtet.setSelected(sel);
                    CreateGraphPanel.this.ungewichtet.setSelected(!sel);
                } else if (CreateGraphPanel.this.ungewichtet == e.getSource()) {
                    boolean sel = CreateGraphPanel.this.gewichtet.isSelected();
                    CreateGraphPanel.this.ungewichtet.setSelected(sel);
                    CreateGraphPanel.this.gewichtet.setSelected(!sel);
                }
                CreateGraphPanel.this.mainclass.getGraph().setWeighted(CreateGraphPanel.this.gewichtet.isSelected());
                CreateGraphPanel.this.mainclass.repaint();
            }
        };
        this.gewichtet.addActionListener(toggleListener);
        this.ungewichtet.addActionListener(toggleListener);
        cont.add(this.gewichtet);
        cont.add(this.ungewichtet);
    }

    public JComboBox createNodeBox(int id) {
        this.nodeBox = new JComboBox();
        this.nodeBox.setFont(new Font("Serif", 1, 16));
        if (id == 1) {
            this.nodeBox.setBounds(200, 185, 44, 25);
        } else {
            this.nodeBox.setBounds(200, 215, 44, 25);
        }
        this.nodeBox.addItem(" ");
        AbstractGraph graph = this.mainclass.getGraph();
        int anz = 0;
        if (graph != null) {
            char sign = 'A';
            int i = 0;
            while (i < 26) {
                if (graph.containsTag("" + sign)) {
                    this.nodeBox.addItem(new Character(sign));
                    ++anz;
                }
                ++i;
                sign = (char)(sign + '\u0001');
            }
        }
        if (anz == 0) {
            this.nodeBox.setEnabled(false);
        }
        this.nodeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateGraphPanel.this.startNodeBox != null) {
                    char cStart = CreateGraphPanel.this.startNodeBox.getSelectedItem().toString().charAt(0);
                    AbstractGraph aktuGraph = CreateGraphPanel.this.mainclass.getGraph();
                    AbstractNode strt = aktuGraph.getNode(cStart);
                    aktuGraph.setStartNode(strt);
                }
            }
        });
        this.nodeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateGraphPanel.this.zielNodeBox != null) {
                    char cZiel = CreateGraphPanel.this.zielNodeBox.getSelectedItem().toString().charAt(0);
                    AbstractGraph aktuGraph = CreateGraphPanel.this.mainclass.getGraph();
                    AbstractNode end = aktuGraph.getNode(cZiel);
                    aktuGraph.setTargetNode(end);
                }
            }
        });
        this.add(this.nodeBox);
        return this.nodeBox;
    }

    public void createStartZielGraph() {
        this.startNodeLab = new JLabel();
        this.startNodeLab.setBounds(30, 185, 150, 25);
        this.add(new SComponent(this.startNodeLab, new String[]{"Startknoten", "Start Node"}));
        this.add(this.startNodeLab);
        this.startNodeBox = this.createNodeBox(1);
        AbstractGraph aktuGraph = this.mainclass.getGraph();
        if (aktuGraph.getStartNode() != null) {
            this.startNodeBox.setSelectedItem(Character.valueOf(aktuGraph.getStartNode().getTag()));
        }
        this.zielNodeLab = new JLabel();
        this.zielNodeLab.setBounds(30, 215, 150, 25);
        this.add(new SComponent(this.zielNodeLab, new String[]{"Zielknoten", "End Node"}));
        this.add(this.zielNodeLab);
        this.zielNodeBox = this.createNodeBox(2);
        AbstractGraph aktuGraph1 = this.mainclass.getGraph();
        if (aktuGraph1.getTargetNode() != null) {
            this.zielNodeBox.setSelectedItem(Character.valueOf(aktuGraph1.getTargetNode().getTag()));
        }
    }

    private void createRadiusComboBox(Container cont) {
        this.labRadius = new JLabel();
        this.labRadius.setBounds(30, 200, 150, 25);
        this.add(new SComponent(this.labRadius, new String[]{"Durchmesser der Knoten", "Node diameter"}));
        this.add(this.labRadius);
        this.radBox = new JComboBox();
        this.radBox.setBounds(205, 200, 50, 25);
        int i = 30;
        while (i < 61) {
            this.radBox.addItem("" + i);
            ++i;
        }
        this.radBox.setSelectedIndex(10);
        this.radBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int radius = Integer.parseInt(CreateGraphPanel.this.radBox.getSelectedItem().toString());
                AbstractGraph loadedgraph = CreateGraphPanel.this.mainclass.getGraph();
                if (loadedgraph != null) {
                    loadedgraph.setDiameter(radius);
                    CreateGraphPanel.this.mainclass.repaint();
                }
            }
        });
        cont.add(this.radBox);
    }

    private JButton createSaveButton() {
        this.saveFile = new JButton();
        this.saveFile.setBounds(45, 400, 200, 25);
        this.add(new SComponent(this.saveFile, new String[]{"Vorlage speichern", "Save Graph"}, new String[]{"Speichert den aktuellen Graphen ab.", "Saves the current used graph."}));
        this.saveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateGraphPanel.this.saveFile();
            }
        });
        return this.saveFile;
    }

    private JButton createTransferButton() {
        this.transferGraph = new JButton();
        this.transferGraph.setBounds(45, 310, 200, 25);
        this.add(new SComponent(this.transferGraph, new String[]{"Graphen transferieren", "Transfer Graph"}, new String[]{"\u2039berf\u00b8hrt den Graphen in die GraphScript Notation.", "Translates the graph into the graphscript notation."}));
        this.transferGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateGraphPanel.this.mainclass.showUserMessage(0)) {
                    CreateGraphPanel.this.mainclass.getGraphDatabase().transfer();
                }
            }
        });
        return this.transferGraph;
    }

    private void createGraphCoordinats() {
        this.graphObenLinksLab = new JLabel();
        this.graphObenLinksLab.setBounds(45, 118, 200, 25);
        this.add(new SComponent(this.graphObenLinksLab, new String[]{"Graph Koordinaten", "Graph Coordinates"}));
        this.add(this.graphObenLinksLab);
        this.graphObenLinksX = new IntegerTextFieldEx(0, 1024);
        this.graphObenLinksX.setBounds(175, 120, 40, 25);
        this.graphObenLinksX.setEnabled(true);
        this.add(this.graphObenLinksX);
        this.graphObenLinksY = new IntegerTextFieldEx(0, 1024);
        this.graphObenLinksY.setBounds(225, 120, 40, 25);
        this.graphObenLinksY.setEnabled(true);
        this.add(this.graphObenLinksY);
        final AbstractGraph g = this.mainclass.getGraph();
        if (g.getCorner() != null) {
            this.graphObenLinksX.setText("" + g.getCorner().x);
            this.graphObenLinksY.setText("" + g.getCorner().y);
        }
        FocusAdapter FA = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int ObenLinksX = CreateGraphPanel.this.graphObenLinksX.getValue();
                int ObenLinksY = CreateGraphPanel.this.graphObenLinksY.getValue();
                Uppercorner rect = new Uppercorner(ObenLinksX, ObenLinksY);
                g.setCorner(rect);
            }
        };
        this.graphObenLinksX.addFocusListener(FA);
        this.graphObenLinksY.addFocusListener(FA);
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        int[] pos = new int[4];
        pos[0] = (size.width - 150) / 2;
        pos[1] = (size.width - 200) / 2;
        pos[2] = (size.width - 100) / 2;
        if (this.mainclass.getLanguageSettings() == 0) {
            pos[3] = (size.width - 225) / 2;
            this.typLabel.setBounds((size.width - 130) / 2, 20, 130, 25);
            this.labRadius.setBounds(pos[3], 250, 150, 25);
            this.radBox.setLocation(pos[3] + 170, 250);
        } else {
            pos[3] = (size.width - 175) / 2;
            this.typLabel.setBounds((size.width - 100) / 2, 20, 100, 25);
            this.labRadius.setBounds(pos[3], 250, 160, 25);
            this.radBox.setLocation(pos[3] + 148, 250);
        }
        this.gerichtet.setLocation(pos[2], 50);
        this.ungerichtet.setLocation(pos[2], 70);
        this.gewichtet.setLocation(pos[2], 100);
        this.ungewichtet.setLocation(pos[2], 120);
        this.graphObenLinksLab.setLocation(pos[3], 156);
        this.graphObenLinksX.setLocation(pos[3] + 145, 156);
        this.graphObenLinksY.setLocation(pos[3] + 185, 156);
        this.transferGraph.setLocation(pos[1], 336);
        this.clearGraph.setLocation(pos[1], 366);
        this.loadFileButton.setLocation(pos[1], 396);
        this.saveFile.setLocation(pos[1], 426);
        super.paint(g);
    }

    private void refreshGraphComboBoxes() {
        AbstractGraph g = this.mainclass.getGraph();
        boolean flag = g.isDirected();
        this.gerichtet.setSelected(flag);
        this.ungerichtet.setSelected(!flag);
        flag = g.isWeighted();
        this.gewichtet.setSelected(flag);
        this.ungewichtet.setSelected(!flag);
        Object select = this.startNodeBox.getSelectedItem();
        this.remove(this.startNodeBox);
        this.startNodeBox = this.createNodeBox(1);
        this.startNodeBox.setSelectedItem(select);
        select = this.zielNodeBox.getSelectedItem();
        this.remove(this.zielNodeBox);
        this.zielNodeBox = this.createNodeBox(2);
        this.zielNodeBox.setSelectedItem(select);
    }

    @Override
    public void refreshPanelComponents() {
        this.refreshGraphComboBoxes();
        this.refreshTransferSaveButton();
        AbstractGraph graph = this.mainclass.getGraph();
        if (graph != null) {
            this.radBox.setSelectedItem("" + graph.getDiameter());
        }
    }

    protected void refreshTransferSaveButton() {
        boolean flag = this.mainclass.getGraph().getNumberOfNodes() > 0;
        this.transferGraph.setEnabled(flag);
        this.saveFile.setEnabled(flag);
    }

    public void saveFile() {
        FileChooserGSF fc = new FileChooserGSF();
        if (fc.showSaveDialog(new JPanel()) == 0) {
            GraphScriptWriter writer;
            String filename = fc.getSelectedFile().getPath();
            if (filename.indexOf(46) == -1) {
                filename = String.valueOf(filename) + ".gsf";
            }
            if ((writer = new GraphScriptWriter(filename)).startWriting(this.mainclass.getGraphDatabase().getSelectedEntry()) != 0) {
                this.mainclass.showUserMessage(7);
            }
        }
    }

    public void loadFile() {
        FileChooserGSF fc;
        if (this.mainclass.showUserMessage(0) && (fc = new FileChooserGSF()).showOpenDialog(new JPanel()) == 0) {
            GraphScriptParser parser = new GraphScriptParser(this.mainclass.getGraphDatabase());
            if (parser.parse(fc.getSelectedFile().getPath()) == 6) {
                this.mainclass.getGraphDatabase().setGraph(parser.getParsedGraph());
                ArrayList<String> eData = parser.getErrorMessages();
                if (eData.size() > 1 && this.mainclass.showUserMessage(1)) {
                    SPanel pan = this.mainclass.getPanel(6);
                    ((GraphScriptPanel)pan).loadFile(fc.getSelectedFile().getPath());
                    ((GraphScriptPanel)pan).parsePanelContent(1);
                }
                this.refreshPanelComponents();
                ((KantenPanelInterface)((Object)this.mainclass.getPanel(4))).refreshPanelComponents();
                this.mainclass.repaint();
            } else {
                this.mainclass.showUserMessage(2);
            }
        }
    }
}

