/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.components;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;

public class SComponent
extends JComponent {
    private static final long serialVersionUID = 3936386413363309213L;
    private JComponent comp;
    private int compId;
    private static final int COMPONENT_IS_JBUTTON = 1;
    private static final int COMPONENT_IS_JLABEL = 2;
    private static final int COMPONENT_IS_JRADIOBUTTON = 3;
    private static final int COMPONENT_IS_JTABBEDPANE = 4;
    private static final int TOOLTIP_COMPONENT = 5;
    private static final int COMPONENT_IS_JCHECKBOX = 6;
    private String[] translations = null;
    private String[] tooltipTranslations = null;
    private int[][] positions = null;

    public SComponent(JComponent comp, String[] tooltipTranslations) {
        this.compId = 5;
        this.comp = comp;
        this.setTooltipTranslations(tooltipTranslations);
    }

    public SComponent(JTabbedPane comp, String[] translations) {
        this.compId = 4;
        this.comp = comp;
        this.setTranslations(translations);
    }

    public SComponent(JButton comp, String[] translations) {
        this.compId = 1;
        this.comp = comp;
        this.setTranslations(translations);
    }

    public SComponent(JButton comp, String[] translations, String[] tooltipTranslations) {
        this.compId = 1;
        this.comp = comp;
        this.setTranslations(translations);
        this.setTooltipTranslations(tooltipTranslations);
    }

    public SComponent(JRadioButton comp, String[] translations) {
        this.compId = 3;
        this.comp = comp;
        this.setTranslations(translations);
    }

    public SComponent(JCheckBox comp, String[] translations) {
        this.compId = 6;
        this.comp = comp;
        this.setTranslations(translations);
    }

    public SComponent(JCheckBox comp, String[] translations, String[] tooltipTranslation) {
        this.compId = 6;
        this.comp = comp;
        this.setTranslations(translations);
        this.setTooltipTranslations(this.tooltipTranslations);
    }

    public SComponent(JLabel comp, String[] translations) {
        this.compId = 2;
        this.comp = comp;
        this.setTranslations(translations);
    }

    public SComponent(JLabel comp, String[] translations, int[][] positions) {
        this.compId = 2;
        this.comp = comp;
        this.setTranslations(translations);
        this.setPositions(positions);
    }

    protected void setTranslations(String[] translations) {
        this.translations = translations;
    }

    protected void setTooltipTranslations(String[] tooltipTranslations) {
        this.tooltipTranslations = tooltipTranslations;
    }

    protected void setPositions(int[][] positions) {
        this.positions = positions;
    }

    protected void changeLanguageSettings(int languageFlag) {
        switch (this.compId) {
            case 2: {
                ((JLabel)this.comp).setText(this.translations[languageFlag]);
                if (this.positions != null) {
                    ((JLabel)this.comp).setBounds(this.positions[languageFlag][0], this.positions[languageFlag][1], this.positions[languageFlag][2], this.positions[languageFlag][3]);
                }
                if (this.tooltipTranslations == null) break;
                this.comp.setToolTipText(this.tooltipTranslations[languageFlag]);
                break;
            }
            case 1: {
                ((JButton)this.comp).setText(this.translations[languageFlag]);
                if (this.positions != null) {
                    ((JLabel)this.comp).setBounds(this.positions[languageFlag][0], this.positions[languageFlag][1], this.positions[languageFlag][2], this.positions[languageFlag][3]);
                }
                if (this.tooltipTranslations == null) break;
                this.comp.setToolTipText(this.tooltipTranslations[languageFlag]);
                break;
            }
            case 3: {
                ((JRadioButton)this.comp).setText(this.translations[languageFlag]);
                if (this.positions != null) {
                    ((JLabel)this.comp).setBounds(this.positions[languageFlag][0], this.positions[languageFlag][1], this.positions[languageFlag][2], this.positions[languageFlag][3]);
                }
                if (this.tooltipTranslations == null) break;
                this.comp.setToolTipText(this.tooltipTranslations[languageFlag]);
                break;
            }
            case 4: {
                JTabbedPane jTab = (JTabbedPane)this.comp;
                int anz = jTab.getTabCount();
                int i = 0;
                int j = languageFlag;
                while (i < anz) {
                    jTab.setTitleAt(i, this.translations[j]);
                    ++i;
                    j += 2;
                }
                if (this.tooltipTranslations == null) break;
                this.comp.setToolTipText(this.tooltipTranslations[languageFlag]);
                break;
            }
            case 6: {
                ((JCheckBox)this.comp).setText(this.translations[languageFlag]);
                if (this.tooltipTranslations == null) break;
                this.comp.setToolTipText(this.tooltipTranslations[languageFlag]);
                break;
            }
            case 5: {
                this.comp.setToolTipText(this.tooltipTranslations[languageFlag]);
            }
        }
    }
}

