/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.GraphDrawer;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.graphs.AbstractEdge;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.AbstractNode;
import gfgaa.gui.graphs.KantenPanelInterface;
import gfgaa.gui.others.JarFileLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public final class PreviewPanel
extends SPanel {
    private static final long serialVersionUID = -3883620705468561538L;
    private GraphAlgController mainclass;
    GraphDrawer drawer;
    AbstractNode moving;
    private JLabel logo;

    public PreviewPanel(final GraphAlgController mainclass) {
        this.mainclass = mainclass;
        this.mainclass.addPanel(2, this);
        this.drawer = mainclass.getGraphDrawer();
        this.setPreferredSize(new Dimension(450, 500));
        this.setMinimumSize(new Dimension(335, 500));
        this.setLayout(null);
        String path = mainclass.getClass().getResource("MessageHandler.class").toString();
        path = path.substring(0, path.length() - 20);
        this.logo = new JLabel(JarFileLoader.loadImage(String.valueOf(path) + "Icons/logo.png"));
        this.logo.setBounds(0, 0, 450, 450);
        this.add(this.logo);
        this.addMouseListener(new MouseListener(){
            boolean kicked;

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            private AbstractNode isWithinCircle(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                AbstractGraph loadedgraph = mainclass.getGraph();
                if (loadedgraph != null) {
                    int i = 0;
                    int radius = loadedgraph.getRadius();
                    while (i < loadedgraph.getNumberOfNodes()) {
                        AbstractNode c = loadedgraph.getNode(i);
                        if (x > c.getXPos() - radius && x < c.getXPos() + radius && y > c.getYPos() - radius && y < c.getYPos() + radius) {
                            return c;
                        }
                        ++i;
                    }
                }
                return null;
            }

            void drawAround(final String sTag) {
                int winkel = PreviewPanel.this.drawer.getEigenkanteWinkel(sTag);
                PreviewPanel.this.drawer.setEigenkanteWinkel(sTag, winkel + 5);
                PreviewPanel.this.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!kicked) {
                            this.drawAround(sTag);
                        }
                    }
                });
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractNode obj = this.isWithinCircle(e);
                if (e.getButton() == 1) {
                    PreviewPanel.this.moving = obj;
                } else if (obj != null) {
                    String sTag = String.valueOf(obj.getTag()) + "->" + obj.getTag();
                    if (mainclass.getGraph().containsTag(sTag)) {
                        this.kicked = false;
                        this.drawAround(sTag);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    int[] pos = PreviewPanel.this.getMousePosition(e);
                    if (PreviewPanel.this.moving != null && pos != null) {
                        PreviewPanel.this.moving.moveTo(pos[0], pos[1]);
                        ((KantenPanelInterface)((Object)mainclass.getPanel(4))).refreshNodePosition(PreviewPanel.this.moving);
                        PreviewPanel.this.moving = null;
                        PreviewPanel.this.repaint();
                    }
                } else {
                    this.kicked = true;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int[] pos = PreviewPanel.this.getMousePosition(e);
                if (PreviewPanel.this.moving != null && pos != null) {
                    PreviewPanel.this.moving.moveTo(pos[0], pos[1]);
                    ((KantenPanelInterface)((Object)mainclass.getPanel(4))).refreshNodePosition(PreviewPanel.this.moving);
                }
                PreviewPanel.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        Image offImage = this.createImage(this.getWidth(), this.getHeight());
        Graphics offGraphics = offImage.getGraphics();
        this.logo.setVisible(true);
        this.drawer.setGraphics(offGraphics);
        super.printComponents(offGraphics);
        AbstractGraph loadedGraph = this.mainclass.getGraph();
        if (loadedGraph != null && loadedGraph.getNumberOfNodes() > 0) {
            AbstractNode c;
            int i;
            Color[] colors = this.drawer.getColorSettings();
            offGraphics.setColor(colors[0]);
            offGraphics.fillRect(0, 0, 450, 450);
            int radius = loadedGraph.getRadius();
            int size = loadedGraph.getNumberOfNodes();
            if (loadedGraph.getGraphTyp() != AbstractGraph.GRAPHTYP_RESIDUAL) {
                i = 0;
                while (i < size) {
                    c = loadedGraph.getNode(i);
                    int anzKanten = c.getNumberOfEdges();
                    int j = 0;
                    while (j < anzKanten) {
                        AbstractEdge k = c.getEdge(j);
                        offGraphics.setColor(colors[1]);
                        this.drawer.drawEdge(offGraphics, k, radius, loadedGraph.isDirected(), loadedGraph.isWeighted());
                        ++j;
                    }
                    ++i;
                }
            }
            radius = loadedGraph.getDiameter();
            i = 0;
            while (i < size) {
                c = loadedGraph.getNode(i);
                this.drawer.drawNodes(offGraphics, c, radius);
                ++i;
            }
        }
        g.drawImage(offImage, 0, 0, this);
    }

    @Override
    public void refreshPanelComponents() {
    }

    int[] getMousePosition(MouseEvent e) {
        int[] pos = new int[]{e.getX(), e.getY()};
        if (this.mainclass.getGraph() != null) {
            if (pos[0] < 30) {
                pos[0] = 30;
            } else if (pos[0] > 420) {
                pos[0] = 420;
            }
            if (pos[1] < 30) {
                pos[1] = 30;
            } else if (pos[1] > 420) {
                pos[1] = 420;
            }
            return pos;
        }
        return null;
    }
}

