/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.messages.MessageDialog;
import gfgaa.gui.messages.error.CantCreateAnimationMessage;
import gfgaa.gui.messages.error.CantReadFileMessage;
import gfgaa.gui.messages.error.ErrorWritingFileMessage;
import gfgaa.gui.messages.error.ScriptCannotBeParsedMessage;
import gfgaa.gui.messages.internal.CantAddAlgorithmMessage;
import gfgaa.gui.messages.internal.ErrorReadingTalktableMessage;
import gfgaa.gui.messages.internal.TalktableNotFoundMessage;
import gfgaa.gui.messages.internal.UnknownErrorMessage;
import gfgaa.gui.messages.parser.ParserErrorGotoInputPanelMessage;
import gfgaa.gui.messages.parser.ParserErrorGotoPreviewMessage;
import gfgaa.gui.messages.warning.ComponentsOutdatetMessage;
import gfgaa.gui.messages.warning.DataMayBeLostMessage;
import gfgaa.gui.messages.warning.GenerationCanceldMessage;
import gfgaa.gui.messages.warning.SelectedAnimationNotCreatedMessage;
import gfgaa.gui.messages.warning.SureToExitMessage;
import gfgaa.gui.messages.warning.SureToRemoveEdgeMessage;
import gfgaa.gui.messages.warning.SureToRemoveNodeMessage;
import gfgaa.gui.others.JarFileLoader;
import gfgaa.gui.others.LanguageInterface;
import javax.swing.ImageIcon;

public final class MessageHandler
implements LanguageInterface {
    private GraphAlgController mainclass;
    private MessageDialog mesdia;
    private ImageIcon errorIcon;
    private ImageIcon questionIcon;
    public static final int MESSAGE_DATA_MAY_BE_LOST = 0;
    public static final int MESSAGE_PARSER_ERRORS_GOTO_PREVIEW = 1;
    public static final int MESSAGE_CANT_READ_FILE = 2;
    public static final int MESSAGE_SURE_TO_REMOVE_NODE = 3;
    public static final int MESSAGE_SURE_TO_REMOVE_EDGE = 4;
    public static final int MESSAGE_PARSER_ERRORS_GOTO_INPUTPANEL = 5;
    public static final int MESSAGE_SCRIPT_CANT_PARSED = 6;
    public static final int MESSAGE_ERROR_WRITING_FILE = 7;
    public static final int MESSAGE_SURE_TO_EXIT = 8;
    public static final int MESSAGE_SELECTED_ANIMATION_NOT_CREATED = 9;
    public static final int MESSAGE_CREATE_COMPONENTS_OUTDATET = 10;
    public static final int MESSAGE_CANT_CREATE_ANIMATION = 11;
    public static final int MESSAGE_CANT_ADD_ALGORITHM = 12;
    public static final int MESSAGE_ERROR_READING_TALKTABLE = 13;
    public static final int MESSAGE_TALKTABLE_NOT_FOUND = 14;
    public static final int MESSAGE_GENERATION_CANCELD = 15;

    public MessageHandler(GraphAlgController mainclass) {
        this.mainclass = mainclass;
        String path = mainclass.getClass().getResource("MessageHandler.class").toString();
        path = path.substring(0, path.length() - 20);
        this.errorIcon = JarFileLoader.loadImage(String.valueOf(path) + "Icons/Error.png");
        this.questionIcon = JarFileLoader.loadImage(String.valueOf(path) + "Icons/Question.png");
    }

    protected void setMessage(int eMessageId) {
        switch (eMessageId) {
            case 0: {
                this.mesdia = new DataMayBeLostMessage(this.mainclass, this.questionIcon);
                break;
            }
            case 1: {
                this.mesdia = new ParserErrorGotoPreviewMessage(this.mainclass, this.questionIcon);
                break;
            }
            case 2: {
                this.mesdia = new CantReadFileMessage(this.mainclass, this.errorIcon);
                break;
            }
            case 3: {
                this.mesdia = new SureToRemoveNodeMessage(this.mainclass, this.questionIcon);
                break;
            }
            case 4: {
                this.mesdia = new SureToRemoveEdgeMessage(this.mainclass, this.questionIcon);
                break;
            }
            case 5: {
                this.mesdia = new ParserErrorGotoInputPanelMessage(this.mainclass, this.questionIcon);
                break;
            }
            case 6: {
                this.mesdia = new ScriptCannotBeParsedMessage(this.mainclass, this.errorIcon);
                break;
            }
            case 7: {
                this.mesdia = new ErrorWritingFileMessage(this.mainclass, this.errorIcon);
                break;
            }
            case 8: {
                this.mesdia = new SureToExitMessage(this.mainclass, this.questionIcon);
                break;
            }
            case 9: {
                this.mesdia = new SelectedAnimationNotCreatedMessage(this.mainclass, this.errorIcon);
                break;
            }
            case 10: {
                this.mesdia = new ComponentsOutdatetMessage(this.mainclass, this.questionIcon);
                break;
            }
            case 11: {
                this.mesdia = new CantCreateAnimationMessage(this.mainclass, this.errorIcon);
                break;
            }
            case 12: {
                this.mesdia = new CantAddAlgorithmMessage(this.mainclass, this.errorIcon);
                break;
            }
            case 13: {
                this.mesdia = new ErrorReadingTalktableMessage(this.mainclass, this.errorIcon);
                break;
            }
            case 14: {
                this.mesdia = new TalktableNotFoundMessage(this.mainclass, this.errorIcon);
            }
            case 15: {
                this.mesdia = new GenerationCanceldMessage(this.mainclass, this.errorIcon);
                break;
            }
            default: {
                this.mesdia = new UnknownErrorMessage(this.mainclass, this.errorIcon);
            }
        }
    }

    protected int getMessageType() {
        return this.mesdia.getMessageType();
    }

    protected boolean getAnswer() {
        return this.mesdia.getAnswer();
    }

    protected void setMessageVisible() {
        this.mesdia.setVisible(true);
    }
}

