/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import algoanim.primitives.Graph;
import generator.PropertiesGUI;
import gfgaa.gui.GraphAlgController;
import gfgaa.gui.GraphAlgGUI;
import gfgaa.gui.ParserPanel;
import gfgaa.gui.components.SComponent;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.others.GraphDataBase;
import gfgaa.gui.parser.GraphScriptParser;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class GraphScriptPanel
extends SPanel {
    private static final int FILE_MAXSIZE = 10000;
    GraphAlgController mainclass;
    private JTabbedPane outtab;
    public JEditorPane input;
    JScrollPane scroll;
    private JButton parse;
    private JButton edit;
    JScrollPane test;
    JButton left;
    JButton right;
    JEditorPane graphTyp;

    public void showGraphData(String graphscript) {
        this.input.setText(graphscript);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphScriptPanel.this.scroll.getVerticalScrollBar().setValue(0);
            }
        });
        int[] nArray = new int[2];
        nArray[0] = 2;
        this.mainclass.setTopLevelPanel(nArray);
        ((ParserPanel)this.mainclass.getPanel(7)).displayMessage("** Transfer successfull");
    }

    public GraphScriptPanel(final GraphAlgController mainclass) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(750, 550));
        this.mainclass = mainclass;
        this.mainclass.addPanel(6, this);
        this.add(this.createInputField());
        this.add(this.createOutputPanels());
        this.add(this.createParseButton());
        this.add(this.createEditButton());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                GraphDataBase gb = mainclass.getGraphDatabase();
                gb.getSelectedEntry();
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }
        });
        this.changeLanguageSettings(mainclass.getLanguageSettings());
    }

    public void parsePanelContent(int idFlag) {
        GraphScriptParser parser = new GraphScriptParser(this.mainclass.getGraphDatabase());
        boolean finished = true;
        if (parser.parse(this.input) != 6) {
            finished = false;
            this.mainclass.showUserMessage(6);
            return;
        }
        this.mainclass.getGraphDatabase().setGraph(parser.getParsedGraph());
        ArrayList<String> eData = parser.getErrorMessages();
        ((ParserPanel)this.mainclass.getPanel(7)).displayMessage(eData);
        if (idFlag == 0) {
            if (eData.size() == 1 || eData.size() > 1 && finished && this.mainclass.showUserMessage(5)) {
                int[] nArray = new int[2];
                nArray[1] = 2;
                this.mainclass.setTopLevelPanel(nArray);
            }
        } else if (idFlag == 1) {
            int[] nArray = new int[2];
            nArray[0] = 1;
            this.mainclass.setTopLevelPanel(nArray);
        }
        this.mainclass.repaint();
    }

    public void loadFile(String path) {
        block21: {
            FileReader reader = null;
            try {
                reader = new FileReader(path);
                String datei = "";
                int anz = 0;
                int count = 0;
                do {
                    char[] cBuf = new char[100];
                    anz = reader.read(cBuf);
                    count += anz;
                    int i = 0;
                    while (i < anz) {
                        datei = String.valueOf(datei) + cBuf[i];
                        ++i;
                    }
                } while (anz != -1 && count < 10000);
                this.input.setText(datei);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GraphScriptPanel.this.scroll.getVerticalScrollBar().setValue(0);
                    }
                });
                if (count == 10000) {
                    ((ParserPanel)this.mainclass.getPanel(7)).displayErrorMessage(1, path);
                } else {
                    ((ParserPanel)this.mainclass.getPanel(7)).displayMessage("** Loading File was successfull");
                }
            }
            catch (FileNotFoundException fnfe) {
                ((ParserPanel)this.mainclass.getPanel(7)).displayErrorMessage(2, path);
                this.mainclass.showUserMessage(6);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        ((ParserPanel)this.mainclass.getPanel(7)).displayErrorMessage(4, path);
                    }
                }
                break block21;
            }
            catch (IOException ioe) {
                try {
                    ((ParserPanel)this.mainclass.getPanel(7)).displayErrorMessage(3, path);
                    this.mainclass.showUserMessage(6);
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe2) {
                            ((ParserPanel)this.mainclass.getPanel(7)).displayErrorMessage(4, path);
                        }
                    }
                }
            }
            if (reader == null) break block21;
            try {
                reader.close();
            }
            catch (IOException ioe) {
                ((ParserPanel)this.mainclass.getPanel(7)).displayErrorMessage(4, path);
            }
        }
        this.setTopLevelPanel(new int[1]);
    }

    private JButton createEditButton() {
        this.edit = new JButton();
        this.edit.setBounds(595, 463, 105, 35);
        this.add(new SComponent(this.edit, new String[]{"Edit Graph", "Edit Script"}, new String[]{"Parst den Inhalt des Eingabe Pane.", "Parses the content of the input pane."}));
        this.edit.addActionListener(new ActionListener(){
            Graph graph = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.graph = PropertiesGUI.getGraphFromScriptFile();
                if (this.graph != null) {
                    GraphScriptPanel.this.parsePanelContent(0);
                }
                GraphAlgGUI test = GraphScriptPanel.this.mainclass.getGUI();
                test.setVisible(true);
            }
        });
        return this.edit;
    }

    private JButton createParseButton() {
        this.parse = new JButton();
        this.parse.setBounds(595, 415, 105, 35);
        this.add(new SComponent(this.parse, new String[]{"Skript parsen", "Parse Script"}, new String[]{"Parst den Inhalt des Eingabe Pane.", "Parses the content of the input pane."}));
        this.parse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphScriptPanel.this.mainclass.showUserMessage(0)) {
                    GraphScriptPanel.this.parsePanelContent(0);
                }
            }
        });
        return this.parse;
    }

    private JScrollPane createInputField() {
        this.input = new JEditorPane();
        this.input.setText("%graphscript");
        this.scroll = new JScrollPane(this.input);
        this.scroll.setBounds(20, 15, 680, 395);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setPreferredSize(new Dimension(400, 600));
        return this.scroll;
    }

    private JTabbedPane createOutputPanels() {
        String[][] tabTitels = new String[][]{{"Parser"}, {"Parser"}};
        this.outtab = new JTabbedPane();
        this.outtab.setBounds(20, 415, 570, 105);
        this.outtab.setTabPlacement(3);
        this.setTabbedPane(this.outtab, tabTitels);
        ParserPanel outpars = new ParserPanel(this.mainclass);
        int flag = this.mainclass.getLanguageSettings();
        this.outtab.add(tabTitels[flag][0], outpars);
        this.add(outpars, false);
        return this.outtab;
    }

    @Override
    public void refreshPanelComponents() {
    }
}

