/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.ColorChooser;
import gfgaa.gui.GraphAlgController;
import gfgaa.gui.graphs.CreateGraphPanel;
import gfgaa.gui.others.LanguageInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class GraphAlgMenuBar
extends JMenuBar
implements LanguageInterface {
    private static final long serialVersionUID = 631583197506199373L;
    GraphAlgController mainclass;
    private JMenu system;
    JMenuItem sysSaveGraph;
    private JMenuItem sysLoadGraph;
    JMenuItem sysTransfer;
    private JMenuItem sysExit;
    private JMenu panels;
    private JMenuItem panAttribute;
    private JMenuItem panGraphen;
    private JMenuItem panMatrix;
    private JMenu setup;
    private JMenu language;
    private JMenu transfer;
    private JMenu popups;
    JCheckBoxMenuItem setErrors;
    JCheckBoxMenuItem setHints;
    JCheckBoxMenuItem setWarnings;
    private JMenuItem setColors;
    private JMenuItem setGraphTyp;
    private JMenu help;
    private JMenuItem helpAbout;

    public GraphAlgMenuBar(GraphAlgController mainclass) {
        this.mainclass = mainclass;
        this.add(this.createSystemMenu());
        this.add(this.createPanelMenu());
        this.add(this.createSetupMenu());
        this.add(this.createAboutMenu());
        this.changeLanguageSettings(mainclass.getLanguageSettings());
    }

    public void changeLanguageSettings(int languageFlag) {
        String[][] text = new String[2][6];
        text[0][0] = "Datei";
        text[0][1] = "Vorlage laden ...";
        text[0][2] = "Vorlage speichern ...";
        text[0][3] = "Graphen transferieren";
        text[0][4] = "Beenden";
        text[1][0] = "File";
        text[1][1] = "Load graph";
        text[1][2] = "Save graph";
        text[1][3] = "Transfer graph";
        text[1][4] = "Exit";
        this.system.setText(text[languageFlag][0]);
        this.sysLoadGraph.setText(text[languageFlag][1]);
        this.sysSaveGraph.setText(text[languageFlag][2]);
        this.sysTransfer.setText(text[languageFlag][3]);
        this.sysExit.setText(text[languageFlag][4]);
        text[0][0] = "Ansicht";
        text[0][1] = "Eigenschaften des Graphen";
        text[0][2] = "Graphen bearbeiten";
        text[0][3] = "Adjazenz Matrix";
        text[0][4] = "Graph Script";
        text[0][5] = "Graphenalgorithmen";
        text[1][0] = "View";
        text[1][1] = "Graph attributes";
        text[1][2] = "Edit Graph";
        text[1][3] = "Adjacencymatrix";
        text[1][4] = "Graphscript";
        text[1][5] = "Graphalgorithms";
        this.panels.setText(text[languageFlag][0]);
        this.panAttribute.setText(text[languageFlag][1]);
        this.panGraphen.setText(text[languageFlag][2]);
        this.panMatrix.setText(text[languageFlag][3]);
        text[0][0] = "Sprache";
        text[1][0] = "Language";
        this.language.setText(text[languageFlag][0]);
        text[0][0] = "PopUp Meldungen";
        text[0][1] = "Warnungen";
        text[0][2] = "Parser Meldungen";
        text[0][3] = "Fehlermeldungen";
        text[1][0] = "Popup messages";
        text[1][1] = "Warnings";
        text[1][2] = "Parser messages";
        text[1][3] = "Error messages";
        this.popups.setText(text[languageFlag][0]);
        this.setHints.setText(text[languageFlag][1]);
        this.setWarnings.setText(text[languageFlag][2]);
        this.setErrors.setText(text[languageFlag][3]);
        text[0][0] = "Einstellungen";
        text[0][1] = "Farbeinstellungen";
        text[0][2] = "Graphtypeinstellungen";
        text[1][0] = "Options";
        text[1][1] = "Color settings";
        text[1][2] = "Graphtyp settings";
        this.setup.setText(text[languageFlag][0]);
        this.setColors.setText(text[languageFlag][1]);
        this.setGraphTyp.setText(text[languageFlag][2]);
        text[0][0] = "Hilfe";
        text[0][1] = "Autor";
        text[1][0] = "Help";
        text[1][1] = "Author";
        this.help.setText(text[languageFlag][0]);
        this.helpAbout.setText(text[languageFlag][1]);
        char[][] keys = new char[][]{{'D', 'F'}, {'A', 'V'}, {'E', 'O'}, {'S', 'L'}, {'F', 'C'}, {'N', 'A'}, {'W', 'C'}, {'K', 'A'}, {'E', 'G'}, {'L', 'D'}, {'A', 'V'}, {'G', 'G'}};
        this.system.setMnemonic(keys[0][languageFlag]);
        this.panels.setMnemonic(keys[1][languageFlag]);
        this.setup.setMnemonic(keys[2][languageFlag]);
        this.language.setMnemonic(keys[3][languageFlag]);
        this.setColors.setMnemonic(keys[4][languageFlag]);
        this.setGraphTyp.setMnemonic(keys[11][languageFlag]);
        if (languageFlag == 0) {
            this.sysLoadGraph.setDisplayedMnemonicIndex(8);
        }
    }

    private JMenu createSystemMenu() {
        this.system = new JMenu();
        this.system.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean flag = GraphAlgMenuBar.this.mainclass.getGraph() != null && GraphAlgMenuBar.this.mainclass.getGraph().getNumberOfNodes() > 0;
                GraphAlgMenuBar.this.sysSaveGraph.setEnabled(flag);
                GraphAlgMenuBar.this.sysTransfer.setEnabled(flag);
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        this.sysLoadGraph = new JMenuItem();
        this.sysLoadGraph.setMnemonic('L');
        this.sysLoadGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CreateGraphPanel)GraphAlgMenuBar.this.mainclass.getPanel(3)).loadFile();
            }
        });
        this.sysSaveGraph = new JMenuItem();
        this.sysSaveGraph.setMnemonic('S');
        this.sysSaveGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CreateGraphPanel)GraphAlgMenuBar.this.mainclass.getPanel(3)).saveFile();
            }
        });
        this.sysTransfer = new JMenuItem();
        this.sysTransfer.setMnemonic('T');
        this.sysTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphAlgMenuBar.this.mainclass.showUserMessage(0)) {
                    GraphAlgMenuBar.this.mainclass.getGraphDatabase().transfer();
                }
            }
        });
        this.sysExit = new JMenuItem();
        this.sysExit.setMnemonic('E');
        this.sysExit.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        this.sysExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphAlgMenuBar.this.mainclass.showUserMessage(8)) {
                    System.exit(0);
                }
            }
        });
        this.system.add(this.sysLoadGraph);
        this.system.add(this.sysSaveGraph);
        this.system.addSeparator();
        this.system.add(this.sysTransfer);
        this.system.addSeparator();
        this.system.add(this.sysExit);
        return this.system;
    }

    private JMenu createPanelMenu() {
        this.panels = new JMenu();
        this.panAttribute = new JMenuItem();
        this.panAttribute.setMnemonic(49);
        this.panAttribute.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.panAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAlgMenuBar.this.mainclass.setTopLevelPanel(new int[2]);
            }
        });
        this.panGraphen = new JMenuItem();
        this.panGraphen.setMnemonic(50);
        this.panGraphen.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.panGraphen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAlgMenuBar.this.mainclass.setTopLevelPanel(new int[]{1});
            }
        });
        this.panMatrix = new JMenuItem();
        this.panMatrix.setMnemonic(51);
        this.panMatrix.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.panMatrix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAlgMenuBar.this.mainclass.setTopLevelPanel(new int[]{2});
            }
        });
        this.panels.add(this.panAttribute);
        this.panels.add(this.panGraphen);
        this.panels.add(this.panMatrix);
        return this.panels;
    }

    private JMenu createLanguageMenu() {
        this.language = new JMenu();
        final JRadioButtonMenuItem langGerman = new JRadioButtonMenuItem("Deutsch");
        final JRadioButtonMenuItem langEnglish = new JRadioButtonMenuItem("English");
        boolean langFlag = this.mainclass.getLanguageSettings() == 0;
        langGerman.setSelected(langFlag);
        langEnglish.setSelected(!langFlag);
        this.language.add(langGerman);
        this.language.add(langEnglish);
        ActionListener languageListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == langEnglish) {
                    this.setLanguage(langGerman.isSelected());
                } else if (e.getSource() == langGerman) {
                    this.setLanguage(!langEnglish.isSelected());
                }
            }

            private void setLanguage(boolean sel) {
                langEnglish.setSelected(sel);
                langGerman.setSelected(!sel);
                if (langEnglish.isSelected()) {
                    GraphAlgMenuBar.this.mainclass.changeLanguageSettings(1);
                } else {
                    GraphAlgMenuBar.this.mainclass.changeLanguageSettings(0);
                }
            }
        };
        langEnglish.addActionListener(languageListener);
        langGerman.addActionListener(languageListener);
        return this.language;
    }

    private JMenu createTransferMenu() {
        this.transfer = new JMenu("Transfer");
        this.transfer.setMnemonic('T');
        final JRadioButtonMenuItem saveAsGraph = new JRadioButtonMenuItem("Graph Mode");
        final JRadioButtonMenuItem saveAsMatrix = new JRadioButtonMenuItem("Matrix Mode");
        saveAsGraph.setSelected(true);
        saveAsMatrix.setSelected(false);
        this.transfer.add(saveAsGraph);
        this.transfer.add(saveAsMatrix);
        ActionListener transferListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == saveAsGraph) {
                    this.setTransferMode(saveAsMatrix.isSelected());
                } else if (e.getSource() == saveAsMatrix) {
                    this.setTransferMode(!saveAsGraph.isSelected());
                }
            }

            private void setTransferMode(boolean sel) {
                saveAsGraph.setSelected(sel);
                saveAsMatrix.setSelected(!sel);
                if (sel) {
                    GraphAlgMenuBar.this.mainclass.setTransferMode(0);
                } else {
                    GraphAlgMenuBar.this.mainclass.setTransferMode(1);
                }
            }
        };
        saveAsGraph.addActionListener(transferListener);
        saveAsMatrix.addActionListener(transferListener);
        return this.transfer;
    }

    private JMenu createPopUpMenu() {
        this.popups = new JMenu();
        this.popups.setMnemonic('P');
        this.setHints = new JCheckBoxMenuItem("Warnungen", true);
        this.setHints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAlgMenuBar.this.mainclass.setHintsEnabeld(0, GraphAlgMenuBar.this.setHints.isSelected());
            }
        });
        this.setWarnings = new JCheckBoxMenuItem("Parser Meldungen", true);
        this.setWarnings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAlgMenuBar.this.mainclass.setHintsEnabeld(1, GraphAlgMenuBar.this.setWarnings.isSelected());
            }
        });
        this.setErrors = new JCheckBoxMenuItem("Fehlermeldungen", true);
        this.setErrors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAlgMenuBar.this.mainclass.setHintsEnabeld(2, GraphAlgMenuBar.this.setErrors.isSelected());
            }
        });
        this.popups.add(this.setHints);
        this.popups.add(this.setWarnings);
        this.popups.add(this.setErrors);
        return this.popups;
    }

    private JMenu createSetupMenu() {
        this.setup = new JMenu();
        this.setup.add(this.createLanguageMenu());
        this.setup.add(this.createPopUpMenu());
        this.setup.add(this.createTransferMenu());
        this.setGraphTyp = new JMenuItem();
        this.setGraphTyp.setMnemonic(54);
        this.setGraphTyp.setAccelerator(KeyStroke.getKeyStroke(54, 8));
        this.setGraphTyp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAlgMenuBar.this.mainclass.getGraphDatabase().showGraphTypDialog();
            }
        });
        this.setup.add(this.setGraphTyp);
        this.setColors = new JMenuItem();
        this.setColors.setMnemonic(55);
        this.setColors.setAccelerator(KeyStroke.getKeyStroke(55, 8));
        this.setColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ColorChooser(GraphAlgMenuBar.this.mainclass).setVisible(true);
            }
        });
        this.setup.add(this.setColors);
        return this.setup;
    }

    private JMenu createAboutMenu() {
        this.help = new JMenu();
        this.help.setMnemonic('H');
        this.helpAbout = new JMenuItem();
        this.helpAbout.setAccelerator(KeyStroke.getKeyStroke(56, 8));
        this.helpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyDia autor = new MyDia();
                autor.setVisible(true);
            }
        });
        this.help.add(this.helpAbout);
        return this.help;
    }

    private final class MyDia
    extends JDialog {
        private static final long serialVersionUID = -6720591781211991375L;

        public MyDia() {
            super((Frame)GraphAlgMenuBar.this.mainclass.getGUI(), true);
            String[] title = new String[]{"Autor", "Author"};
            this.setTitle(title[GraphAlgMenuBar.this.mainclass.getLanguageSettings()]);
            this.setSize(200, 200);
            this.setResizable(false);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
            this.setContentPane(new MyPanel());
        }

        public void close() {
            this.setVisible(false);
            this.dispose();
        }

        private final class MyPanel
        extends JPanel {
            private static final long serialVersionUID = -2245165579751107497L;

            public MyPanel() {
                this.setLayout(null);
                this.setSize(200, 200);
                JButton myBut = new JButton("Close");
                myBut.setBounds(60, 140, 80, 25);
                myBut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MyDia.this.close();
                    }
                });
                this.add(myBut);
            }

            @Override
            public void paint(Graphics g) {
                int panWidth = this.getSize().width;
                Image offImage = this.createImage(panWidth, this.getSize().height);
                Graphics offGraphics = offImage.getGraphics();
                super.paint(offGraphics);
                String[] text = new String[]{((MyDia)MyDia.this).GraphAlgMenuBar.this.mainclass.getLanguageSettings() == 0 ? "Ein Programm von" : "A program from", "Simon Kulessa", "TU Darmstadt", "Fachbereich Informatik", "S.Kulessa@gmx.de", "Version 0.97c - 10.04.2007"};
                int[] sizes = new int[]{12, 20, 16, 16, 14, 12};
                int[] ycord = new int[]{20, 40, 65, 80, 105, 130};
                offGraphics.setColor(Color.BLACK);
                int i = 0;
                while (i < 6) {
                    Font serifBold = new Font("Serif", 1, sizes[i]);
                    Rectangle2D sis = serifBold.getStringBounds(text[i], new FontRenderContext(new AffineTransform(), false, false));
                    offGraphics.setFont(serifBold);
                    offGraphics.drawString(text[i], (int)((double)panWidth - sis.getWidth()) / 2, ycord[i]);
                    ++i;
                }
                g.drawImage(offImage, 0, 0, this);
            }
        }
    }
}

