/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.EditGraphPanel;
import gfgaa.gui.GraphAlgController;
import gfgaa.gui.GraphAlgMenuBar;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.others.JarFileLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public final class GraphAlgGUI
extends JFrame {
    private static final long serialVersionUID = 8955424210341510262L;
    private GraphAlgController mainclass;
    private GraphAlgMenuBar menu;
    private SPanel mp;

    public GraphAlgGUI(GraphAlgController mainclass) {
        this.mainclass = mainclass;
        this.setSize(800, 600);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        Container cont = this.getContentPane();
        this.mp = new EditGraphPanel(mainclass);
        cont.add((Component)this.mp, "Center");
        this.menu = new GraphAlgMenuBar(mainclass);
        this.setJMenuBar(this.menu);
        this.changeLanguageSettings(mainclass.getLanguageSettings());
        String path = mainclass.getClass().getResource("MessageHandler.class").toString();
        path = path.substring(0, path.length() - 20);
        ImageIcon icon = JarFileLoader.loadImage(String.valueOf(path) + "Icons/icon.png");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
    }

    public int getLanguageSettings() {
        return this.mainclass.getLanguageSettings();
    }

    protected void changeLanguageSettings(int languageFlag) {
        this.menu.changeLanguageSettings(languageFlag);
        this.mp.changeLanguageSettings(languageFlag);
        String[] text = new String[]{"Generator f\u00b8r Graph Algorithmen Animationen", "Generator for Graph Algorithm Animations"};
        super.setTitle(text[languageFlag]);
    }

    protected void setTopLevelPanel(int[] panelId) {
        this.mp.setTopLevelPanel(panelId);
    }

    protected GraphAlgMenuBar getGraphAlgMenuBar() {
        return this.menu;
    }
}

