/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class SwapSort
implements Generator {
    private Language lang;
    private boolean hidden_am_i;
    private TextProperties textProps;
    private ArrayProperties arrayProps;
    private ArrayMarkerProperties startProps;
    private ArrayMarkerProperties iProps;
    private SourceCodeProperties scProps;
    private boolean counter_hidden;
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Swap-Sort. Swap-Sort ist ein Sortieralgorithmus, der ein Array aus paarweise verschiedenen Zahlen sortiert. Daher ist wichtig, dass der Nutzer im zu sortierenden Array nur PAARWEISE VERSCHIEDENE Zahlen eingibt, da der Algorithmus sonst NICHT TERMINIERT (und kein Code generiert werden kann)!\n\nBeim Swap-Sort werden fuer jedes Element elem des zu sortierenden Arrays A[0..n-1] die Anzahl \"smallers\" der Elemente von A mit kleineren Werten gezaehlt. Anschliessend wird elem mit dem Element in A[smallers] vertauscht. Somit wird der Platz fuer die \"smallers\" Elemente geschaffen, so dass elem bereits an der richtigen Position steht.";
    private static final String CODE_EXAMPLE = "public void sort(int[] array) { \n  int start = 0; \n  while (start < array.length - 1) { \n    int smallers = 0; \n    for (int i = start + 1; i < array.length; i++) \n      if (array[i] < array[start]) \n        smallers++; \n    if (smallers > 0) \n      swap(array, start, start + smallers); \n    else \n      start++; \n  } \n}";

    public SwapSort(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public SwapSort() {
        this(new AnimalScript("SwapSort", "Dmytro Vronskyi", 640, 480));
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.textProps = (TextProperties)props.getPropertiesByName("text");
        this.arrayProps = (ArrayProperties)props.getPropertiesByName("arrayProps");
        this.startProps = (ArrayMarkerProperties)props.getPropertiesByName("startMarker");
        this.iProps = (ArrayMarkerProperties)props.getPropertiesByName("iMarker");
        this.scProps = (SourceCodeProperties)props.getPropertiesByName("code");
        int[] array = (int[])primitives.get("intArray");
        try {
            this.sort(array);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    private void sort(int[] array) throws LineNotExistsException {
        MsTiming duration = new MsTiming(1000);
        TextProperties titleTextProp = new TextProperties();
        titleTextProp.set("font", new Font("Monospaced", 1, 24));
        this.lang.newText(new Coordinates(480, 40), "Swap-Sort Sortieralgorithmus", "title", null, titleTextProp);
        this.lang.nextStep();
        SourceCode sc = this.lang.newSourceCode(new Coordinates(20, 200), "code", null, this.scProps);
        sc.addCodeLine("public void sort(int[] array) {", null, 0, null);
        sc.addCodeLine("int start = 0;", null, 1, null);
        sc.addCodeLine("while (start < array.length - 1) {", null, 1, null);
        sc.addCodeLine("int smallers = 0;", null, 2, null);
        sc.addCodeLine("for (int i = start + 1; i < array.length; i++)", null, 2, null);
        sc.addCodeLine("if (array[i] < array[start])", null, 3, null);
        sc.addCodeLine("smallers++;", null, 4, null);
        sc.addCodeLine("if (smallers > 0)", null, 2, null);
        sc.addCodeLine("swap(array, start, start + smallers);", null, 3, null);
        sc.addCodeLine("else", null, 2, null);
        sc.addCodeLine("start++;", null, 3, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        this.lang.newText(new Offset(70, 0, sc, "NE"), "Erl\u2030uterung zur Animation: ", "", null, this.textProps);
        this.lang.newText(new Offset(70, 25, sc, "NE"), "Die aktuell betrachteten Elemente des Arrays werden hervorgehoben. ", "", null, this.textProps);
        this.lang.newText(new Offset(70, 40, sc, "NE"), "Die hervorgehobenen Zellen des Arrays enthalten die bereits sortierten Elemente.", "", null, this.textProps);
        IntArray ia = this.lang.newIntArray(new Coordinates(20, 150), array, "array", null, this.arrayProps);
        sc.highlight(0);
        this.lang.nextStep();
        sc.toggleHighlight(0, 1);
        int start = 0;
        ArrayMarker am_start = this.lang.newArrayMarker(ia, start, "start", null, this.startProps);
        ia.highlightElem(start, null, null);
        ArrayMarker am_i = this.lang.newArrayMarker(ia, start + 1, "i", null, this.iProps);
        am_i.hide();
        this.hidden_am_i = true;
        this.lang.nextStep();
        sc.toggleHighlight(1, 2);
        Text counter = this.lang.newText(new Offset(25, 0, ia, "E"), "smallers = ", "smallers", null, this.textProps);
        counter.hide();
        this.counter_hidden = true;
        Text sm_value = this.lang.newText(new Offset(0, 0, counter, "NE"), "", "sm_value", null, this.textProps);
        while (start < array.length - 1) {
            this.lang.nextStep();
            int smallers = 0;
            sc.highlight(2, 0, true);
            sc.highlight(11, 0, true);
            sc.highlight(3);
            if (this.counter_hidden) {
                counter.show();
                this.counter_hidden = false;
            }
            sm_value.setText(String.valueOf(smallers), null, null);
            this.lang.nextStep();
            sc.toggleHighlight(3, 4);
            int i = start + 1;
            while (i < array.length) {
                am_i.move(i, null, null);
                if (this.hidden_am_i) {
                    am_i.show();
                }
                this.lang.nextStep();
                ia.highlightElem(i, null, null);
                sc.highlight(4, 0, true);
                sc.highlight(5);
                if (array[i] < array[start]) {
                    this.lang.nextStep();
                    sc.toggleHighlight(5, 6);
                    sm_value.setText(String.valueOf(++smallers), null, null);
                    this.lang.nextStep();
                    sc.unhighlight(6);
                } else {
                    this.lang.nextStep();
                    sc.unhighlight(5);
                }
                ia.unhighlightElem(i, null, null);
                ++i;
            }
            this.lang.nextStep();
            sc.toggleHighlight(4, 7);
            if (smallers > 0) {
                this.lang.nextStep();
                sc.toggleHighlight(7, 8);
                ia.swap(start, start + smallers, null, duration);
                this.lang.nextStep();
                sc.unhighlight(8);
                ia.unhighlightElem(start + smallers, null, null);
                ia.highlightCell(start + smallers, null, null);
                ia.highlightElem(start, null, null);
                continue;
            }
            this.lang.nextStep();
            sc.toggleHighlight(7, 9);
            this.lang.nextStep();
            sc.toggleHighlight(9, 10);
            ia.highlightCell(start, null, null);
            ia.unhighlightElem(start, null, null);
            am_start.increment(null, null);
            ia.highlightElem(++start, null, null);
            this.lang.nextStep();
            sc.unhighlight(10);
        }
        this.lang.nextStep();
        sc.unhighlight(2);
        sc.unhighlight(11);
        ia.unhighlightElem(start, null, null);
    }

    @Override
    public String getAlgorithmName() {
        return "Swap Sort";
    }

    @Override
    public String getCodeExample() {
        return CODE_EXAMPLE;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "SwapSort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Dmytro Vronskyi";
    }

    @Override
    public void init() {
    }
}

