/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class SimpleSort
implements Generator {
    Language l = new AnimalScript("SimpleSort", "Eduard Metlewski", 200, 200);
    ArrayProperties ap;
    ArrayMarkerProperties lgp;
    ArrayMarkerProperties akp;
    TextProperties tp;
    SourceCodeProperties scp;

    public SimpleSort() {
        this.l.setStepMode(true);
        this.ap = new ArrayProperties();
        this.ap.set("elementColor", Color.BLUE);
        this.ap.set("elemHighlight", Color.RED);
        this.ap.set("cellHighlight", Color.green);
        this.ap.set("fillColor", Color.LIGHT_GRAY);
        this.lgp = new ArrayMarkerProperties();
        this.lgp.set("color", Color.GREEN);
        this.lgp.set("label", "S");
        this.akp = new ArrayMarkerProperties();
        this.akp.set("color", Color.RED);
        this.akp.set("label", "A");
        this.tp = new TextProperties();
        this.tp.set("font", new Font("SansSerif", 1, 16));
        this.tp.set("color", Color.CYAN);
        this.tp.set("centered", true);
        this.scp = new SourceCodeProperties();
        this.scp.set("color", Color.BLUE);
        this.scp.set("highlightColor", Color.RED);
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "SimpleSort";
    }

    @Override
    public String getDescription() {
        return "SimplySort hat eine Komplexit&auml;t von  O(n^2)";
    }

    @Override
    public String getCodeExample() {
        String s = "for(int i=0;i<array.langth;i++){\n  for(int j=i+1;j<array.length;j++){\n    if(array[i] > array[j]){\n      \tja-->swap(array(i),array(j));\n    }\n  }\n}";
        return s;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public String getAlgorithmName() {
        return "SimpleSort";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        int[] ar = (int[])primitives.get("a");
        MsTiming dur = new MsTiming(300);
        this.l.newText(new Coordinates(50, 10), "SimpleSort", "titel", null, this.tp);
        if (ar.length < 2) {
            return null;
        }
        IntArray a = this.l.newIntArray(new Coordinates(50, 150), ar, "array", null, this.ap);
        ArrayMarker lm = this.l.newArrayMarker(a, 0, "links", null, this.lgp);
        ArrayMarker rm = this.l.newArrayMarker(a, 1, "rechts", null, this.akp);
        SourceCode code = this.l.newSourceCode(new Coordinates(50, 200), "code", null, this.scp);
        code.addCodeLine("0.for(int i=0;i<array.langth;i++)   {", null, 0, null);
        code.addCodeLine("1.      for(int j=i+1;j<array.length;j++)   {", null, 0, null);
        code.addCodeLine("2.          if(array[i] > array[j])   {", null, 0, null);
        code.addCodeLine("3.                  ja-->swap(array(i),array(j));", null, 0, null);
        code.addCodeLine("4.          }", null, 0, null);
        code.addCodeLine("5.      }", null, 0, null);
        code.addCodeLine("6.}", null, 0, null);
        this.l.nextStep();
        code.highlight(0);
        code.highlight(6);
        int i = 0;
        while (i < a.getLength()) {
            this.l.nextStep();
            lm.move(i, null, dur);
            this.l.nextStep();
            a.highlightElem(i, null, null);
            this.l.nextStep();
            code.highlight(1);
            code.highlight(5);
            this.l.nextStep();
            int j = i + 1;
            while (j < a.getLength()) {
                rm.move(j, null, dur);
                this.l.nextStep();
                a.highlightElem(j, null, null);
                this.l.nextStep();
                code.highlight(2);
                code.highlight(4);
                this.l.nextStep();
                if (a.getData(i) > a.getData(j)) {
                    code.highlight(3);
                    this.l.nextStep();
                    a.swap(i, j, null, dur);
                    this.l.nextStep();
                    code.unhighlight(3);
                    this.l.nextStep();
                }
                code.unhighlight(2);
                code.unhighlight(4);
                this.l.nextStep();
                a.unhighlightElem(j, null, null);
                this.l.nextStep();
                ++j;
            }
            this.l.nextStep();
            code.unhighlight(1);
            code.unhighlight(5);
            this.l.nextStep();
            a.unhighlightElem(i, null, null);
            a.highlightCell(i, null, null);
            ++i;
        }
        code.hide();
        lm.hide();
        rm.hide();
        return this.l.toString();
    }

    @Override
    public String getAnimationAuthor() {
        return "Eduard Metlewski";
    }

    @Override
    public void init() {
    }
}

