/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

public class ShakerSortVP
implements Generator {
    protected Language lang;

    public ShakerSortVP() {
        this.init();
    }

    public ShakerSortVP(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    private void sort(int[] a, ArrayProperties aprops, SourceCodeProperties scprops, ArrayMarkerProperties amprops_i, ArrayMarkerProperties amprops_j) {
        IntArray ia = this.lang.newIntArray(new Coordinates(20, 100), a, "intArray", null, aprops);
        this.lang.nextStep();
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scprops);
        sc.addCodeLine("public void sort(int[] array)", null, 0, null);
        sc.addCodeLine("{", null, 0, null);
        sc.addCodeLine("boolean swapped;", null, 1, null);
        sc.addCodeLine("int i;", null, 1, null);
        sc.addCodeLine("do", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("swapped = false;", null, 2, null);
        sc.addCodeLine("for (i = 0; i <= A.length - 2; i++)", null, 2, null);
        sc.addCodeLine("{", null, 2, null);
        sc.addCodeLine("if (A[i] > A[i+1])", null, 3, null);
        sc.addCodeLine("{", null, 3, null);
        sc.addCodeLine("swap(array, i, i+1);", null, 4, null);
        sc.addCodeLine("swapped = true;", null, 4, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("if (swapped == false)", null, 2, null);
        sc.addCodeLine("break;", null, 3, null);
        sc.addCodeLine("swapped = false;", null, 2, null);
        sc.addCodeLine("for (i = 0; i <= A.length - 2; i++)", null, 2, null);
        sc.addCodeLine("{", null, 2, null);
        sc.addCodeLine("if (A[i] > A[i+1])", null, 3, null);
        sc.addCodeLine("{", null, 3, null);
        sc.addCodeLine("swap(array, i, i+1);", null, 4, null);
        sc.addCodeLine("swapped = true;", null, 4, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("while (swapped);", null, 0, null);
        sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        ia.highlightCell(0, ia.getLength() - 1, null, null);
        try {
            this.shakeSort(ia, sc, amprops_i, amprops_j);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private void shakeSort(IntArray array, SourceCode codeSupport, ArrayMarkerProperties amprops_i, ArrayMarkerProperties amprops_j) {
        boolean swapped;
        codeSupport.highlight(0, 0, false);
        this.lang.nextStep();
        codeSupport.toggleHighlight(0, 1);
        this.lang.nextStep();
        codeSupport.toggleHighlight(1, 2);
        this.lang.nextStep();
        codeSupport.toggleHighlight(2, 3);
        this.lang.nextStep();
        codeSupport.toggleHighlight(3, 4);
        this.lang.nextStep();
        codeSupport.toggleHighlight(4, 5);
        this.lang.nextStep();
        codeSupport.toggleHighlight(5, 6);
        this.lang.nextStep();
        codeSupport.unhighlight(6);
        ArrayMarker iMarker = this.lang.newArrayMarker(array, 1, "i", null, amprops_i);
        ArrayMarker jMarker = this.lang.newArrayMarker(array, array.getLength() - 2, "j", null, amprops_j);
        jMarker.hide();
        do {
            swapped = false;
            iMarker.show();
            int i = 0;
            while (i <= array.getLength() - 2) {
                codeSupport.highlight(7);
                this.lang.nextStep();
                codeSupport.toggleHighlight(7, 9);
                array.highlightElem(i, null, null);
                array.highlightElem(i + 1, null, null);
                this.lang.nextStep();
                if (array.getData(i) > array.getData(i + 1)) {
                    codeSupport.toggleHighlight(9, 11);
                    codeSupport.highlight(12);
                    array.swap(i, i + 1, null, new TicksTiming(15));
                    swapped = true;
                    this.lang.nextStep();
                    iMarker.increment(new TicksTiming(25), new TicksTiming(20));
                    codeSupport.unhighlight(11);
                    codeSupport.unhighlight(12);
                    array.unhighlightElem(i, null, null);
                    array.unhighlightElem(i + 1, null, null);
                } else {
                    codeSupport.unhighlight(9);
                    array.unhighlightElem(i, null, null);
                    iMarker.increment(null, new TicksTiming(20));
                    array.unhighlightElem(i + 1, null, null);
                }
                ++i;
            }
            iMarker.move(1, null, new TicksTiming(15));
            codeSupport.highlight(15);
            this.lang.nextStep();
            if (!swapped) {
                codeSupport.toggleHighlight(15, 16);
                this.lang.nextStep();
                codeSupport.unhighlight(16);
                break;
            }
            codeSupport.unhighlight(15);
            codeSupport.highlight(17);
            swapped = false;
            this.lang.nextStep();
            jMarker.show();
            int j = array.getLength() - 2;
            while (j >= 0) {
                codeSupport.toggleHighlight(17, 18);
                this.lang.nextStep();
                codeSupport.toggleHighlight(18, 20);
                array.highlightElem(j, null, null);
                array.highlightElem(j + 1, null, null);
                this.lang.nextStep();
                if (array.getData(j) > array.getData(j + 1)) {
                    codeSupport.toggleHighlight(20, 22);
                    codeSupport.highlight(23);
                    array.swap(j, j + 1, null, new TicksTiming(15));
                    swapped = true;
                    this.lang.nextStep();
                    jMarker.decrement(new TicksTiming(25), new TicksTiming(20));
                    codeSupport.unhighlight(22);
                    codeSupport.unhighlight(23);
                    array.unhighlightElem(j, null, null);
                    array.unhighlightElem(j + 1, null, null);
                } else {
                    codeSupport.unhighlight(20);
                    array.unhighlightElem(j, null, null);
                    jMarker.decrement(null, new TicksTiming(20));
                    array.unhighlightElem(j + 1, null, null);
                }
                --j;
            }
            jMarker.move(array.getLength() - 2, null, new TicksTiming(15));
        } while (swapped);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int[] ia = (int[])primitives.get("Input Data");
        ArrayProperties ap = (ArrayProperties)props.getPropertiesByName("arrayProps");
        SourceCodeProperties scp = (SourceCodeProperties)props.getPropertiesByName("sourceCodeProps");
        ArrayMarkerProperties amp_i = (ArrayMarkerProperties)props.getPropertiesByName("iMarkerProps");
        ArrayMarkerProperties amp_j = (ArrayMarkerProperties)props.getPropertiesByName("jMarkerProps");
        System.out.println(ia);
        this.sort(ia, ap, scp, amp_i, amp_j);
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "ShakerSort";
    }

    @Override
    public String getAnimationAuthor() {
        return "Vyacheslav Polonskyy";
    }

    @Override
    public String getCodeExample() {
        return "procedure cocktailSort( A : list of sortable items ) defined as:\n  do\n    swapped := false\n\t for each i in 0 to length( A ) - 2 do:\n  \t\tif A[ i ] > A[ i + 1 ] then // test whether the two elements are in the wrong order\n \t\t \tswap( A[ i ], A[ i + 1 ] ) // let the two elements change places\n  \t\t\tswapped := true\n \t\tend if\n\t end for\n  \t if swapped = false then\n\t\t// we can exit the outer loop here if no swaps occurred.\n\t\tbreak do-while loop\n\t end if\n\t swapped := false\n\t for each i in length( A ) - 2 to 0 do:\n\t\tif A[ i ] > A[ i + 1 ] then\n\t\t\tswap( A[ i ], A[ i + 1 ] )\n\t\t\tswapped := true\n\t\tend if\n\t end for\n  while swapped // if no elements have been swapped, then the list is sorted\nend procedure";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "Das zu sortierende Feld wird abwechselnd nach oben und nach unten durchlaufen. Dabei werden jeweils zwei benachbarte Elemente verglichen und gegebenenfalls vertauscht.Durch diese Bidirektionalit\u2030t kommt es zu einem schnellerem Absetzen von gro\ufb02en bzw. kleinen Elementen. Anhand des Sortierverfahrens l\u2030sst sich auch der Name erkl\u2030ren, denn der Sortiervorgang erinnert an das Sch\u00b8tteln des Arrays oder eines Barmixers.";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "Shaker Sort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public void init() {
        this.lang = new AnimalScript("Shakersort Animation", "Vyacheslav Polonskyy", 640, 480);
        this.lang.setStepMode(true);
    }
}

