/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.Graph;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class HeapSort
implements Generator {
    private Language lang;
    private Graph g;
    private static final String DESCRIPTION = "Heapsort ist ein Sortierverfahren das einen bin\u221a\u00a7ren Baum als Datenstrukturnutzt. Der eigentliche Sortieralgorithmus nutzt die Tatsache aus, dass dieWurzel eines Heaps stets der gr\u221a\u2202\u221a\u00fcte Knoten ist. Da im fertig sortierten Arrayder gr\u221a\u2202\u221a\u00fcte Wert ganz rechts stehen soll, vertauscht man das erste mit dem letztenArrayelement. Das Element am Ende des Arrays ist nun an der gew\u221a\u00banschten Positionund bleibt dort. Den Rest des Arrays muss man wieder in einen neuen Heap \u221a\u00baberf\u221a\u00bahren,Anschlie\u221a\u00fcend vertauscht man das erste mit dem vorletzten Element, d. h. die beidengr\u221a\u2202\u221a\u00fcten Werte sind wie gew\u221a\u00banscht am Ende des Arrays, usw.";
    private static final String SOURCE_CODE = " public void heapSort(int[] heap) {\n  generateMaxHeap(heap);\n  for(int i = heap.length -1 ; i > 0 ; i--) {\n    swap(i, 0);\n    versenke(heap, 0, i);\n  }\n }\n\n private void generateMaxHeap(int[] heap) {\n  for (int i = heap.length - 1; i >= 0; i--) {\n   versenke(heap, 0, i);\n  }\n }\n\n private void versenke(int[] heap, int iNode, int heapSize) {\n  int i,j;\n  j := iNode;\n  do {\n   i := j;\n   if((2*i+1) < heapSize) && (heap[2*i+1]>heap[j]))\n    j := 2*i+1;\n   if((2*i+2) < heapSize) && (heap[2*i+2]>heap[j]))\n    j := 2*i+2;\n   swap(i,j);\n  }while (i!=j);\n }";

    public HeapSort() {
    }

    public HeapSort(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void sort(int[] a, AnimationPropertiesContainer aprops) {
        TextProperties txprops = new TextProperties();
        txprops.set("font", new Font("Monospaced", 0, 18));
        txprops.set("color", aprops.get("title", "color"));
        this.lang.newText(new Coordinates(100, 500), "HeapSort", "title", null, txprops);
        ArrayProperties arrayProps = new ArrayProperties();
        arrayProps.set("color", aprops.get("array", "color"));
        arrayProps.set("fillColor", aprops.get("array", "fillColor"));
        arrayProps.set("filled", aprops.get("array", "filled"));
        arrayProps.set("elementColor", aprops.get("array", "elementColor"));
        arrayProps.set("elemHighlight", aprops.get("array", "elemHighlight"));
        arrayProps.set("cellHighlight", aprops.get("array", "cellHighlight"));
        IntArray ia = this.lang.newIntArray(new Coordinates(440, 500), a, "intArray", null, arrayProps);
        this.lang.nextStep();
        this.g = new Graph(a, this.lang);
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", aprops.get("sourceCode", "highlightColor"));
        scProps.set("color", aprops.get("sourceCode", "color"));
        scProps.set("font", aprops.get("sourceCode", "font"));
        scProps.set("size", aprops.get("sourceCode", "size"));
        SourceCode sc = this.lang.newSourceCode(new Coordinates(50, 20), "sourceCode", null, scProps);
        sc.addCodeLine("public void heapSort(int[] heap)", null, 0, null);
        sc.addCodeLine("{", null, 0, null);
        sc.addCodeLine("generateMaxHeap(heap);", null, 1, null);
        sc.addCodeLine("for(int i = heap.length -1 ; i > 0 ; i--) {", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("swap(i, 0);", null, 2, null);
        sc.addCodeLine("versenke(heap, 0,i);", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("private void generateMaxHeap(int[] heap) {", null, 0, null);
        sc.addCodeLine("for(int i = heap.length  - 1; i >= 0 ; i--) {", null, 1, null);
        sc.addCodeLine("versenke(heap,0,i);", null, 2, null);
        sc.addCodeLine(" }", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("private void versenke(int[] Heap, int iNode,HeapSize) {", null, 0, null);
        sc.addCodeLine("int i,j;", null, 1, null);
        sc.addCodeLine("j=iNode;  ", null, 1, null);
        sc.addCodeLine("do{", null, 1, null);
        sc.addCodeLine("i=j;", null, 2, null);
        sc.addCodeLine("if((2*i+1)<HeapSize && Heap[2*i+1]>Heap[j])", null, 2, null);
        sc.addCodeLine("j=2*i+1", null, 3, null);
        sc.addCodeLine("if((2*i+2)<HeapSize && Heap[2*i+2]>Heap[j])", null, 2, null);
        sc.addCodeLine("j=2*i+2;", null, 3, null);
        sc.addCodeLine("swap(i,j);", null, 2, null);
        sc.addCodeLine("}while(i!=j);", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        ia.highlightCell(0, ia.getLength() - 1, null, null);
        try {
            this.heapSort(ia, sc, aprops);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private void heapSort(IntArray heap, SourceCode codeSupport, AnimationPropertiesContainer aprops) throws LineNotExistsException {
        codeSupport.highlight(0, 0, false);
        this.lang.nextStep();
        codeSupport.toggleHighlight(0, 0, false, 2, 0);
        this.lang.nextStep();
        codeSupport.unhighlight(2, 0, false);
        this.generateMaxHeap(heap, codeSupport);
        ArrayMarker m = this.lang.newArrayMarker(heap, heap.getLength() - 1, "m", null);
        int i = heap.getLength() - 1;
        while (i >= 0) {
            codeSupport.highlight(3, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(3, 0, false);
            this.swap(heap, 0, i, codeSupport);
            this.g.markout(i);
            codeSupport.highlight(5, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(5, 0, false);
            this.versenke(heap, 0, i, codeSupport);
            codeSupport.highlight(6, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(6, 0, false);
            m.decrement(null, null);
            --i;
        }
    }

    private void generateMaxHeap(IntArray heap, SourceCode codeSupport) throws LineNotExistsException {
        codeSupport.highlight(11, 0, false);
        this.lang.nextStep();
        codeSupport.unhighlight(11, 0, false);
        int i = heap.getLength() - 1;
        while (i >= 0) {
            codeSupport.highlight(11, 0, false);
            this.lang.nextStep();
            this.g.moveStart(i);
            codeSupport.unhighlight(11, 0, false);
            codeSupport.highlight(12, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(12, 0, false);
            if (i < heap.getLength() / 2) {
                this.versenke(heap, i, heap.getLength(), codeSupport);
            }
            --i;
        }
    }

    private void versenke(IntArray Heap, int iNode, int HeapSize, SourceCode codeSupport) throws LineNotExistsException {
        int i;
        codeSupport.highlight(16, 0, false);
        this.lang.nextStep();
        codeSupport.unhighlight(16, 0, false);
        int j = iNode;
        do {
            codeSupport.highlight(19, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(19, 0, false);
            i = j;
            this.g.hightlight(i);
            Heap.highlightCell(i, null, null);
            if (2 * i + 1 < HeapSize && Heap.getData(2 * i + 1) > Heap.getData(j)) {
                j = 2 * i + 1;
                codeSupport.highlight(21, 0, false);
                this.lang.nextStep();
                codeSupport.unhighlight(21, 0, false);
            }
            if (2 * i + 2 < HeapSize && Heap.getData(2 * i + 2) > Heap.getData(j)) {
                j = 2 * i + 2;
                codeSupport.highlight(23, 0, false);
                this.lang.nextStep();
                codeSupport.unhighlight(23, 0, false);
            }
            this.g.hightlight(j);
            Heap.highlightCell(j, null, null);
            this.swap(Heap, i, j, codeSupport);
            if (i != j) {
                codeSupport.highlight(25, 0, false);
                this.lang.nextStep();
                codeSupport.unhighlight(25, 0, false);
                this.lang.nextStep();
            }
            this.g.unhightlight(i);
            this.g.unhightlight(j);
            Heap.unhighlightCell(i, null, null);
            Heap.unhighlightCell(j, null, null);
        } while (i != j);
    }

    private void swap(IntArray heap, int i, int j, SourceCode codeSupport) throws LineNotExistsException {
        heap.swap(i, j, null, new TicksTiming(15));
        this.g.swap(i, j);
    }

    public static void main(String[] args) {
    }

    @Override
    public String getAlgorithmName() {
        return "HeapSort";
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMAN;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "HeapSort";
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        int[] myArray = (int[])arg1.get("array");
        this.lang = new AnimalScript("HeapSort Animation", "doowap", 800, 600);
        HeapSort s = new HeapSort(this.lang);
        this.lang.setStepMode(true);
        s.sort(myArray, arg0);
        return this.lang.toString();
    }

    @Override
    public String getAnimationAuthor() {
        return "Daniel Thies, Dominik Ulrich, J\u221a\u2202rg Schmalfu\u221a\u00fc & Atilla Yalzin";
    }

    @Override
    public void init() {
    }
}

