/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Primitive;
import algoanim.primitives.SourceCode;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import algoanim.util.Offset;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class GnomeSort
implements Generator {
    private static final String DESCRIPTION = "Put items in order by comparing the current item with the previous item. If they are in order, move to the next item (or stop if the end is reached).If they are out of order, swap them and move to the previous item.If there is no previous item, move to the next item.When the stop state is reached the array is sorted.";
    private static final String SOURCE_CODE = "public int[] gnomeSort(int[] a) {\n  int i;\n  for (i = 1; i < a.length;) {\n    if (a[i-1] <= a[i]) {\n      i++;\n    } else {\n      swap(a, i, i - 1);\n      if(i>1) {\n        i--;\n      } else {\n        i++;\n      }    }\n  }\n  return a;\n}";
    private static final String AUTHOR = "Patrick Fongue, Matthias Prager, Daniel Staesche";
    private static final String ALGORITHM_NAME = "GnomeSort";
    private Language lang;

    @Override
    public void init() {
        this.lang = new AnimalScript(this.getName(), this.getAnimationAuthor(), 620, 480);
        this.lang.setStepMode(true);
        this.lang.newText(new Coordinates(0, 0), this.getName(), "AlgoTitle", null);
    }

    private IntArray createIntArray(int[] a) {
        ArrayProperties arrayProps = new ArrayProperties();
        arrayProps.set("color", Color.BLACK);
        arrayProps.set("fillColor", Color.WHITE);
        arrayProps.set("filled", Boolean.TRUE);
        arrayProps.set("elementColor", Color.BLACK);
        arrayProps.set("elemHighlight", Color.RED);
        arrayProps.set("cellHighlight", Color.YELLOW);
        return this.lang.newIntArray(new Coordinates(20, 100), a, "intArray", null, arrayProps);
    }

    private SourceCode initSourceCode(Primitive reference) {
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        int spacing_distance = 50;
        SourceCode code = this.lang.newSourceCode(new Offset(0, spacing_distance, reference, "SW"), "sourceCode", null, scProps);
        code.addCodeLine("public int[] gnomeSort(int[] a) {", null, 0, null);
        code.addCodeLine("int i;", null, 1, null);
        code.addCodeLine("for (i = 1; i < a.length;){", null, 1, null);
        code.addCodeLine("if (a[i-1] <= a[i]) {", null, 2, null);
        code.addCodeLine("i++;", null, 3, null);
        code.addCodeLine("} else {", null, 2, null);
        code.addCodeLine("swap(a, i, i - 1);", null, 3, null);
        code.addCodeLine("if(i>1) { ", null, 3, null);
        code.addCodeLine("i--;", null, 4, null);
        code.addCodeLine("} else{ ", null, 3, null);
        code.addCodeLine("i++;", null, 4, null);
        code.addCodeLine("}", null, 3, null);
        code.addCodeLine("}", null, 2, null);
        code.addCodeLine("}", null, 1, null);
        code.addCodeLine("return a;", null, 1, null);
        code.addCodeLine("}", null, 0, null);
        return code;
    }

    private void highlightNextLine(SourceCode code, int currentLine) {
        code.unhighlight(currentLine);
        code.highlight(currentLine + 1);
        this.lang.nextStep();
    }

    private void highlightThatLine(SourceCode code, int thatLine) {
        this.highlightThatLine(code, thatLine, 0);
    }

    private void highlightThatLine(SourceCode code, int thatLine, int duration) {
        code.highlight(thatLine);
        this.lang.nextStep(duration);
    }

    private ArrayMarker createArrayMarker(String label, int position, IntArray array) {
        ArrayMarkerProperties arrayMarkerProps = new ArrayMarkerProperties();
        arrayMarkerProps.set("label", label);
        arrayMarkerProps.set("color", Color.BLACK);
        return this.lang.newArrayMarker(array, position, label, null, arrayMarkerProps);
    }

    public void gnomeSort(int[] inputArray) {
        TicksTiming swapDuration = new TicksTiming(75);
        TicksTiming moveDuration = new TicksTiming(25);
        MsTiming ifDuration = new MsTiming(1500);
        IntArray animalArray = this.createIntArray(inputArray);
        int arraySize = animalArray.getLength();
        this.lang.nextStep();
        SourceCode animalSourceCode = this.initSourceCode(animalArray);
        this.lang.nextStep();
        animalArray.highlightCell(0, arraySize - 1, null, null);
        this.highlightThatLine(animalSourceCode, 0);
        ArrayMarker animalIMarker = this.createArrayMarker("i", 1, animalArray);
        ArrayMarker animalPrevMarker = this.createArrayMarker("i-1", 0, animalArray);
        this.highlightNextLine(animalSourceCode, 0);
        animalSourceCode.unhighlight(1);
        int i = 1;
        while (i < arraySize) {
            this.highlightThatLine(animalSourceCode, 2);
            this.highlightNextLine(animalSourceCode, 2);
            animalSourceCode.unhighlight(3);
            if (animalArray.getData(i - 1) <= animalArray.getData(i)) {
                this.highlightThatLine(animalSourceCode, 4, ifDuration.getDelay());
                if (++i == arraySize) {
                    animalIMarker.hide();
                    animalPrevMarker.hide();
                } else {
                    animalIMarker.move(i, null, moveDuration);
                    animalPrevMarker.move(i - 1, null, moveDuration);
                }
                animalSourceCode.unhighlight(4);
                continue;
            }
            this.highlightThatLine(animalSourceCode, 5);
            this.highlightNextLine(animalSourceCode, 5);
            animalArray.swap(i, i - 1, null, swapDuration);
            this.lang.nextStep();
            this.highlightNextLine(animalSourceCode, 6);
            animalSourceCode.unhighlight(7);
            if (i > 1) {
                this.highlightThatLine(animalSourceCode, 8, ifDuration.getDelay());
                --i;
                animalSourceCode.unhighlight(8);
            } else {
                this.highlightThatLine(animalSourceCode, 9, ifDuration.getDelay());
                ++i;
                this.highlightNextLine(animalSourceCode, 9);
                animalSourceCode.unhighlight(10);
            }
            animalIMarker.move(i, null, moveDuration);
            animalPrevMarker.move(i - 1, null, moveDuration);
        }
        this.highlightThatLine(animalSourceCode, 14);
        animalSourceCode.unhighlight(14);
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return this.getAlgorithmName();
    }

    @Override
    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getAnimationAuthor() {
        return AUTHOR;
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int[] arrayData = (int[])primitives.get("array");
        this.gnomeSort(arrayData);
        return this.lang.toString();
    }

    public static void main(String[] args) {
        GnomeSort s = new GnomeSort();
        int[] a = new int[]{7, 3, 2, 4, 1, 13, 52, 13, 5, 1};
        s.init();
        s.gnomeSort(a);
        System.out.println(s.lang);
    }
}

