/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.interactionsupport.DocumentationLink;
import algoanim.interactionsupport.FillInBlanksQuestion;
import algoanim.interactionsupport.GroupInfo;
import algoanim.interactionsupport.MultipleChoiceQuestion;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.Text;
import avinteraction.parser.InteractionFactory;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.AnimatedIntArrayAlgorithm;
import java.util.Hashtable;
import java.util.Locale;
import translator.Translator;

public class GenericInteractiveAnnotatedQuickSort
extends AnimatedIntArrayAlgorithm
implements Generator {
    protected Text swapLabel;
    protected Text swapPerf;
    protected Locale contentLocale = null;
    protected ArrayMarker iMarker = null;
    protected ArrayMarker jMarker = null;
    private InteractionFactory factory = null;
    private int questionCounter = 0;
    private int random1 = 0;
    private int random2 = 0;
    private MultipleChoiceQuestion mcq = null;
    String resourceName;
    Locale locale;

    public GenericInteractiveAnnotatedQuickSort(String aResourceName, Locale aLocale) {
        this.resourceName = aResourceName;
        this.locale = aLocale;
        this.init();
    }

    @Override
    public void init() {
        this.translator = new Translator(this.resourceName, this.locale);
        this.primitiveProps = new Hashtable(59);
        this.localType = new GeneratorType(1);
        this.contentLocale = this.locale;
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.array != null) {
            this.array.hide();
        }
    }

    public void sort() {
        this.lang.setInteractionType(1024);
        this.factory = new InteractionFactory(this.lang, "InteractionPatterns.xml");
        this.lang.addQuestionGroup(new GroupInfo(this.lang, "pivot", 2));
        MultipleChoiceQuestion year = new MultipleChoiceQuestion(this.lang, "AlgorithmYear");
        year.setPrompt("In which year did C.A.R. Hoare develop the QuickSort Algorithm?");
        year.setPointsPossible(1);
        year.addAnswerOption("1960", true, "That is correct", 1);
        year.addAnswerOption("2006", false, "The QuickSort Algorithm is much older", -1);
        year.addAnswerOption("1972", false, "Close, but not right", 0);
        this.lang.addMCQuestion(year);
        this.lang.nextStep();
        FillInBlanksQuestion fib = new FillInBlanksQuestion(this.lang, "Comparisons");
        fib.setPrompt("How many Comparisons will it take the Algorithm to sort the given Array?");
        fib.setPointsPossible(5);
        this.lang.addFIBQuestion(fib);
        this.lang.nextStep();
        this.questionCounter = 0;
        this.quickSort(0, this.array.getLength() - 1, 0);
        fib.addAnswer("" + this.nrComparisons, "The Answer is " + this.nrComparisons + " Comparisons", 5);
        DocumentationLink link = new DocumentationLink(this.lang, "QuickSort Docu");
        link.setLinkAddress("http://www.linux-related.de/index.html?/coding/sort/sort_quick.htm");
        this.lang.addDocumentationLink(link);
    }

    private String makeLabel(int l, int r, int depth) {
        StringBuilder sb = new StringBuilder(32);
        int i = 0;
        while (i < depth) {
            sb.append(' ');
            ++i;
        }
        sb.append("quicksort(").append(l).append(", ").append(r);
        sb.append(")");
        return sb.toString();
    }

    public void quickSort(int l, int r, int depth) {
        this.code.highlight("header");
        this.array.highlightCell(l, r, null, null);
        this.lang.nextStep(this.makeLabel(l, r, depth));
        this.code.toggleHighlight("header", "variables");
        this.lang.nextStep();
        this.code.toggleHighlight("variables", "check1");
        this.lang.nextStep();
        if (r > l) {
            ++this.questionCounter;
            this.incrementNrComparisons();
            this.code.toggleHighlight("check1", "setPivot");
            this.lang.nextStep();
            int pivot = this.array.getData(r);
            this.mcq = this.factory.generateMCQuestion("PivotPlaceholder", "Pivot" + this.questionCounter, "" + pivot);
            this.incrementNrAssignments();
            this.code.toggleHighlight("setPivot", "loop");
            this.lang.nextStep();
            this.incrementNrAssignments(2);
            int i = l;
            int j = r - 1;
            while (i < j) {
                if (this.iMarker == null) {
                    this.iMarker = this.installArrayMarker("iMarker", this.array, i);
                } else {
                    this.iMarker.move(i, null, null);
                }
                if (this.jMarker == null) {
                    this.jMarker = this.installArrayMarker("jMarker", this.array, j);
                } else {
                    this.jMarker.move(j, null, null);
                }
                this.incrementNrComparisons();
                this.code.toggleHighlight("loop", "loopI");
                this.lang.nextStep();
                this.incrementNrComparisons(2);
                while (this.array.getData(i) <= pivot && j > i) {
                    this.code.toggleHighlight("loopI", "incrementI");
                    this.lang.nextStep();
                    this.incrementNrAssignments();
                    this.iMarker.move(++i, null, null);
                    this.code.toggleHighlight("incrementI", "loopI");
                    this.lang.nextStep();
                    this.incrementNrComparisons(2);
                }
                this.code.toggleHighlight("loopI", "loopJ");
                this.lang.nextStep();
                this.incrementNrComparisons(2);
                while (pivot < this.array.getData(j) && j > i) {
                    this.code.toggleHighlight("loopJ", "decrementJ");
                    this.lang.nextStep();
                    this.incrementNrAssignments();
                    this.jMarker.move(--j, null, null);
                    this.code.toggleHighlight("decrementJ", "loopJ");
                    this.lang.nextStep();
                    this.incrementNrComparisons(2);
                }
                this.code.toggleHighlight("loopJ", "check2");
                this.lang.nextStep();
                this.incrementNrComparisons();
                if (i < j) {
                    this.code.toggleHighlight("check2", "swapIJ");
                    this.lang.nextStep();
                    this.array.swap(i, j, null, null);
                    this.incrementNrAssignments(2);
                    this.code.toggleHighlight("swapIJ", "loop");
                    this.lang.nextStep();
                    continue;
                }
                this.code.toggleHighlight("check2", "loop");
                this.lang.nextStep();
            }
            this.code.toggleHighlight("loop", "check3");
            this.lang.nextStep();
            this.incrementNrComparisons();
            if (pivot < this.array.getData(i)) {
                this.code.toggleHighlight("check3", "swapIR");
                this.lang.nextStep();
                this.incrementNrAssignments(2);
                this.array.swap(i, r, null, null);
                this.code.toggleHighlight("swapIR", "sortLeft");
                this.lang.nextStep();
            } else {
                this.code.toggleHighlight("check3", "setItoR");
                this.lang.nextStep();
                i = r;
                this.incrementNrAssignments();
                this.code.toggleHighlight("setItoR", "sortLeft");
                this.lang.nextStep();
            }
            this.random1 = (int)(Math.random() * (double)(this.array.getLength() - 1));
            this.random2 = (int)(Math.random() * (double)(this.array.getLength() - 1));
            this.check(i);
            this.mcq.addAnswerOption("" + i, true, "right", 5);
            this.mcq.addAnswerOption("" + this.random1, false, "wrong, " + i + " where the correct position", -3);
            this.mcq.addAnswerOption("" + this.random2, false, "wrong, " + i + " where the correct position", -3);
            this.code.unhighlight("sortLeft");
            this.array.unhighlightCell(l, r, null, null);
            this.quickSort(l, i - 1, depth + 1);
            this.code.highlight("sortRight");
            this.lang.nextStep();
            this.code.unhighlight("sortRight");
            this.quickSort(i + 1, r, depth + 1);
            this.array.highlightCell(l, r, null, null);
        } else {
            this.code.unhighlight("check1");
        }
        this.array.unhighlightCell(l, r, null, null);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        this.sort();
        if (this.swapPerf != null) {
            this.swapPerf.hide();
        }
        if (this.swapLabel != null) {
            this.swapLabel.hide();
        }
        this.wrapUpAnimation();
        this.lang.finalizeGeneration();
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Quicksort Interactive";
    }

    @Override
    public String getAnimationAuthor() {
        return "Krasimir Markov";
    }

    @Override
    public Locale getContentLocale() {
        return this.contentLocale;
    }

    private void check(int i) {
        if (this.random1 == i) {
            ++this.random1;
            if (this.random1 > this.array.getLength() - 1) {
                this.random1 = 0;
            }
        }
        if (this.random1 == this.random2) {
            ++this.random2;
            if (this.random2 > this.array.getLength() - 1) {
                this.random2 = 0;
            }
        }
        if (this.random2 == i) {
            ++this.random2;
            if (this.random2 > this.array.getLength() - 1) {
                this.random2 = 0;
            }
        }
        if (this.random1 == this.random2) {
            ++this.random2;
            if (this.random2 > this.array.getLength() - 1) {
                this.random2 = 0;
            }
        }
    }
}

