/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Text;
import algoanim.properties.TextProperties;
import algoanim.util.Offset;
import avinteraction.parser.InteractionFactory;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.AnimatedIntArrayAlgorithm;
import java.util.Hashtable;
import java.util.Locale;
import translator.Translator;

public class DelphiAnnotatedSelectionSort
extends AnimatedIntArrayAlgorithm
implements Generator {
    protected Text tempLabel;
    protected Text tempValue;
    protected InteractionFactory factory;
    protected Locale contentLocale = null;

    public DelphiAnnotatedSelectionSort() {
        this("resources/DelphiSelectionSort", Locale.GERMANY);
    }

    public DelphiAnnotatedSelectionSort(String aResourceName, Locale aLocale) {
        this.resourceName = aResourceName;
        this.locale = aLocale;
        this.init();
    }

    @Override
    public void init() {
        this.translator = new Translator(this.resourceName, this.locale);
        this.primitiveProps = new Hashtable(59);
        this.localType = new GeneratorType(1);
        this.contentLocale = this.locale;
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.array != null) {
            this.array.hide();
        }
    }

    public void sort() {
        int enumSwaps = 0;
        int nrElems = this.array.getLength();
        ArrayMarker iMarker = null;
        ArrayMarker jMarker = null;
        this.code.highlight("header");
        this.lang.nextStep("Erster Aufruf");
        this.code.toggleHighlight("header", "variables");
        this.tempLabel = this.lang.newText(new Offset(0, 30, this.nrCompLabel, "SW"), "T =", "tLabel", null, (TextProperties)this.primitiveProps.get("title"));
        this.tempValue = this.lang.newText(new Offset(10, 0, this.tempLabel, "baseline end"), "", "tValue", null, (TextProperties)this.primitiveProps.get("title"));
        this.lang.nextStep("Deklaration der Variablen");
        this.code.unhighlight("variables");
        boolean done = false;
        int i = 0;
        while (!done && i < nrElems - 1) {
            this.code.highlight("outerLoop");
            if (i == 0) {
                iMarker = this.installArrayMarker("iMarker", this.array, i);
            } else {
                iMarker.move(i, null, DEFAULT_TIMING);
            }
            this.incrementNrComparisons();
            this.incrementNrAssignments();
            this.array.highlightElem(i, null, null);
            this.lang.nextStep("Selection Sort, i=" + i);
            this.code.unhighlight("outerLoop");
            int j = nrElems - 1;
            while (!done && j > i) {
                this.code.highlight("innerLoop");
                if (jMarker == null) {
                    jMarker = this.installArrayMarker("jMarker", this.array, j);
                } else {
                    jMarker.move(j, null, DEFAULT_TIMING);
                }
                this.incrementNrAssignments();
                this.incrementNrComparisons();
                this.lang.nextStep();
                this.code.toggleHighlight("innerLoop", "if");
                this.array.highlightElem(j, null, null);
                this.incrementNrComparisons();
                this.lang.nextStep();
                if (this.array.getData(i) > this.array.getData(j)) {
                    ++enumSwaps;
                    this.code.toggleHighlight("if", "copy");
                    int t = this.array.getData(i);
                    this.tempValue.setText(String.valueOf(t), null, DEFAULT_TIMING);
                    this.incrementNrAssignments();
                    this.lang.nextStep("  Vertausche " + this.array.getData(i) + ", " + this.array.getData(j));
                    this.code.toggleHighlight("copy", "replicate");
                    this.array.put(i, this.array.getData(j), null, DEFAULT_TIMING);
                    this.array.highlightElem(i, null, DEFAULT_TIMING);
                    this.incrementNrAssignments();
                    this.lang.nextStep();
                    this.code.toggleHighlight("replicate", "insertCopy");
                    this.array.put(j, t, null, DEFAULT_TIMING);
                    this.incrementNrAssignments();
                    this.lang.nextStep();
                    done = this.terminated(this.array);
                    this.code.toggleHighlight("insertCopy", "checkDone");
                    this.lang.nextStep();
                    this.code.unhighlight("checkDone");
                } else {
                    this.code.unhighlight("if");
                }
                this.array.unhighlightElem(j, null, null);
                --j;
            }
            this.incrementNrComparisons();
            this.incrementNrAssignments();
            this.array.unhighlightElem(i, null, null);
            this.array.highlightCell(i, null, null);
            ++i;
        }
        this.incrementNrComparisons();
        this.incrementNrAssignments();
    }

    private boolean terminated(IntArray theArray) {
        int i = 0;
        while (i < this.array.getLength() - 1) {
            if (this.array.getData(i) > this.array.getData(i + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Locale getContentLocale() {
        return this.contentLocale;
    }

    @Override
    public String getAlgorithmName() {
        return "Selection Sort";
    }

    @Override
    public String getAnimationAuthor() {
        return "Dr. Guido Roessling";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        this.sort();
        if (this.tempValue != null) {
            this.tempValue.hide();
        }
        if (this.tempLabel != null) {
            this.tempLabel.hide();
        }
        this.wrapUpAnimation();
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }
}

