/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.searching;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.animalTranslator.codeItems.Hidden;
import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Off;
import algorithm.animalTranslator.codeItems.Pos;
import algorithm.animalTranslator.codeItems.TimeOffset;
import algorithm.animalTranslator.codeItems.Timing;
import algorithm.animalTranslator.codeItems.WithinTiming;

public class SequentielleSuche {
    private AnimalTranslator at;
    private int[] intA;
    private int toSearch;
    private boolean initialized = false;
    private String arrayName;
    private String javaCodeName;
    private String algorithmName;
    private String markerName;
    private String legendeName;
    private int iii;
    private int[] markedLinesInAlgorithm;
    private int[] markedLinesInJavaCode;
    private boolean javaCode = false;

    public SequentielleSuche() {
    }

    public SequentielleSuche(AnimalTranslator newAT, boolean displayJavaCode) {
        this.at = newAT;
        this.javaCode = displayJavaCode;
    }

    public void initialize(int[] intArrayToSort, int toBeSearched) {
        this.intA = intArrayToSort;
        this.toSearch = toBeSearched;
        this.arrayName = "SequentialSearchArray";
        this.javaCodeName = "CodeGroup_SeqSearchIterativ";
        this.algorithmName = "CodeGroup_Algorithm";
        this.markerName = "theMarker";
        this.legendeName = "dieLegende";
        this.iii = -1;
        this.initialized = true;
    }

    public int generateAnimation() throws Exception {
        if (!this.initialized) {
            throw new Exception("Instance of SequentialSearch has not been initialized!");
        }
        this.displayInitialScreen();
        this.displaySortingScreen();
        return this.seqSearchIterativ(this.intA, this.toSearch);
    }

    private void displayInitialScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("initial screen");
        this.at.advancedCreateWorkSheet();
        this.at.addText("sollSortiert", "Sequentielle Suche", new Pos(400, 150), "color black size 40 bold", null);
        this.at.compositeStepEnd();
        this.at.compositeStepStart();
        this.at.addText("comment1", "Die einfachste und allgemeinste Methode der Suche nach Elementen.", new Off(-420, 130, "sollSortiert", "S"), "color black size 25", null);
        this.at.addText("comment2", "Die Elemente werden dabei der Reihe nach \u221a\u00baberpr\u221a\u00baft.", new Off(0, 40, "comment1", "SW"), "color black size 25", null);
        this.at.addText("comment3", "auch als Brute-Force-Search ('Suche mit brutaler Gewalt') bezeichnet.", new Off(0, 40, "comment2", "SW"), "color black size 25", null);
        this.at.addText("comment4", "Die Komplexit\u221a\u00a7t ist mit O(n) sehr ung\u221a\u00banstig.", new Off(0, 40, "comment3", "SW"), "color black size 25", null);
        this.at.compositeStepEnd();
    }

    private void displaySortingScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("searching screen");
        this.at.hide(new String[]{"sollSortiert", "comment1", "comment2", "comment3", "comment4"}, null);
        this.at.advancedTextLine("headline", new Pos(300, 70), "color black size 30 bold", null, "Sequentielle Suche nach dem Element: " + this.toSearch);
        this.at.advancedArrayReduction(this.arrayName, (Node)new Off(-200, 120, "headline", "NW"), this.intA);
        this.at.addArrayMarker(this.markerName, this.arrayName, 0, "color blue", new Hidden());
        this.at.addText(this.legendeName, "(i) aktuell betrachtete Position im Feld", new Off(0, -25, this.arrayName, "NW"), "color blue size 15", null);
        this.at.hide(new String[]{this.legendeName}, null);
        if (!this.javaCode) {
            this.at.advancedCodeGroupStandard(this.algorithmName, new Off(15, 75, this.arrayName, "SW"), new TimeOffset(0), new String[]{"1. Beginne die Suche beim ersten Element des Arrays", "2. Ist das aktuelle Element gleich dem gesuchten?", "   - Falls ja, weiter bei Schritt 5 (gefunden)", "3. Hat das Array noch weitere Elemente?", "   - falls nein, weiter bei Schritt 5 (nicht gefunden)", "4. Gehe zu Schritt 2 mit dem n\u221a\u00a7chsten Element im Array", "5. Gib den entsprechenden Wert zurueck", "   - (-1) falls nicht gefunden", "   - Ansonsten wurde das Element an der aktuellen Position gefunden."});
        } else {
            int[] nArray = new int[14];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 1;
            nArray[4] = 1;
            nArray[5] = 1;
            nArray[6] = 2;
            nArray[7] = 1;
            nArray[8] = 1;
            nArray[9] = 2;
            nArray[10] = 1;
            nArray[11] = 2;
            nArray[12] = 1;
            this.at.advancedCodeGroupStandard(this.javaCodeName, new Off(15, 75, this.arrayName, "SW"), new TimeOffset(0), new String[]{"private int sequentialSearch(int[] a, int x) {", "if (a == null || a.length == 0) {", "return -1; //feld null oder leer", "}", "int i = 0;", "while (i < a.length && a[i] != x) {", "i++;", "}", "if (i < a.length) {", "return i;", "} else {", "return -1;", "}", "}"}, nArray);
        }
        this.at.compositeStepEnd();
    }

    private int seqSearchIterativ(int[] a, int x) {
        if (a == null || a.length == 0) {
            return this.returnResult(-1);
        }
        this.setI(0, a);
        this.codeMarkingForWhile(a, x);
        while (this.iii < a.length && a[this.iii] != x) {
            this.setI(this.iii + 1, a);
            this.codeMarkingForWhile(a, x);
        }
        if (this.iii < a.length) {
            return this.returnResult(this.iii);
        }
        return this.returnResult(-1);
    }

    private void setI(int newValue, int[] a) {
        this.at.compositeStepStart();
        if (this.iii == -1) {
            this.at.show(this.legendeName, null);
            this.at.moveArrayMarker(this.markerName, newValue, (Timing)new WithinTiming(0));
            this.at.show(this.markerName, null);
            this.markLines(new int[1], new int[]{4});
        } else {
            this.at.advancedHighlightArrayCells(this.arrayName, this.iii, newValue - 1);
            if (newValue < a.length) {
                this.at.moveArrayMarker(this.markerName, newValue, (Timing)new WithinTiming(1000));
                this.markLines(new int[]{5}, new int[]{6});
            }
        }
        this.iii = newValue;
        this.at.compositeStepEnd();
    }

    private void codeMarkingForWhile(int[] a, int x) {
        if (this.iii < a.length) {
            this.markLines(new int[]{1}, new int[]{5});
            if (a[this.iii] != x) {
                this.markLines(new int[]{3}, null);
            }
        }
    }

    private int returnResult(int result) {
        if (result == -1) {
            this.at.compositeStepStart();
            this.at.advancedHighlightArrayCell(this.arrayName, this.iii);
            this.markLines(new int[]{3}, null);
            this.markLines(new int[]{3, 4}, new int[]{8});
            this.at.compositeStepEnd();
            this.at.compositeStepStart();
            this.markLines(new int[]{6, 7}, new int[]{8, 10, 11});
            if (!this.javaCode) {
                this.at.advancedTextLine("Ergebnis", new Off(130, 100, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde nicht gefunden!");
            } else {
                this.at.advancedTextLine("Ergebnis", new Off(130, 100, this.javaCodeName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde nicht gefunden!");
            }
            this.at.compositeStepEnd();
        } else {
            this.markLines(new int[]{1, 2}, new int[]{8});
            this.at.compositeStepStart();
            this.markLines(new int[]{6, 8}, new int[]{8, 9});
            if (!this.javaCode) {
                this.at.advancedTextLine("Ergebnis", new Off(130, 50, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde bei index " + this.iii + " gefunden!");
            } else {
                this.at.advancedTextLine("Ergebnis", new Off(130, 50, this.javaCodeName, "SW"), "color blue size 30", new TimeOffset(0), "Das gesuchte Element wurde bei index " + this.iii + " gefunden!");
            }
            this.at.advancedTextLine("Ergebnis2", new Off(200, 15, "Ergebnis", "SW"), "color blue size 15", new TimeOffset(0), "(der index beginnt bei 0 und geht bis a.length - 1)");
            this.at.compositeStepEnd();
        }
        this.at.addLabel("SortingResult");
        return result;
    }

    private void markLines(int[] linesInAlgorithm, int[] linesInJavaCode) {
        if (linesInAlgorithm == null && linesInJavaCode == null) {
            System.out.println("useless call of markLines in Sequential Search - all parameters null");
        } else if (!(linesInAlgorithm == null && !this.javaCode || linesInJavaCode == null && this.javaCode)) {
            int i;
            this.at.compositeStepStart();
            if (this.markedLinesInAlgorithm == null) {
                this.markedLinesInAlgorithm = new int[0];
            }
            if (this.markedLinesInJavaCode == null) {
                this.markedLinesInJavaCode = new int[0];
            }
            if (linesInAlgorithm != null && !this.javaCode) {
                i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.unhighlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
                this.markedLinesInAlgorithm = linesInAlgorithm;
                i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.highlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
            }
            if (linesInJavaCode != null && this.javaCode) {
                i = 0;
                while (i < this.markedLinesInJavaCode.length) {
                    this.at.unhighlightCode(this.javaCodeName, this.markedLinesInJavaCode[i], "", null);
                    ++i;
                }
                this.markedLinesInJavaCode = linesInJavaCode;
                i = 0;
                while (i < this.markedLinesInJavaCode.length) {
                    this.at.highlightCode(this.javaCodeName, this.markedLinesInJavaCode[i], "", null);
                    ++i;
                }
            }
            this.at.compositeStepEnd();
        }
    }
}

