/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.searching;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

public class Levenstein
implements Generator {
    private Language lang;
    private static final String DESCRIPTION = "Dies eine Animation des Levenstein Distanz Algorithmus";
    private static final String SOURCE_CODE = "public int getLevensteinDistance(String s, String t)\n{\n  int n = s.length();int m = t.length();\n  if (n == 0)\n  {\n    return m;\n  }\n  else if(m == 0)\n  {\n    return n;\n  }\n  int p[] = new int[n+1];int d[] = new int[n+1];\n  int _d[]; int i, j, cost; char t_j;\n  for (i = 0; i<=n; i++)\n  {\n    p[i] = i;\n  }\n  for (j = 1; j<=m; j++)\n  {\n    t_j = t.charAt(j-1);\n    d[0] = j;\n    for (i=1; i<=n; i++)\n    {\n    cost = s.charAt(i-1)==t_j ? 0 : 1;\n    d[i] = Math.min(Math.min(d[i-1]+1, p[i]+1),  p[i-1]+cost);\n    }\n    _d = p;\n    p = d;\n    d = _d;\n  }\n  return p[n];\n}";

    public Levenstein() {
    }

    public Levenstein(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void levensteinDistance(SourceCodeProperties scProps, ArrayProperties arrayProps, TextProperties textProps, String s, String t) {
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scProps);
        sc.addCodeLine("public int getLevensteinDistance(String s, String t))", null, 0, null);
        sc.addCodeLine("{", null, 0, null);
        sc.addCodeLine("int n = s.length();int m = t.length();", null, 1, null);
        sc.addCodeLine("if (n == 0)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("return m;", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("else if(m == 0)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("return n;", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("int p[] = new int[n+1];int d[] = new int[n+1];", null, 1, null);
        sc.addCodeLine("int _d[]; int i, j, cost; char t_j;", null, 1, null);
        sc.addCodeLine("for (i = 0; i<=n; i++)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("p[i] = i;", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("for (j = 1; j<=m; j++)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("t_j = t.charAt(j-1);", null, 2, null);
        sc.addCodeLine("d[0] = j;", null, 2, null);
        sc.addCodeLine("for (i=1; i<=n; i++)", null, 2, null);
        sc.addCodeLine("{", null, 2, null);
        sc.addCodeLine("cost = s.charAt(i-1)==t_j ? 0 : 1;", null, 3, null);
        sc.addCodeLine("d[i] = Math.min(Math.min(d[i-1]+1, p[i]+1),  p[i-1]+cost);", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("_d = p.clone();", null, 2, null);
        sc.addCodeLine("p = d.clone();", null, 2, null);
        sc.addCodeLine("d = _d.clone();", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("return p[n];", null, 1, null);
        sc.addCodeLine("};", null, 0, null);
        this.lang.newText(new Coordinates(10, 10), "Berechnung der Levenshtein-Distanz zwischen", "label1", null, textProps);
        this.lang.newText(new Coordinates(10, 30), "String s: " + s + " und", "label2", null, textProps);
        this.lang.newText(new Coordinates(10, 50), "String t: " + t, "label3", null, textProps);
        this.lang.nextStep();
        try {
            this.getLevensteinDistance(sc, arrayProps, textProps, s, t);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private int getLevensteinDistance(SourceCode codeSupport, ArrayProperties arrayProps, TextProperties textProps, String s, String t) throws LineNotExistsException {
        codeSupport.highlight(0, 0, false);
        this.lang.nextStep();
        codeSupport.toggleHighlight(0, 0, false, 2, 0);
        this.lang.nextStep();
        int n = s.length();
        int m = t.length();
        codeSupport.toggleHighlight(2, 0, false, 3, 0);
        this.lang.nextStep();
        if (n == 0) {
            codeSupport.toggleHighlight(3, 0, false, 5, 0);
            this.lang.nextStep();
            return m;
        }
        codeSupport.toggleHighlight(3, 0, false, 7, 0);
        this.lang.nextStep();
        if (m == 0) {
            codeSupport.toggleHighlight(7, 0, false, 9, 0);
            this.lang.nextStep();
            return n;
        }
        codeSupport.toggleHighlight(7, 0, false, 11, 0);
        int[] p = new int[n + 1];
        int i = 0;
        while (i < n + 1) {
            p[i] = 0;
            ++i;
        }
        IntArray ia1 = this.lang.newIntArray(new Coordinates(20, 90), p, "intArray", null, arrayProps);
        this.lang.newText(new Coordinates(20, 70), "Array p:", "labelia1", null, textProps);
        int[] d = new int[n + 1];
        int j = 0;
        while (j < n + 1) {
            d[j] = 0;
            ++j;
        }
        IntArray ia2 = this.lang.newIntArray(new Coordinates(220, 90), d, "intArray", null, arrayProps);
        this.lang.newText(new Coordinates(220, 70), "Array d:", "labelia2", null, textProps);
        this.lang.nextStep();
        codeSupport.toggleHighlight(11, 0, false, 12, 0);
        int[] _d = new int[n + 1];
        this.lang.nextStep();
        codeSupport.toggleHighlight(12, 0, false, 13, 0);
        this.lang.nextStep();
        int i2 = 0;
        while (i2 <= n) {
            codeSupport.toggleHighlight(13, 0, false, 15, 0);
            this.lang.nextStep();
            p[i2] = i2;
            ia1.put(i2, i2, new MsTiming(0), new MsTiming(0));
            ia1.highlightCell(i2, i2, new MsTiming(0), new MsTiming(250));
            ia1.unhighlightCell(i2, i2, new MsTiming(750), new MsTiming(250));
            codeSupport.toggleHighlight(15, 0, false, 13, 0);
            this.lang.nextStep();
            ++i2;
        }
        codeSupport.toggleHighlight(13, 0, false, 17, 0);
        this.lang.nextStep();
        int j2 = 1;
        while (j2 <= m) {
            codeSupport.toggleHighlight(17, 0, false, 19, 0);
            this.lang.nextStep();
            char t_j = t.charAt(j2 - 1);
            codeSupport.toggleHighlight(19, 0, false, 20, 0);
            this.lang.nextStep();
            d[0] = j2;
            ia2.put(0, j2, new MsTiming(0), new MsTiming(0));
            ia2.highlightCell(j2, j2, new MsTiming(0), new MsTiming(250));
            ia2.unhighlightCell(j2, j2, new MsTiming(750), new MsTiming(250));
            codeSupport.toggleHighlight(20, 0, false, 21, 0);
            this.lang.nextStep();
            i2 = 1;
            while (i2 <= n) {
                codeSupport.toggleHighlight(21, 0, false, 23, 0);
                this.lang.nextStep();
                int cost = s.charAt(i2 - 1) == t_j ? 0 : 1;
                codeSupport.toggleHighlight(23, 0, false, 24, 0);
                this.lang.nextStep();
                d[i2] = Math.min(Math.min(d[i2 - 1] + 1, p[i2] + 1), p[i2 - 1] + cost);
                ia2.highlightElem(i2 - 1, new MsTiming(0), new MsTiming(250));
                ia2.unhighlightElem(i2 - 1, new MsTiming(750), new MsTiming(250));
                ia1.highlightElem(i2, new MsTiming(0), new MsTiming(250));
                ia1.unhighlightElem(i2, new MsTiming(750), new MsTiming(250));
                ia1.highlightElem(i2 - 1, new MsTiming(0), new MsTiming(250));
                ia1.unhighlightElem(i2 - 1, new MsTiming(750), new MsTiming(250));
                ia2.put(i2, d[i2], new MsTiming(0), new MsTiming(0));
                ia2.highlightCell(i2, new MsTiming(0), new MsTiming(250));
                ia2.unhighlightCell(i2, new MsTiming(750), new MsTiming(250));
                codeSupport.toggleHighlight(24, 0, false, 21, 0);
                this.lang.nextStep();
                ++i2;
            }
            codeSupport.toggleHighlight(21, 0, false, 26, 0);
            this.lang.nextStep();
            Text labelas = this.lang.newText(new Coordinates(160, 120), "Tausche Arrays", "labelas", null, textProps);
            labelas.changeColor("", Color.green, new MsTiming(0), new MsTiming(0));
            _d = (int[])p.clone();
            codeSupport.toggleHighlight(26, 0, false, 27, 0);
            this.lang.nextStep();
            p = (int[])d.clone();
            int z = 0;
            while (z < n + 1) {
                ia1.put(z, d[z], new MsTiming(0), new MsTiming(0));
                ++z;
            }
            codeSupport.toggleHighlight(27, 0, false, 28, 0);
            this.lang.nextStep();
            d = (int[])_d.clone();
            int y = 0;
            while (y < n + 1) {
                ia2.put(y, _d[y], new MsTiming(0), new MsTiming(0));
                ++y;
            }
            labelas.hide();
            codeSupport.toggleHighlight(28, 0, false, 17, 0);
            this.lang.nextStep();
            ++j2;
        }
        codeSupport.toggleHighlight(17, 0, false, 30, 0);
        this.lang.nextStep();
        ia1.highlightElem(n, new MsTiming(0), new MsTiming(0));
        ia1.highlightCell(n, new MsTiming(0), new MsTiming(0));
        Text res = this.lang.newText(new Coordinates(240, 120), "Die Levenshtein-Distanz ist: " + p[n], "Textres", null, textProps);
        res.changeColor("", Color.cyan, new MsTiming(0), new MsTiming(0));
        return p[n];
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    @Override
    public String getName() {
        return "Levenshtein Distanz Algorithmus";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        AnimalScript l = new AnimalScript("Levenstein Distanz Algorithmusmit Array", "Martin Dingeldey, Thomas Poepl, Ulf Karrock", 640, 480);
        Levenstein ls = new Levenstein(l);
        String a = arg1.get("a").toString();
        String b = arg1.get("b").toString();
        ArrayProperties arrayProps = (ArrayProperties)arg0.getPropertiesByName("arrayProps");
        SourceCodeProperties sourceProps = (SourceCodeProperties)arg0.getPropertiesByName("sourceCodeProps");
        TextProperties textProps = (TextProperties)arg0.getPropertiesByName("textProps");
        ls.levensteinDistance(sourceProps, arrayProps, textProps, a, b);
        return ((Object)l).toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Levenshtein Distanzma\ufb02 mit Arrays";
    }

    @Override
    public String getAnimationAuthor() {
        return "Martin Dingeldey, Thomas Poepl, Ulf Karrock";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getFileExtension() {
        String extension = "asu";
        return extension;
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(2);
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public void init() {
    }
}

