/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.searching;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringMatrix;
import algoanim.primitives.generators.Language;
import algoanim.properties.MatrixProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

public class Levenshteinmatrix
implements Generator {
    private Language lang;
    private static final String DESCRIPTION = "Dies eine Animation des Levenstein Distanz Algorithmus";
    private static final String SOURCE_CODE = "public int getLevenshteinDistance(String s, String t)\n{\n  int n = s.length();int m = t.length();\n  if (n == 0)\n  {\n    return m;\n  }\n  else if(m == 0)\n  {\n    return n;\n  }\n  int p[][] = new int[n+1][m+1]\n  int i, j, cost; char t_j;\n  for (i = 0; i<=n; i++)\n  {\n    p[i][0] = i;\n  }\n  for (j = 0; j<=n; j++)\n  {\n    p[0][j] = j;\n  }\n  for (i = 0; i<=n; i++)\n  {\n    for (j = 1; j<=m; j++)\n    {\n    t_j = t.charAt(j-1);\n    cost = s.charAt(i-1)==t_j ? 0 : 1;\n    p[i][j] = Math.min(Math.min(p[i-1][j]+1, p[i][j-1]+1),  p[i-1][j-1]+cost)\n    }\n  }\n  return p[n][m];\n}";

    public Levenshteinmatrix() {
    }

    public Levenshteinmatrix(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void levenshteinDistance(String s, String t, MatrixProperties matrixProps, SourceCodeProperties scProps, TextProperties textProps) {
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scProps);
        sc.addCodeLine("public int getLevenshteinDistance(String s, String t))", null, 0, null);
        sc.addCodeLine("{", null, 0, null);
        sc.addCodeLine("int n = s.length();int m = t.length();", null, 1, null);
        sc.addCodeLine("if (n == 0)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("return m;", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("else if(m == 0)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("return n;", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("int p[][] = new int[n+1][m+1];", null, 1, null);
        sc.addCodeLine("int i, j, cost; char t_j;", null, 1, null);
        sc.addCodeLine("for (i = 0; i<=n; i++)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("p[i][0] = i;", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("for (j = 0; j<=m; j++)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("p[0][j] = j;", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("for (i = 1; i<=n; i++)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("for (j = 1; j<=m; j++)", null, 2, null);
        sc.addCodeLine("{", null, 2, null);
        sc.addCodeLine("t_j = t.charAt(j-1);", null, 3, null);
        sc.addCodeLine("cost = s.charAt(i-1)==t_j ? 0 : 1;", null, 3, null);
        sc.addCodeLine("p[i][j] = Math.min(Math.min(p[i-1][j]+1, p[i][j-1]+1),  p[i-1][j-1]+cost)", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("return p[n][m];", null, 1, null);
        sc.addCodeLine("};", null, 0, null);
        this.lang.newText(new Coordinates(10, 10), "Berechnung der Levenshtein-Distanz zwischen", "label1", null, textProps);
        this.lang.newText(new Coordinates(10, 30), "String s: " + s + " und", "label2", null, textProps);
        this.lang.newText(new Coordinates(10, 50), "String t: " + t, "label3", null, textProps);
        this.lang.nextStep();
        try {
            this.getLevenshteinDistance(sc, matrixProps, textProps, s, t);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private int getLevenshteinDistance(SourceCode codeSupport, MatrixProperties matrixProps, TextProperties textProps, String s, String t) throws LineNotExistsException {
        codeSupport.highlight(0, 0, false);
        this.lang.nextStep();
        codeSupport.toggleHighlight(0, 0, false, 2, 0);
        this.lang.nextStep();
        int n = s.length();
        int m = t.length();
        codeSupport.toggleHighlight(2, 0, false, 3, 0);
        this.lang.nextStep();
        if (n == 0) {
            codeSupport.toggleHighlight(3, 0, false, 5, 0);
            this.lang.nextStep();
            return m;
        }
        codeSupport.toggleHighlight(3, 0, false, 7, 0);
        this.lang.nextStep();
        if (m == 0) {
            codeSupport.toggleHighlight(7, 0, false, 9, 0);
            this.lang.nextStep();
            return n;
        }
        codeSupport.toggleHighlight(7, 0, false, 11, 0);
        this.lang.newText(new Coordinates(410, 10), "Matrix p:", "labelim", null, textProps);
        int[][] p = new int[n + 1][m + 1];
        String[][] q = new String[n + 1][m + 1];
        int a = 0;
        while (a < n + 1) {
            int b = 0;
            while (b < m + 1) {
                q[a][b] = " ";
                ++b;
            }
            ++a;
        }
        int i = 1;
        while (i <= n) {
            q[i][0] = s.substring(i - 1, i);
            ++i;
        }
        int j = 1;
        while (j <= m) {
            q[0][j] = t.substring(j - 1, j);
            ++j;
        }
        StringMatrix im = this.lang.newStringMatrix(new Coordinates(440, 20), q, "stringMatrix", null, matrixProps);
        this.lang.nextStep();
        codeSupport.toggleHighlight(11, 0, false, 12, 0);
        this.lang.nextStep();
        codeSupport.toggleHighlight(12, 0, false, 13, 0);
        this.lang.nextStep();
        int i2 = 1;
        while (i2 <= n) {
            codeSupport.toggleHighlight(13, 0, false, 15, 0);
            im.put(i2, 0, s.substring(i2 - 1, i2), new MsTiming(0), new MsTiming(0));
            im.highlightCell(i2, 1, new MsTiming(0), new MsTiming(250));
            im.put(i2, 1, String.valueOf(i2), new MsTiming(0), new MsTiming(0));
            this.lang.nextStep();
            p[i2][0] = 99;
            p[i2][1] = i2;
            codeSupport.toggleHighlight(15, 0, false, 13, 0);
            im.unhighlightCell(i2, 1, new MsTiming(750), new MsTiming(250));
            this.lang.nextStep();
            ++i2;
        }
        codeSupport.toggleHighlight(13, 0, false, 17, 0);
        this.lang.nextStep();
        int j2 = 1;
        while (j2 <= m) {
            codeSupport.toggleHighlight(17, 0, false, 19, 0);
            im.put(0, j2, t.substring(j2 - 1, j2), new MsTiming(0), new MsTiming(0));
            im.highlightCell(1, j2, new MsTiming(0), new MsTiming(250));
            im.put(1, j2, String.valueOf(j2), new MsTiming(0), new MsTiming(0));
            this.lang.nextStep();
            p[0][j2] = 99;
            p[1][j2] = j2;
            codeSupport.toggleHighlight(19, 0, false, 17, 0);
            im.unhighlightCell(1, j2, new MsTiming(750), new MsTiming(250));
            this.lang.nextStep();
            ++j2;
        }
        codeSupport.toggleHighlight(17, 0, false, 21, 0);
        this.lang.nextStep();
        i2 = 2;
        while (i2 <= n) {
            codeSupport.toggleHighlight(21, 0, false, 23, 0);
            this.lang.nextStep();
            j2 = 2;
            while (j2 <= m) {
                codeSupport.toggleHighlight(23, 0, false, 25, 0);
                this.lang.nextStep();
                char t_j = t.charAt(j2 - 1);
                codeSupport.toggleHighlight(25, 0, false, 26, 0);
                this.lang.nextStep();
                int cost = s.charAt(i2 - 1) == t_j ? 0 : 1;
                codeSupport.toggleHighlight(26, 0, false, 27, 0);
                im.highlightCell(i2, j2, new MsTiming(0), new MsTiming(250));
                p[i2][j2] = Math.min(Math.min(p[i2 - 1][j2] + 1, p[i2][j2 - 1] + 1), p[i2 - 1][j2 - 1] + cost);
                im.put(i2, j2, String.valueOf(p[i2][j2]), new MsTiming(0), new MsTiming(0));
                this.lang.nextStep();
                codeSupport.toggleHighlight(27, 0, false, 23, 0);
                im.unhighlightCell(i2, j2, new MsTiming(750), new MsTiming(250));
                this.lang.nextStep();
                ++j2;
            }
            codeSupport.toggleHighlight(23, 0, false, 21, 0);
            this.lang.nextStep();
            ++i2;
        }
        codeSupport.toggleHighlight(21, 0, false, 29, 0);
        this.lang.nextStep();
        this.lang.newText(new Coordinates(10, 70), "Die Levenshtein-Distanz ist: " + p[n][m], "Textres", null, textProps);
        im.highlightCell(n, m, new MsTiming(0), new MsTiming(0));
        return p[n][m];
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    @Override
    public String getName() {
        return "Levenshtein Distanz Algorithmus";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        AnimalScript l = new AnimalScript("Levenstein Distanz Algorithmus", "Martin Dingeldey, Thomas Poepl, Ulf Karrock", 640, 480);
        Levenshteinmatrix ls = new Levenshteinmatrix(l);
        String a = arg1.get("a").toString();
        String b = arg1.get("b").toString();
        MatrixProperties matrixProps = (MatrixProperties)arg0.getPropertiesByName("mProps");
        SourceCodeProperties sourceProps = (SourceCodeProperties)arg0.getPropertiesByName("sourceCodeProps");
        TextProperties textProps = (TextProperties)arg0.getPropertiesByName("textProps");
        ls.levenshteinDistance(a, b, matrixProps, sourceProps, textProps);
        return ((Object)l).toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Levenshtein Distanzmass";
    }

    @Override
    public String getAnimationAuthor() {
        return "Martin Dingeldey, Thomas Poepl, Ulf Karrock";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getFileExtension() {
        String extension = "asu";
        return extension;
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(2);
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public void init() {
    }
}

