/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.searching;

import algoanim.interactionsupport.FillInBlanksQuestion;
import algoanim.interactionsupport.GroupInfo;
import algoanim.interactionsupport.MultipleChoiceQuestion;
import algoanim.primitives.ArrayMarker;
import algoanim.util.Offset;
import avinteraction.parser.InteractionFactory;
import generator.Generator;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.searching.AbstractBinaryIntSearching;
import java.util.Hashtable;
import java.util.Locale;

public class GenericIterativeBinaryIntSearching
extends AbstractBinaryIntSearching
implements Generator {
    private InteractionFactory f;

    public GenericIterativeBinaryIntSearching(String aResourceName, Locale aLocale) {
        super(aResourceName, aLocale);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        int valueToSearchFor = (Integer)prims.get("value");
        this.lang.setInteractionType(1024);
        this.lang.addQuestionGroup(new GroupInfo(this.lang, "mid", 2));
        this.f = new InteractionFactory(this.lang, "InteractionPatterns.xml");
        this.search(valueToSearchFor);
        this.wrapUpAnimation();
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    protected int search(int valueToSearchFor) {
        ArrayMarker lMarker = null;
        ArrayMarker rMarker = null;
        ArrayMarker midMarker = null;
        MultipleChoiceQuestion mcq = new MultipleChoiceQuestion(this.lang, "Eigenschaft");
        mcq.setPrompt("Welche Eigenschaft muss erf\u00b8llt sein, damit eine Bin\u2030re Suche erfolgreich ist?");
        mcq.setPointsPossible(2);
        mcq.addAnswerOption("Das Suchfeld muss sortiert sein", true, "Ohne vorherige Sortierung findet die Bin\u2030re Suche nur zuf\u2030llig das richtige Element", 2);
        mcq.addAnswerOption("Das Suchfeld darf nicht mehr als 1024 Elemente beinhalten", false, "Die Gr\u02c6\ufb02e des Suchraums ist nicht begrenzt", -1);
        mcq.addAnswerOption("Das Suchfeld muss eine gemischte Folge von Zahlen und Buchstaben enthalten", false, "Zwar k\u02c6nnen Buchstaben anhand ihrer Zahlenrepr\u2030sentation sortiert werden, jedoch ist die Verwendung von Zahlen und Buchstaben im Suchfeld optional", -1);
        this.lang.addMCQuestion(mcq);
        this.lang.nextStep();
        this.valueText = this.installText("value", "value: " + valueToSearchFor, new Offset(30, 0, this.array, "SE"));
        this.code.highlight("header");
        this.lang.nextStep();
        this.code.toggleHighlight("header", "ifNull");
        this.incrementNrComparisons(2);
        this.lang.nextStep();
        this.code.toggleHighlight("ifNull", "getArrayLength");
        int nrElems = this.array.getLength();
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.toggleHighlight("getArrayLength", "installLMarker");
        lMarker = this.installArrayMarker("lMarker", this.array, 0);
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.toggleHighlight("installLMarker", "installRMarker");
        rMarker = this.installArrayMarker("rMarker", this.array, nrElems - 1);
        this.incrementNrAssignments();
        this.array.highlightCell(0, nrElems - 1, DEFAULT_TIMING, null);
        this.lang.nextStep();
        this.code.toggleHighlight("installRMarker", "installMidMarker");
        midMarker = this.installArrayMarker("midMarker", this.array, (lMarker.getPosition() + rMarker.getPosition()) / 2);
        this.array.highlightElem(midMarker.getPosition(), null, null);
        this.incrementNrAssignments();
        this.lang.nextStep();
        FillInBlanksQuestion fib = new FillInBlanksQuestion(this.lang, "Iterationen");
        fib.setPrompt("Wieviele Iterationen ben\u02c6tigt die Bin\u2030re Suche um das gesuchte Element zu finden?");
        fib.setPointsPossible(5);
        this.lang.addFIBQuestion(fib);
        this.lang.nextStep();
        FillInBlanksQuestion fib2 = this.f.generateFIBQuestion("nrComparisons", "AnzahlVergleiche", new String[0]);
        this.code.toggleHighlight("installMidMarker", "whileLoop");
        int iteration = 0;
        while (rMarker.getPosition() > lMarker.getPosition() && this.array.getData(midMarker.getPosition()) != valueToSearchFor) {
            ++iteration;
            this.incrementNrComparisons(3);
            this.lang.nextStep();
            this.code.toggleHighlight("whileLoop", "ifLess");
            this.incrementNrComparisons();
            this.lang.nextStep();
            MultipleChoiceQuestion mcq2 = new MultipleChoiceQuestion(this.lang, "midElement" + iteration);
            mcq2.setPrompt("Welches ist das n\u2030chste, mittlere Element?");
            mcq2.setPointsPossible(1);
            mcq2.setQuestionGroup("mid");
            this.lang.addMCQuestion(mcq2);
            this.lang.nextStep();
            if (valueToSearchFor < this.array.getData(midMarker.getPosition())) {
                this.code.toggleHighlight("ifLess", "continueLeft");
                this.array.unhighlightCell(midMarker.getPosition(), rMarker.getPosition(), DEFAULT_TIMING, DEFAULT_TIMING);
                rMarker.move(midMarker.getPosition() - 1, null, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.unhighlight("continueLeft");
            } else {
                this.code.toggleHighlight("ifLess", "continueRight");
                this.array.unhighlightCell(lMarker.getPosition(), midMarker.getPosition(), DEFAULT_TIMING, DEFAULT_TIMING);
                lMarker.move(midMarker.getPosition() + 1, null, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.unhighlight("continueRight");
            }
            this.code.highlight("updateMidElem");
            this.array.unhighlightElem(midMarker.getPosition(), null, null);
            midMarker.move((lMarker.getPosition() + rMarker.getPosition()) / 2, null, DEFAULT_TIMING);
            this.array.highlightElem(midMarker.getPosition(), null, null);
            mcq2.addAnswerOption("" + this.array.getData(midMarker.getPosition()), true, "Das ist korrekt", 1);
            if (midMarker.getPosition() == this.array.getLength() - 1) {
                mcq2.addAnswerOption("" + this.array.getData(midMarker.getPosition() - 2), false, "Das n\u2030chste mittlere Element lautet: " + this.array.getData(midMarker.getPosition()), -1);
            } else {
                mcq2.addAnswerOption("" + this.array.getData(midMarker.getPosition() + 1), false, "Das n\u2030chste mittlere Element lautet: " + this.array.getData(midMarker.getPosition()), -1);
            }
            if (midMarker.getPosition() == 0) {
                mcq2.addAnswerOption("" + this.array.getData(midMarker.getPosition() + 2), false, "Das n\u2030chste mittlere Element lautet: " + this.array.getData(midMarker.getPosition()), -1);
            } else {
                mcq2.addAnswerOption("" + this.array.getData(midMarker.getPosition() - 1), false, "Das n\u2030chste mittlere Element lautet: " + this.array.getData(midMarker.getPosition()), -1);
            }
            this.incrementNrAssignments();
            this.lang.nextStep();
            this.code.toggleHighlight("updateMidElem", "whileLoop");
        }
        this.incrementNrComparisons(3);
        this.lang.nextStep();
        this.code.toggleHighlight("whileLoop", "checkFound");
        this.incrementNrComparisons();
        fib.addAnswer("" + iteration, "Die korrekte Antwort lautet: " + iteration, 5);
        fib2.addAnswer("" + this.nrComparisons, "Die korrekte Antwort lautet: " + this.nrComparisons, 5);
        this.lang.nextStep();
        if (this.array.getData(midMarker.getPosition()) == valueToSearchFor) {
            this.code.toggleHighlight("checkFound", "found");
            this.result = this.installText("value", this.translator.translateMessage("result", new Integer[]{new Integer(midMarker.getPosition())}), new Offset(20, 0, this.valueText, "baseline end"));
            this.lang.nextStep();
            this.code.unhighlight("found");
            return midMarker.getPosition();
        }
        this.code.toggleHighlight("checkFound", "notFound");
        this.result = this.installText("value", this.translator.translateMessage("result", new Integer[]{new Integer(-1)}), new Offset(20, 0, this.valueText, "baseline end"));
        this.lang.nextStep();
        this.code.unhighlight("notFound");
        return -1;
    }
}

