/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.misc;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringMatrix;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayProperties;
import algoanim.properties.MatrixProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.helpers.VogelApproxHelper;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class VogelApproximation
implements Generator {
    static int[] angebot;
    static int[] nachfrage;
    static boolean[] markierteZeilen;
    static boolean[] markierteSpalten;
    static int maxDsIndex_global;
    static int maxDzIndex_global;
    static int indexMinZeile;
    static int indexMinSpalte;
    static int transportmenge;

    public static String getCode(AnimationPropertiesContainer properties, Hashtable<String, Object> primitives) {
        Vector<Integer> lsgIndexVector = new Vector<Integer>(2);
        AnimalScript lang = new AnimalScript("Vogelsche Approximationsmethode", "Petra Doersam, Kevin Tappe", 640, 480);
        ((Language)lang).setStepMode(true);
        int[] a = (int[])primitives.get("anbieter");
        int[] b = (int[])primitives.get("nachfrager");
        int[][] c = (int[][])primitives.get("kosten");
        TextProperties tp = new TextProperties();
        tp.set("color", Color.BLACK);
        ArrayProperties arrayProps = new ArrayProperties();
        arrayProps.set("color", Color.BLACK);
        arrayProps.set("fillColor", Color.WHITE);
        int[][] b_j_daten = new int[1][b.length];
        int i = 0;
        while (i < b.length) {
            b_j_daten[0][i] = b[i];
            ++i;
        }
        int[][] a_j_daten = new int[a.length][1];
        int j = 0;
        while (j < a.length) {
            a_j_daten[j][0] = a[j];
            ++j;
        }
        int[][] b_j_anzahl = new int[1][b.length];
        int i2 = 0;
        while (i2 < b.length) {
            b_j_anzahl[0][i2] = i2 + 1;
            ++i2;
        }
        int[][] a_i_anzahl = new int[a.length][1];
        int i3 = 0;
        while (i3 < a.length) {
            a_i_anzahl[i3][0] = i3 + 1;
            ++i3;
        }
        MatrixProperties matrix_redhighlight_props = new MatrixProperties();
        matrix_redhighlight_props.set("color", Color.BLACK);
        matrix_redhighlight_props.set("fillColor", Color.WHITE);
        matrix_redhighlight_props.set("filled", Boolean.FALSE);
        matrix_redhighlight_props.set("elementColor", Color.BLACK);
        matrix_redhighlight_props.set("elemHighlight", Color.RED);
        MatrixProperties matrix_grayhighlight_props = new MatrixProperties();
        matrix_grayhighlight_props.set("fillColor", Color.WHITE);
        matrix_grayhighlight_props.set("elementColor", Color.BLACK);
        matrix_grayhighlight_props.set("elemHighlight", Color.GRAY);
        int[][] lsgMatrixWerte = new int[a.length][b.length];
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        SourceCodeProperties scHeadProps = new SourceCodeProperties();
        scHeadProps.set("font", new Font("SansSerif", 1, 16));
        SourceCodeProperties scNormalProps = new SourceCodeProperties();
        scNormalProps.set("font", new Font("SansSerif", 1, 12));
        SourceCode einleitung1 = ((Language)lang).newSourceCode(new Coordinates(30, 120), "einleitung1", null, scNormalProps);
        einleitung1.addCodeLine("Bei der Vogelschen Approximationsmethode handelt es sich um eine Heuristik zum Loesen des klassischen Transportproblems.", null, 0, null);
        einleitung1.addCodeLine("", null, 0, null);
        einleitung1.addCodeLine("Das klassische Transportproblem (TPP) ist ein lineares Optimierungsproblem:", null, 0, null);
        einleitung1.addCodeLine("Zwischem m Anbietern A_i (i = 1...m) und n Nachfragern B_j (j = 1...n) soll ein Gut transportiert werden.", null, 0, null);
        einleitung1.addCodeLine("Die Anbieter bieten die Angebotsmengen a = (a_1, ..., a_m) an und die Nachfrager moechten die Nachfragemengen b = (b_1, ..., b_m).", null, 0, null);
        einleitung1.addCodeLine("Durch Angabe einer Transportkostenmatrix C, die die Transportkosten pro Mengeneinheit des Gutes fuer jeden moeglichen Weg zwischen Anbietern und Nachfragern", null, 0, null);
        einleitung1.addCodeLine("wiedergibt, entsteht ein Optimierungsproblem: Es soll ein kostenminimaler Transportplan fuer die Konstellation aus Angebots- und Nachfragemengen gefunden werden.", null, 0, null);
        einleitung1.addCodeLine("Als Nebenbedingung gilt: Die Summe der Angebotsmengen muss gleich der Summe der Nachfragemengen sein.", null, 0, null);
        lang.nextStep();
        SourceCode weitereAlgo = ((Language)lang).newSourceCode(new Coordinates(30, 350), "weitereAlgo", null, scNormalProps);
        weitereAlgo.addCodeLine("Die Vogelsche Approximationsmethode ist nur eine Heuristik unter vielen.", null, 0, null);
        weitereAlgo.addCodeLine("Weitere Heuristiken fuer das klassische Transportproblem sind beispielsweise", null, 0, null);
        weitereAlgo.addCodeLine("die Nordwest-Ecken-Regel und die Spaltenminimum-Methode.", null, 0, null);
        weitereAlgo.addCodeLine("Natuerlich gibt es auch Algorithmen, die stets eine optimale Loesung finden. Hier seien der", null, 0, null);
        weitereAlgo.addCodeLine("Simplex-Algorithmus (fuer alle linearen Optimierungsprobleme) sowie die MODI-Methode und die", null, 0, null);
        weitereAlgo.addCodeLine("Stepping-Stone-Methode genannt. Die beiden letztgenannten sind im Vergleich zum Simplex-Algorithmus", null, 0, null);
        weitereAlgo.addCodeLine("fuer das klassische TPP effizienter, da sie die spezielle Struktur der Problemstellung ausnutzen.", null, 0, null);
        lang.nextStep();
        einleitung1.hide();
        weitereAlgo.hide();
        SourceCode einleitung2 = ((Language)lang).newSourceCode(new Coordinates(30, 220), "einleitung2", null, scNormalProps);
        einleitung2.addCodeLine("Oben finden sich die Angaben zur den Angebots- und Nachfragemengen,", null, 0, null);
        einleitung2.addCodeLine("sowie die Transportkosten. Diese Angaben finden sich auch in den", null, 0, null);
        einleitung2.addCodeLine("unten erscheinenden Matrizen, in welchen der Algorithmus visualisiert wird, wieder.", null, 0, null);
        ((Language)lang).newText(new Coordinates(20, 50), "Angebotsmenge a = ", "angebotsText", null, tp);
        ((Language)lang).newIntArray(new Coordinates(145, 45), a, "angebot", null, arrayProps);
        ((Language)lang).newText(new Coordinates(20, 85), "Nachfragemente b = ", "nachfrageText", null, tp);
        ((Language)lang).newIntArray(new Coordinates(145, 80), b, "nachfrage", null, arrayProps);
        Text textKosten = ((Language)lang).newText(new Coordinates(400, 65), "Transportkostenmatrix C = ", "kostenText", null, tp);
        IntMatrix initC = ((Language)lang).newIntMatrix(new Offset(5, -20, textKosten, "NE"), c, "kosten_anzeige", null, matrix_redhighlight_props);
        lang.nextStep();
        String[][] waagLinie = new String[1][b.length + 2];
        int count = 0;
        while (count < b.length + 2) {
            waagLinie[0][count] = "_";
            ++count;
        }
        String[][] senkLinie = new String[a.length + 2][1];
        int count2 = 0;
        while (count2 < a.length + 2) {
            senkLinie[count2][0] = "|";
            ++count2;
        }
        IntMatrix a_i_anz = ((Language)lang).newIntMatrix(new Coordinates(120, 560), a_i_anzahl, "a_i_anz", null, matrix_grayhighlight_props);
        IntMatrix lsgMatrix = ((Language)lang).newIntMatrix(new Offset(0, 3, a_i_anz, "NE"), lsgMatrixWerte, "lsgMatrix", null, matrix_redhighlight_props);
        IntMatrix b_j = ((Language)lang).newIntMatrix(new Offset(0, 18, lsgMatrix, "SW"), b_j_daten, "b_j", null, matrix_redhighlight_props);
        IntMatrix a_i = ((Language)lang).newIntMatrix(new Offset(0, 0, lsgMatrix, "NE"), a_j_daten, "a_i", null, matrix_redhighlight_props);
        IntMatrix a_i_anz2 = ((Language)lang).newIntMatrix(new Offset(200, -2, lsgMatrix, "NE"), a_i_anzahl, "a_i_anz2", null, matrix_grayhighlight_props);
        String[][] c_String = new String[c.length][c[0].length];
        int count3 = 0;
        while (count3 < c.length) {
            int x = 0;
            while (x < c[0].length) {
                c_String[count3][x] = new Integer(c[count3][x]).toString();
                ++x;
            }
            ++count3;
        }
        StringMatrix kostenmatrix = ((Language)lang).newStringMatrix(new Offset(0, 0, a_i_anz2, "NE"), c_String, "kostenmatrix", null, matrix_redhighlight_props);
        ((Language)lang).newStringMatrix(new Offset(-10, -28, kostenmatrix, "NE"), senkLinie, "senkLinieKMatrix", null, matrix_redhighlight_props);
        ((Language)lang).newStringMatrix(new Offset(-10, -28, kostenmatrix, "NW"), senkLinie, "senkLinieKMatrix2", null, matrix_redhighlight_props);
        StringMatrix waagrechteLinie = ((Language)lang).newStringMatrix(new Offset(-28, -20, kostenmatrix, "NW"), waagLinie, "waagLinieKMatrix", null, matrix_redhighlight_props);
        ((Language)lang).newStringMatrix(new Offset(-28, -20, kostenmatrix, "SW"), waagLinie, "waagLinieKMatrix2", null, matrix_redhighlight_props);
        IntMatrix b_j_anz2 = ((Language)lang).newIntMatrix(new Offset(-30, -3, waagrechteLinie, "N"), b_j_anzahl, "b_j_anz", null, matrix_grayhighlight_props);
        ((Language)lang).newText(new Offset(-80, -20, a_i_anz2, "W"), "Anbieter A_i", "aText", null, tp);
        ((Language)lang).newText(new Offset(-40, -20, b_j_anz2, "N"), "Nachfrager B_j", "bText", null, tp);
        ((Language)lang).newText(new Offset(-23, -15, waagrechteLinie, "E"), "dz", "dzText", null, tp);
        ((Language)lang).newText(new Offset(-30, 0, a_i_anz2, "SE"), "ds", "dsText", null, tp);
        ((Language)lang).newStringMatrix(new Offset(-10, -28, lsgMatrix, "NE"), senkLinie, "senkLinieLsgMatrix", null, matrix_redhighlight_props);
        ((Language)lang).newStringMatrix(new Offset(-10, -28, lsgMatrix, "NW"), senkLinie, "senkLinieLsgMatrix2", null, matrix_redhighlight_props);
        StringMatrix waagrechteLinieMlinks = ((Language)lang).newStringMatrix(new Offset(-28, -20, lsgMatrix, "NW"), waagLinie, "waagLinieLsgMatrixlinks", null, matrix_redhighlight_props);
        ((Language)lang).newStringMatrix(new Offset(-28, -20, lsgMatrix, "SW"), waagLinie, "waagLinieLsgMatrix2", null, matrix_redhighlight_props);
        IntMatrix b_j_anz = ((Language)lang).newIntMatrix(new Offset(-30, -3, waagrechteLinieMlinks, "N"), b_j_anzahl, "b_j_anz", null, matrix_grayhighlight_props);
        ((Language)lang).newText(new Offset(-80, -20, a_i_anz, "W"), "Anbieter A_i", "aText_Lsg", null, tp);
        ((Language)lang).newText(new Offset(-40, -20, b_j_anz, "N"), "Nachfrager B_j", "bText_Lsg", null, tp);
        ((Language)lang).newText(new Offset(-28, -18, waagrechteLinieMlinks, "E"), "Rest", "dzText", null, tp);
        ((Language)lang).newText(new Offset(-35, 5, a_i_anz, "SE"), "Rest", "dsText", null, tp);
        ((Language)lang).newText(new Offset(-90, -65, kostenmatrix, "N"), "Transportkosten / Regretwerte:", "ueberschrift_kostenmatrix", null, tp);
        ((Language)lang).newText(new Offset(-125, -65, lsgMatrix, "N"), "realisierte und restliche Transportmengen:", "ueberschrift_transportmengen", null, tp);
        ((Language)lang).newText(new Offset(-60, 40, kostenmatrix, "SW"), "X markiert einen gestrichenen Eintrag", "hinweis_gestrichen", null, tp);
        String[][] dz_matrix = new String[a.length][1];
        int x = 0;
        while (x < a.length) {
            dz_matrix[x][0] = " ";
            ++x;
        }
        String[][] ds_matrix = new String[1][b.length];
        int x2 = 0;
        while (x2 < b.length) {
            ds_matrix[0][x2] = " ";
            ++x2;
        }
        StringMatrix dz_i = ((Language)lang).newStringMatrix(new Offset(0, 0, kostenmatrix, "NE"), dz_matrix, "dz", null, matrix_redhighlight_props);
        StringMatrix ds_j = ((Language)lang).newStringMatrix(new Offset(0, 0, kostenmatrix, "SW"), ds_matrix, "ds", null, matrix_redhighlight_props);
        lang.nextStep();
        einleitung2.hide();
        SourceCode einleitung3 = ((Language)lang).newSourceCode(new Coordinates(30, 140), "einleitung3", null, scNormalProps);
        einleitung3.addCodeLine("Die Transportmengenmatrix unten links wird die realisierten Transportmengen schrittweise anzeigen.", null, 0, null);
        einleitung3.addCodeLine("Rechts von dieser Matrix werden die noch zu verteilenden restlichen Angebotsmengen angezeigt,", null, 0, null);
        einleitung3.addCodeLine("unterhalb die noch zu verteilenden Transportmengen.", null, 0, null);
        einleitung3.addCodeLine("", null, 0, null);
        einleitung3.addCodeLine("Die Transportkostenmatrix unten rechts enthaelt zunaechst die gleichen Werte wie die Matrix C oben rechts.", null, 0, null);
        einleitung3.addCodeLine("Waehrend der Ausfuehrung des Algorithmus werden jedoch Zeilen und Spalten dieser Matrix gestrichen. ", null, 0, null);
        einleitung3.addCodeLine("Rechts von dieser Matrix werden die Zeilenregretwerte (dz) angezeigt,", null, 0, null);
        einleitung3.addCodeLine("unterhalb die Spaltenregretwerte (ds).", null, 0, null);
        einleitung3.addCodeLine("", null, 0, null);
        einleitung3.addCodeLine("", null, 0, null);
        einleitung3.addCodeLine("Die Vogelsche Approximationsmethode baut auf dem Konzept des maximalen Regretwertes (= 'groesstes Bedauern') auf:", null, 0, null);
        einleitung3.addCodeLine("Die Transportwege werden schrittweise ausgewaehlt und mit Transportmengen bestueckt. Dies geschieht bei jeder Iteration so, dass zuerst anhand des maximalen", null, 0, null);
        einleitung3.addCodeLine("Regretwertes ein Anbieter oder Nachfrager ausgewaehlt wird. Fuer diesen Anbieter bzw. Nachfrager wird dann ein Weg mit minimalen Transportkosten bestimmt und", null, 0, null);
        einleitung3.addCodeLine("mit der maximal moeglichen Transportmenge realisiert. So werden zukuenftige hoehere Transportkosten umgangen.", null, 0, null);
        lang.nextStep();
        einleitung3.hide();
        SourceCode einleitung4 = ((Language)lang).newSourceCode(new Coordinates(30, 140), "einleitung4", null, scNormalProps);
        einleitung4.addCodeLine("", null, 0, null);
        einleitung4.addCodeLine("Die Vogelsche Approximationsmethode besteht aus zwei Teilen:", null, 0, null);
        einleitung4.addCodeLine("", null, 0, null);
        einleitung4.addCodeLine("* Im ersten Teil des Algorithmus werden Transportmengen solange ", null, 1, null);
        einleitung4.addCodeLine("  nach dem Prinzip des maximalen Regrets verteilt, bis entweder ", null, 1, null);
        einleitung4.addCodeLine("  m-1 Zeilen oder n-1 Spalten der Transportmengenmatrix belegt (= gestrichen) sind.", null, 1, null);
        einleitung4.addCodeLine("", null, 1, null);
        einleitung4.addCodeLine("* Im zweiten Teil des Algorithmus werden die noch verbleibenden ", null, 1, null);
        einleitung4.addCodeLine("  Transportmengen verteilt.", null, 1, null);
        einleitung4.addCodeLine("", null, 0, null);
        einleitung4.addCodeLine("(mit m = Anzahl Zeilen = Anzahl Anbieter, n = Anzahl Spalten = Anzahl Nachfrager)", null, 0, null);
        lang.nextStep();
        einleitung4.hide();
        SourceCode scHead = ((Language)lang).newSourceCode(new Coordinates(30, 140), "ueberschrift_ersterTeil", null, scHeadProps);
        scHead.addCodeLine("Erster Teil des Algorithmus (Verteilen nach maximalem Regret):", null, 0, null);
        SourceCode sc = ((Language)lang).newSourceCode(new Coordinates(30, 190), "sourceCodeTeil1", null, scProps);
        sc.addCodeLine("Schleife: Solange (noch nicht m-1 Zeilen gestrichen) ODER (noch nicht n-1 Spalten gestrichen)) {", null, 0, null);
        sc.addCodeLine("Fuer jede ungestrichen Zeile i in der Transportkostenmatrix:", null, 1, null);
        sc.addCodeLine("* Bestimme die zwei kleinsten Werte und berechne deren Differenz (= Regretwert dz)", null, 2, null);
        sc.addCodeLine("Fuer jede ungestrichene Spalte j in der Transportkostenmatrix:", null, 1, null);
        sc.addCodeLine("* Bestimme die zwei kleinsten Werte und berechne deren Differenz (= Regretwert ds);", null, 2, null);
        sc.addCodeLine("Waehle die Zeile oder Spalte mit dem maximalen Regretwert, die nicht gestrichen ist", null, 1, null);
        sc.addCodeLine("Bestimme die guenstigste Verbindung in dieser Zeile/Spalte, d.h. die minimalen Transportkosten", null, 1, null);
        sc.addCodeLine("Realisiere die Transportmenge fuer diese minimalen Transportkosten:", null, 1, null);
        sc.addCodeLine("* Transportmenge := Minimum(Angebot[i], Nachfrage[j])", null, 2, null);
        sc.addCodeLine("* Angebot[i] := Angebot[i] - Tranportmenge", null, 2, null);
        sc.addCodeLine("* Nachfrage[j] := Nachfrage[j] - Tranportmenge", null, 2, null);
        sc.addCodeLine("Falls Angebot[i] = 0 => streiche i-te Zeile", null, 1, null);
        sc.addCodeLine("ansonsten gilt Nachfrage[j] = 0 => streiche j-te Spalte", null, 2, null);
        sc.addCodeLine("} // Schleifenabbruchbedingung erfuellt (m-1 Zeilen ODER n-1 Spalten gestrichen) -> Ende der Schleife", null, 0, null);
        int i4 = a.length;
        int j2 = b.length;
        markierteZeilen = new boolean[i4];
        markierteSpalten = new boolean[j2];
        VogelApproximation.initMarkierung(markierteZeilen);
        VogelApproximation.initMarkierung(markierteSpalten);
        angebot = new int[i4];
        nachfrage = new int[j2];
        angebot = a;
        nachfrage = b;
        lang.nextStep();
        sc.highlight(0);
        while (VogelApproximation.zaehleMarkierungen(markierteZeilen) < i4 - 1 && VogelApproximation.zaehleMarkierungen(markierteSpalten) < j2 - 1) {
            int q;
            int sMaxReg;
            int zMaxReg;
            Vector<Object> regretVektoren = new Vector(2);
            regretVektoren = VogelApproximation.berechneRegretwerte(c);
            int[] indexKleinstesEle = new int[2];
            int prev_z = 0;
            lang.nextStep();
            sc.unhighlight(0);
            sc.highlight(1);
            sc.highlight(2);
            lang.nextStep();
            int z = 0;
            while (z < i4) {
                if (!markierteZeilen[z]) {
                    kostenmatrix.unhighlightCell(prev_z, indexKleinstesEle[0], null, null);
                    kostenmatrix.unhighlightCell(prev_z, indexKleinstesEle[1], null, null);
                    indexKleinstesEle = VogelApproximation.findeIndexKleinsteEle(c[z], markierteSpalten);
                    kostenmatrix.highlightCell(z, indexKleinstesEle[0], null, null);
                    kostenmatrix.highlightCell(z, indexKleinstesEle[1], null, null);
                    prev_z = z;
                    lang.nextStep();
                    int[] dz_array = (int[])regretVektoren.get(0);
                    String[] dz_String = new String[dz_array.length];
                    int k = 0;
                    while (k < dz_array.length) {
                        dz_String[k] = new Integer(dz_array[k]).toString();
                        ++k;
                    }
                    dz_i.put(z, 0, dz_String[z], null, null);
                    dz_i.highlightCell(z, 0, null, null);
                    lang.nextStep();
                    dz_i.unhighlightCell(z, 0, null, null);
                }
                ++z;
            }
            sc.unhighlight(1);
            sc.unhighlight(2);
            kostenmatrix.unhighlightCell(prev_z, indexKleinstesEle[0], null, null);
            kostenmatrix.unhighlightCell(prev_z, indexKleinstesEle[1], null, null);
            int[] indexKleinstesEleSp = new int[2];
            int prev_s = 0;
            int[] spalten_array = new int[a.length];
            sc.highlight(3);
            sc.highlight(4);
            lang.nextStep();
            int s = 0;
            while (s < j2) {
                if (!markierteSpalten[s]) {
                    kostenmatrix.unhighlightCell(indexKleinstesEleSp[0], prev_s, null, null);
                    kostenmatrix.unhighlightCell(indexKleinstesEleSp[1], prev_s, null, null);
                    int k = 0;
                    while (k < a.length) {
                        spalten_array[k] = c[k][s];
                        ++k;
                    }
                    indexKleinstesEleSp = VogelApproximation.findeIndexKleinsteEle(spalten_array, markierteZeilen);
                    kostenmatrix.highlightCell(indexKleinstesEleSp[0], s, null, null);
                    kostenmatrix.highlightCell(indexKleinstesEleSp[1], s, null, null);
                    prev_s = s;
                    lang.nextStep();
                    int[] ds_array = (int[])regretVektoren.get(1);
                    String[] ds_String = new String[ds_array.length];
                    int k2 = 0;
                    while (k2 < ds_array.length) {
                        ds_String[k2] = new Integer(ds_array[k2]).toString();
                        ++k2;
                    }
                    ds_j.put(0, s, ds_String[s], null, null);
                    ds_j.highlightCell(0, s, null, null);
                    lang.nextStep();
                    ds_j.unhighlightCell(0, s, null, null);
                }
                ++s;
            }
            sc.unhighlight(3);
            sc.unhighlight(4);
            kostenmatrix.unhighlightCell(indexKleinstesEleSp[0], prev_s, null, null);
            kostenmatrix.unhighlightCell(indexKleinstesEleSp[1], prev_s, null, null);
            int[] maxRegret = VogelApproximation.berechneMaxRegret(regretVektoren);
            VogelApproximation.realisiere(c, maxRegret);
            if (maxRegret[1] == 0) {
                zMaxReg = maxDzIndex_global;
                sMaxReg = indexMinZeile;
                sc.toggleHighlight(4, 5);
                lang.nextStep();
                dz_i.highlightCell(zMaxReg, 0, null, null);
            } else {
                sMaxReg = maxDsIndex_global;
                zMaxReg = indexMinSpalte;
                sc.toggleHighlight(4, 5);
                lang.nextStep();
                ds_j.highlightCell(0, sMaxReg, null, null);
            }
            lang.nextStep();
            sc.toggleHighlight(5, 6);
            lang.nextStep();
            kostenmatrix.highlightCell(zMaxReg, sMaxReg, null, null);
            lsgMatrix.highlightCell(zMaxReg, sMaxReg, null, null);
            lsgIndexVector.add(0, zMaxReg);
            lsgIndexVector.add(1, sMaxReg);
            lang.nextStep();
            ds_j.unhighlightCell(0, sMaxReg, null, null);
            dz_i.unhighlightCell(zMaxReg, 0, null, null);
            sc.unhighlight(6);
            sc.highlight(7);
            lang.nextStep();
            sc.highlight(8);
            lang.nextStep();
            b_j.highlightCell(0, sMaxReg, null, null);
            a_i.highlightCell(zMaxReg, 0, null, null);
            lang.nextStep();
            lsgMatrix.put(zMaxReg, sMaxReg, transportmenge, null, null);
            lang.nextStep();
            sc.toggleHighlight(8, 9);
            b_j.unhighlightCell(0, sMaxReg, null, null);
            lang.nextStep();
            a_i.put(zMaxReg, 0, angebot[zMaxReg], null, null);
            lang.nextStep();
            sc.toggleHighlight(9, 10);
            a_i.unhighlightCell(zMaxReg, 0, null, null);
            b_j.highlightCell(0, sMaxReg, null, null);
            lang.nextStep();
            b_j.put(0, sMaxReg, nachfrage[sMaxReg], null, null);
            lang.nextStep();
            b_j.unhighlightCell(0, sMaxReg, null, null);
            lsgMatrix.unhighlightCell(zMaxReg, sMaxReg, null, null);
            sc.unhighlight(7);
            sc.unhighlight(10);
            sc.highlight(11);
            a_i.highlightCell(zMaxReg, 0, null, null);
            lang.nextStep();
            if (markierteZeilen[zMaxReg]) {
                a_i_anz2.highlightCell(zMaxReg, 0, null, null);
                a_i_anz.highlightCell(zMaxReg, 0, null, null);
                dz_i.put(zMaxReg, 0, "X", null, null);
                kostenmatrix.highlightCellColumnRange(zMaxReg, kostenmatrix.getNrCols() - 1, 0, null, null);
                q = 0;
                while (q < kostenmatrix.getNrCols()) {
                    kostenmatrix.put(zMaxReg, q, "X", null, null);
                    ++q;
                }
                lang.nextStep();
                a_i_anz2.unhighlightCell(zMaxReg, 0, null, null);
                a_i_anz.unhighlightCell(zMaxReg, 0, null, null);
                kostenmatrix.unhighlightCellColumnRange(zMaxReg, kostenmatrix.getNrCols() - 1, 0, null, null);
                sc.unhighlight(11);
                a_i.unhighlightCell(zMaxReg, 0, null, null);
            } else {
                if (markierteSpalten[sMaxReg]) {
                    sc.unhighlight(11);
                    a_i.unhighlightCell(zMaxReg, 0, null, null);
                    b_j.highlightCell(0, sMaxReg, null, null);
                    sc.highlight(12);
                    b_j_anz.highlightCell(0, sMaxReg, null, null);
                    lang.nextStep();
                    a_i.unhighlightCell(zMaxReg, 0, null, null);
                    b_j_anz2.highlightCell(0, sMaxReg, null, null);
                    b_j_anz.highlightCell(0, sMaxReg, null, null);
                    ds_j.put(0, sMaxReg, "X", null, null);
                    kostenmatrix.highlightCellRowRange(0, kostenmatrix.getNrRows() - 1, sMaxReg, null, null);
                    q = 0;
                    while (q < kostenmatrix.getNrRows()) {
                        kostenmatrix.put(q, sMaxReg, "X", null, null);
                        ++q;
                    }
                }
                lang.nextStep();
                a_i.unhighlightCell(zMaxReg, 0, null, null);
                b_j.unhighlightCell(0, sMaxReg, null, null);
                b_j_anz2.unhighlightCell(0, sMaxReg, null, null);
                b_j_anz.unhighlightCell(0, sMaxReg, null, null);
                kostenmatrix.unhighlightCellRowRange(0, kostenmatrix.getNrRows() - 1, sMaxReg, null, null);
                sc.unhighlight(12);
            }
            sc.highlight(0);
            b_j.unhighlightCell(0, sMaxReg, null, null);
            a_i.unhighlightCell(zMaxReg, 0, null, null);
            kostenmatrix.unhighlightCell(zMaxReg, sMaxReg, null, null);
            lsgMatrix.unhighlightCell(zMaxReg, sMaxReg, null, null);
        }
        lang.nextStep();
        sc.unhighlight(0);
        sc.highlight(13);
        lang.nextStep();
        scHead.hide();
        sc.hide();
        SourceCode scHead2 = ((Language)lang).newSourceCode(new Coordinates(30, 140), "ueberschrift_zweiterTeil", null, scHeadProps);
        scHead2.addCodeLine("Zweiter Teil des Algorithmus (Verteilen der Restmengen):", null, 0, null);
        SourceCode scRest = ((Language)lang).newSourceCode(new Coordinates(30, 190), "sourceCodeTeil2", null, scProps);
        scRest.addCodeLine("Fuer alle nun noch ungestrichenen Elemente [i,j] der Transportkostenmatrix:", null, 0, null);
        scRest.addCodeLine("* Realisiere die moegliche Transportmenge:", null, 1, null);
        scRest.addCodeLine("* Transportmenge := Minimum(Angebot[i], Nachfrage[j])", null, 2, null);
        scRest.addCodeLine("* Angebot[i] := Angebot[i] - Tranportmenge", null, 2, null);
        scRest.addCodeLine("* Nachfrage[j] := Nachfrage[j] - Tranportmenge", null, 2, null);
        scRest.addCodeLine("* Falls Angebot[i] = 0 => streiche i-te Zeile", null, 2, null);
        scRest.addCodeLine("  ansonsten gilt Nachfrage[j] = 0 => streiche j-te Spalte", null, 3, null);
        scRest.addCodeLine("Alle Elemente gestrichen, d.h. alle Transportmengen verteilt -> Ende", null, 0, null);
        lang.nextStep();
        int z = 0;
        while (z < a.length) {
            int s = 0;
            while (s < b.length) {
                if (!markierteZeilen[z] && !markierteSpalten[s]) {
                    int q;
                    scRest.highlight(0);
                    lang.nextStep();
                    lsgMatrix.highlightCell(z, s, null, null);
                    kostenmatrix.highlightCell(z, s, null, null);
                    lang.nextStep();
                    scRest.toggleHighlight(0, 1);
                    lang.nextStep();
                    scRest.highlight(2);
                    lang.nextStep();
                    a_i.highlightCell(z, 0, null, null);
                    b_j.highlightCell(0, s, null, null);
                    int transportmenge = 0;
                    int angebot = a_i.getElement(z, 0);
                    int nachfrage = b_j.getElement(0, s);
                    if (angebot <= nachfrage) {
                        transportmenge = angebot;
                        angebot = 0;
                        nachfrage -= transportmenge;
                        VogelApproximation.markierteZeilen[z] = true;
                    } else {
                        transportmenge = nachfrage;
                        angebot -= transportmenge;
                        nachfrage = 0;
                        VogelApproximation.markierteSpalten[s] = true;
                    }
                    lang.nextStep();
                    lsgMatrix.highlightCell(z, s, null, null);
                    lsgMatrix.put(z, s, transportmenge, null, null);
                    lsgIndexVector.add(0, z);
                    lsgIndexVector.add(1, s);
                    lang.nextStep();
                    scRest.toggleHighlight(2, 3);
                    lang.nextStep();
                    b_j.unhighlightCell(0, s, null, null);
                    a_i.put(z, 0, angebot, null, null);
                    lang.nextStep();
                    scRest.toggleHighlight(3, 4);
                    lang.nextStep();
                    b_j.highlightCell(0, s, null, null);
                    a_i.unhighlightCell(z, 0, null, null);
                    lang.nextStep();
                    b_j.put(0, s, nachfrage, null, null);
                    lang.nextStep();
                    scRest.unhighlight(4);
                    scRest.highlight(5);
                    a_i.highlightCell(z, 0, null, null);
                    b_j.unhighlightCell(0, s, null, null);
                    lsgMatrix.unhighlightCell(z, s, null, null);
                    lang.nextStep();
                    if (angebot == 0) {
                        a_i_anz2.highlightCell(z, 0, null, null);
                        a_i_anz.highlightCell(z, 0, null, null);
                        lang.nextStep();
                        dz_i.put(z, 0, "X", null, null);
                        kostenmatrix.highlightCellColumnRange(z, kostenmatrix.getNrCols() - 1, 0, null, null);
                        q = 0;
                        while (q < kostenmatrix.getNrCols()) {
                            kostenmatrix.put(z, q, "X", null, null);
                            ++q;
                        }
                    } else if (nachfrage == 0) {
                        a_i.unhighlightCell(z, 0, null, null);
                        b_j.highlightCell(0, s, null, null);
                        scRest.unhighlight(5);
                        scRest.highlight(6);
                        b_j_anz2.highlightCell(0, s, null, null);
                        b_j_anz.highlightCell(0, s, null, null);
                        lang.nextStep();
                        ds_j.put(0, s, "X", null, null);
                        kostenmatrix.highlightCellRowRange(0, kostenmatrix.getNrRows() - 1, s, null, null);
                        q = 0;
                        while (q < kostenmatrix.getNrRows()) {
                            kostenmatrix.put(q, s, "X", null, null);
                            ++q;
                        }
                    }
                    lang.nextStep();
                    a_i.unhighlightCell(z, 0, null, null);
                    b_j.unhighlightCell(0, s, null, null);
                    scRest.unhighlight(5);
                    scRest.unhighlight(6);
                    a_i_anz2.unhighlightCell(z, 0, null, null);
                    a_i_anz.unhighlightCell(z, 0, null, null);
                    b_j_anz2.unhighlightCell(0, s, null, null);
                    b_j_anz.unhighlightCell(0, s, null, null);
                    kostenmatrix.unhighlightCellColumnRange(z, kostenmatrix.getNrCols() - 1, 0, null, null);
                    kostenmatrix.unhighlightCellRowRange(0, kostenmatrix.getNrRows() - 1, s, null, null);
                    scRest.unhighlight(5);
                    scRest.unhighlight(1);
                    lsgMatrix.unhighlightCell(z, 0, null, null);
                    kostenmatrix.unhighlightCell(z, s, null, null);
                }
                ++s;
            }
            ++z;
        }
        scRest.highlight(0);
        lang.nextStep();
        scRest.unhighlight(0);
        scRest.highlight(7);
        int count4 = 0;
        while (count4 < c.length) {
            dz_i.put(count4, 0, "X", null, null);
            int x3 = 0;
            while (x3 < c[0].length) {
                kostenmatrix.unhighlightCell(count4, x3, null, null);
                lsgMatrix.unhighlightCell(count4, x3, null, null);
                ds_j.put(0, x3, "X", null, null);
                ++x3;
            }
            ++count4;
        }
        lang.nextStep();
        scHead2.hide();
        scRest.hide();
        SourceCode scHead3 = ((Language)lang).newSourceCode(new Coordinates(30, 140), "ueberschrift_FktWert", null, scHeadProps);
        scHead3.addCodeLine("Transportkosten", null, 0, null);
        SourceCode scFktWert = ((Language)lang).newSourceCode(new Coordinates(30, 190), "Funktionswert", null, scProps);
        scFktWert.addCodeLine("Nachdem die Transportmengen verteilt wurden, koennen die Transportkosten einfach", null, 0, null);
        scFktWert.addCodeLine("berechnet werden:", null, 0, null);
        scFktWert.addCodeLine("", null, 0, null);
        scFktWert.addCodeLine("Gesamte Transportkosten = Transportkosten c_ij * Transportmenge zwischen A_i und B_j", null, 0, null);
        scFktWert.addCodeLine("[fuer alle i = 1...m, j = 1...n]", null, 0, null);
        TextProperties fktProp = new TextProperties();
        fktProp.set("color", Color.RED);
        fktProp.set("font", new Font("Serif", 0, 16));
        String FktRechnung = " ";
        Integer erg_int = 0;
        Text FktWert_text = ((Language)lang).newText(new Offset(-200, 150, scFktWert, "N"), "Gesamte Transportkosten = ", "funktionswert", null, tp);
        Text FktRechnung_anzeige = ((Language)lang).newText(new Offset(35, 0, FktWert_text, "NE"), FktRechnung, "rechnung", null, tp);
        Text FktWert_ergebnis = ((Language)lang).newText(new Offset(5, 0, FktWert_text, "NE"), FktRechnung, "ergebnis", null, fktProp);
        FktWert_ergebnis.setText(erg_int.toString(), null, null);
        lang.nextStep();
        Enumeration e = lsgIndexVector.elements();
        boolean first = true;
        while (e.hasMoreElements()) {
            Integer z2 = (Integer)e.nextElement();
            Integer s = (Integer)e.nextElement();
            lsgMatrix.highlightCell(z2, s, null, null);
            Integer kosten = c[z2][s];
            Integer menge = lsgMatrix.getElement(z2, s);
            kostenmatrix.put(z2, s, kosten.toString(), null, null);
            kostenmatrix.highlightCell(z2, s, null, null);
            initC.highlightCell(z2, s, null, null);
            erg_int = erg_int + kosten * lsgMatrix.getElement(z2, s);
            FktRechnung = first ? String.valueOf(FktRechnung) + " = " + kosten.toString() + " x " + menge.toString() : String.valueOf(FktRechnung) + " + " + kosten.toString() + " x " + menge.toString();
            FktRechnung_anzeige.setText(FktRechnung, null, null);
            FktWert_ergebnis.setText(erg_int.toString(), null, null);
            first = false;
            lang.nextStep();
            kostenmatrix.unhighlightCell(z2, s, null, null);
            initC.unhighlightCell(z2, s, null, null);
            lsgMatrix.unhighlightCell(z2, s, null, null);
        }
        lang.nextStep();
        SourceCode scHinweis = ((Language)lang).newSourceCode(new Coordinates(30, 400), "Hinweis", null, scProps);
        scHinweis.addCodeLine("Hinweis: Bei den errechneten Transportkosten handelt es sich nicht unbedingt um die minimal moeglichen", null, 0, null);
        scHinweis.addCodeLine("Transportkosten fuer diese Instanz des Problems, da zur Loesung eine Heuristik herangezogen wurde!", null, 0, null);
        return ((Object)lang).toString();
    }

    public static int[] findeIndexKleinsteEle(int[] liste, boolean[] markListe) {
        Object[] kopieListe = new VogelApproxHelper[liste.length];
        int i = 0;
        while (i < liste.length) {
            kopieListe[i] = new VogelApproxHelper(liste[i], i, markListe[i]);
            ++i;
        }
        Arrays.sort(kopieListe);
        int indexMin = -1;
        int indexMin2 = -1;
        int indexMinSort = -1;
        int i2 = 0;
        while (i2 < kopieListe.length) {
            if (!((VogelApproxHelper)kopieListe[i2]).markiert) {
                indexMin = ((VogelApproxHelper)kopieListe[i2]).index;
                indexMinSort = i2;
                break;
            }
            ++i2;
        }
        i2 = indexMinSort + 1;
        while (i2 < kopieListe.length) {
            if (!((VogelApproxHelper)kopieListe[i2]).markiert) {
                indexMin2 = ((VogelApproxHelper)kopieListe[i2]).index;
                break;
            }
            ++i2;
        }
        int[] indexMinFeld = new int[]{indexMin, indexMin2};
        return indexMinFeld;
    }

    public static Vector<int[]> berechneRegretwerte(int[][] feld) {
        int minWert2;
        int minWert;
        int[] indexKleinsteEle;
        int[] dz = new int[feld.length];
        int[] ds = new int[feld[0].length];
        int[] zeilenvektor = new int[feld[0].length];
        int[] spaltenvektor = new int[feld.length];
        int i = 0;
        while (i < feld.length) {
            int j = 0;
            while (j < feld[0].length) {
                zeilenvektor[j] = feld[i][j];
                ++j;
            }
            indexKleinsteEle = VogelApproximation.findeIndexKleinsteEle(zeilenvektor, markierteSpalten);
            minWert = indexKleinsteEle[0];
            minWert2 = indexKleinsteEle[1];
            dz[i] = feld[i][minWert2] - feld[i][minWert];
            ++i;
        }
        int j = 0;
        while (j < feld[0].length) {
            int i2 = 0;
            while (i2 < feld.length) {
                spaltenvektor[i2] = feld[i2][j];
                ++i2;
            }
            indexKleinsteEle = VogelApproximation.findeIndexKleinsteEle(spaltenvektor, markierteZeilen);
            minWert = indexKleinsteEle[0];
            minWert2 = indexKleinsteEle[1];
            ds[j] = feld[minWert2][j] - feld[minWert][j];
            ++j;
        }
        i = 0;
        while (i < dz.length) {
            if (markierteZeilen[i]) {
                dz[i] = Integer.MIN_VALUE;
            }
            ++i;
        }
        i = 0;
        while (i < ds.length) {
            if (markierteSpalten[i]) {
                ds[i] = Integer.MIN_VALUE;
            }
            ++i;
        }
        Vector<int[]> erg = new Vector<int[]>(2);
        erg.add(0, dz);
        erg.add(1, ds);
        return erg;
    }

    public static int[] berechneMaxRegret(Vector<int[]> regretVektoren) {
        int[] dz = regretVektoren.get(0);
        int[] ds = regretVektoren.get(1);
        int tempMaxWert = -1;
        int maxDzIndex = -1;
        int maxDsIndex = -1;
        int maxWert = -1;
        int maxWertInZoderS = -1;
        int i = 0;
        while (i < dz.length) {
            if (dz[i] > tempMaxWert && !markierteZeilen[i]) {
                tempMaxWert = dz[i];
                maxDzIndex = i;
            }
            ++i;
        }
        tempMaxWert = -1;
        i = 0;
        while (i < ds.length) {
            if (ds[i] > tempMaxWert && !markierteSpalten[i]) {
                tempMaxWert = ds[i];
                maxDsIndex = i;
            }
            ++i;
        }
        if (maxDzIndex < 0 || maxDsIndex < 0) {
            throw new IllegalArgumentException("Mehr als #Zeilen - 1 oder #Spalten - 1 markiert!. maxDz = " + maxDzIndex + ", maxDs=" + maxDsIndex);
        }
        if (dz[maxDzIndex] >= ds[maxDsIndex]) {
            maxWert = maxDzIndex;
            maxWertInZoderS = 0;
            maxDzIndex_global = maxDzIndex;
        } else {
            maxWert = maxDsIndex;
            maxWertInZoderS = 1;
            maxDsIndex_global = maxDsIndex;
        }
        int[] erg = new int[]{maxWert, maxWertInZoderS};
        return erg;
    }

    public static void realisiere(int[][] feld, int[] maxRegret) {
        int spalte;
        int zeile;
        int i;
        int pos = maxRegret[0];
        int indexMin = -1;
        int min = Integer.MAX_VALUE;
        if (maxRegret[1] == 0) {
            i = 0;
            while (i < feld[0].length) {
                if (feld[pos][i] <= min && !markierteSpalten[i]) {
                    min = feld[pos][i];
                    indexMin = i;
                }
                ++i;
            }
            indexMinZeile = indexMin;
        } else {
            i = 0;
            while (i < feld.length) {
                if (feld[i][pos] <= min && !markierteZeilen[i]) {
                    min = feld[i][pos];
                    indexMin = i;
                }
                ++i;
            }
            indexMinSpalte = indexMin;
        }
        if (maxRegret[1] == 0) {
            zeile = pos;
            spalte = indexMin;
        } else {
            zeile = indexMin;
            spalte = pos;
        }
        if (angebot[zeile] <= nachfrage[spalte]) {
            transportmenge = angebot[zeile];
            VogelApproximation.angebot[zeile] = 0;
            VogelApproximation.nachfrage[spalte] = nachfrage[spalte] - transportmenge;
            VogelApproximation.markierteZeilen[zeile] = true;
        } else {
            transportmenge = nachfrage[spalte];
            VogelApproximation.angebot[zeile] = angebot[zeile] - transportmenge;
            VogelApproximation.nachfrage[spalte] = 0;
            VogelApproximation.markierteSpalten[spalte] = true;
        }
    }

    public static void initMarkierung(boolean[] a) {
        int l = 0;
        while (l < a.length) {
            a[l] = false;
            ++l;
        }
    }

    public static int zaehleMarkierungen(boolean[] a) {
        int zaehler = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i]) {
                ++zaehler;
            }
            ++i;
        }
        return zaehler;
    }

    public static boolean kostenmatrixOk(int[][] matrix) {
        boolean matrixOk = true;
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                if (matrix[i][j] < 0) {
                    matrixOk = false;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return matrixOk;
    }

    @Override
    public String generate(AnimationPropertiesContainer properties, Hashtable<String, Object> primitives) {
        return VogelApproximation.getCode(properties, primitives);
    }

    @Override
    public String getAlgorithmName() {
        return "Vogelsche Approximationsmethode";
    }

    @Override
    public String getCodeExample() {
        return "Die Vogelsche Approximationsmethode besteht aus zwei Teilen:\n* Im ersten Teil des Algorithmus werden Transportmengen solange\n   nach dem Prinzip des maximalen Regrets verteilt, bis entweder \n  m-1 Zeilen oder n-1 Spalten der Transportmengenmatrix belegt (= gestrichen) sind.\n* Im zweiten Teil des Algorithmus werden die noch verbleibenden \n  Transportmengen verteilt.\n(mit m = Anzahl Zeilen = Anzahl Anbieter, n = Anzahl Spalten = Anzahl Nachfrager)\n";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "Die Vogelsche Approximationsmethode ist eine Heuristik aus dem Bereich des Operations Research zur Loesung des klassischen Transportproblems. Bei gegebener Angebots- und Nachfragemenge sowie den Kosten fuer einen jeden Transportweg werden die moeglichst optimalen Verbindungen zwischen Anbietern und Nachfragern gesucht.Optimal bedeutet in diesem Zusammenhang, dass der Nachfrager alle gewuenschten Gueter erhaelt, der Anbieter alle angebotenen Waren absetzt und die Transportkosten insgesamt kostenminimal sind";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(0x40000000);
    }

    @Override
    public String getName() {
        return "Vogelsche Approximation";
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public String getAnimationAuthor() {
        return "Petra Doersam und Kevin Tappe";
    }

    @Override
    public void init() {
    }
}

