/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.misc;

import algoanim.animalscript.AnimalScript;
import algoanim.interactionsupport.DocumentationLink;
import algoanim.interactionsupport.FillInBlanksQuestion;
import algoanim.interactionsupport.GroupInfo;
import algoanim.interactionsupport.MultipleSelectionQuestion;
import algoanim.primitives.Polyline;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.PolylineProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Hidden;
import algoanim.util.Node;
import algoanim.util.Offset;
import avinteraction.parser.InteractionFactory;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class PascalTriangle
implements Generator {
    private Language language;
    private int[][] pascalTriangle;
    private int numberOfRows;
    private int numberOfStepwiseCalculatedRows;
    private SourceCode pascalCode;
    private TextProperties triangleProperties;
    private TextProperties triangleZeroProperties;
    private Text[][] triangleText;
    private Text[][] triangleZeros;
    private int windowSizeX = 1000;
    private int trianglePosX = 400;
    private int trianglePosY = 300;
    private int trianglePosNextColumnOffsetX = 60;
    private int trianglePosNextRowOffsetY = 50;
    private int arrowOffsetStartXLeft = 11;
    private int arrowOffsetStartXRight = 0;
    private int arrowOffsetStartY = 20;
    private int arrowOffsetEndXLeft = 4;
    private int arrowOffsetEndXRight = 8;
    private int arrowOffsetEndY = 3;
    private boolean useArrowhead;
    private boolean useCodeMarker;
    private String codeMarker = "-->";
    private Color zerosColor;
    private PolylineProperties arrowProperties;
    private Polyline[][] arrows;
    private Text[] highlightArrows;
    private int currentHighlight;
    private String answer;
    private InteractionFactory f;
    private FillInBlanksQuestion fib;
    private static final String[] pseudoCode = new String[]{"1. Das einzige Element der ersten Zeile ist die 1.", "2. F\u221a\u00bar die Konstruktion der zweiten Zeile denkt man sich jeweils eine 0 links und rechts neben die 1.", "3. Nun addiert man jeweils zwei benachbarte Zahlen und f\u221a\u00bagt das Ergebnis darunter in die Mitte ein.", "4. Man entfernt die gedachten Nullen wieder.", "5. F\u221a\u00bar die Konstruktion der n\u221a\u00a7chsten Zeile denkt man sich jeweils eine 0 links und rechts au\u221a\u00fcen neben die 1en.", "6. Nun addiert man jeweils zwei benachbarte Zahlen und f\u221a\u00bagt das Ergebnis darunter in die Mitte ein.", "7. Man entfernt die gedachten Nullen wieder.", "Die Anweisungen 5, 6 und 7 wiederholt man so lange, bis das Dreieck die gew\u221a\u00banschte Gr\u221a\u2202\u221a\u00fce hat."};

    public PascalTriangle() {
        this(7, 4, false, true, Color.GRAY);
    }

    public PascalTriangle(int numberOfRows) {
        this(numberOfRows, 4, false, true, Color.GRAY);
    }

    public PascalTriangle(int numberOfRows, int numberOfStepwiseCalculatedRows) {
        this(numberOfRows, numberOfStepwiseCalculatedRows, false, true, Color.GRAY);
    }

    public PascalTriangle(int numberOfRows, int numberOfStepwiseCalculatedRows, boolean useArrowhead, boolean useCodeMarker, Color zerosColor) {
        if (numberOfRows < 4) {
            numberOfRows = 4;
            System.err.println("The triangle must have at least four rows!");
        }
        if (numberOfRows > 14) {
            numberOfRows = 14;
            System.err.println("The triangle must have at most fourteen rows!");
        }
        if (numberOfStepwiseCalculatedRows < 3) {
            numberOfStepwiseCalculatedRows = 3;
            System.err.println("At least the first three rows must be calculated stepwise!");
        }
        if (numberOfStepwiseCalculatedRows > numberOfRows) {
            numberOfStepwiseCalculatedRows = numberOfRows;
            System.err.println("It is not possible to calculate more rows stepwise than we have rows at all!");
        }
        this.numberOfRows = numberOfRows;
        this.numberOfStepwiseCalculatedRows = numberOfStepwiseCalculatedRows;
        this.useArrowhead = useArrowhead;
        this.useCodeMarker = useCodeMarker;
        this.zerosColor = zerosColor;
    }

    public String generate() {
        this.language = new AnimalScript("Das Pascalsche Dreieck", "Jan Stolzenburg <jan.stolzenburg@arcor.de>", this.windowSizeX, this.trianglePosY + this.trianglePosNextRowOffsetY * this.numberOfRows);
        this.language.setStepMode(true);
        this.language.setInteractionType(1024);
        this.f = new InteractionFactory(this.language, "InteractionPatterns.xml");
        this.language.addQuestionGroup(new GroupInfo(this.language, "triangle", 2));
        this.makeAnimation();
        return this.language.toString();
    }

    private void makeAnimation() {
        this.makeHeader();
        this.language.nextStep();
        MultipleSelectionQuestion msq = new MultipleSelectionQuestion(this.language, "Namensgebung");
        msq.setPrompt("Unter welchen Namen ist das Pascalsche Dreieck bekannt?");
        msq.addAnswerOption("Das pascalsche Dreieck", true, "Diese Bezeichnung geht auf Blaise Pascal zur\u00b8ck", 1);
        msq.addAnswerOption("Yang-Hui-Dreieck", true, "Diese Bezeichnung geht auf Yang Hui (China) zur\u00b8ck", 1);
        msq.addAnswerOption("Tartaglia-Dreieck", true, "Diese Bezeichnung geht auf Niccol\u00da Fontana Tartaglia (Italien) zur\u00b8ck", 1);
        msq.addAnswerOption("Chayyam-Dreieck", true, "Diese Bezeichnung geht auf Omar Chayyam (Iran) zur\u00b8ck", 1);
        msq.addAnswerOption("Binominal-Dreieck", false, "Das Dreieck ist zwar eine geometrische Darstellung des Binomialkoeffizienten jedoch gibt es die Bezeichnung des Binomaldreiecks nicht", -1);
        msq.setPointsPossible(4);
        this.language.addMSQuestion(msq);
        this.language.nextStep();
        this.makeCode();
        this.language.nextStep();
        this.makeTriangle();
        DocumentationLink link = new DocumentationLink(this.language, "link");
        link.setLinkAddress("http://de.wikipedia.org/wiki/Pascalsches_Dreieck");
        this.language.addDocumentationLink(link);
        this.language.nextStep();
        this.language.finalizeGeneration();
    }

    private void makeHeader() {
        TextProperties titleProperties = new TextProperties();
        titleProperties.set("color", Color.BLACK);
        titleProperties.set("depth", 1);
        titleProperties.set("font", new Font("SansSerif", 1, 24));
        Text title = this.language.newText(new Coordinates(20, 30), "Das Pascalsche Dreieck - Konstruktion", "title", null, titleProperties);
        RectProperties titleBoxProperties = new RectProperties();
        titleBoxProperties.set("depth", 2);
        titleBoxProperties.set("color", Color.BLACK);
        titleBoxProperties.set("filled", true);
        titleBoxProperties.set("fillColor", Color.WHITE);
        this.language.newRect(new Offset(-5, -5, title, "NW"), new Offset(5, 5, title, "SE"), "titleBox", null, titleBoxProperties);
    }

    private void makeCode() {
        SourceCodeProperties pascalCodeProperties = new SourceCodeProperties();
        pascalCodeProperties.set("color", Color.BLACK);
        pascalCodeProperties.set("highlightColor", Color.RED);
        pascalCodeProperties.set("font", new Font("SansSerif", 0, 16));
        this.pascalCode = this.language.newSourceCode(new Coordinates(30, 80), "Pascal Pseude Code", null, pascalCodeProperties);
        this.highlightArrows = new Text[pseudoCode.length];
        if (!this.useCodeMarker) {
            this.codeMarker = "";
        }
        int i = 0;
        while (i < pseudoCode.length) {
            this.pascalCode.addCodeLine(pseudoCode[i], "line" + String.valueOf(i), 0, null);
            this.highlightArrows[i] = this.language.newText(new Coordinates(5, 94 + 20 * i), this.codeMarker, "arrowCode" + String.valueOf(i), new Hidden());
            ++i;
        }
    }

    private void makeTriangle() {
        this.pascalTriangle = new int[this.numberOfRows][this.numberOfRows];
        this.calcPascalTriangle();
        this.prepareTriangle();
        this.makeFirstRow();
        this.language.nextStep();
        this.makeSecondRow();
        this.language.nextStep();
        this.makeThirdRow();
        this.language.nextStep();
        int currentRow = 4;
        while (currentRow <= this.numberOfRows) {
            this.makeNextRow(currentRow);
            this.language.nextStep();
            ++currentRow;
        }
        this.finalizeTriangle();
    }

    private void prepareTriangle() {
        this.triangleProperties = new TextProperties();
        this.triangleProperties.set("color", Color.BLACK);
        this.triangleProperties.set("font", new Font("SansSerif", 1, 18));
        this.triangleZeroProperties = new TextProperties();
        this.triangleZeroProperties.set("color", this.zerosColor);
        this.triangleZeroProperties.set("font", new Font("SansSerif", 0, 18));
        this.triangleText = new Text[this.numberOfRows][this.numberOfRows];
        this.triangleZeros = new Text[this.numberOfRows - 1][2];
        this.arrowProperties = new PolylineProperties();
        this.arrowProperties.set("fwArrow", this.useArrowhead);
        this.arrows = new Polyline[this.numberOfRows - 1][this.numberOfRows * 2];
    }

    private void makeFirstRow() {
        this.highlight(0);
        this.language.newText(new Coordinates(0, 0), "FailureWorkaround", "FailureWorkaround", new Hidden(), this.triangleProperties);
        this.triangleText[0][0] = this.language.newText(new Coordinates(this.trianglePosX, this.trianglePosY), "1", "Row0Column1", null, this.triangleProperties);
    }

    private void makeSecondRow() {
        this.highlight(1);
        this.triangleZeros[0][0] = this.language.newText(new Coordinates(this.trianglePosX - this.trianglePosNextColumnOffsetX, this.trianglePosY), "0", "Row0ColumnFirst", null, this.triangleZeroProperties);
        this.triangleZeros[0][1] = this.language.newText(new Coordinates(this.trianglePosX + this.trianglePosNextColumnOffsetX, this.trianglePosY), "0", "Row0ColumnLast", null, this.triangleZeroProperties);
        this.language.nextStep();
        this.highlight(2);
        this.makeArrows(1, 0);
        this.language.nextStep();
        this.triangleText[1][0] = this.language.newText(new Coordinates(this.trianglePosX - this.trianglePosNextColumnOffsetX / 2, this.trianglePosY + this.trianglePosNextRowOffsetY), "1", "Row1Column1", null, this.triangleProperties);
        this.language.nextStep();
        this.makeArrows(1, 1);
        this.language.nextStep();
        this.triangleText[1][1] = this.language.newText(new Coordinates(this.trianglePosX + this.trianglePosNextColumnOffsetX / 2, this.trianglePosY + this.trianglePosNextRowOffsetY), "1", "Row1Column2", null, this.triangleProperties);
        this.language.nextStep();
        this.hideArrows(1, 0);
        this.hideArrows(1, 1);
        this.language.nextStep();
        this.highlight(3);
        this.hideZeros(0);
    }

    private void makeThirdRow() {
        this.highlight(4);
        this.triangleZeros[1][0] = this.language.newText(new Coordinates(this.trianglePosX - this.trianglePosNextColumnOffsetX / 2 * 3, this.trianglePosY + this.trianglePosNextRowOffsetY), "0", "Row1ColumnFirst", null, this.triangleZeroProperties);
        this.triangleZeros[1][1] = this.language.newText(new Coordinates(this.trianglePosX + this.trianglePosNextColumnOffsetX / 2 * 3, this.trianglePosY + this.trianglePosNextRowOffsetY), "0", "Row1ColumnLast", null, this.triangleZeroProperties);
        this.language.nextStep();
        this.highlight(5);
        this.makeArrows(2, 0);
        this.language.nextStep();
        this.triangleText[2][0] = this.language.newText(new Coordinates(this.trianglePosX + this.trianglePosNextColumnOffsetX / 2 * -2, this.trianglePosY + this.trianglePosNextRowOffsetY * 2), "1", "Row2Column1", null, this.triangleProperties);
        this.language.nextStep();
        this.makeArrows(2, 1);
        this.language.nextStep();
        this.triangleText[2][1] = this.language.newText(new Coordinates(this.trianglePosX + this.trianglePosNextColumnOffsetX / 2 * 0, this.trianglePosY + this.trianglePosNextRowOffsetY * 2), "2", "Row2Column2", null, this.triangleProperties);
        this.language.nextStep();
        this.makeArrows(2, 2);
        this.language.nextStep();
        this.triangleText[2][2] = this.language.newText(new Coordinates(this.trianglePosX + this.trianglePosNextColumnOffsetX / 2 * 2, this.trianglePosY + this.trianglePosNextRowOffsetY * 2), "1", "Row2Column3", null, this.triangleProperties);
        this.language.nextStep();
        this.hideArrows(2, 0);
        this.hideArrows(2, 1);
        this.hideArrows(2, 2);
        this.language.nextStep();
        this.highlight(6);
        this.hideZeros(1);
    }

    private void makeNextRow(int currentRow) {
        int i;
        int rowIndex = currentRow - 1;
        this.makeTriangleZeros(rowIndex - 1);
        this.language.nextStep();
        this.highlight(5);
        if (this.numberOfStepwiseCalculatedRows >= currentRow) {
            this.fib = this.f.generateFIBQuestion("nextRowPascalTriangle", "nextRow" + currentRow, new String[0]);
            this.answer = "";
            i = 0;
            while (i < currentRow) {
                this.makeArrows(rowIndex, i);
                this.language.nextStep();
                this.triangleText[rowIndex][i] = this.language.newText(new Coordinates(this.calcPositionX(rowIndex, i), this.calcPositionY(rowIndex, i)), String.valueOf(this.pascalTriangle[rowIndex][i]), "Row" + String.valueOf(rowIndex) + "Column" + String.valueOf(i + 1), null, this.triangleProperties);
                this.answer = i + 1 == currentRow ? String.valueOf(this.answer) + String.valueOf(this.pascalTriangle[rowIndex][i]) : String.valueOf(this.answer) + String.valueOf(this.pascalTriangle[rowIndex][i]) + ", ";
                this.language.nextStep();
                ++i;
            }
            this.fib.addAnswer(this.answer, "Die richtige Antwort lautet: " + this.answer, 2);
        } else {
            this.fib = this.f.generateFIBQuestion("nextRowPascalTriangle", "nextRow" + currentRow, new String[0]);
            i = 0;
            while (i < currentRow) {
                this.makeArrows(rowIndex, i);
                ++i;
            }
            this.language.nextStep();
            this.answer = "";
            i = 0;
            while (i < currentRow) {
                this.triangleText[rowIndex][i] = this.language.newText(new Coordinates(this.calcPositionX(rowIndex, i), this.calcPositionY(rowIndex, i)), String.valueOf(this.pascalTriangle[rowIndex][i]), "Row" + String.valueOf(rowIndex) + "Column" + String.valueOf(i + 1), null, this.triangleProperties);
                this.answer = i + 1 == currentRow ? String.valueOf(this.answer) + String.valueOf(this.pascalTriangle[rowIndex][i]) : String.valueOf(this.answer) + String.valueOf(this.pascalTriangle[rowIndex][i]) + ", ";
                this.language.nextStep();
                ++i;
            }
            this.fib.addAnswer(this.answer, "Die richtige Antwort lautet: " + this.answer, 2);
        }
        i = 0;
        while (i < currentRow) {
            this.hideArrows(rowIndex, i);
            ++i;
        }
        this.language.nextStep();
        this.highlight(6);
        this.hideZeros(rowIndex - 1);
    }

    private void makeTriangleZeros(int rowIndex) {
        this.highlight(4);
        this.triangleZeros[rowIndex][0] = this.language.newText(new Coordinates(this.calcPositionX(rowIndex, -1), this.calcPositionY(rowIndex, -1)), "0", "Row" + String.valueOf(rowIndex) + "ColumnFirst", null, this.triangleZeroProperties);
        this.triangleZeros[rowIndex][1] = this.language.newText(new Coordinates(this.calcPositionX(rowIndex, rowIndex + 1), this.calcPositionY(rowIndex, rowIndex + 1)), "0", "Row" + String.valueOf(rowIndex) + "ColumnLast", null, this.triangleZeroProperties);
    }

    private int calcPositionX(int rowIndex, int entryIndex) {
        return this.trianglePosX + this.trianglePosNextColumnOffsetX / 2 * (entryIndex * 2 - rowIndex);
    }

    private int calcPositionY(int rowIndex, int entryIndex) {
        return this.trianglePosY + this.trianglePosNextRowOffsetY * rowIndex;
    }

    private void makeArrows(int rowIndex, int entryIndex) {
        Coordinates startLeft = new Coordinates(this.arrowOffsetStartXLeft + this.calcPositionX(rowIndex - 1, entryIndex - 1), this.arrowOffsetStartY + this.calcPositionY(rowIndex - 1, entryIndex - 1));
        Coordinates startRight = new Coordinates(this.arrowOffsetStartXRight + this.calcPositionX(rowIndex - 1, entryIndex), this.arrowOffsetStartY + this.calcPositionY(rowIndex - 1, entryIndex));
        Coordinates endLeft = new Coordinates(this.arrowOffsetEndXLeft + this.calcPositionX(rowIndex, entryIndex), this.arrowOffsetEndY + this.calcPositionY(rowIndex, entryIndex));
        Coordinates endRight = new Coordinates(this.arrowOffsetEndXRight + this.calcPositionX(rowIndex, entryIndex), this.arrowOffsetEndY + this.calcPositionY(rowIndex, entryIndex));
        Node[] arrowPointsLeft = new Node[]{startLeft, endLeft};
        Node[] arrowPointsRight = new Node[]{startRight, endRight};
        this.arrows[rowIndex - 1][entryIndex * 2] = this.language.newPolyline(arrowPointsLeft, "arrowLeftForRow" + String.valueOf(rowIndex) + "Column" + String.valueOf(entryIndex + 1), null, this.arrowProperties);
        this.arrows[rowIndex - 1][entryIndex * 2 + 1] = this.language.newPolyline(arrowPointsRight, "arrowRightForRow" + String.valueOf(rowIndex) + "Column" + String.valueOf(entryIndex + 1), null, this.arrowProperties);
    }

    private void hideArrows(int rowIndex, int entryIndex) {
        this.arrows[rowIndex - 1][entryIndex * 2].hide();
        this.arrows[rowIndex - 1][entryIndex * 2 + 1].hide();
    }

    private void hideZeros(int rowIndex) {
        this.triangleZeros[rowIndex][0].hide();
        this.triangleZeros[rowIndex][1].hide();
    }

    private void highlight(int rowIndex) {
        this.pascalCode.unhighlight(this.currentHighlight);
        this.pascalCode.highlight(rowIndex);
        this.highlightArrows[this.currentHighlight].hide();
        this.highlightArrows[rowIndex].show();
        this.currentHighlight = rowIndex;
        this.language.nextStep();
    }

    private void finalizeTriangle() {
    }

    private void calcPascalTriangle() {
        int j;
        int[][] calcTriangle = new int[this.numberOfRows][this.numberOfRows + 1];
        calcTriangle[0][1] = 1;
        int i = 1;
        while (i < this.numberOfRows) {
            j = 1;
            while (j <= i + 1) {
                calcTriangle[i][j] = calcTriangle[i - 1][j - 1] + calcTriangle[i - 1][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfRows) {
            j = 0;
            while (j <= i) {
                this.pascalTriangle[i][j] = calcTriangle[i][j + 1];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String generate(AnimationPropertiesContainer properties, Hashtable<String, Object> primitives) {
        String nameNumberOfRows = "Anzahl der Zeilen (mindestens 4)";
        String nameNumberOfStepwiseCalculatedRows = "Anzahl der Zeilen, deren Werte einzeln berechnet werden (mindestens 3)";
        String nameUseArrowhead = "Pfeilspitzen anzeigen?";
        String nameUseCodeMarker = "Die aktuelle Codezeile mit einem Pfeil markieren?";
        String nameZerosColor = "Farbe der Hilfsnullen?";
        if (primitives.containsKey(nameNumberOfRows) && primitives.get(nameNumberOfRows) != null) {
            this.numberOfRows = (Integer)primitives.get(nameNumberOfRows);
            if (this.numberOfRows < 4) {
                this.numberOfRows = 4;
                System.err.println("The triangle must have at least four rows!");
            }
            if (this.numberOfRows > 14) {
                this.numberOfRows = 14;
                System.err.println("The triangle must have at most fourteen rows!");
            }
        }
        if (primitives.containsKey(nameNumberOfStepwiseCalculatedRows) && primitives.get(nameNumberOfStepwiseCalculatedRows) != null) {
            this.numberOfStepwiseCalculatedRows = (Integer)primitives.get(nameNumberOfStepwiseCalculatedRows);
            if (this.numberOfStepwiseCalculatedRows < 3) {
                this.numberOfStepwiseCalculatedRows = 3;
                System.err.println("At least the first three rows must be calculated stepwise!");
            }
            if (this.numberOfStepwiseCalculatedRows > this.numberOfRows) {
                this.numberOfStepwiseCalculatedRows = this.numberOfRows;
                System.err.println("It is not possible to calculate more rows stepwise than we have rows at all!");
            }
        }
        if (primitives.containsKey(nameUseArrowhead) && primitives.get(nameUseArrowhead) != null) {
            this.useArrowhead = (Boolean)primitives.get(nameUseArrowhead);
        }
        if (primitives.containsKey(nameUseCodeMarker) && primitives.get(nameUseCodeMarker) != null) {
            this.useCodeMarker = (Boolean)primitives.get(nameUseCodeMarker);
        }
        if (primitives.containsKey(nameZerosColor) && primitives.get(nameZerosColor) != null) {
            this.zerosColor = (Color)primitives.get(nameZerosColor);
        }
        return this.generate();
    }

    @Override
    public String getCodeExample() {
        String result = "";
        String[] stringArray = pseudoCode;
        int n = pseudoCode.length;
        int n2 = 0;
        while (n2 < n) {
            String lineOfCode = stringArray[n2];
            result = String.valueOf(result) + lineOfCode + "\n";
            ++n2;
        }
        return result;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "Zeigt schrittweise die Konstruktion des Pascalschen Dreiecks.";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(0x40000000);
    }

    @Override
    public String getName() {
        return "Die Konstruktion des Pascalschen Dreiecks";
    }

    public static void main(String[] args) {
        System.out.println(new PascalTriangle().generate());
    }

    @Override
    public String getAlgorithmName() {
        return "Das Pascalsche Dreieck - Konstruktion";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Jan Stolzenburg";
    }

    @Override
    public void init() {
    }
}

