/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.graph;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Graph;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.CircleProperties;
import algoanim.properties.GraphProperties;
import algoanim.properties.MatrixProperties;
import algoanim.properties.PolylineProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class Warshall2
implements Generator {
    protected Language lang;
    Node node;
    MatrixProperties matrixprops;
    RectProperties rectprops;
    GraphProperties graphprops;
    CircleProperties circleprops;
    PolylineProperties arcprops;
    TextProperties textprops;
    IntMatrix matrix;
    String name;
    int[][] graphAdjacencyMatrix;
    static Node[] graphNodes;
    static String[] labels;
    DisplayOptions display;
    public SourceCode sc;
    public Graph gr;
    public int[] nodeIndices;
    public AnimationPropertiesContainer animationProperties;

    public void showGraph(Graph graph) {
        int size = graph.getSize();
        graphNodes = new Node[size];
        labels = new String[size];
        int i = 0;
        while (i < graph.getSize()) {
            Warshall2.graphNodes[i] = graph.getNode(i);
            Warshall2.labels[i] = graph.getNodeLabel(i);
            ++i;
        }
        this.graphprops = (GraphProperties)this.animationProperties.getPropertiesByName("graph");
        this.gr = this.lang.newGraph(graph.getName(), graph.getAdjacencyMatrix(), graphNodes, labels, graph.getDisplayOptions(), this.graphprops);
    }

    public void Warshall(Graph graph) {
        int[][] graphAdjacencyMatrix = graph.getAdjacencyMatrix();
        this.showGraph(graph);
        Text text5 = this.lang.newText(new Coordinates(50, 200), "", "text", this.display, this.textprops);
        Text text4 = this.lang.newText(new Coordinates(180, 40), "", "text", this.display, this.textprops);
        Text text = this.lang.newText(new Coordinates(180, 70), "", "text", this.display, this.textprops);
        Text text2 = this.lang.newText(new Coordinates(180, 100), "", "text", this.display, this.textprops);
        Text text3 = this.lang.newText(new Coordinates(180, 130), "", "text", this.display, this.textprops);
        this.lang.newRect(new Coordinates(500, 300), new Coordinates(30, 20), "matrix", this.display, this.rectprops);
        IntMatrix matrix = this.lang.newIntMatrix(new Coordinates(70, 40), graphAdjacencyMatrix, "matrix", null, this.matrixprops);
        TicksTiming timing = new TicksTiming(30);
        int y = 0;
        int x = 0;
        int j = 0;
        int temp = 0;
        this.showSourceCode();
        this.lang.nextStep();
        this.sc.highlight(0);
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 1);
        this.lang.nextStep();
        this.sc.toggleHighlight(1, 2);
        text4.setText("X= " + x + "    Y= " + y + "     J= " + j, null, timing);
        this.lang.nextStep();
        this.sc.toggleHighlight(2, 3);
        y = 0;
        while (y < matrix.getNrRows()) {
            this.sc.highlight(3);
            x = 0;
            j = 0;
            text4.setText("X= " + x + "    Y= " + y + "     J= " + j, null, timing);
            this.lang.nextStep();
            x = 0;
            while (x < matrix.getNrCols()) {
                j = 0;
                this.sc.unhighlight(3);
                this.sc.highlight(4);
                text4.setText("X= " + x + "    Y= " + y + "     J= " + j, null, timing);
                this.lang.nextStep();
                if (matrix.getElement(x, y) > 0) {
                    this.gr.highlightNode(x, null, null);
                    this.gr.highlightNode(y, null, null);
                    this.sc.unhighlight(4);
                    this.sc.highlight(5);
                    text.setText("A(x,y)=A(" + x + "," + y + ")=" + matrix.getElement(x, y), timing, timing);
                    text5.setText("A(x,y)=A(" + x + "," + y + ") ist groesser als null = " + matrix.getElement(x, y), timing, timing);
                    matrix.highlightCell(x, y, null, timing);
                    this.lang.nextStep();
                    text5.setText("", null, null);
                    j = 0;
                    while (j < matrix.getNrCols()) {
                        this.sc.unhighlight(5);
                        this.sc.highlight(6);
                        text4.setText("X= " + x + "    Y= " + y + "     J= " + j, null, timing);
                        this.lang.nextStep();
                        this.sc.toggleHighlight(6, 7);
                        if (matrix.getElement(y, j) > 0) {
                            this.gr.highlightNode(j, null, null);
                            this.sc.highlight(7);
                            matrix.highlightCell(y, j, null, timing);
                            text2.setText("A(y,j)= A(" + y + "," + j + ")=" + matrix.getElement(y, j), null, timing);
                            text5.setText("A(y,j)=A(" + y + "," + j + ") ist groesser als null = " + matrix.getElement(y, j), null, timing);
                            this.lang.nextStep();
                            text5.setText("", null, null);
                            this.sc.toggleHighlight(7, 8);
                            matrix.unhighlightCell(x, y, timing, timing);
                            matrix.unhighlightCell(y, j, timing, timing);
                            matrix.highlightCell(x, j, timing, timing);
                            if (matrix.getElement(x, j) == 0 || matrix.getElement(x, y) + matrix.getElement(y, j) < matrix.getElement(x, j)) {
                                this.sc.highlight(8);
                                this.sc.unhighlight(7);
                                temp = matrix.getElement(x, y) + matrix.getElement(y, j);
                                text3.setText("A(x,j)=A(" + x + "," + j + ")=" + matrix.getElement(x, j), null, timing);
                                this.lang.nextStep();
                                this.sc.toggleHighlight(8, 9);
                                matrix.put(x, j, temp, null, timing);
                                this.gr.setEdgeWeight(x, j, matrix.getElement(x, j), null, null);
                                this.gr.getEdgeWeight(x, j);
                                this.gr.highlightEdge(x, j, null, null);
                                matrix.highlightElem(x, j, timing, timing);
                                text3.setText("A(x,j)=A(" + x + "," + j + ")=" + matrix.getElement(x, j), null, timing);
                                text5.setText("A(x,j)=A(" + x + "," + j + ")= A(" + x + "," + y + ") +A(" + y + "," + j + ") = " + matrix.getElement(x, j), null, timing);
                                this.lang.nextStep();
                                this.gr.unhighlightNode(x, null, null);
                                this.gr.unhighlightNode(y, null, null);
                                this.gr.unhighlightNode(j, null, null);
                                this.gr.unhighlightEdge(x, j, null, null);
                                text3.setText("", null, null);
                                text5.setText("", null, null);
                                matrix.unhighlightCell(x, j, null, timing);
                                this.sc.toggleHighlight(9, 6);
                            } else {
                                this.sc.highlight(8);
                                this.sc.unhighlight(7);
                                text3.setText("A(x,j)=A(" + x + "," + j + ")=" + matrix.getElement(x, j), null, timing);
                                text5.setText("A(x,j)=A(" + x + "," + j + ") ist nicht gleich null = " + matrix.getElement(x, j), null, timing);
                                this.lang.nextStep();
                                matrix.unhighlightCell(x, j, null, timing);
                                text3.setText("", null, null);
                                text5.setText("", null, null);
                                this.sc.toggleHighlight(8, 6);
                            }
                            text2.setText("", null, null);
                        } else {
                            this.sc.unhighlight(6);
                            this.sc.highlight(7);
                            matrix.highlightCell(y, j, null, timing);
                            text2.setText("A(y,j)= A(" + y + "," + j + ")=" + matrix.getElement(y, j), null, timing);
                            text5.setText("A(y,j)=A(" + y + "," + j + ") ist nicht groesser als null = " + matrix.getElement(y, j), null, timing);
                            this.lang.nextStep();
                            matrix.unhighlightCell(y, j, null, timing);
                            text2.setText("", null, null);
                            text5.setText("", null, null);
                            this.sc.toggleHighlight(7, 6);
                        }
                        ++j;
                    }
                    text.setText("", null, null);
                } else {
                    this.sc.unhighlight(4);
                    this.sc.highlight(5);
                    matrix.highlightCell(x, y, timing, timing);
                    text.setText("A(x,y)=A(" + x + "," + y + ")=" + matrix.getElement(x, y), timing, timing);
                    text5.setText("A(x,y)=A(" + x + "," + y + ") nicht groesser als null = " + matrix.getElement(x, y), timing, timing);
                    this.lang.nextStep();
                    matrix.unhighlightCell(x, y, timing, timing);
                    text5.setText("", null, null);
                    text.setText("", null, null);
                    this.sc.toggleHighlight(5, 4);
                }
                this.sc.toggleHighlight(6, 4);
                this.lang.nextStep();
                ++x;
            }
            this.sc.toggleHighlight(4, 3);
            this.lang.nextStep();
            ++y;
        }
    }

    @Override
    public void init() {
        this.lang = new AnimalScript("Warshall Animation", "Madieha + Bouchra", 620, 480);
        this.lang.setStepMode(true);
        this.matrixprops = new MatrixProperties();
        this.textprops = new TextProperties();
        this.rectprops = new RectProperties();
        this.arcprops = new PolylineProperties();
        this.circleprops = new CircleProperties();
        this.circleprops.set("depth", 1);
        this.circleprops.set("filled", true);
        this.circleprops.set("fillColor", Color.WHITE);
        this.arcprops.set("depth", 5);
        this.matrixprops.set("elementColor", Color.BLACK);
        this.matrixprops.set("elemHighlight", Color.red);
        this.matrixprops.set("filled", true);
        this.matrixprops.set("fillColor", Color.pink);
        this.matrixprops.set("cellHighlight", Color.MAGENTA);
        this.matrixprops.set("depth", 1);
        this.textprops.set("color", Color.blue);
        this.textprops.set("font", new Font("Monospaced", 1, 14));
        this.rectprops.set("filled", true);
        this.rectprops.set("fillColor", Color.orange);
        this.rectprops.set("depth", 10);
    }

    public void showSourceCode() {
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.CYAN);
        scProps.set("font", new Font("Monospaced", 1, 16));
        scProps.set("highlightColor", Color.red);
        scProps.set("color", Color.BLACK);
        this.sc = this.lang.newSourceCode(new Coordinates(40, 300), "sourceCode", null, scProps);
        this.sc.addCodeLine("public void Warshall(int[][]) {", null, 0, null);
        this.sc.addCodeLine("int N=a.length;", null, 1, null);
        this.sc.addCodeLine("int y=0, x=0,j=0;", null, 1, null);
        this.sc.addCodeLine("for (y= 0; y< N; y++) ", null, 1, null);
        this.sc.addCodeLine("for (x=0 ; x< N; x++)", null, 2, null);
        this.sc.addCodeLine("if  (a[x][y]>0]", null, 3, null);
        this.sc.addCodeLine("for (j=0; j<N ;j++)", null, 4, null);
        this.sc.addCodeLine("if (a[y][j]>0)", null, 5, null);
        this.sc.addCodeLine("if ((a[x][j]==0 || (a[x][y]+a[y][j]<a[x][j]))", null, 5, null);
        this.sc.addCodeLine("a[x][j]= a[x][y]+a[y][j];", null, 6, null);
        this.sc.addCodeLine("}", null, 0, null);
    }

    @Override
    public String getCodeExample() {
        return "Straight forward Warshall Algorithm";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "Animates Warshall with Source Code + Highlighting";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(8);
    }

    @Override
    public String getName() {
        return "Warshall";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        Enumeration<String> iter = primitives.keys();
        while (iter.hasMoreElements()) {
            String Element2 = iter.nextElement();
            if (!Element2.contains("graph")) continue;
            this.gr = (Graph)primitives.get(Element2);
        }
        this.animationProperties = props;
        this.Warshall(this.gr);
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Warshall";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Madieha Taddbier, Bouchra Elfakir";
    }
}

