/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.compression;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.Graph;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.compression.CompressionAlgorithm;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ShannonFanoEncoding
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 10;
    SourceCode sc;
    private static Graph gr;
    private static Partition mainPartition;
    private static StringArray actualStrArray;
    private static StringArray leftStrArry;
    private static StringArray rightStrArray;
    private static Text actualSumText;
    private static Text leftSumText;
    private static Text rightSumText;
    private static final String DESCRIPTION = "Die Shannon Fano Kodierung ist ein Kodierungsverfahren, welches vergleichbar mit der Huffman Kodierung ist. Die Buchstaben werden nach ihrer H\u2030ufigkeit sortiert und durch die Anwendung des Verfahrens werden f\u00b8r die h\u2030ufigsten Buchstaben die k\u00b8rzesten Bitfolgen f\u00b8r eine Kodierung gew\u2030hlt.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 10 Buchstaben begrenzt.";

    public ShannonFanoEncoding() {
        this(new AnimalScript("Shannon Fano", "Florian Lindner", 800, 600));
    }

    public ShannonFanoEncoding(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void animate(Partition p) {
        actualStrArray.hide();
        actualSumText.hide();
        leftStrArry.hide();
        leftSumText.hide();
        rightStrArray.hide();
        rightSumText.hide();
        if (!p.equals(mainPartition)) {
            p.getParent().unhighlight(mainPartition);
            p.getSibling().unhighlight(mainPartition);
        }
        gr.showNode(0, null, null);
        p.highlight(mainPartition);
        String[] actualData = new String[p.getLetters().size()];
        int i = 0;
        while (i < p.getLetters().size()) {
            actualData[i] = p.getLetters().elementAt(i).getLetter();
            ++i;
        }
        actualStrArray = this.lang.newStringArray(new Offset(0, 0, actualStrArray, "NW"), actualData, "strArray", null, ap);
        actualSumText = this.lang.newText(new Offset(0, -4, actualSumText, "SW"), "Summe: " + p.getSum(), "textSum", null, tpsteps);
        this.lang.nextStep();
        if (p.getValue() == null) {
            p.getLeft().highlight(mainPartition);
            gr.showNode(mainPartition.getOrderNr(p.getLeft()), null, null);
            String[] leftData = new String[p.getLeft().getLetters().size()];
            int i2 = 0;
            while (i2 < p.getLeft().getLetters().size()) {
                leftData[i2] = p.getLeft().getLetters().elementAt(i2).getLetter();
                ++i2;
            }
            leftStrArry = this.lang.newStringArray(new Offset(0, 0, leftStrArry, "NW"), leftData, "strArray", null, ap);
            leftSumText = this.lang.newText(new Offset(0, -4, leftSumText, "SW"), "Summe: " + p.getLeft().getSum(), "textSum", null, tpsteps);
            p.getRight().highlight(mainPartition);
            gr.showNode(mainPartition.getOrderNr(p.getRight()), null, null);
            String[] rightData = new String[p.getRight().getLetters().size()];
            int i3 = 0;
            while (i3 < p.getRight().getLetters().size()) {
                rightData[i3] = p.getRight().getLetters().elementAt(i3).getLetter();
                ++i3;
            }
            rightStrArray = this.lang.newStringArray(new Offset(0, 0, rightStrArray, "NW"), rightData, "strArray", null, ap);
            rightSumText = this.lang.newText(new Offset(0, -4, rightSumText, "SW"), "Summe: " + p.getRight().getSum(), "textSum", null, tpsteps);
            this.lang.nextStep();
            p.unhighlight(mainPartition);
            p.getRight().unhighlight(mainPartition);
            this.animate(p.getLeft());
            p.getLeft().unhighlight(mainPartition);
            this.animate(p.getRight());
            p.getRight().unhighlight(mainPartition);
        }
    }

    public void compress(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 10)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Shannon Fano Encoding", "Topic", null, tptopic);
        this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Ermittle die H\u2030ufigkeiten der Buchstaben in der Eingabe und sortiere diese danach absteigend.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "2) Zu Beginn wird die Menge aller Buchstaben als eine Partition betrachtet.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 30, step2, "SW"), "3) Teile jede Partition mit mehr als einem Buchstaben in 2 Teilpartitionen auf, so dass ", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "      die Differenz der Summe der H\u2030ufigkeiten beider Seiten minimal ist.", "line31", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 30, step31, "SW"), "4) Nach 3. entsteht ein Baum, sobald nur noch Partitionen mit einem Buchstaben vorhanden sind.", "line4", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "      Der Baum wird nun bin\u2030r traversiert, so dass eine Kodierung f\u00b8r jeden Buchstaben entsteht.", "line32", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step4.hide();
        step41.hide();
        this.lang.nextStep();
        tpwords.set("font", new Font("SansSerif", 0, 16));
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        algoinWords.setText("Eingabe:  " + input, null, null);
        algoinWords.show();
        step1.changeColor(null, Color.RED, null, null);
        step1.show();
        int[] list = new int[256];
        int i3 = 0;
        while (i3 < text.length) {
            int n = new Integer(text[i3].charAt(0));
            list[n] = list[n] + 1;
            ++i3;
        }
        int numberOfLetters = 0;
        int i4 = 0;
        while (i4 < 256) {
            if (list[i4] != 0) {
                ++numberOfLetters;
            }
            ++i4;
        }
        String[][] freqPrint = new String[numberOfLetters][2];
        int[] listClone = (int[])list.clone();
        int cnt = 0;
        int i5 = 0;
        while (i5 < numberOfLetters) {
            int big = -1;
            int bigIndex = -1;
            int j = 0;
            while (j < list.length) {
                if (list[j] != 0 && list[j] > big) {
                    big = list[j];
                    bigIndex = j;
                }
                ++j;
            }
            freqPrint[cnt][0] = (char)bigIndex + ":  ";
            freqPrint[cnt][1] = "" + big;
            list[bigIndex] = -1;
            ++cnt;
            ++i5;
        }
        list = listClone;
        this.lang.newStringMatrix(new Offset(30, 0, step1, "NE"), freqPrint, "matrix", null, mp);
        this.lang.nextStep();
        step1.changeColor(null, Color.BLACK, null, null);
        step2.changeColor(null, Color.RED, null, null);
        step3.changeColor(null, Color.RED, null, null);
        step31.changeColor(null, Color.RED, null, null);
        step2.show();
        step3.show();
        step31.show();
        this.lang.nextStep();
        Vector<Letter> letters = new Vector<Letter>(0, 1);
        int most = -1;
        int mostIndex = -1;
        int i6 = 0;
        while (i6 < numberOfLetters) {
            most = -1;
            mostIndex = -1;
            int j = 0;
            while (j < list.length) {
                if (list[j] > 0 && list[j] > most) {
                    most = list[j];
                    mostIndex = j;
                }
                ++j;
            }
            letters.add(new Letter("" + (char)mostIndex, most));
            list[mostIndex] = 0;
            ++i6;
        }
        mainPartition = new Partition(letters);
        Vector<Partition> order = mainPartition.getInOrder();
        int[][] adj = new int[mainPartition.elements()][mainPartition.elements()];
        int i7 = 0;
        while (i7 < order.size()) {
            if (order.elementAt(i7).getValue() == null) {
                adj[i7][ShannonFanoEncoding.mainPartition.getOrderNr((Partition)order.elementAt((int)i7).getLeft())] = 9;
                adj[i7][ShannonFanoEncoding.mainPartition.getOrderNr((Partition)order.elementAt((int)i7).getRight())] = 1;
            }
            ++i7;
        }
        Node[] graphNodes = new Node[order.size()];
        graphNodes = mainPartition.getCoords(mainPartition, new Coordinates(350, 300), graphNodes);
        graphNodes[0] = new Coordinates(350, 300);
        String[] label = new String[order.size()];
        int i8 = 0;
        while (i8 < order.size()) {
            label[i8] = order.elementAt(i8).getValue() != null ? order.elementAt(i8).getValue() : "";
            ++i8;
        }
        gr = this.lang.newGraph("graph", adj, graphNodes, label, null, gp);
        i8 = 0;
        while (i8 < gr.getSize()) {
            gr.hideNode(i8, null, null);
            ++i8;
        }
        Text actual = this.lang.newText(new Offset(0, 50, gr, "SW"), "Gesamtmenge:", "actual", null, tpsteps);
        actualStrArray = this.lang.newStringArray(new Offset(20, 0, actual, "NE"), new String[]{"   ", "   ", "   ", "   "}, "actual", null, ap);
        actualSumText = this.lang.newText(new Offset(65, 5, actualStrArray, "E"), "Summe: " + mainPartition.getSum(), "sumtext", null, tpsteps);
        Text left = this.lang.newText(new Offset(0, 30, actual, "SW"), "Unterteilung 1:  ", "left", null, tpsteps);
        leftStrArry = this.lang.newStringArray(new Offset(20, 0, left, "NE"), new String[]{"   ", "   ", "   ", "   "}, "left", null, ap);
        leftSumText = this.lang.newText(new Offset(65, 9, leftStrArry, "E"), "Summe: " + mainPartition.getLeft().getSum(), "sumtext", null, tpsteps);
        Text right = this.lang.newText(new Offset(0, 30, left, "SW"), "Unterteilung 2:  ", "right", null, tpsteps);
        rightStrArray = this.lang.newStringArray(new Offset(20, 0, right, "NE"), new String[]{"   ", "   ", "   ", "   "}, "right", null, ap);
        rightSumText = this.lang.newText(new Offset(65, 10, rightStrArray, "E"), "Summe: " + mainPartition.getRight().getSum(), "sumtext", null, tpsteps);
        this.lang.nextStep();
        this.animate(mainPartition);
        gr.showEdgeWeight(0, gr.getSize() - 1, null, null);
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash = ShannonFanoEncoding.fillHash(hash, mainPartition, "");
        String result = "";
        int i9 = 0;
        while (i9 < text.length) {
            result = String.valueOf(result) + hash.get(text[i9]) + "  ";
            ++i9;
        }
        actualStrArray.hide();
        leftStrArry.hide();
        rightStrArray.hide();
        Text fazit1 = this.lang.newText(new Offset(-210, 70, right, "SW"), "Jeder Buchstabe der Eingabe kann nun durch den Baum kodiert werden,", "fazit", null, tpsteps);
        Text fazit11 = this.lang.newText(new Offset(0, 20, fazit1, "SW"), "die Bitfolge beschreibt den Pfad von der Wurzel zum Blatt.", "fazit1", null, tpsteps);
        StringArray in = this.lang.newStringArray(new Offset(0, 35, fazit11, "SW"), text, "in", null, ap);
        in.highlightCell(0, null, null);
        StringTokenizer tResult = new StringTokenizer(result);
        String showResult = "";
        Text fazit2 = this.lang.newText(new Offset(0, 20, in, "SW"), "Die Ausgabe ist also: ", "fazit2", null, tpsteps);
        Text fazit21 = this.lang.newText(new Offset(20, -5, fazit2, "SE"), showResult, "fazit3", null, tpsteps);
        fazit21.changeColor(null, Color.BLUE, null, null);
        int j = 0;
        while (j < text.length) {
            in.highlightCell(j, null, null);
            if (j > 0) {
                in.unhighlightCell(j - 1, null, null);
            }
            Vector<Integer> nodes = mainPartition.getEdgeNodes(text[j]);
            int k = 0;
            while (k < nodes.size() - 1) {
                gr.highlightEdge(nodes.elementAt(k), nodes.elementAt(k + 1), null, null);
                ++k;
            }
            showResult = String.valueOf(showResult) + " " + tResult.nextToken();
            fazit21.setText(showResult, null, null);
            this.lang.nextStep();
            ++j;
        }
    }

    public static Hashtable<String, String> fillHash(Hashtable<String, String> hash, Partition p, String currentBits) {
        if (p.getValue() != null) {
            hash.put(p.getValue(), currentBits);
        } else {
            hash = ShannonFanoEncoding.fillHash(hash, p.getLeft(), String.valueOf(currentBits) + "0");
            hash = ShannonFanoEncoding.fillHash(hash, p.getRight(), String.valueOf(currentBits) + "1");
        }
        return hash;
    }

    public static int[][] fillAdj(Partition p, Vector<Integer> preorder) {
        int[][] adj = new int[p.elements()][p.elements()];
        if (p.getValue() != null) {
            return adj;
        }
        return adj;
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "Shannon Fano Kodierung";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    public static class Letter {
        private String letter;
        private int frequency;

        public Letter(String let, int frequ) {
            this.letter = let;
            this.frequency = frequ;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public String getLetter() {
            return this.letter;
        }
    }

    public static class Partition {
        private Partition left;
        private Partition right;
        private String value;
        private Vector<Letter> letters;

        public Partition(Vector<Letter> lettersVec) {
            this.letters = lettersVec;
            if (this.letters.size() == 1) {
                this.value = this.letters.elementAt(0).getLetter();
            } else {
                int sum = 0;
                int i = 0;
                while (i < this.letters.size()) {
                    sum += this.letters.elementAt(i).getFrequency();
                    ++i;
                }
                float half = (float)sum / 2.0f;
                int count = 0;
                int index = 0;
                float difference = half;
                int i2 = 0;
                while (i2 < this.letters.size()) {
                    if (!(Math.abs(half - ((float)count + (float)this.letters.elementAt(i2).getFrequency())) < difference)) break;
                    difference = Math.abs(half - (float)(count += this.letters.elementAt(i2).getFrequency()));
                    index = i2++;
                }
                Vector<Letter> l = new Vector<Letter>(0, 1);
                Vector<Letter> r = new Vector<Letter>(0, 1);
                int i3 = 0;
                while (i3 < this.letters.size()) {
                    if (i3 <= index) {
                        l.add(this.letters.elementAt(i3));
                    } else {
                        r.add(this.letters.elementAt(i3));
                    }
                    ++i3;
                }
                this.left = new Partition(l);
                this.right = new Partition(r);
            }
        }

        public int getHeight() {
            if (this.value != null) {
                return 0;
            }
            return 1 + Math.max(this.left.getHeight(), this.right.getHeight());
        }

        public int elements() {
            if (this.value != null) {
                return 1;
            }
            return 1 + this.left.elements() + this.right.elements();
        }

        public Vector<Partition> getInOrder(Vector<Partition> order) {
            order.add(this);
            if (this.value == null) {
                order = this.getLeft().getInOrder(order);
                order = this.getRight().getInOrder(order);
            }
            return order;
        }

        public Vector<Partition> getInOrder() {
            Vector<Partition> order = new Vector<Partition>(0, 1);
            return this.getInOrder(order);
        }

        public int getOrderNr(Partition p) {
            Vector<Partition> order = this.getInOrder();
            int i = 0;
            while (i < order.size()) {
                if (p.equals(order.elementAt(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public static int getDistance(Partition upper, Partition lower) {
            if (upper.equals(lower)) {
                return 0;
            }
            if (upper.value != null) {
                return 1000;
            }
            return Math.min(1 + Partition.getDistance(upper.left, lower), 1 + Partition.getDistance(upper.right, lower));
        }

        public Node[] getCoords(Partition main, Node actualCoords, Node[] coords) {
            int h = main.getHeight();
            float offsetFactor = (float)Math.pow(2.0, 1 - Partition.getDistance(main, this));
            float l = 700.0f / (float)(Math.pow(2.0, h) - 1.0);
            if (this.value == null) {
                int x = ((Coordinates)actualCoords).getX() - new Float(l * offsetFactor).intValue();
                int y = ((Coordinates)actualCoords).getY() + 50;
                int nrLeft = main.getOrderNr(this.left);
                coords[nrLeft] = new Coordinates(x, y);
                x = ((Coordinates)actualCoords).getX() + new Float(l * offsetFactor).intValue();
                int nrRight = main.getOrderNr(this.right);
                coords[nrRight] = new Coordinates(x, y);
                coords = this.left.getCoords(main, coords[nrLeft], coords);
                coords = this.right.getCoords(main, coords[nrRight], coords);
            }
            return coords;
        }

        public void highlight(Partition mainp) {
            int nr = mainp.getOrderNr(this);
            gr.highlightNode(nr, null, null);
        }

        public void unhighlight(Partition mainp) {
            int nr = mainp.getOrderNr(this);
            gr.unhighlightNode(nr, null, null);
        }

        public Partition getParent() {
            Vector<Partition> order = mainPartition.getInOrder();
            int i = 0;
            while (i < order.size()) {
                if (order.elementAt(i).getValue() == null) {
                    if (order.elementAt((int)i).left.equals(this)) {
                        return order.elementAt(i);
                    }
                    if (order.elementAt((int)i).right.equals(this)) {
                        return order.elementAt(i);
                    }
                }
                ++i;
            }
            return null;
        }

        public Vector<Integer> getEdgeNodes(String letter) {
            Vector<Partition> nodesOrdered = this.getInOrder();
            Vector<Integer> nodes = new Vector<Integer>();
            int i = 0;
            while (i < nodesOrdered.size()) {
                if (nodesOrdered.elementAt((int)i).value != null && nodesOrdered.elementAt((int)i).value.equals(letter) && nodesOrdered.elementAt(i).getLeft() == null && nodesOrdered.elementAt(i).getRight() == null) {
                    nodes.add(this.getOrderNr(nodesOrdered.elementAt(i)));
                    Partition tmp = nodesOrdered.elementAt(i);
                    while (tmp.getParent() != null) {
                        nodes.add(this.getOrderNr(tmp.getParent()));
                        tmp = tmp.getParent();
                    }
                    break;
                }
                ++i;
            }
            return nodes;
        }

        public Partition getSibling() {
            if (mainPartition.equals(this)) {
                return null;
            }
            if (this.equals(this.getParent().left)) {
                return this.getParent().right;
            }
            return this.getParent().left;
        }

        public int getSum() {
            int sum = 0;
            int i = 0;
            while (i < this.letters.size()) {
                sum += this.letters.elementAt(i).getFrequency();
                ++i;
            }
            return sum;
        }

        public Partition getLeft() {
            return this.left;
        }

        public Vector<Letter> getLetters() {
            return this.letters;
        }

        public Partition getRight() {
            return this.right;
        }

        public String getValue() {
            return this.value;
        }
    }
}

