/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.compression;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.util.Coordinates;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.compression.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

public class LZ77En
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 11;
    private static final String DESCRIPTION = "LZ77 is the name of a lossless data compression algorithm. Words or parts of them that appear several times in a text are replaced by a key.";
    private static final String SOURCE_CODE = "The algorithm is explained by an animation. To ensure the animation  is not larger than the frame size, the text is limited to 11 characters.";

    public LZ77En() {
        this(new AnimalScript("LZ77 EN", "Florian Lindner", 800, 600));
    }

    public LZ77En(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String[] t = new String[text.length];
        int i = 0;
        while (i < Math.min(11, text.length)) {
            t[i] = text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "LZ77", "Topic", null, tptopic);
        this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Description of the algorithm:", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Set up a table with 2 columns: a text window and a buffer. The text window saves", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(0, 20, step1, "SW"), "     the last read text with increasing indexes from right to left.", "line1", null, tpsteps);
        Text step13 = this.lang.newText(new Offset(0, 20, step12, "SW"), "     The buffer contains read characters that are not yet encoded.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step13, "SW"), "2) Find a substring in the text window that is equal to left sided beginning of the buffer.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step2, "SW"), "3) Encode the substring in a tuple (a,b,c).", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "      a:    index of the position of the substring in the text window", "line3", null, tpsteps);
        Text step32 = this.lang.newText(new Offset(0, 20, step31, "SW"), "      b:    length of the substring", "line3", null, tpsteps);
        Text step33 = this.lang.newText(new Offset(0, 20, step32, "SW"), "      c:    following  character of the substring in the buffer", "line3", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 40, step33, "SW"), "4)  Shift the substring and the following character iteratively to the left window. Go to step 2).", "line3", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step12.hide();
        step13.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step32.hide();
        step33.hide();
        step4.hide();
        this.lang.nextStep();
        Text description = this.lang.newText(new Offset(0, 40, topic, "SW"), "We are searching for first letters of the buffer in the text window.", "desc", null, tpsteps);
        String input = "";
        int[][] ind = new int[1][text.length];
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ind[0][i2] = text.length - i2 - 1;
            ++i2;
        }
        IntMatrix index = this.lang.newIntMatrix(new Offset(5, 20, description, "SW"), ind, "index", null, mp);
        Text bufText = this.lang.newText(new Offset(60, 0, index, "SE"), "buffer", "buftext", null, tpsteps);
        bufText.changeColor(null, Color.BLUE, null, null);
        String[] winContent = new String[input.length()];
        String[] bufContent = new String[input.length()];
        int i3 = 0;
        while (i3 < winContent.length) {
            winContent[i3] = "      ";
            bufContent[i3] = "  " + text[i3] + "  ";
            ++i3;
        }
        StringArray windowArray = this.lang.newStringArray(new Offset(-5, 15, index, "SW"), winContent, "window", null, ap);
        StringArray bufferArray = this.lang.newStringArray(new Offset(35, 0, windowArray, "NE"), bufContent, "buffer", null, ap);
        StringArray lastWindow = windowArray;
        StringArray lastBuffer = bufferArray;
        this.lang.nextStep();
        String window = "";
        String buffer = "";
        String result = "";
        int i4 = 0;
        while (i4 < text.length) {
            buffer = String.valueOf(buffer) + text[i4];
            ++i4;
        }
        while (buffer.length() != 0) {
            int i5;
            Text tupel;
            String tmp = "" + buffer.charAt(0);
            int cnt = 0;
            while (cnt < buffer.length() - 1 && window.contains(tmp)) {
                if (!window.contains(String.valueOf(tmp) + buffer.charAt(++cnt))) break;
                tmp = String.valueOf(tmp) + buffer.charAt(cnt);
            }
            if (!window.contains(tmp)) {
                result = String.valueOf(result) + "(0,0," + tmp + ") ";
                tupel = this.lang.newText(new Offset(10, 20, lastBuffer, "NE"), "(0,0," + tmp + ") ", "tupel", null, tpsteps);
                tupel.changeColor(null, Color.RED, null, null);
                bufferArray.highlightCell(0, tmp.length() - 1, null, null);
                this.lang.nextStep();
                window = String.valueOf(window) + buffer.substring(0, 1);
                buffer = buffer.substring(1, buffer.length());
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[i5] = "       ";
                    bufContent[i5] = "       ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[winContent.length - i5 - 1] = i5 < window.length() ? "  " + window.charAt(window.length() - i5 - 1) + "  " : "      ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < bufContent.length) {
                    bufContent[i5] = i5 > buffer.length() - 1 ? "      " : "  " + buffer.charAt(i5) + "  ";
                    ++i5;
                }
                windowArray = this.lang.newStringArray(new Offset(0, 20, lastWindow, "SW"), winContent, "window", null, ap);
                bufferArray = this.lang.newStringArray(new Offset(0, 20, lastBuffer, "SW"), bufContent, "buffer", null, ap);
                lastWindow = windowArray;
                lastBuffer = bufferArray;
                this.lang.nextStep();
            } else if (cnt + 1 < buffer.length()) {
                result = String.valueOf(result) + "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + buffer.charAt(cnt) + ") ";
                tupel = this.lang.newText(new Offset(10, 20, lastBuffer, "NE"), "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + buffer.charAt(cnt) + ") ", "tupel", null, tpsteps);
                tupel.changeColor(null, Color.RED, null, null);
                bufferArray.highlightCell(0, tmp.length() - 1, null, null);
                this.lang.nextStep();
                window = String.valueOf(window) + buffer.substring(0, tmp.length() + 1);
                buffer = buffer.substring(tmp.length() + 1, buffer.length());
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[i5] = "       ";
                    bufContent[i5] = "       ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[winContent.length - i5 - 1] = i5 < window.length() ? "  " + window.charAt(window.length() - i5 - 1) + "  " : "      ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < bufContent.length) {
                    bufContent[i5] = i5 > buffer.length() - 1 ? "      " : "  " + buffer.charAt(i5) + "  ";
                    ++i5;
                }
                windowArray = this.lang.newStringArray(new Offset(0, 20, lastWindow, "SW"), winContent, "window", null, ap);
                bufferArray = this.lang.newStringArray(new Offset(0, 20, lastBuffer, "SW"), bufContent, "buffer", null, ap);
                lastWindow = windowArray;
                lastBuffer = bufferArray;
                this.lang.nextStep();
            } else {
                result = String.valueOf(result) + "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + "EOF)";
                tupel = this.lang.newText(new Offset(10, 20, lastBuffer, "NE"), "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + "EOF)", "tupel", null, tpsteps);
                tupel.changeColor(null, Color.RED, null, null);
                bufferArray.highlightCell(0, tmp.length() - 1, null, null);
                this.lang.nextStep();
                break;
            }
            this.lang.nextStep();
        }
        Text fazit = this.lang.newText(new Offset(0, 90, lastWindow, "SW"), "output:  ", "Ausgabe", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(15, -5, fazit, "SE"), result, "Ausgabe", null, tpsteps);
        fazit2.changeColor(null, Color.BLUE, null, null);
        Text fazit3 = this.lang.newText(new Offset(0, 20, fazit2, "SW"), "The result can now be compressed by Huffman encoding.", "fazit", null, tpsteps);
        this.lang.newText(new Offset(0, 20, fazit3, "SW"), "You can find a combination of this procedures in Deflate Encoding.", "fazit", null, tpsteps);
    }

    public static String getDESCRIPTION() {
        return DESCRIPTION;
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "LZ77 EN";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

