/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.AnnotatedAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

public class Sumup
extends AnnotatedAlgorithm
implements Generator {
    @Override
    public String getAnimationAuthor() {
        return "Sebastian Proksch <sproksch[at]rbg.informatik.tu-darmstadt.de>";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnnotatedSrc() {
        return "int sumup(int number) {\t@label(\"header\") @highlight(\"end\")\n\tint result = 0;\t\t\t@label(\"variables\") @declare(\"int\", \"result\", \"0\")\n\tfor(i = 0;\t\t\t\t@label(\"forInit\") @declare(\"int\", \"i\")\n\t     i <= number;\t\t@label(\"forCond\") @continue\n\t            i++)\t\t@label(\"forInc\") @continue @inc(\"i\")\n\t\tresult += i;\t\t@label(\"sumup\") @eval(\"result\", \"result + i\")\n\treturn result;\t\t\t@label(\"return\")\n}\t\t\t\t\t\t\t@label(\"end\") @discard(\"i\")\n";
    }

    @Override
    public void init() {
        super.init();
        SourceCodeProperties props = new SourceCodeProperties();
        props.set("highlightColor", Color.BLUE);
        props.set("bold", true);
        this.sourceCode = this.lang.newSourceCode(new Coordinates(20, 20), "sumupCode", null, props);
        this.parse();
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int number = (Integer)primitives.get("Integer Argument");
        this.vars.declare("int", "number", String.valueOf(number));
        this.exec("header");
        this.lang.nextStep();
        this.exec("variables");
        this.lang.nextStep();
        this.exec("forInit");
        this.lang.nextStep();
        this.exec("forCond");
        this.lang.nextStep();
        int i = 0;
        while (i <= number) {
            this.exec("sumup");
            this.lang.nextStep();
            this.exec("forInc");
            this.lang.nextStep();
            this.exec("forCond");
            this.lang.nextStep();
            i = Integer.parseInt(this.vars.get("i"));
        }
        this.exec("return");
        return this.lang.toString();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "The summing up of numbers from 0 to n is animated in this generator to work as an example for the new annotation system";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(0x40000000);
    }

    @Override
    public String getName() {
        return "Sumup [annotation based]";
    }

    @Override
    public String getAlgorithmName() {
        return "Sumup";
    }
}

