/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class SelectionSortDemo
implements Generator {
    private Language lang;
    private ArrayProperties arrayProps;
    private ArrayMarkerProperties ami;
    private ArrayMarkerProperties amj;
    private ArrayMarkerProperties amMin;
    private SourceCode sc;

    @Override
    public void init() {
        this.lang = new AnimalScript("Quicksort Animation", "Dr. Guido Roessling", 640, 480);
        this.lang.setStepMode(true);
        this.arrayProps = new ArrayProperties();
        this.arrayProps.set("elementColor", Color.RED);
        this.arrayProps.set("filled", true);
        this.arrayProps.set("fillColor", Color.GRAY);
        this.ami = new ArrayMarkerProperties();
        this.ami.set("color", Color.BLACK);
        this.ami.set("label", "i");
        this.amj = new ArrayMarkerProperties();
        this.amj.set("color", Color.BLUE);
        this.amj.set("label", "j");
        this.amMin = new ArrayMarkerProperties();
        this.amMin.set("color", Color.GREEN);
        this.amMin.set("label", "min");
    }

    public static void main(String[] args) {
        SelectionSortDemo ssd = new SelectionSortDemo();
        ssd.init();
        int[] original = new int[]{1, 13, 7, 2, 11};
        ssd.selectionSort(original);
        ssd.lang.finalizeGeneration();
        System.err.println(ssd.lang.getAnimationCode());
    }

    public void selectionSort1(int[] arrayContents) {
        IntArray array = this.lang.newIntArray(new Coordinates(10, 100), arrayContents, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        int i = 0;
        while (i < array.getLength() - 1) {
            int minIndex = i;
            int j = i + 1;
            while (j < array.getLength()) {
                if (array.getData(j) < array.getData(minIndex)) {
                    minIndex = j;
                }
                ++j;
            }
            array.swap(i, minIndex, null, defaultTiming);
            this.lang.nextStep();
            ++i;
        }
    }

    public void showSourceCode() {
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        this.sc = this.lang.newSourceCode(new Coordinates(10, 140), "sourceCode", null, scProps);
        this.sc.addCodeLine("public void selectionSort(int[] data) {", null, 0, null);
        this.sc.addCodeLine("int i, j, minIndex;", null, 1, null);
        this.sc.addCodeLine("for (i = 0; i < inputArray.length - 1; i++) {", null, 1, null);
        this.sc.addCodeLine("minIndex = i;", null, 2, null);
        this.sc.addCodeLine("for (j = i + 1; j < inputArray.length; j++)", null, 2, null);
        this.sc.addCodeLine("if (inputArray[j] < inputArray[minIndex])", null, 3, null);
        this.sc.addCodeLine("minIndex = j;", null, 4, null);
        this.sc.addCodeLine("swap(inputArray, i, j); // swap", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
    }

    public void selectionSort2(int[] arrayContents) {
        IntArray array = this.lang.newIntArray(new Coordinates(10, 100), arrayContents, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        this.lang.nextStep();
        ArrayMarker i = this.lang.newArrayMarker(array, 0, "i", null, this.ami);
        this.lang.nextStep();
        ArrayMarker j = this.lang.newArrayMarker(array, 0, "j", null, this.amj);
        this.lang.nextStep();
        ArrayMarker min = this.lang.newArrayMarker(array, 0, "min", null, this.amMin);
        while (i.getPosition() < array.getLength() - 1) {
            this.lang.nextStep();
            min.move(i.getPosition(), null, defaultTiming);
            this.lang.nextStep();
            j.move(i.getPosition() + 1, null, defaultTiming);
            while (j.getPosition() < array.getLength()) {
                this.lang.nextStep();
                if (array.getData(j.getPosition()) < array.getData(min.getPosition())) {
                    min.move(j.getPosition(), null, defaultTiming);
                    this.lang.nextStep();
                }
                j.increment(null, defaultTiming);
            }
            array.swap(i.getPosition(), min.getPosition(), null, defaultTiming);
            this.lang.nextStep();
            i.increment(null, defaultTiming);
        }
    }

    public void selectionSort3(int[] arrayContents) {
        IntArray array = this.lang.newIntArray(new Coordinates(10, 100), arrayContents, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        this.showSourceCode();
        this.lang.nextStep();
        ArrayMarker i = this.lang.newArrayMarker(array, 0, "i", null, this.ami);
        this.lang.nextStep();
        ArrayMarker j = this.lang.newArrayMarker(array, 0, "j", null, this.amj);
        this.lang.nextStep();
        ArrayMarker min = this.lang.newArrayMarker(array, 0, "min", null, this.amMin);
        while (i.getPosition() < array.getLength() - 1) {
            this.lang.nextStep();
            min.move(i.getPosition(), null, defaultTiming);
            this.lang.nextStep();
            j.move(i.getPosition() + 1, null, defaultTiming);
            while (j.getPosition() < array.getLength()) {
                this.lang.nextStep();
                if (array.getData(j.getPosition()) < array.getData(min.getPosition())) {
                    min.move(j.getPosition(), null, defaultTiming);
                    this.lang.nextStep();
                }
                j.increment(null, defaultTiming);
            }
            array.swap(i.getPosition(), min.getPosition(), null, defaultTiming);
            this.lang.nextStep();
            i.increment(null, defaultTiming);
        }
    }

    public void selectionSort4(int[] arrayContents) {
        IntArray array = this.lang.newIntArray(new Coordinates(10, 100), arrayContents, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        this.showSourceCode();
        this.lang.nextStep();
        this.sc.highlight(0);
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 1);
        ArrayMarker i = this.lang.newArrayMarker(array, 0, "i", null, this.ami);
        this.lang.nextStep();
        ArrayMarker j = this.lang.newArrayMarker(array, 0, "j", null, this.amj);
        this.lang.nextStep();
        ArrayMarker min = this.lang.newArrayMarker(array, 0, "min", null, this.amMin);
        this.sc.unhighlight(1);
        while (i.getPosition() < array.getLength() - 1) {
            this.sc.highlight(2);
            this.lang.nextStep();
            this.sc.toggleHighlight(2, 3);
            min.move(i.getPosition(), null, defaultTiming);
            this.lang.nextStep();
            this.sc.unhighlight(3);
            j.move(i.getPosition() + 1, null, defaultTiming);
            while (j.getPosition() < array.getLength()) {
                this.sc.highlight(4);
                this.lang.nextStep();
                this.sc.toggleHighlight(4, 5);
                if (array.getData(j.getPosition()) < array.getData(min.getPosition())) {
                    this.lang.nextStep();
                    this.sc.toggleHighlight(5, 6);
                    min.move(j.getPosition(), null, defaultTiming);
                    this.lang.nextStep();
                    this.sc.unhighlight(6);
                } else {
                    this.lang.nextStep();
                    this.sc.unhighlight(5);
                }
                j.increment(null, defaultTiming);
            }
            this.sc.highlight(7);
            array.swap(i.getPosition(), min.getPosition(), null, defaultTiming);
            this.lang.nextStep();
            this.sc.unhighlight(7);
            i.increment(null, defaultTiming);
        }
    }

    public void selectionSort(int[] data) {
        this.selectionSort4(data);
    }

    @Override
    public String getCodeExample() {
        return "Straightforward SelectionSort Algorithm";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "Animates SelectionSort with Source Code + Highlighting";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "SelectionSortDemo";
    }

    @Override
    public String getAnimationAuthor() {
        return "Dr. Guido Roessling";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int[] arrayData = (int[])primitives.get("array");
        this.arrayProps.set("color", props.get("array", "color"));
        this.selectionSort(arrayData);
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAlgorithmName() {
        return "Selection Sort";
    }
}

