/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algoanim.primitives.Text;
import algoanim.primitives.updater.TextUpdater;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.AnnotatedAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

public class Fibonacci
extends AnnotatedAlgorithm
implements Generator {
    private String assi = "Assignments";
    private String comp = "Compares";
    private String recdep = "Recursiondepth";

    @Override
    public String getAnimationAuthor() {
        return "Sebastian Proksch <sproksch[at]rbg.informatik.tu-darmstadt.de>";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnnotatedSrc() {
        return "int fib(int number) {\t@label(\"header\") @highlight(\"end\") @openContext @inc(\"" + this.recdep + "\")\n" + "\tint result;\t\t\t\t\t@label(\"vars\") @declare(\"int\", \"result\")\n" + "\tif(number == 0)\t\t\t\t@label(\"test0\") @inc(\"" + this.comp + "\")\n" + "\t\tresult = 1;\t\t\t\t@label(\"res0\") @inc(\"" + this.assi + "\") @set(\"result\", \"1\")\n" + "\telseif(number == 1)\t\t\t@label(\"test1\") @inc(\"" + this.comp + "\")\n" + "\t\tresult = 1;\t\t\t\t@label(\"res1\") @inc(\"" + this.assi + "\") @set(\"result\", \"1\")\n" + "\telse {\t\t\t\t\t\t@label(\"else\") @highlight(\"elseend\")\n" + "\t\tint fib1 = \t\t\t\t@label(\"setfib1\") @dec(\"" + this.recdep + "\") @closeContext @inc(\"" + this.assi + "\") @highlight(\"calcfib1\")\n" + "\t\t\t\t\t\t\tfib(number - 1);\t@label(\"calcfib1\") @continue\n" + "\t\tint fib2 =\t\t\t\t@label(\"setfib2\") @dec(\"" + this.recdep + "\") @closeContext @inc(\"" + this.assi + "\") @highlight(\"calcfib2\")\n" + "\t\t\t\t\t\t\tfib(number - 2);\t@label(\"calcfib2\") @continue\n" + "\t\tresult = fib1 + fib2;\t@label(\"result\") @inc(\"" + this.assi + "\") @eval(\"result\", \"fib1 + fib2\")\n" + "\t}\t\t\t\t\t\t\t@label(\"elseend\")\n" + "\treturn result;\t\t\t\t@label(\"return\")\n" + "}\t\t\t\t\t\t\t\t@label(\"end\")\n";
    }

    @Override
    public void init() {
        super.init();
        SourceCodeProperties props = new SourceCodeProperties();
        props.set("highlightColor", Color.BLUE);
        props.set("bold", true);
        this.sourceCode = this.lang.newSourceCode(new Coordinates(20, 10), "sumupCode", null, props);
        this.parse();
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        this.vars.declare("int", this.assi, "0");
        this.vars.setGlobal(this.assi);
        this.vars.declare("int", this.comp, "0");
        this.vars.setGlobal(this.comp);
        this.vars.declare("int", this.recdep, "0");
        this.vars.setGlobal(this.recdep);
        Text text = this.lang.newText(new Coordinates(270, 100), "", "rekText", null);
        TextUpdater recdepTU = new TextUpdater(text);
        recdepTU.addToken("aktuelle Rekursionstiefe: ");
        recdepTU.addToken(this.vars.getVariable(this.recdep));
        recdepTU.update();
        Text compText = this.lang.newText(new Coordinates(270, 120), "", "complexText", null);
        TextUpdater compTU = new TextUpdater(compText);
        compTU.addToken(String.valueOf(this.assi) + ": ");
        compTU.addToken(this.vars.getVariable(this.assi));
        compTU.addToken(" - " + this.comp + ": ");
        compTU.addToken(this.vars.getVariable(this.comp));
        compTU.update();
        int param = (Integer)primitives.get("Integer Argument");
        this.fib(param);
        return this.lang.toString();
    }

    public int fib(int number) {
        this.exec("header");
        this.vars.declare("int", "number", String.valueOf(number));
        this.lang.nextStep();
        this.exec("vars");
        this.lang.nextStep();
        this.exec("test0");
        this.lang.nextStep();
        if (number == 0) {
            this.exec("res0");
            this.lang.nextStep();
        } else {
            this.exec("test1");
            this.lang.nextStep();
        }
        if (number == 1) {
            this.exec("res1");
            this.lang.nextStep();
        } else if (number != 0 && number != 1) {
            this.exec("else");
            this.lang.nextStep();
            this.exec("calcfib1");
            this.lang.nextStep();
            int fib1 = this.fib(number - 1);
            this.exec("setfib1");
            this.vars.declare("int", "fib1", String.valueOf(fib1));
            this.lang.nextStep();
            this.exec("calcfib2");
            this.lang.nextStep();
            int fib2 = this.fib(number - 2);
            this.exec("setfib2");
            this.vars.declare("int", "fib2", String.valueOf(fib2));
            this.lang.nextStep();
            this.exec("result");
            this.lang.nextStep();
        }
        this.exec("return");
        this.lang.nextStep();
        return Integer.parseInt(this.vars.get("result"));
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "This is the second example for the new annotationsystem. the animation visualizes the calculation of a fibonacci-number.";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(0x40000000);
    }

    @Override
    public String getName() {
        return "Fibonacci [annotation based]";
    }

    @Override
    public String getAlgorithmName() {
        return "Fibonacci";
    }
}

