/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algoanim.animalscript.AnimalScript;
import algoanim.annotations.Annotation;
import algoanim.annotations.ExecutorManager;
import algoanim.annotations.LineParser;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Variables;
import algoanim.primitives.generators.Language;
import generator.Generator;
import java.util.HashMap;
import java.util.Vector;

public abstract class AnnotatedAlgorithm
implements Generator {
    protected Language lang;
    protected SourceCode sourceCode;
    protected Variables vars;
    protected HashMap<String, Vector<Annotation>> annotations;
    protected ExecutorManager annoMan;

    public abstract String getAnnotatedSrc();

    @Override
    public void init() {
        this.lang = new AnimalScript(this.getName(), this.getAnimationAuthor(), 640, 480);
        this.lang.setStepMode(true);
        this.vars = this.lang.newVariables();
        this.annotations = new HashMap();
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    public void parse() {
        this.annoMan = new ExecutorManager(this.vars, this.sourceCode);
        String[] lines = this.getAnnotatedSrc().split("\n");
        int i = 0;
        while (i < lines.length) {
            LineParser parser = new LineParser(lines[i], "@");
            this.annotations.put(parser.getLabel(), parser.getProperties());
            if (parser.isContinue()) {
                this.sourceCode.addCodeElement(parser.getCode(), parser.getLabel(), parser.getIndent(), null);
            } else {
                this.sourceCode.addCodeLine(parser.getCode(), parser.getLabel(), parser.getIndent(), null);
            }
            ++i;
        }
    }

    @Override
    public String getCodeExample() {
        String codeExample = "";
        String preLine = "";
        String[] lines = this.getAnnotatedSrc().split("\n");
        int i = 0;
        while (i < lines.length) {
            LineParser parser = new LineParser(lines[i], "@");
            String indent = "";
            int j = 0;
            while (j < parser.getIndent()) {
                indent = String.valueOf(indent) + "  ";
                ++j;
            }
            String code = parser.getCode().replace("<", "&lt;").replace(">", "&gt;");
            if (parser.isContinue()) {
                codeExample = String.valueOf(codeExample) + " " + code;
            } else {
                codeExample = String.valueOf(codeExample) + preLine + indent + code;
                preLine = "\n";
            }
            ++i;
        }
        return codeExample;
    }

    public void exec(String label) {
        Vector<Annotation> props = this.annotations.get(label);
        this.sourceCode.toggleHighlight(label);
        this.annoMan.exec(props);
    }
}

