/*
 * Decompiled with CFR 0.152.
 */
package generator.properties.tree;

import algoanim.properties.AnimationProperties;
import algoanim.properties.CallMethodProperties;
import generator.properties.tree.PropertiesTreeNode;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PropertiesTreeRenderer
extends DefaultTreeCellRenderer {
    private static final String ICON_LOCATION = "generator/properties/tree/";
    private static final long serialVersionUID = 3257570594253255734L;
    private ImageIcon folderIcon = this.getImageIcon("folder.gif");
    private ImageIcon propIcon = this.getImageIcon("prop.gif");
    private ImageIcon itemIcon = this.getImageIcon("item.gif");
    private ImageIcon primitiveIcon = this.getImageIcon("primitive.gif");
    private ImageIcon callMethodIcon = this.getImageIcon("callMethod.gif");

    public ImageIcon getImageIcon(String name) {
        ImageIcon icon = null;
        URL url = null;
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl != null) {
            url = cl.getResource(ICON_LOCATION + name);
            if (url != null && (icon = new ImageIcon(url)) != null) {
                return icon;
            }
            System.err.println("trying again, this failed... for graphics/" + name);
        } else {
            System.err.println("ClassLoader failed, null!");
        }
        System.err.println("trying again, this failed... for " + name);
        return icon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean _hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, _hasFocus);
        if (value == null) {
            return this;
        }
        if (!(value instanceof PropertiesTreeNode)) {
            return this;
        }
        PropertiesTreeNode n = (PropertiesTreeNode)value;
        if (n.isItem()) {
            String t = n.getLabel();
            if (t.trim().length() == 0) {
                t = n.getName();
            }
            this.setText(t);
            this.setIcon(this.itemIcon);
            return this;
        }
        if (n.isFolder()) {
            this.setText(n.getLabel());
            this.setIcon(this.folderIcon);
            return this;
        }
        if (n.isPrimitive()) {
            this.setText(n.getName());
            this.setIcon(this.primitiveIcon);
            return this;
        }
        AnimationProperties ap = n.getAnimationProperties();
        if (ap == null) {
            return this;
        }
        if (ap instanceof CallMethodProperties) {
            this.setIcon(this.callMethodIcon);
        } else {
            this.setIcon(this.propIcon);
        }
        this.setText((String)ap.get("name"));
        return this;
    }
}

