/*
 * Decompiled with CFR 0.152.
 */
package generator;

import algoanim.primitives.Graph;
import algoanim.properties.AnimationProperties;
import generator.CustomFileFilter;
import generator.NewPrimitiveDialog;
import generator.NewPropertyTypeDialog;
import generator.PropertiesPanel;
import generator.WizardGUI;
import generator.WizardGUIListener;
import generator.properties.tree.PropertiesTree;
import generator.properties.tree.PropertiesTreeModel;
import generator.properties.tree.PropertiesTreeNode;
import generator.properties.tree.PropertiesTreePane;
import gfgaa.gui.GraphAlgController;
import gfgaa.gui.GraphScriptPanel;
import gfgaa.gui.parser.GraphReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import translator.Translator;

public class PropertiesGUI
implements WizardGUIListener,
ActionListener,
TreeSelectionListener,
KeyListener {
    private static final String APP_NAME = "Animal Properties Builder";
    private WizardGUI wiz = new WizardGUI(3);
    private PropertiesTreePane treePane;
    private PropertiesTree tree;
    private JButton newFolder;
    private JButton newType;
    private JButton newPrimitive;
    private JButton changeName;
    private JButton delete;
    private JButton load;
    private JTextField txtFileName;
    private NewPropertyTypeDialog newProp;
    private NewPrimitiveDialog newPrim;
    private PropertiesPanel propPanel;
    private Translator translator;
    public static GraphAlgController mainclass;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PropertiesGUI();
                PropertiesGUI.start();
                PropertiesGUI.createGraphScriptPanel();
            }
        });
    }

    public PropertiesGUI() {
        this.wiz.getWizardFrame().setTitle(APP_NAME);
        this.wiz.setHelpString(0, "<html>Welcome to the \"<B>AnimationProperties Builder</B>\".<br />This wizard will help you to set up all the AnimationProperties that your Generator needs.</html>");
        this.wiz.setHelpString(1, "<html>Please change the <B>values</B> of the AnimationProperties and<br />chose which values can be edited by the users.</html>");
        this.wiz.setHelpString(2, "<html>Please <B>enter a filename</B><br />(or browse for a file by clicking the \"<B>Browse...</B>\" Button).<br />Then press \"<B>Finish</B>\" to write the file.</html>");
        this.tree = new PropertiesTree();
        int i = 0;
        while (i < 3) {
            this.wiz.setContent(i, this.createPanelForStep(i));
            ++i;
        }
        this.tree.setBuildMode();
        this.treePane.reInsertTree();
        this.tree.setSelectionRow(0);
        this.wiz.setListener(this);
        this.newProp = new NewPropertyTypeDialog(this.wiz.getWizardFrame());
        this.newPrim = new NewPrimitiveDialog(this.wiz.getWizardFrame());
        this.translator = new Translator("GeneratorMsg", Locale.GERMANY);
        this.wiz.setTranslator(this.translator);
        this.wiz.displayWizard();
    }

    private JComponent createPanelForStep(int numberOfStep) {
        if (numberOfStep < 0 || numberOfStep > 2) {
            return null;
        }
        switch (numberOfStep) {
            case 0: {
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout(8, 8));
                this.treePane = new PropertiesTreePane(this.tree);
                p.add((Component)this.treePane, "Center");
                this.tree.setSelectionRow(0);
                JPanel right = new JPanel();
                right.setLayout(new BoxLayout(right, 3));
                right.setPreferredSize(new Dimension(200, 250));
                p.add((Component)right, "East");
                this.newFolder = new JButton("New Folder...");
                this.newFolder.setActionCommand("newFolder");
                this.newFolder.addActionListener(this);
                this.newFolder.setMaximumSize(new Dimension(200, 30));
                right.add(this.newFolder);
                right.add(Box.createRigidArea(new Dimension(0, 10)));
                this.newType = new JButton("New Properties...");
                this.newType.setActionCommand("newProperties");
                this.newType.addActionListener(this);
                this.newType.setMaximumSize(new Dimension(200, 30));
                right.add(this.newType);
                right.add(Box.createRigidArea(new Dimension(0, 10)));
                this.newPrimitive = new JButton("New Primitive...");
                this.newPrimitive.setActionCommand("newPrimitive");
                this.newPrimitive.addActionListener(this);
                this.newPrimitive.setMaximumSize(new Dimension(200, 30));
                right.add(this.newPrimitive);
                right.add(Box.createRigidArea(new Dimension(0, 10)));
                this.changeName = new JButton("Change Name...");
                this.changeName.setActionCommand("changeName");
                this.changeName.addActionListener(this);
                this.changeName.setMaximumSize(new Dimension(200, 30));
                right.add(this.changeName);
                right.add(Box.createRigidArea(new Dimension(0, 10)));
                this.delete = new JButton("Delete");
                this.delete.setActionCommand("delete");
                this.delete.addActionListener(this);
                this.delete.setMaximumSize(new Dimension(200, 30));
                right.add(this.delete);
                right.add(Box.createRigidArea(new Dimension(0, 25)));
                this.load = new JButton("Load from File...");
                this.load.setActionCommand("load");
                this.load.addActionListener(this);
                this.load.setMaximumSize(new Dimension(200, 30));
                right.add(this.load);
                this.tree.addTreeSelectionListener(this);
                return p;
            }
            case 1: {
                this.propPanel = new PropertiesPanel(this.tree);
                return this.propPanel;
            }
            case 2: {
                JPanel p2 = new JPanel();
                p2.setLayout(new BoxLayout(p2, 3));
                JPanel panelTextField = new JPanel();
                panelTextField.setLayout(new BorderLayout(8, 8));
                panelTextField.add((Component)new JLabel("Filename:"), "Before");
                this.txtFileName = new JTextField();
                panelTextField.add((Component)this.txtFileName, "Center");
                this.txtFileName.addKeyListener(this);
                int txtHeight = this.txtFileName.getPreferredSize().height;
                panelTextField.setPreferredSize(new Dimension(300, txtHeight + 5));
                panelTextField.setMaximumSize(new Dimension(600, txtHeight + 5));
                p2.add(panelTextField);
                p2.add(Box.createRigidArea(new Dimension(0, 16)));
                JPanel panelButton = new JPanel();
                panelButton.setLayout(new BorderLayout(8, 8));
                JButton but = new JButton("Browse...");
                but.setActionCommand("browse");
                but.addActionListener(this);
                panelButton.add((Component)but, "After");
                int butHeight = but.getPreferredSize().height;
                but.setPreferredSize(new Dimension(200, butHeight + 5));
                panelButton.setPreferredSize(new Dimension(300, butHeight + 5));
                panelButton.setMaximumSize(new Dimension(600, butHeight + 5));
                p2.add(panelButton);
                return p2;
            }
        }
        return null;
    }

    @Override
    public boolean nextPressed() {
        if (this.wiz.getCurrentStep() == 0) {
            this.tree.setWorkingMode();
            this.propPanel.reInsertTree();
            this.tree.expandAllFolders();
        }
        if (this.wiz.getCurrentStep() == 1) {
            this.propPanel.updateCurrentPropertyValues();
        }
        if (this.wiz.getCurrentStep() == 2) {
            File selFile = new File(this.txtFileName.getText());
            if (selFile.exists()) {
                if (!selFile.isFile()) {
                    JOptionPane.showMessageDialog(this.wiz.getWizardFrame(), String.valueOf(selFile.getPath()) + "\nis not a valid name " + "for a file. Please choose another name!", APP_NAME, 0);
                    return false;
                }
                int ret = JOptionPane.showConfirmDialog(this.wiz.getWizardFrame(), String.valueOf(selFile.getPath()) + "\nalready exists. Are you " + "sure that you want to overwrite it?", APP_NAME, 0);
                if (ret == 1) {
                    return false;
                }
            }
            BufferedWriter buf = null;
            try {
                try {
                    FileWriter out = new FileWriter(selFile);
                    buf = new BufferedWriter(out);
                    buf.write(((PropertiesTreeModel)this.tree.getModel()).getAsXML());
                    buf.flush();
                    buf.close();
                    int choice = JOptionPane.showConfirmDialog(this.wiz.getWizardFrame(), "The file has successfully been written. Do you want to exit Animal Properties Builder?", APP_NAME, 0, 3);
                    if (choice == 0) {
                        this.wiz.getWizardFrame().dispose();
                    }
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this.wiz.getWizardFrame(), "An error occured while writing to " + selFile.getPath() + ". Please try to choose" + " another name!", APP_NAME, 0);
                    try {
                        if (buf != null) {
                            buf.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            }
            finally {
                try {
                    if (buf != null) {
                        buf.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private void updateButtons() {
        boolean somethingSelected = this.tree.getSelectionPath() != null && this.tree.getSelectionRows() != null && this.tree.getSelectionRows()[0] != 0;
        this.changeName.setEnabled(somethingSelected);
        this.delete.setEnabled(somethingSelected);
        if (this.wiz.btnNext != null) {
            this.wiz.btnNext.setEnabled(((PropertiesTreeModel)this.tree.getModel()).getElementsCount() > 0);
        }
    }

    @Override
    public boolean backPressed() {
        if (this.wiz.getCurrentStep() == 1) {
            this.tree.setBuildMode();
            this.treePane.reInsertTree();
            this.tree.expandAllFolders();
        }
        return true;
    }

    @Override
    public void afterShowStep(int index) {
        if (index == 0) {
            this.wiz.btnNext.setEnabled(((PropertiesTreeModel)this.tree.getModel()).getElementsCount() > 0);
            this.updateButtons();
        }
        if (index == 1) {
            this.updateButtons();
            this.tree.setSelectionRow(0);
        }
        if (index == 2) {
            this.wiz.btnNext.setEnabled(this.txtFileName.getText().length() > 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("newFolder")) {
            if (this.tree.getSelectionPath() == null) {
                this.tree.setSelectionRow(0);
            }
            PropertiesTreeNode m = (PropertiesTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            while (m != null && !m.isFolder()) {
                m = (PropertiesTreeNode)m.getParent();
            }
            if (m == null) {
                return;
            }
            String name = JOptionPane.showInputDialog("Please enter a label for the folder.");
            if (name == null || name.trim().length() == 0) {
                return;
            }
            PropertiesTreeNode folder = new PropertiesTreeNode(name);
            PropertiesTreeModel model = (PropertiesTreeModel)this.tree.getModel();
            model.insertNodeInto(folder, m, m.getChildCount());
            this.tree.expandAllFolders();
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("newProperties")) {
            if (this.tree.getSelectionPath() == null) {
                this.tree.setSelectionRow(0);
            }
            PropertiesTreeNode m = (PropertiesTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            while (m != null && !m.isFolder()) {
                m = (PropertiesTreeNode)m.getParent();
            }
            if (m == null) {
                return;
            }
            if (!this.newProp.showDialog()) {
                return;
            }
            if (this.newProp.getName().trim().length() == 0) {
                return;
            }
            AnimationProperties prop = PropertiesGUI.createPropertiesByName(this.newProp.getType());
            if (prop == null) {
                return;
            }
            String newName = this.getNextValidPropertiesName(this.newProp.getName(), null);
            prop.set("name", newName);
            PropertiesTreeModel model = (PropertiesTreeModel)this.tree.getModel();
            model.insertNodeInto(model.getNewNode(prop), m, m.getChildCount());
            this.tree.expandAllFolders();
            this.updateButtons();
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("newPrimitive")) {
            if (this.tree.getSelectionPath() == null) {
                this.tree.setSelectionRow(0);
            }
            PropertiesTreeNode m = (PropertiesTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            while (m != null && !m.isFolder()) {
                m = (PropertiesTreeNode)m.getParent();
            }
            if (m == null) {
                return;
            }
            if (!this.newPrim.showDialog()) {
                return;
            }
            if (this.newPrim.getName().trim().length() == 0) {
                return;
            }
            Object o = PropertiesGUI.createPrimitiveByName(this.newPrim.getType());
            if (o == null) {
                return;
            }
            String newName = this.getNextValidPrimitiveName(this.newPrim.getName(), null);
            PropertiesTreeNode primitive = new PropertiesTreeNode(newName, o);
            PropertiesTreeModel model = (PropertiesTreeModel)this.tree.getModel();
            model.insertNodeInto(primitive, m, m.getChildCount());
            this.tree.expandAllFolders();
            this.updateButtons();
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("changeName")) {
            String newName;
            if (this.tree.getSelectionPath() == null) {
                return;
            }
            PropertiesTreeNode n = (PropertiesTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            if (n.equals(this.tree.getModel().getRoot())) {
                return;
            }
            if (n.isItem()) {
                return;
            }
            if (n.isFolder()) {
                newName = JOptionPane.showInputDialog("Please enter a new name for the folder.", (Object)n.getLabel());
                if (newName == null || newName.trim().length() == 0) {
                    return;
                }
                n.setLabel(newName);
            }
            if (n.isProperty()) {
                AnimationProperties ap = n.getAnimationProperties();
                String newName2 = JOptionPane.showInputDialog("Please enter a new name for the Properties.", ap.get("name"));
                if (newName2 == null || newName2.trim().length() == 0) {
                    return;
                }
                newName2 = this.getNextValidPropertiesName(newName2, ap);
                ap.set("name", newName2);
            }
            if (n.isPrimitive()) {
                newName = JOptionPane.showInputDialog("Please enter a new name for the Primitive.", (Object)n.getName());
                if (newName == null || newName.trim().length() == 0) {
                    return;
                }
                newName = this.getNextValidPrimitiveName(newName, n.getName());
                n.setName(newName);
            }
            ((PropertiesTreeModel)this.tree.getModel()).nodeChanged(n);
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("delete")) {
            if (this.tree.getSelectionPath() == null) {
                return;
            }
            MutableTreeNode n = (MutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            if (n.equals(this.tree.getModel().getRoot())) {
                return;
            }
            int selRow = this.tree.getSelectionRows()[0];
            ((PropertiesTreeModel)this.tree.getModel()).removeNodeFromParent(n);
            this.tree.setSelectionRow(selRow - 1);
            this.updateButtons();
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("load")) {
            String path = this.getDefaultPath();
            JFileChooser fc = path == null ? new JFileChooser() : new JFileChooser(path);
            fc.addChoosableFileFilter(new CustomFileFilter("xml"));
            fc.addChoosableFileFilter(new CustomFileFilter("ptm"));
            int result = fc.showOpenDialog(this.wiz.getWizardFrame());
            if (result != 0) {
                return;
            }
            File selFile = fc.getSelectedFile();
            try {
                String strFile = selFile.getCanonicalPath();
                ((PropertiesTreeModel)this.tree.getModel()).loadFromXMLFile(strFile, false);
            }
            catch (Exception e1) {
                System.err.println("Error while loading " + selFile.getName() + "\n" + e1.getLocalizedMessage());
                ((PropertiesTreeModel)this.tree.getModel()).clear();
            }
            this.tree.expandAllFolders();
            if (this.tree.getSelectionPath() == null && ((PropertiesTreeModel)this.tree.getModel()).getElementsCount() > 0) {
                this.tree.setSelectionRow(0);
            }
            this.updateButtons();
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("browse")) {
            JFileChooser fc;
            if (this.txtFileName.getText().length() > 0) {
                File start = new File(this.txtFileName.getText());
                fc = new JFileChooser(start.getParent());
            } else {
                String path = this.getDefaultPath();
                fc = path == null ? new JFileChooser() : new JFileChooser(path);
            }
            fc.addChoosableFileFilter(new CustomFileFilter("xml"));
            int result = fc.showSaveDialog(this.wiz.getWizardFrame());
            if (result != 0) {
                return;
            }
            File selFile = fc.getSelectedFile();
            try {
                String strFile = selFile.getCanonicalPath();
                if (selFile.getName().indexOf(".") == -1) {
                    strFile = strFile.concat(".xml");
                }
                this.txtFileName.setText(strFile);
                this.wiz.btnNext.setEnabled(this.txtFileName.getText().length() > 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e == null) {
            return;
        }
        this.updateButtons();
    }

    private String getNextValidPropertiesName(String base, AnimationProperties current) {
        long suffix = 2L;
        String newName = base;
        while (true) {
            Iterator iterTypes = ((PropertiesTreeModel)this.tree.getModel()).getPropertiesContainer().iterator();
            boolean found = false;
            while (iterTypes.hasNext()) {
                AnimationProperties obj = (AnimationProperties)iterTypes.next();
                if (obj == current || !newName.equals(obj.get("name"))) continue;
                found = true;
                break;
            }
            if (!found) {
                return newName;
            }
            newName = String.valueOf(base) + Long.toString(suffix++);
        }
    }

    private String getNextValidPrimitiveName(String base, String currentName) {
        long suffix = 2L;
        String newName = base;
        while (true) {
            Enumeration<String> eNames = ((PropertiesTreeModel)this.tree.getModel()).getPrimitivesContainer().keys();
            boolean found = false;
            while (eNames.hasMoreElements()) {
                String eName = eNames.nextElement();
                if (eName == currentName || !newName.equals(eName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return newName;
            }
            newName = String.valueOf(base) + Long.toString(suffix++);
        }
    }

    private static AnimationProperties createPropertiesByName(String className) {
        AnimationProperties object = null;
        String pack = AnimationProperties.class.getPackage().getName();
        try {
            Class<?> propClass = Class.forName(String.valueOf(pack) + "." + className);
            object = (AnimationProperties)propClass.newInstance();
            return object;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Object createPrimitiveByName(String className) {
        if (className.equals("String")) {
            return "";
        }
        if (className.equals("int")) {
            return 2;
        }
        if (className.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (className.equals("double")) {
            return new Double(2.0);
        }
        if (className.equals("int[]")) {
            int[] i = new int[]{1, 2, 3, 4};
            return i;
        }
        if (className.equals("int[][]")) {
            int[][] i = new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}};
            return i;
        }
        if (className.equals("String[]")) {
            String[] i = new String[]{"A", "B", "C", "D"};
            return i;
        }
        if (className.equals("String[][]")) {
            String[][] i = new String[][]{{"A", "B"}, {"C", "D"}};
            return i;
        }
        if (className.equals("Color")) {
            return Color.GREEN;
        }
        if (className.equals("Font")) {
            return new Font("SansSerif", 0, 12);
        }
        if (className.equals("Graph")) {
            return mainclass.getPanel(6);
        }
        return null;
    }

    public static void start() {
        boolean langFlag = true;
        mainclass = new GraphAlgController(1);
    }

    public static GraphScriptPanel createGraphScriptPanel() {
        return new GraphScriptPanel(mainclass);
    }

    private String getDefaultPath() {
        if (this.getClass().getResource("../generatorImplementations") == null) {
            return null;
        }
        return this.getClass().getResource("../generatorImplementations").getPath().substring(1).replaceAll("%20", " ");
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e == null) {
            return;
        }
        final JTextField txt = this.txtFileName;
        final AbstractButton but = this.wiz.btnNext;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                but.setEnabled(txt.getText().length() > 0);
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e == null) {
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e == null) {
            return;
        }
    }

    public static Graph getGraphFromScriptFile() {
        Graph graph;
        block16: {
            if (mainclass == null) {
                return null;
            }
            GraphScriptPanel panel = (GraphScriptPanel)mainclass.getPanel(6);
            if (panel == null || panel.input == null) {
                return null;
            }
            String string1 = ((GraphScriptPanel)PropertiesGUI.mainclass.getPanel((int)6)).input.getText();
            FileWriter fw = null;
            graph = null;
            try {
                try {
                    fw = new FileWriter("fileWriter.txt");
                    fw.write(string1);
                }
                catch (IOException e1) {
                    System.err.println("Konnte Datei nicht erstellen");
                    if (fw != null) {
                        try {
                            ((Writer)fw).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (fw != null) {
                    try {
                        ((Writer)fw).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (fw != null) {
                try {
                    ((Writer)fw).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        GraphReader gr = new GraphReader("fileWriter.txt");
        graph = gr.readFile();
        return graph;
    }
}

