/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Color;
import de.ahrgr.animal.kohnert.asugen.Node;
import de.ahrgr.animal.kohnert.asugen.Rectangle;
import de.ahrgr.animal.kohnert.asugen.Text;

public class TextBox
extends AnimalObject {
    Rectangle rect;
    Text text;

    public TextBox(AnimalScriptWriter aWriter, Node pposition, String ptext) {
        super(aWriter);
        this.name = "textbox" + this.instance_index;
        this.position = pposition;
        this.text = new Text(aWriter, pposition.createOffset(5, -5), ptext);
        this.rect = new Rectangle(aWriter, pposition, this.text.createOffset(5, -5, 2));
        this.rect.setFillColor(Color.DEFAULT_FILLCOLOR);
        this.setDepth(this.depth);
    }

    @Override
    public void setDepth(int aDepth) {
        this.depth = aDepth;
        this.text.setDepth(this.depth);
        this.rect.setDepth(this.depth + 1);
    }

    @Override
    public void register() {
        super.register();
        if (!this.registered) {
            this.text.register();
            this.rect.register();
            this.out.print("group \"");
            this.out.print(this.name);
            this.out.print("\" \"");
            this.out.print(this.text.getName());
            this.out.print("\" \"");
            this.out.print(this.rect.getName());
            this.out.print("\"");
            this.printDisplayOptions();
            this.out.println();
            this.registered = true;
        }
    }

    public Text getText() {
        return this.text;
    }

    public Text setText(String s) {
        if (this.registered) {
            Text t = new Text(this.scriptwriter, this.position.createOffset(5, -5), s);
            this.getText().setHidden(true);
            t.register();
            this.text = t;
            return t;
        }
        this.text.text = s;
        return this.text;
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    @Override
    public Node createOffset(int dx, int dy, int direction) {
        return this.rect.createOffset(dx, dy, direction);
    }
}

