/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.Font;
import de.ahrgr.animal.kohnert.asugen.Generator;
import de.ahrgr.animal.kohnert.asugen.GeneratorFactory;
import de.ahrgr.animal.kohnert.asugen.property.ColorProperty;
import de.ahrgr.animal.kohnert.asugen.property.FontProperty;
import de.ahrgr.animal.kohnert.asugen.property.FormatedTextProperty;
import de.ahrgr.animal.kohnert.asugen.property.Property;
import de.ahrgr.animal.kohnert.asugen.property.TextProperty;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;

public class PropertyParser {
    private static String tokenToString(StreamTokenizer tok) {
        switch (tok.ttype) {
            case 40: {
                return "(";
            }
            case 41: {
                return ")";
            }
            case 44: {
                return ",";
            }
            case -1: {
                return "end of file";
            }
            case 10: {
                return "end of line";
            }
            case -3: {
                return tok.sval;
            }
            case 34: {
                return "\"" + tok.sval + "\"";
            }
        }
        return "" + (char)tok.ttype;
    }

    private void parseerror(StreamTokenizer tok, String s) throws IOException {
        throw new IOException("Parse Error in line " + tok.lineno() + " Token " + PropertyParser.tokenToString(tok) + ": " + s);
    }

    private void asserttokentype(StreamTokenizer tok, int soll) throws IOException {
        if (tok.ttype != soll) {
            this.parseerror(tok, "unexpected Token: " + PropertyParser.tokenToString(tok));
        }
    }

    public Generator parse(Reader src, GeneratorFactory generatorFactory) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(src);
        tok.ordinaryChar(44);
        tok.ordinaryChar(61);
        tok.ordinaryChar(40);
        tok.ordinaryChar(41);
        tok.eolIsSignificant(true);
        tok.quoteChar(34);
        tok.nextToken();
        this.asserttokentype(tok, -3);
        if (!"generator".equals(tok.sval)) {
            this.parseerror(tok, "generator class definition expected but found: " + PropertyParser.tokenToString(tok));
        }
        tok.nextToken();
        this.asserttokentype(tok, 61);
        tok.nextToken();
        this.asserttokentype(tok, 34);
        String generatorclass = tok.sval;
        tok.nextToken();
        this.asserttokentype(tok, 10);
        Generator g = generatorFactory.getGenerator(generatorclass);
        if (g == null) {
            return null;
        }
        HashMap<String, Property> properties = new HashMap<String, Property>();
        Property[] pa = g.getProperties();
        int i = 0;
        while (i < pa.length) {
            properties.put(pa[i].getKey(), pa[i]);
            ++i;
        }
        while (tok.nextToken() != -1) {
            if (tok.ttype != -3 && tok.ttype != 34) {
                this.parseerror(tok, "Key erwartet");
            }
            String key = tok.sval;
            tok.nextToken();
            this.asserttokentype(tok, 61);
            tok.nextToken();
            this.asserttokentype(tok, -3);
            String dataType = tok.sval;
            tok.nextToken();
            this.asserttokentype(tok, 40);
            ArrayList<String> params = new ArrayList<String>(3);
            while (tok.nextToken() != 41) {
                if (tok.ttype != -3 && tok.ttype != 34) {
                    this.parseerror(tok, "Parameter erwartet");
                }
                String param = tok.sval;
                params.add(param);
                tok.nextToken();
                if (tok.ttype == 41) {
                    tok.pushBack();
                    continue;
                }
                this.asserttokentype(tok, 44);
            }
            tok.nextToken();
            this.asserttokentype(tok, 10);
            String[] aparams = new String[params.size()];
            i = 0;
            while (i < aparams.length) {
                aparams[i] = (String)params.get(i);
                ++i;
            }
            this.parse(properties, key, dataType, aparams);
        }
        return g;
    }

    public void parse(HashMap<String, Property> properties, String key, String dataType, String[] params) {
        Property p = properties.get(key);
        if (p == null) {
            System.out.println("warning: Key \"" + key + "\" unknown and ignored");
            return;
        }
        if ("Text".equals(dataType)) {
            ((TextProperty)p).setValue(params[0]);
        } else if ("Color".equals(dataType)) {
            ((ColorProperty)p).setValue(params[0]);
        } else if ("FormatedText".equals(dataType)) {
            String text = params[0];
            String color = params[2];
            Font font = Font.parseAnimal(params[1]);
            ((FormatedTextProperty)p).setText(text);
            ((FormatedTextProperty)p).setColor(color);
            ((FormatedTextProperty)p).setFont(font);
        } else if ("Font".equals(dataType)) {
            Font font = Font.parseAnimal(params[0]);
            String color = params[1];
            ((FontProperty)p).setFont(font);
            ((FontProperty)p).setColor(color);
        } else {
            System.out.println("warning: unknown Property Type \"" + dataType + "\" ignored");
        }
    }
}

