/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Color;
import de.ahrgr.animal.kohnert.asugen.Node;
import de.ahrgr.animal.kohnert.asugen.TextBox;

public class Chart
extends AnimalObject {
    TextBox[][] elements;
    int columns;
    int rows;

    public Chart(AnimalScriptWriter aWriter, Node aPosition, int pcolumns, int prows) {
        super(aWriter);
        this.name = "chart" + this.instance_index;
        this.columns = pcolumns;
        this.rows = prows;
        this.elements = new TextBox[this.rows][this.columns];
        boolean firstrow = true;
        int i1 = this.rows - 1;
        while (i1 >= 0) {
            TextBox t;
            if (firstrow) {
                t = new TextBox(aWriter, aPosition, " ");
                firstrow = false;
            } else {
                t = new TextBox(aWriter, this.elements[i1 + 1][0].createOffset(0, 0, 0), " ");
            }
            this.elements[i1][0] = t;
            int i2 = 1;
            while (i2 < this.columns) {
                this.elements[i1][i2] = new TextBox(aWriter, this.elements[i1][i2 - 1].createOffset(0, 0, 8), " ");
                ++i2;
            }
            --i1;
        }
        this.setDepth(this.depth);
    }

    @Override
    public void setDepth(int aDepth) {
        this.depth = aDepth;
        int i1 = 0;
        while (i1 < this.rows) {
            int i2 = 0;
            while (i2 < this.columns) {
                this.elements[i1][i2].setDepth(this.depth);
                ++i2;
            }
            ++i1;
        }
    }

    public TextBox getElementAt(int x, int y) {
        return this.elements[y][x];
    }

    public void setText(int x, int y, String text) {
        this.elements[y][x].getText().setValue(text);
    }

    public void setFillColorRect(int x, int y, int w, int h, Color c) {
        int i1 = x;
        while (i1 < x + w) {
            int i2 = y;
            while (i2 < y + h) {
                this.elements[i2][i1].getRectangle().setFillColor(c);
                ++i2;
            }
            ++i1;
        }
    }

    public void setCharsHorizontaly(int x, int y, String chars) {
        int width = chars.length();
        int i = 0;
        while (i < width) {
            if (i + x >= this.columns) break;
            this.getElementAt(i + x, y).setText("" + chars.charAt(i));
            ++i;
        }
    }

    public void setCharsVerticaly(int x, int y, String chars) {
        int width = chars.length();
        int i = 0;
        while (i < width) {
            if (i + y >= this.rows) break;
            this.getElementAt(x, y + i).setText("" + chars.charAt(i));
            ++i;
        }
    }

    @Override
    public void register() {
        int i2;
        super.register();
        int i1 = this.rows - 1;
        while (i1 >= 0) {
            i2 = 0;
            while (i2 < this.columns) {
                this.elements[i1][i2].register();
                ++i2;
            }
            --i1;
        }
        this.out.print("group \"");
        this.out.print(this.name);
        i1 = this.rows - 1;
        while (i1 >= 0) {
            i2 = 0;
            while (i2 < this.columns) {
                String s = this.elements[i1][i2].name;
                this.out.print("\" \"");
                this.out.print(s);
                this.out.print("\" \"");
                ++i2;
            }
            --i1;
        }
        this.out.println();
    }
}

