/*
 * Decompiled with CFR 0.152.
 */
package avinteraction;

import avinteraction.InteractionModule;
import avinteraction.QuestionInterface;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class Question
extends JPanel
implements QuestionInterface {
    private static final long serialVersionUID = -1316691187134298731L;
    public static int questionCounter = 0;
    protected InteractionModule handler;
    protected JButton submitButton;
    protected JEditorPane feedbackView;
    protected JPanel mainPanel;
    protected JScrollPane feedbackScroller;
    protected JTextArea questionOutput;
    protected String feedbackText;
    protected String groupID;
    protected String objectID;
    protected String questionText;
    protected boolean correct = false;
    protected boolean guiBuilt = false;
    protected int achievedPoints;
    protected int points;
    protected int questionNumber = questionCounter++;

    Question() {
        this.feedbackView = new JEditorPane("text/html", "");
        this.feedbackView.setEditable(false);
        this.feedbackScroller = new JScrollPane(this.feedbackView, 20, 30);
        this.feedbackScroller.setPreferredSize(new Dimension(200, 100));
        this.feedbackText = "";
    }

    @Override
    public abstract String getComment();

    @Override
    public abstract void makeGUI();

    @Override
    public abstract void rebuildQuestion();

    @Override
    public int getAchievedPoints() {
        return this.achievedPoints;
    }

    public boolean isCorrect() {
        return this.correct;
    }

    @Override
    public void setFeedback(String feedback) {
        this.feedbackText = feedback;
        this.feedbackView.setText(InteractionModule.translateMessage("feedbackTemplate", new String[]{feedback}));
    }

    public void setFeedbackBlack() {
        this.feedbackView.setForeground(Color.BLACK);
    }

    public void setFeedbackRed() {
        this.feedbackView.setForeground(Color.RED);
    }

    public String getGroupID() {
        return this.groupID;
    }

    public boolean getGuiBuilt() {
        return this.guiBuilt;
    }

    @Override
    public void setPoints(int pts) {
        this.points = pts;
    }

    @Override
    public int getPoints() {
        return this.points;
    }

    @Override
    public void setQuestion(String question) {
        this.questionText = question;
    }

    @Override
    public void enableSubmit() {
        this.submitButton.setEnabled(true);
    }

    @Override
    public boolean wasSubmitted() {
        return !this.submitButton.isEnabled();
    }

    protected void setHandler(InteractionModule module) {
        this.handler = module;
    }
}

