/*
 * Decompiled with CFR 0.152.
 */
package avinteraction;

import avinteraction.InteractionModule;
import avinteraction.MCAnswerObject;
import avinteraction.MCQuestionInterface;
import avinteraction.Question;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class MCQuestion
extends Question
implements MCQuestionInterface,
ActionListener {
    private static final long serialVersionUID = 1254727069355954104L;
    private ButtonGroup answerBoxes;
    private String theComment;
    private Vector<JToggleButton> answers;
    private Vector<Integer> correctAnswer;
    private Vector<Integer> permutation;
    private Vector<MCAnswerObject> possibleAnswers;
    private boolean checkBoxes;

    public MCQuestion(String id, String group) {
        this.objectID = id;
        this.groupID = group;
        this.possibleAnswers = new Vector();
        this.questionText = "";
        this.correctAnswer = new Vector();
        this.permutation = new Vector();
        this.checkBoxes = false;
    }

    @Override
    public String getComment() {
        return this.theComment;
    }

    @Override
    public void setQuestion(String question) {
        this.questionText = question;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int correctCount = 0;
        StringBuilder commentBuffer = new StringBuilder(256);
        int tmpPoints = 0;
        int selectedCount = 0;
        int nrSelected = 0;
        this.correct = true;
        if (this.answerBoxes != null) {
            int i = 0;
            while (i < this.possibleAnswers.size()) {
                if (this.answers.elementAt(i).isSelected()) {
                    ++nrSelected;
                }
                ++i;
            }
            i = 0;
            while (i < this.possibleAnswers.size()) {
                if (this.answers.elementAt(i).isSelected()) {
                    MCAnswerObject answer = this.possibleAnswers.get(this.permutation.get(i));
                    if (nrSelected > 1) {
                        commentBuffer.append("[").append(answer.answer).append("] - ");
                    }
                    if (this.correctAnswer.contains(new Integer(this.permutation.get(i) + 1))) {
                        ++correctCount;
                        tmpPoints += answer.pointparts;
                        commentBuffer.append(answer.comment).append("<br>\n");
                        ++selectedCount;
                    } else {
                        this.correct = false;
                        ++selectedCount;
                        tmpPoints += answer.pointparts;
                        commentBuffer.append(answer.comment).append("<br>\n");
                    }
                } else if (this.correctAnswer.contains(new Integer(this.permutation.get(i) + 1))) {
                    this.correct = false;
                }
                ++i;
            }
        }
        if (correctCount != this.correctAnswer.size()) {
            this.correct = false;
        }
        if (!this.correct) {
            String msgKey = null;
            msgKey = selectedCount < this.correctAnswer.size() ? "mcFBNotAll" : (selectedCount == this.correctAnswer.size() ? "mcFBNotAllSomeWrong" : "mcFBSomeWrong");
            commentBuffer.append(InteractionModule.translateMessage(msgKey, new String[]{String.valueOf(correctCount), String.valueOf(this.correctAnswer.size())}));
        }
        this.achievedPoints = this.correct && this.points > 0 && this.points > tmpPoints ? this.points : tmpPoints;
        this.theComment = commentBuffer.toString();
        this.submitButton.setEnabled(false);
        this.handler.processQuestion(this.objectID, this);
    }

    @Override
    public void addCorrectAnswer(int answer) {
        this.correctAnswer.add(new Integer(answer));
    }

    @Override
    public void addPossibleAnswer(String answer, int subpoints, String comment) {
        MCAnswerObject anAnswer = new MCAnswerObject(answer, subpoints, comment);
        this.permutation.add(new Integer(this.possibleAnswers.size()));
        this.possibleAnswers.add(anAnswer);
    }

    @Override
    public void makeGUI() {
        this.answerBoxes = new ButtonGroup();
        this.answers = new Vector(this.permutation.size());
        this.setLayout(new BorderLayout());
        ImageIcon mcIcon = new ImageIcon("MCGraphic.gif");
        JLabel headlineLabel = new JLabel(mcIcon, 0);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JPanel questionPanel = new JPanel();
        questionPanel.setLayout(new BoxLayout(questionPanel, 1));
        this.questionOutput = new JTextArea(this.questionText);
        this.questionOutput.setEditable(false);
        this.questionOutput.setWrapStyleWord(true);
        this.questionOutput.setLineWrap(true);
        JScrollPane questionScroller = new JScrollPane(this.questionOutput, 20, 31);
        this.mainPanel.add(questionScroller);
        int i = 0;
        while (i < this.possibleAnswers.size()) {
            JToggleButton choice = this.checkBoxes ? new JCheckBox("#" + new Integer(i + 1).toString(), false) : new JRadioButton("#" + new Integer(i + 1).toString(), false);
            this.answers.addElement(choice);
            if (!this.checkBoxes) {
                this.answerBoxes.add(choice);
            }
            JTextArea answerArea = new JTextArea(this.possibleAnswers.elementAt((int)this.permutation.elementAt((int)i).intValue()).answer.trim());
            answerArea.setWrapStyleWord(true);
            answerArea.setLineWrap(true);
            answerArea.setEditable(false);
            JScrollPane answerScroller = new JScrollPane(answerArea, 20, 31);
            JPanel answerPanel = new JPanel(new BorderLayout());
            answerPanel.add("West", choice);
            answerPanel.add("Center", answerScroller);
            questionPanel.add(answerPanel);
            ++i;
        }
        this.mainPanel.add(questionPanel);
        JPanel buttonPanel = new JPanel();
        this.submitButton = new JButton(InteractionModule.translateMessage("submit"));
        this.submitButton.addActionListener(this);
        buttonPanel.add(this.submitButton);
        this.setFeedback(InteractionModule.translateMessage("noAnswerYet"));
        this.setFeedbackRed();
        JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
        bottomPanel.add(buttonPanel);
        this.mainPanel.add(buttonPanel);
        this.mainPanel.add(this.feedbackScroller);
        this.add("North", headlineLabel);
        this.add("Center", this.mainPanel);
        this.guiBuilt = true;
    }

    @Override
    public void randomize() {
        Random randomizer = new Random();
        int i = this.permutation.size() - 1;
        while (i > 0) {
            int j = randomizer.nextInt(i);
            Integer swap = this.permutation.elementAt(j);
            this.permutation.setElementAt(this.permutation.elementAt(i), j);
            this.permutation.setElementAt(swap, i);
            --i;
        }
    }

    @Override
    public void rebuildQuestion() {
        int i = 0;
        while (i < this.answers.size()) {
            this.answers.elementAt(i).setSelected(false);
            ++i;
        }
        this.setFeedback("");
        this.submitButton.setEnabled(true);
    }

    @Override
    public void useCheckBoxes(boolean flag) {
        this.checkBoxes = flag;
    }
}

