/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.graphics.PTText;
import animal.main.Animal;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class InternationalTextSupport
extends BasicParser
implements AnimalScriptInterface {
    private String[] registeredLanguages = null;

    public InternationalTextSupport() {
        this.handledKeywords = new Hashtable();
        this.handledKeywords.put("itext", "parseTextInput");
        this.handledKeywords.put("supports", "parseLanguageSupport");
    }

    @Override
    public boolean generateNewStep(String command) {
        return !command.equalsIgnoreCase("iText") && !sameStep;
    }

    public void parseLanguageSupport() throws IOException {
        ParseSupport.parseWord(stok, "Arc type");
        this.registeredLanguages = ParseSupport.parseOIDs(stok, null, false);
        this.chooseLanguage();
    }

    public void parseTextInput() throws IOException {
        boolean isCentered = false;
        PTText pt = new PTText();
        StringBuilder oids = new StringBuilder();
        ParseSupport.parseMandatoryWord(stok, "Text type", "itext");
        String s = AnimalParseSupport.parseText(stok, "Text object name");
        pt.setObjectName(s);
        pt.setText(AnimalParseSupport.parseText(stok, "Text component", "text", false, chosenLanguage));
        ParseSupport.parseOptionalWord(stok, "Text command 'at'(deprecated)", "at");
        Point basePoint = AnimalParseSupport.parseNodeInfo(stok, "text baseline", null);
        pt.setLocation(basePoint);
        isCentered = ParseSupport.parseOptionalWord(stok, "'centered' tag for Text", "centered");
        pt.setColor(AnimalParseSupport.parseAndSetColor(stok, "text", "color"));
        AnimalParseSupport.parseAndSetDepth(stok, pt, "text");
        Font f = AnimalParseSupport.parseFontInfo(stok, "text");
        pt.setFont(f);
        if (isCentered) {
            FontMetrics fm = Animal.getConcreteFontMetrics(f);
            int translationWidth = fm.stringWidth(pt.getText());
            pt.translate(-(translationWidth >>> 1), 0);
        }
        BasicParser.addGraphicObject(pt, anim);
        oids.append(pt.getNum(false));
        InternationalTextSupport.getObjectIDs().put(s, pt.getNum(false));
        InternationalTextSupport.getObjectTypes().put(s, InternationalTextSupport.getTypeIdentifier("text"));
        AnimalParseSupport.showComponents(stok, oids.toString(), "text", true);
    }

    public void chooseLanguage() {
        chosenLanguage = (String)JOptionPane.showInputDialog(null, "Choose a language", "Language Choice", 3, null, this.registeredLanguages, this.registeredLanguages[0]);
        if (chosenLanguage == null) {
            chosenLanguage = this.registeredLanguages[0];
        }
        System.err.println("chosen: " + chosenLanguage);
    }
}

