/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.ColorChanger;
import animal.animator.Move;
import animal.animator.SetFont;
import animal.animator.SetText;
import animal.animator.TimedShow;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTOpenCircleSegment;
import animal.graphics.PTPoint;
import animal.graphics.PTPolygon;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.misc.MessageDisplay;
import animalscript.core.BasicParser;
import animalscript.extensions.GridMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GridProducer
extends BasicParser {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_MATRIX = 1;
    public static final int STYLE_TABLE = 2;
    public static final int ALIGN_LEFT = 110;
    public static final int ALIGN_CENTER = 111;
    public static final int ALIGN_RIGHT = 112;
    public static final int DEFAULT_INT = -1;
    public static final Color DEFAULT_COLOR = null;
    public static final Font DEFAULT_FONT = null;
    public static final String DEFAULT_UNIT = null;

    private static final String gridLocationKey(String gridName) {
        return String.valueOf(gridName) + ".location";
    }

    private static final String gridStyleKey(String gridName) {
        return String.valueOf(gridName) + ".style";
    }

    private static final String gridSizeKey(String gridName) {
        return String.valueOf(gridName) + ".size";
    }

    private static final String gridDepthKey(String gridName) {
        return String.valueOf(gridName) + ".depth";
    }

    private static final String gridCellWidthKey(String gridName) {
        return String.valueOf(gridName) + ".cellWidth";
    }

    private static final String gridMaxCellWidthKey(String gridName) {
        return String.valueOf(gridName) + ".maxCellWidth";
    }

    private static final String gridCellHeightKey(String gridName) {
        return String.valueOf(gridName) + ".cellHeight";
    }

    private static final String gridMaxCellHeightKey(String gridName) {
        return String.valueOf(gridName) + ".maxCellHeight";
    }

    private static final String gridTextKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text";
    }

    private static final String gridTextStringKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.string";
    }

    private static final String gridTextFontKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.font";
    }

    private static final String gridTextPositionKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.position";
    }

    private static final String gridBackKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].background";
    }

    private static final String gridBackPositionKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].background.position";
    }

    private static final String gridBackSizeKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].background.size";
    }

    private static final String gridBracketKey(String gridName, int part) {
        return String.valueOf(gridName) + ".bracket[" + part + "]";
    }

    private static final String gridBracketPositionKey(String gridName, int part) {
        return String.valueOf(gridName) + ".bracket[" + part + "].position";
    }

    private static final String gridTextAlignmentKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.alignment";
    }

    private static final String gridTextColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].textColor";
    }

    private static final String gridHighlightTextColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].hlTextColor";
    }

    private static final String gridFillColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].fillColor";
    }

    private static final String gridHighlightFillColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].hlFillColor";
    }

    private static final String gridBorderColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].borderColor";
    }

    private static final String gridHighlightBorderColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].hlBorderColor";
    }

    private static void collectObjectMovements(int objectID, int dx, int dy, Hashtable<String, Vector<Integer>> objects) {
        if (dx == 0 && dy == 0) {
            return;
        }
        Vector<Integer> objectsToMove = new Vector<Integer>();
        if (objects.containsKey(String.valueOf(dx) + "," + dy)) {
            objectsToMove = objects.get(String.valueOf(dx) + "," + dy);
        }
        objectsToMove.add(new Integer(objectID));
        objects.put(String.valueOf(dx) + "," + dy, objectsToMove);
    }

    public static void makeGrid(String gridName, Point basePoint, int lines, int cols, int cellWidth, int maxCellWidth, int cellHeight, int maxCellHeight, boolean fixedCellSize, Color genericColor, Color textColor, Color fillColor, Color borderColor, Color hTextColor, Color hFillColor, Color hBorderColor, int style, Font font, int alignment, int depth, int delay, int duration, String unit) {
        if (style == -1) {
            style = 0;
        }
        if (depth == -1) {
            depth = 5;
        }
        if (delay == -1) {
            delay = 0;
        }
        if (duration == -1) {
            duration = 0;
        }
        if (unit == DEFAULT_UNIT) {
            unit = "ms";
        }
        if (fixedCellSize) {
            maxCellWidth = cellWidth;
            maxCellHeight = cellHeight;
        }
        switch (style) {
            case 0: {
                if (cellWidth == -1) {
                    cellWidth = 20;
                }
                if (maxCellWidth == -1) {
                    maxCellWidth = 0;
                }
                if (cellHeight == -1) {
                    cellHeight = 10;
                }
                if (maxCellHeight == -1) {
                    maxCellHeight = 0;
                }
                if (genericColor == DEFAULT_COLOR) {
                    genericColor = new Color(0.0f, 0.0f, 0.0f);
                }
                if (textColor == DEFAULT_COLOR) {
                    textColor = genericColor;
                }
                if (fillColor == DEFAULT_COLOR) {
                    fillColor = new Color(1.0f, 1.0f, 1.0f);
                }
                if (borderColor == DEFAULT_COLOR) {
                    borderColor = fillColor;
                }
                if (hTextColor == DEFAULT_COLOR) {
                    hTextColor = new Color(0.0f, 0.0f, 0.0f);
                }
                if (hFillColor == DEFAULT_COLOR) {
                    hFillColor = new Color(1.0f, 1.0f, 0.5f);
                }
                if (hBorderColor == DEFAULT_COLOR) {
                    hBorderColor = hFillColor;
                }
                if (alignment != -1) break;
                alignment = 110;
                break;
            }
            case 2: {
                if (cellWidth == -1) {
                    cellWidth = 20;
                }
                if (maxCellWidth == -1) {
                    maxCellWidth = 0;
                }
                if (cellHeight == -1) {
                    cellHeight = 10;
                }
                if (maxCellHeight == -1) {
                    maxCellHeight = 0;
                }
                if (genericColor == DEFAULT_COLOR) {
                    genericColor = new Color(0.0f, 0.0f, 0.0f);
                }
                if (textColor == DEFAULT_COLOR) {
                    textColor = genericColor;
                }
                if (fillColor == DEFAULT_COLOR) {
                    fillColor = new Color(0.8f, 0.8f, 0.8f);
                }
                if (borderColor == DEFAULT_COLOR) {
                    borderColor = new Color(0.5f, 0.5f, 0.5f);
                }
                if (hTextColor == DEFAULT_COLOR) {
                    hTextColor = new Color(0.0f, 0.0f, 0.0f);
                }
                if (hFillColor == DEFAULT_COLOR) {
                    hFillColor = new Color(1.0f, 1.0f, 0.8f);
                }
                if (hBorderColor == DEFAULT_COLOR) {
                    hBorderColor = new Color(1.0f, 1.0f, 0.5f);
                }
                if (alignment != -1) break;
                alignment = 110;
                break;
            }
            case 1: {
                if (cellWidth == -1) {
                    cellWidth = 15;
                }
                if (maxCellWidth == -1) {
                    maxCellWidth = 0;
                }
                if (cellHeight == -1) {
                    cellHeight = 15;
                }
                if (maxCellHeight == -1) {
                    maxCellHeight = 0;
                }
                if (genericColor == DEFAULT_COLOR) {
                    genericColor = new Color(0.0f, 0.0f, 1.0f);
                }
                if (textColor == DEFAULT_COLOR) {
                    textColor = genericColor;
                }
                if (fillColor == DEFAULT_COLOR) {
                    fillColor = new Color(1.0f, 1.0f, 1.0f);
                }
                if (borderColor == DEFAULT_COLOR) {
                    borderColor = new Color(1.0f, 1.0f, 1.0f);
                }
                if (hTextColor == DEFAULT_COLOR) {
                    hTextColor = new Color(0.0f, 0.0f, 0.5f);
                }
                if (hFillColor == DEFAULT_COLOR) {
                    hFillColor = new Color(0.75f, 0.75f, 1.0f);
                }
                if (hBorderColor == DEFAULT_COLOR) {
                    hBorderColor = new Color(0.5f, 0.5f, 0.75f);
                }
                if (alignment != -1) break;
                alignment = 111;
            }
        }
        int[] widths = new int[cols];
        int[] heights = new int[lines];
        GridMath.calculateColumnWidths(widths, cellWidth, font);
        GridMath.calculateLineHeights(heights, cellHeight, font);
        int OIDAlength = 0;
        OIDAlength += lines * cols;
        PTText[][] values = new PTText[lines][cols];
        int[][] alignments = new int[lines][cols];
        int line = 0;
        while (line < lines) {
            int col = 0;
            while (col < cols) {
                alignments[line][col] = alignment;
                values[line][col] = new PTText();
                values[line][col].setFont(font);
                values[line][col].setDepth(depth);
                values[line][col].setColor(textColor);
                values[line][col].setText("");
                values[line][col].setObjectName(GridProducer.gridTextKey(gridName, line, col));
                ++col;
            }
            ++line;
        }
        GridMath.calculateTextPositions(values, alignments, widths, heights, basePoint, style);
        PTGraphicObject[] brackets = new PTGraphicObject[6];
        if (style == 1) {
            OIDAlength += 6;
            GridMath.calculateBracketPositions(brackets, widths, heights, basePoint, style);
            int part = 0;
            while (part < 6) {
                brackets[part].setColor(textColor);
                brackets[part].setDepth(depth);
                brackets[part].setObjectName(GridProducer.gridBracketKey(gridName, part));
                ++part;
            }
        }
        int[][][] bPos = new int[lines][cols][4];
        PTPolygon[][] backgroundRects = new PTPolygon[lines][cols];
        OIDAlength += lines * cols;
        GridMath.calculateBackgroundPositions(bPos, widths, heights, basePoint, style);
        int col = 0;
        while (col < cols) {
            int line2 = 0;
            while (line2 < lines) {
                int nodeNr = 0;
                PTPolygon currentPL = new PTPolygon();
                currentPL.setFilled(true);
                currentPL.setFillColor(fillColor);
                currentPL.setColor(borderColor);
                currentPL.setDepth(depth + 1);
                currentPL.setObjectName(GridProducer.gridBackKey(gridName, line2, col));
                PTPoint a = new PTPoint(bPos[line2][col][0], bPos[line2][col][1]);
                PTPoint b = new PTPoint(bPos[line2][col][0], bPos[line2][col][1] + bPos[line2][col][3]);
                PTPoint c = new PTPoint(bPos[line2][col][0] + bPos[line2][col][2], bPos[line2][col][1] + bPos[line2][col][3]);
                PTPoint d = new PTPoint(bPos[line2][col][0] + bPos[line2][col][2], bPos[line2][col][1]);
                currentPL.setNode(nodeNr++, a);
                currentPL.setNode(nodeNr++, b);
                currentPL.setNode(nodeNr++, c);
                currentPL.setNode(nodeNr++, d);
                backgroundRects[line2][col] = currentPL;
                ++line2;
            }
            ++col;
        }
        int[] gridOIDs = new int[OIDAlength];
        int currentOID = 0;
        int line3 = 0;
        while (line3 < lines) {
            int col2 = 0;
            while (col2 < cols) {
                BasicParser.addGraphicObject(values[line3][col2], anim);
                GridProducer.getObjectTypes().put(GridProducer.gridTextKey(gridName, line3, col2), GridProducer.getTypeIdentifier("text"));
                GridProducer.getObjectIDs().put(GridProducer.gridTextKey(gridName, line3, col2), values[line3][col2].getNum(true));
                GridProducer.getObjectProperties().put(GridProducer.gridTextAlignmentKey(gridName, line3, col2), alignment);
                GridProducer.getObjectProperties().put(GridProducer.gridTextStringKey(gridName, line3, col2), values[line3][col2].getText());
                GridProducer.getObjectProperties().put(GridProducer.gridTextFontKey(gridName, line3, col2), font);
                GridProducer.getObjectProperties().put(GridProducer.gridTextPositionKey(gridName, line3, col2), values[line3][col2].getLocation());
                GridProducer.getObjectProperties().put(GridProducer.gridHighlightTextColorKey(gridName, line3, col2), hTextColor);
                GridProducer.getObjectProperties().put(GridProducer.gridTextColorKey(gridName, line3, col2), textColor);
                gridOIDs[currentOID++] = values[line3][col2].getNum(true);
                BasicParser.addGraphicObject(backgroundRects[line3][col2], anim);
                GridProducer.getObjectTypes().put(GridProducer.gridBackKey(gridName, line3, col2), GridProducer.getTypeIdentifier("Polyline"));
                GridProducer.getObjectIDs().put(GridProducer.gridBackKey(gridName, line3, col2), backgroundRects[line3][col2].getNum(true));
                GridProducer.getObjectProperties().put(GridProducer.gridBackPositionKey(gridName, line3, col2), backgroundRects[line3][col2].getLocation());
                int[] boxSize = new int[]{backgroundRects[line3][col2].getNodeAsPoint((int)2).x - backgroundRects[line3][col2].getLocation().x, backgroundRects[line3][col2].getNodeAsPoint((int)2).x - backgroundRects[line3][col2].getLocation().y};
                GridProducer.getObjectProperties().put(GridProducer.gridBackSizeKey(gridName, line3, col2), boxSize);
                GridProducer.getObjectProperties().put(GridProducer.gridBorderColorKey(gridName, line3, col2), borderColor);
                GridProducer.getObjectProperties().put(GridProducer.gridFillColorKey(gridName, line3, col2), fillColor);
                GridProducer.getObjectProperties().put(GridProducer.gridHighlightBorderColorKey(gridName, line3, col2), hBorderColor);
                GridProducer.getObjectProperties().put(GridProducer.gridHighlightFillColorKey(gridName, line3, col2), hFillColor);
                gridOIDs[currentOID++] = backgroundRects[line3][col2].getNum(true);
                ++col2;
            }
            ++line3;
        }
        if (style == 1) {
            BasicParser.addGraphicObject(brackets[0], anim);
            GridProducer.getObjectTypes().put(GridProducer.gridBracketKey(gridName, 0), GridProducer.getTypeIdentifier("Arc"));
            GridProducer.getObjectIDs().put(GridProducer.gridBracketKey(gridName, 0), brackets[0].getNum(true));
            GridProducer.getObjectProperties().put(GridProducer.gridBracketPositionKey(gridName, 0), ((PTOpenCircleSegment)brackets[0]).getCenter());
            gridOIDs[currentOID++] = brackets[0].getNum(true);
            BasicParser.addGraphicObject(brackets[1], anim);
            GridProducer.getObjectTypes().put(GridProducer.gridBracketKey(gridName, 1), GridProducer.getTypeIdentifier("Polyline"));
            GridProducer.getObjectIDs().put(GridProducer.gridBracketKey(gridName, 1), brackets[1].getNum(true));
            GridProducer.getObjectProperties().put(GridProducer.gridBracketPositionKey(gridName, 1), brackets[1].getLocation());
            gridOIDs[currentOID++] = brackets[1].getNum(true);
            BasicParser.addGraphicObject(brackets[2], anim);
            GridProducer.getObjectTypes().put(GridProducer.gridBracketKey(gridName, 2), GridProducer.getTypeIdentifier("Arc"));
            GridProducer.getObjectIDs().put(GridProducer.gridBracketKey(gridName, 2), brackets[2].getNum(true));
            GridProducer.getObjectProperties().put(GridProducer.gridBracketPositionKey(gridName, 2), ((PTOpenCircleSegment)brackets[2]).getCenter());
            gridOIDs[currentOID++] = brackets[2].getNum(true);
            BasicParser.addGraphicObject(brackets[3], anim);
            GridProducer.getObjectTypes().put(GridProducer.gridBracketKey(gridName, 3), GridProducer.getTypeIdentifier("Arc"));
            GridProducer.getObjectIDs().put(GridProducer.gridBracketKey(gridName, 3), brackets[3].getNum(true));
            GridProducer.getObjectProperties().put(GridProducer.gridBracketPositionKey(gridName, 3), ((PTOpenCircleSegment)brackets[3]).getCenter());
            gridOIDs[currentOID++] = brackets[3].getNum(true);
            BasicParser.addGraphicObject(brackets[4], anim);
            GridProducer.getObjectTypes().put(GridProducer.gridBracketKey(gridName, 4), GridProducer.getTypeIdentifier("Polyline"));
            GridProducer.getObjectIDs().put(GridProducer.gridBracketKey(gridName, 4), brackets[4].getNum(true));
            GridProducer.getObjectProperties().put(GridProducer.gridBracketPositionKey(gridName, 4), brackets[4].getLocation());
            gridOIDs[currentOID++] = brackets[4].getNum(true);
            BasicParser.addGraphicObject(brackets[5], anim);
            GridProducer.getObjectTypes().put(GridProducer.gridBracketKey(gridName, 5), GridProducer.getTypeIdentifier("Arc"));
            GridProducer.getObjectIDs().put(GridProducer.gridBracketKey(gridName, 5), brackets[5].getNum(true));
            GridProducer.getObjectProperties().put(GridProducer.gridBracketPositionKey(gridName, 5), ((PTOpenCircleSegment)brackets[5]).getCenter());
            gridOIDs[currentOID++] = brackets[5].getNum(true);
        }
        GridProducer.getObjectProperties().put(GridProducer.gridLocationKey(gridName), basePoint);
        GridProducer.getObjectProperties().put(GridProducer.gridSizeKey(gridName), new int[]{lines, cols});
        GridProducer.getObjectProperties().put(GridProducer.gridDepthKey(gridName), depth);
        GridProducer.getObjectProperties().put(GridProducer.gridCellWidthKey(gridName), cellWidth);
        GridProducer.getObjectProperties().put(GridProducer.gridCellHeightKey(gridName), cellHeight);
        GridProducer.getObjectProperties().put(GridProducer.gridMaxCellWidthKey(gridName), maxCellWidth);
        GridProducer.getObjectProperties().put(GridProducer.gridMaxCellHeightKey(gridName), maxCellHeight);
        GridProducer.getObjectProperties().put(GridProducer.gridStyleKey(gridName), style);
        GridProducer.getObjectIDs().put(gridName, gridOIDs);
        TimedShow showFX = new TimedShow(currentStep, gridOIDs, duration, "show", delay >= 0);
        showFX.setOffset(delay);
        showFX.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
        BasicParser.addAnimatorToAnimation(showFX, anim);
    }

    public static void setGridValue(String gridName, int line, int column, String value, int step, int duration, int offset, String unit, boolean refresh) {
        int[] cellValuesToUpdate;
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        if (line == -1) {
            int l;
            if (column == -1) {
                cellValuesToUpdate = new int[size[0] * size[1]];
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        cellValuesToUpdate[l * size[1] + c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, c));
                        GridProducer.getObjectProperties().put(GridProducer.gridTextStringKey(gridName, l, c), value);
                        ++c;
                    }
                    ++l;
                }
            } else {
                cellValuesToUpdate = new int[size[0]];
                l = 0;
                while (l < size[0]) {
                    cellValuesToUpdate[l] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, column));
                    GridProducer.getObjectProperties().put(GridProducer.gridTextStringKey(gridName, l, column), value);
                    ++l;
                }
            }
        } else if (column == -1) {
            cellValuesToUpdate = new int[size[1]];
            int c = 0;
            while (c < size[1]) {
                cellValuesToUpdate[c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, c));
                GridProducer.getObjectProperties().put(GridProducer.gridTextStringKey(gridName, line, c), value);
                ++c;
            }
        } else {
            cellValuesToUpdate = new int[]{GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, column))};
            GridProducer.getObjectProperties().put(GridProducer.gridTextStringKey(gridName, line, column), value);
        }
        SetText setValueAnimator = new SetText(step, cellValuesToUpdate, duration, offset, unit, value);
        BasicParser.addAnimatorToAnimation(setValueAnimator, anim);
        if (refresh) {
            GridProducer.refreshGrid(gridName, step, duration, offset, unit);
        }
    }

    public static void setGridColor(String gridName, int line, int column, Color genericColor, Color textColor, Color fillColor, Color borderColor, Color highlightTextColor, Color highlightFillColor, Color highlightBorderColor, int step, int duration, int offset, String unit) {
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        if (textColor == null) {
            textColor = genericColor;
        }
        if (line == -1) {
            if (column == -1) {
                int c;
                int[] textNumsToColor = new int[size[0] * size[1]];
                int[] cellNumsToColor = new int[size[0] * size[1]];
                int l = 0;
                while (l < size[0]) {
                    c = 0;
                    while (c < size[1]) {
                        textNumsToColor[l * size[1] + c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, c));
                        cellNumsToColor[l * size[1] + c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, c));
                        ++c;
                    }
                    ++l;
                }
                if (textColor != null) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            GridProducer.getObjectProperties().put(GridProducer.gridTextColorKey(gridName, l, c), textColor);
                            ++c;
                        }
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (fillColor != null) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            GridProducer.getObjectProperties().put(GridProducer.gridFillColorKey(gridName, l, c), fillColor);
                            ++c;
                        }
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (borderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            GridProducer.getObjectProperties().put(GridProducer.gridBorderColorKey(gridName, l, c), borderColor);
                            ++c;
                        }
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (highlightTextColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            GridProducer.getObjectProperties().put(GridProducer.gridHighlightTextColorKey(gridName, l, c), highlightTextColor);
                            ++c;
                        }
                        ++l;
                    }
                }
                if (highlightFillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            GridProducer.getObjectProperties().put(GridProducer.gridHighlightFillColorKey(gridName, l, c), highlightFillColor);
                            ++c;
                        }
                        ++l;
                    }
                }
                if (highlightBorderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            GridProducer.getObjectProperties().put(GridProducer.gridHighlightBorderColorKey(gridName, l, c), highlightBorderColor);
                            ++c;
                        }
                        ++l;
                    }
                }
            } else {
                int[] textNumsToColor = new int[size[0]];
                int[] cellNumsToColor = new int[size[0]];
                int l = 0;
                while (l < size[0]) {
                    textNumsToColor[l] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, column));
                    cellNumsToColor[l] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, column));
                    ++l;
                }
                if (textColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridTextColorKey(gridName, l, column), textColor);
                        ++l;
                    }
                }
                if (fillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridFillColorKey(gridName, l, column), fillColor);
                        ++l;
                    }
                }
                if (textColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridTextColorKey(gridName, l, column), textColor);
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (fillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridFillColorKey(gridName, l, column), fillColor);
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (borderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridBorderColorKey(gridName, l, column), borderColor);
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (highlightTextColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridHighlightTextColorKey(gridName, l, column), highlightTextColor);
                        ++l;
                    }
                }
                if (highlightFillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridHighlightFillColorKey(gridName, l, column), highlightFillColor);
                        ++l;
                    }
                }
                if (highlightBorderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridHighlightBorderColorKey(gridName, l, column), highlightBorderColor);
                        ++l;
                    }
                }
            }
        } else if (column == -1) {
            int[] textNumsToColor = new int[size[1]];
            int[] cellNumsToColor = new int[size[1]];
            int c = 0;
            while (c < size[1]) {
                textNumsToColor[c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, c));
                cellNumsToColor[c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, c));
                ++c;
            }
            if (textColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridTextColorKey(gridName, line, c), textColor);
                    ++c;
                }
                ColorChanger setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (fillColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridFillColorKey(gridName, line, c), fillColor);
                    ++c;
                }
                ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (borderColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridBorderColorKey(gridName, line, c), borderColor);
                    ++c;
                }
                ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (highlightTextColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridHighlightTextColorKey(gridName, line, c), highlightTextColor);
                    ++c;
                }
            }
            if (highlightFillColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridHighlightFillColorKey(gridName, line, c), highlightFillColor);
                    ++c;
                }
            }
            if (highlightBorderColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridHighlightBorderColorKey(gridName, line, c), highlightBorderColor);
                    ++c;
                }
            }
        } else {
            ColorChanger setColorAnimator;
            int[] textNumsToColor = new int[]{GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, column))};
            int[] cellNumsToColor = new int[]{GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, column))};
            if (textColor != DEFAULT_COLOR) {
                GridProducer.getObjectProperties().put(GridProducer.gridTextColorKey(gridName, line, column), textColor);
                setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (fillColor != DEFAULT_COLOR) {
                GridProducer.getObjectProperties().put(GridProducer.gridFillColorKey(gridName, line, column), fillColor);
                setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (borderColor != DEFAULT_COLOR) {
                GridProducer.getObjectProperties().put(GridProducer.gridBorderColorKey(gridName, line, column), borderColor);
                setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (highlightTextColor != DEFAULT_COLOR) {
                GridProducer.getObjectProperties().put(GridProducer.gridHighlightTextColorKey(gridName, line, column), highlightTextColor);
            }
            if (highlightFillColor != DEFAULT_COLOR) {
                GridProducer.getObjectProperties().put(GridProducer.gridHighlightFillColorKey(gridName, line, column), highlightFillColor);
            }
            if (highlightBorderColor != DEFAULT_COLOR) {
                GridProducer.getObjectProperties().put(GridProducer.gridHighlightBorderColorKey(gridName, line, column), highlightBorderColor);
            }
        }
    }

    public static void swapGridValues(String gridName1, int line1, int col1, String gridName2, int line2, int col2, int step, int duration, int offset, String unit, boolean refresh) {
        int[] objects2;
        int[] objects1;
        int[] size1 = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName1));
        int[] size2 = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName2));
        if (line1 >= size1[0] || col1 >= size1[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName1 + "[" + line1 + "][" + col1 + "] is out of bounds. Valid cells are [0.." + size1[0] + "][0.." + size1[1], 4);
            return;
        }
        if (line2 >= size2[0] || col2 >= size2[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName2 + "[" + line2 + "][" + col2 + "] is out of bounds. Valid cells are [0.." + size2[0] + "][0.." + size2[1], 4);
            return;
        }
        if (line1 * line2 < 0 || col1 * col2 < 0) {
            MessageDisplay.errorMsg("Invalid coordinates for swapgridvalues. Maybe you try to swap a value and a column.", 4);
            return;
        }
        if (line1 == -1) {
            int l;
            if (col1 == -1) {
                if (size1[0] != size2[0] || size1[1] != size2[1]) {
                    MessageDisplay.errorMsg("Cannot swap all values of '" + gridName1 + "' and '" + gridName2 + "' because of different gridsizes", 4);
                    return;
                }
                objects1 = new int[size1[0] * size1[1]];
                objects2 = new int[size1[0] * size1[1]];
                l = 0;
                while (l < size1[0]) {
                    int c = 0;
                    while (c < size1[1]) {
                        String value1 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName1, l, c));
                        String value2 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName2, l, c));
                        GridProducer.setGridValue(gridName1, l, c, value2, step, 0, duration + offset, unit, false);
                        GridProducer.setGridValue(gridName2, l, c, value1, step, 0, duration + offset, unit, false);
                        objects1[l + c * size1[0]] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName1, l, c));
                        objects2[l + c * size1[0]] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName2, l, c));
                        ++c;
                    }
                    ++l;
                }
            } else {
                if (size1[0] != size2[0]) {
                    MessageDisplay.errorMsg("Cannot swap column '" + col1 + "' of '" + gridName1 + "' and column '" + col1 + "' of '" + gridName2 + "' because of different sizes", 4);
                    return;
                }
                objects1 = new int[size1[0]];
                objects2 = new int[size1[0]];
                l = 0;
                while (l < size1[0]) {
                    String value1 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName1, l, col1));
                    String value2 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName2, l, col2));
                    GridProducer.setGridValue(gridName1, l, col1, value2, step, 0, duration + offset, unit, false);
                    GridProducer.setGridValue(gridName2, l, col2, value1, step, 0, duration + offset, unit, false);
                    objects1[l] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName1, l, col1));
                    objects2[l] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName2, l, col2));
                    ++l;
                }
            }
        } else if (col1 == -1) {
            if (size1[1] != size2[1]) {
                MessageDisplay.errorMsg("Cannot swap line '" + line1 + "' of '" + gridName1 + "' and line '" + line1 + "' of '" + gridName2 + "' because of different sizes", 4);
                return;
            }
            objects1 = new int[size1[1]];
            objects2 = new int[size1[1]];
            int c = 0;
            while (c < size1[1]) {
                String value1 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName1, line1, c));
                String value2 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName2, line2, c));
                GridProducer.setGridValue(gridName1, line1, c, value2, step, 0, duration + offset, unit, false);
                GridProducer.setGridValue(gridName2, line2, c, value1, step, 0, duration + offset, unit, false);
                objects1[c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName1, line1, c));
                objects2[c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName2, line2, c));
                ++c;
            }
        } else {
            String value1 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName1, line1, col1));
            String value2 = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName2, line2, col2));
            GridProducer.setGridValue(gridName1, line1, col1, value2, step, 0, duration + offset, unit, false);
            GridProducer.setGridValue(gridName2, line2, col2, value1, step, 0, duration + offset, unit, false);
            objects1 = new int[]{GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName1, line1, col1))};
            objects2 = new int[]{GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName2, line2, col2))};
        }
        if (line1 < 0) {
            line1 = 0;
        }
        if (line2 < 0) {
            line2 = 0;
        }
        if (col1 < 0) {
            col1 = 0;
        }
        if (col2 < 0) {
            col2 = 0;
        }
        if (duration > 0) {
            PTPoint location1 = new PTPoint(GridProducer.getObjectProperties().getPointProperty(GridProducer.gridTextPositionKey(gridName1, line1, col1)));
            PTPoint location2 = new PTPoint(GridProducer.getObjectProperties().getPointProperty(GridProducer.gridTextPositionKey(gridName2, line2, col2)));
            PTPolyline moveBase1to2 = new PTPolyline();
            moveBase1to2.addNode(location1);
            moveBase1to2.addNode(location2);
            moveBase1to2.setColor(new Color(1.0f, 1.0f, 0.0f));
            moveBase1to2.setDepth(0);
            int mb12Num = moveBase1to2.getNum(true);
            GridProducer.getObjectIDs().put("mb12_step" + step, mb12Num);
            GridProducer.getObjectTypes().put("mb12_step" + step, "polyline");
            BasicParser.addGraphicObject(moveBase1to2, anim);
            PTPolyline moveBase2to1 = new PTPolyline();
            moveBase2to1.addNode(location2);
            moveBase2to1.addNode(location1);
            moveBase2to1.setColor(new Color(1.0f, 1.0f, 0.0f));
            moveBase2to1.setDepth(0);
            int mb21Num = moveBase2to1.getNum(true);
            GridProducer.getObjectIDs().put("mb21_step" + step, mb21Num);
            GridProducer.getObjectTypes().put("mb21_step" + step, "polyline");
            BasicParser.addGraphicObject(moveBase2to1, anim);
            Move move1to2 = new Move(step, objects1, duration, "translate", mb12Num);
            move1to2.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            move1to2.setOffset(offset);
            Move move2to1 = new Move(step, objects2, duration, "translate", mb21Num);
            move2to1.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            move2to1.setOffset(offset);
            BasicParser.addAnimatorToAnimation(move1to2, anim);
            BasicParser.addAnimatorToAnimation(move2to1, anim);
            Move back2to1 = new Move(step, objects1, 0, "translate", mb21Num);
            back2to1.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            back2to1.setOffset(offset + duration);
            Move back1to2 = new Move(step, objects2, 0, "translate", mb12Num);
            back1to2.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            back1to2.setOffset(offset + duration);
            BasicParser.addAnimatorToAnimation(back1to2, anim);
            BasicParser.addAnimatorToAnimation(back2to1, anim);
        }
        if (refresh) {
            GridProducer.refreshGrid(gridName1, step, duration, offset, unit);
            GridProducer.refreshGrid(gridName2, step, duration, offset, unit);
        }
    }

    public static void highlightGridCell(String gridName, int line, int column, int step, int duration, int offset, String unit) {
        String currentBorderHLColor;
        String currentTextHLColor;
        String currentBackHLColor;
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        Hashtable backgroundsToHighlight = new Hashtable();
        Hashtable textObjectsToHighlight = new Hashtable();
        Hashtable bordersToHighlight = new Hashtable();
        if (line == -1) {
            int l;
            if (column == -1) {
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, l, c)).getRGB());
                        if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                            backgroundsToHighlight.put(currentBackHLColor, new Vector());
                        }
                        ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, c)));
                        currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, l, c)).getRGB());
                        if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                            textObjectsToHighlight.put(currentTextHLColor, new Vector());
                        }
                        ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, c)));
                        currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, l, c)).getRGB());
                        if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                            bordersToHighlight.put(currentBorderHLColor, new Vector());
                        }
                        ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, c)));
                        ++c;
                    }
                    ++l;
                }
            } else {
                l = 0;
                while (l < size[0]) {
                    currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, l, column)).getRGB());
                    if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                        backgroundsToHighlight.put(currentBackHLColor, new Vector());
                    }
                    ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, column)));
                    currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, l, column)).getRGB());
                    if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                        textObjectsToHighlight.put(currentTextHLColor, new Vector());
                    }
                    ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, column)));
                    currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, l, column)).getRGB());
                    if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                        bordersToHighlight.put(currentBorderHLColor, new Vector());
                    }
                    ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, column)));
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, line, c)).getRGB());
                if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                    backgroundsToHighlight.put(currentBackHLColor, new Vector());
                }
                ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, c)));
                currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, line, c)).getRGB());
                if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                    textObjectsToHighlight.put(currentTextHLColor, new Vector());
                }
                ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, c)));
                currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, line, c)).getRGB());
                if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                    bordersToHighlight.put(currentBorderHLColor, new Vector());
                }
                ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, c)));
                ++c;
            }
        } else {
            currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, line, column)).getRGB());
            if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                backgroundsToHighlight.put(currentBackHLColor, new Vector());
            }
            ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, column)));
            currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, line, column)).getRGB());
            if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                textObjectsToHighlight.put(currentTextHLColor, new Vector());
            }
            ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, column)));
            currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, line, column)).getRGB());
            if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                bordersToHighlight.put(currentBorderHLColor, new Vector());
            }
            ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, column)));
        }
        Enumeration collectedBackgroundHighlightColorKeys = backgroundsToHighlight.keys();
        while (collectedBackgroundHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBackgroundHighlightColorKeys.nextElement();
            Vector backgrounds = (Vector)backgroundsToHighlight.get(currentHLColor);
            int[] backgroundIDs = new int[backgrounds.size()];
            int i = 0;
            while (i < backgroundIDs.length) {
                backgroundIDs[i] = (Integer)backgrounds.get(i);
                ++i;
            }
            ColorChanger backgroundHL = new ColorChanger(step, backgroundIDs, duration, "fillcolor", new Color(Integer.parseInt(currentHLColor)));
            backgroundHL.setOffset(offset);
            backgroundHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(backgroundHL, anim);
        }
        Enumeration collectedTextObjectHighlightColorKeys = textObjectsToHighlight.keys();
        while (collectedTextObjectHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedTextObjectHighlightColorKeys.nextElement();
            Vector textObjects = (Vector)textObjectsToHighlight.get(currentHLColor);
            int[] textObjectIDs = new int[textObjects.size()];
            int i = 0;
            while (i < textObjectIDs.length) {
                textObjectIDs[i] = (Integer)textObjects.get(i);
                ++i;
            }
            ColorChanger textObjectHL = new ColorChanger(step, textObjectIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            textObjectHL.setOffset(offset);
            textObjectHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(textObjectHL, anim);
        }
        Enumeration collectedBorderHighlightColorKeys = bordersToHighlight.keys();
        while (collectedBorderHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBorderHighlightColorKeys.nextElement();
            Vector borders = (Vector)bordersToHighlight.get(currentHLColor);
            int[] borderIDs = new int[borders.size()];
            int i = 0;
            while (i < borderIDs.length) {
                borderIDs[i] = (Integer)borders.get(i);
                ++i;
            }
            ColorChanger borderHL = new ColorChanger(step, borderIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            borderHL.setOffset(offset);
            borderHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(borderHL, anim);
        }
    }

    public static void highlightGridElem(String gridName, int line, int column, int step, int duration, int offset, String unit) {
        String currentBorderHLColor;
        String currentTextHLColor;
        String currentBackHLColor;
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        Hashtable backgroundsToHighlight = new Hashtable();
        Hashtable textObjectsToHighlight = new Hashtable();
        Hashtable bordersToHighlight = new Hashtable();
        if (line == -1) {
            int l;
            if (column == -1) {
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, l, c)).getRGB());
                        if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                            backgroundsToHighlight.put(currentBackHLColor, new Vector());
                        }
                        ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, c)));
                        currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, l, c)).getRGB());
                        if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                            textObjectsToHighlight.put(currentTextHLColor, new Vector());
                        }
                        ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, c)));
                        currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, l, c)).getRGB());
                        if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                            bordersToHighlight.put(currentBorderHLColor, new Vector());
                        }
                        ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, c)));
                        ++c;
                    }
                    ++l;
                }
            } else {
                l = 0;
                while (l < size[0]) {
                    currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, l, column)).getRGB());
                    if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                        backgroundsToHighlight.put(currentBackHLColor, new Vector());
                    }
                    ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, column)));
                    currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, l, column)).getRGB());
                    if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                        textObjectsToHighlight.put(currentTextHLColor, new Vector());
                    }
                    ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, column)));
                    currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, l, column)).getRGB());
                    if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                        bordersToHighlight.put(currentBorderHLColor, new Vector());
                    }
                    ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, column)));
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, line, c)).getRGB());
                if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                    backgroundsToHighlight.put(currentBackHLColor, new Vector());
                }
                ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, c)));
                currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, line, c)).getRGB());
                if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                    textObjectsToHighlight.put(currentTextHLColor, new Vector());
                }
                ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, c)));
                currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, line, c)).getRGB());
                if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                    bordersToHighlight.put(currentBorderHLColor, new Vector());
                }
                ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, c)));
                ++c;
            }
        } else {
            currentBackHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightFillColorKey(gridName, line, column)).getRGB());
            if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                backgroundsToHighlight.put(currentBackHLColor, new Vector());
            }
            ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, column)));
            currentTextHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightTextColorKey(gridName, line, column)).getRGB());
            if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                textObjectsToHighlight.put(currentTextHLColor, new Vector());
            }
            ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, column)));
            currentBorderHLColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridHighlightBorderColorKey(gridName, line, column)).getRGB());
            if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                bordersToHighlight.put(currentBorderHLColor, new Vector());
            }
            ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, column)));
        }
        Enumeration collectedBackgroundHighlightColorKeys = backgroundsToHighlight.keys();
        while (collectedBackgroundHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBackgroundHighlightColorKeys.nextElement();
            Vector backgrounds = (Vector)backgroundsToHighlight.get(currentHLColor);
            int[] backgroundIDs = new int[backgrounds.size()];
            int i = 0;
            while (i < backgroundIDs.length) {
                backgroundIDs[i] = (Integer)backgrounds.get(i);
                ++i;
            }
            ColorChanger backgroundHL = new ColorChanger(step, backgroundIDs, duration, "fillcolor", new Color(Integer.parseInt(currentHLColor)));
            backgroundHL.setOffset(offset);
            backgroundHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(backgroundHL, anim);
        }
        Enumeration collectedTextObjectHighlightColorKeys = textObjectsToHighlight.keys();
        while (collectedTextObjectHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedTextObjectHighlightColorKeys.nextElement();
            Vector textObjects = (Vector)textObjectsToHighlight.get(currentHLColor);
            int[] textObjectIDs = new int[textObjects.size()];
            int i = 0;
            while (i < textObjectIDs.length) {
                textObjectIDs[i] = (Integer)textObjects.get(i);
                ++i;
            }
            ColorChanger textObjectHL = new ColorChanger(step, textObjectIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            textObjectHL.setOffset(offset);
            textObjectHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(textObjectHL, anim);
        }
        Enumeration collectedBorderHighlightColorKeys = bordersToHighlight.keys();
        while (collectedBorderHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBorderHighlightColorKeys.nextElement();
            Vector borders = (Vector)bordersToHighlight.get(currentHLColor);
            int[] borderIDs = new int[borders.size()];
            int i = 0;
            while (i < borderIDs.length) {
                borderIDs[i] = (Integer)borders.get(i);
                ++i;
            }
            ColorChanger borderHL = new ColorChanger(step, borderIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            borderHL.setOffset(offset);
            borderHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(borderHL, anim);
        }
    }

    public static void unhighlightGridCell(String gridName, int line, int column, int step, int duration, int offset, String unit) {
        String currentBorderColor;
        String currentTextColor;
        String currentFillColor;
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        Hashtable backgroundsToUnhighlight = new Hashtable();
        Hashtable textObjectsToUnhighlight = new Hashtable();
        Hashtable bordersToUnhighlight = new Hashtable();
        if (line == -1) {
            int l;
            if (column == -1) {
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        currentFillColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridFillColorKey(gridName, l, c)).getRGB());
                        if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                            backgroundsToUnhighlight.put(currentFillColor, new Vector());
                        }
                        ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, c)));
                        currentTextColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridTextColorKey(gridName, l, c)).getRGB());
                        if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                            textObjectsToUnhighlight.put(currentTextColor, new Vector());
                        }
                        ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, c)));
                        currentBorderColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridBorderColorKey(gridName, l, c)).getRGB());
                        if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                            bordersToUnhighlight.put(currentBorderColor, new Vector());
                        }
                        ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, c)));
                        ++c;
                    }
                    ++l;
                }
            } else {
                l = 0;
                while (l < size[0]) {
                    currentFillColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridFillColorKey(gridName, l, column)).getRGB());
                    if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                        backgroundsToUnhighlight.put(currentFillColor, new Vector());
                    }
                    ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, column)));
                    currentTextColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridTextColorKey(gridName, l, column)).getRGB());
                    if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                        textObjectsToUnhighlight.put(currentTextColor, new Vector());
                    }
                    ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, column)));
                    currentBorderColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridBorderColorKey(gridName, l, column)).getRGB());
                    if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                        bordersToUnhighlight.put(currentBorderColor, new Vector());
                    }
                    ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l, column)));
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                currentFillColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridFillColorKey(gridName, line, c)).getRGB());
                if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                    backgroundsToUnhighlight.put(currentFillColor, new Vector());
                }
                ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, c)));
                currentTextColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridTextColorKey(gridName, line, c)).getRGB());
                if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                    textObjectsToUnhighlight.put(currentTextColor, new Vector());
                }
                ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, c)));
                currentBorderColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridBorderColorKey(gridName, line, c)).getRGB());
                if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                    bordersToUnhighlight.put(currentBorderColor, new Vector());
                }
                ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, c)));
                ++c;
            }
        } else {
            currentFillColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridFillColorKey(gridName, line, column)).getRGB());
            if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                backgroundsToUnhighlight.put(currentFillColor, new Vector());
            }
            ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, column)));
            currentTextColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridTextColorKey(gridName, line, column)).getRGB());
            if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                textObjectsToUnhighlight.put(currentTextColor, new Vector());
            }
            ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, column)));
            currentBorderColor = String.valueOf(GridProducer.getObjectProperties().getColorProperty(GridProducer.gridBorderColorKey(gridName, line, column)).getRGB());
            if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                bordersToUnhighlight.put(currentBorderColor, new Vector());
            }
            ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, line, column)));
        }
        Enumeration collectedBackgroundHighlightColorKeys = backgroundsToUnhighlight.keys();
        while (collectedBackgroundHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBackgroundHighlightColorKeys.nextElement();
            Vector backgrounds = (Vector)backgroundsToUnhighlight.get(currentHLColor);
            int[] backgroundIDs = new int[backgrounds.size()];
            int i = 0;
            while (i < backgroundIDs.length) {
                backgroundIDs[i] = (Integer)backgrounds.get(i);
                ++i;
            }
            ColorChanger backgroundUnHL = new ColorChanger(step, backgroundIDs, duration, "fillcolor", new Color(Integer.parseInt(currentHLColor)));
            backgroundUnHL.setOffset(offset);
            backgroundUnHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(backgroundUnHL, anim);
        }
        Enumeration collectedTextObjectHighlightColorKeys = textObjectsToUnhighlight.keys();
        while (collectedTextObjectHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedTextObjectHighlightColorKeys.nextElement();
            Vector textObjects = (Vector)textObjectsToUnhighlight.get(currentHLColor);
            int[] textObjectIDs = new int[textObjects.size()];
            int i = 0;
            while (i < textObjectIDs.length) {
                textObjectIDs[i] = (Integer)textObjects.get(i);
                ++i;
            }
            ColorChanger textObjectUnHL = new ColorChanger(step, textObjectIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            textObjectUnHL.setOffset(offset);
            textObjectUnHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(textObjectUnHL, anim);
        }
        Enumeration collectedBorderHighlightColorKeys = bordersToUnhighlight.keys();
        while (collectedBorderHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBorderHighlightColorKeys.nextElement();
            Vector borders = (Vector)bordersToUnhighlight.get(currentHLColor);
            int[] borderIDs = new int[borders.size()];
            int i = 0;
            while (i < borderIDs.length) {
                borderIDs[i] = (Integer)borders.get(i);
                ++i;
            }
            ColorChanger borderUnHL = new ColorChanger(step, borderIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            borderUnHL.setOffset(offset);
            borderUnHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(borderUnHL, anim);
        }
    }

    public static void alignGridValue(String gridName, int line, int column, int alignment, int step, int duration, int offset, String unit) {
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        if (line == -1) {
            if (column == -1) {
                int l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        GridProducer.getObjectProperties().put(GridProducer.gridTextAlignmentKey(gridName, l, c), alignment);
                        ++c;
                    }
                    ++l;
                }
            } else {
                int l = 0;
                while (l < size[0]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridTextAlignmentKey(gridName, l, column), alignment);
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                GridProducer.getObjectProperties().put(GridProducer.gridTextAlignmentKey(gridName, line, c), alignment);
                ++c;
            }
        } else {
            GridProducer.getObjectProperties().put(GridProducer.gridTextAlignmentKey(gridName, line, column), alignment);
        }
        GridProducer.refreshGrid(gridName, step, duration, offset, unit);
    }

    public static void setGridFont(String gridName, int line, int column, Font newFont, int step, int duration, int offset, String unit, boolean refresh) {
        int[] cellFontsToUpdate;
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        if (line == -1) {
            int l;
            if (column == -1) {
                cellFontsToUpdate = new int[size[0] * size[1]];
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (l < size[1]) {
                        cellFontsToUpdate[l * size[1] + c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, c));
                        GridProducer.getObjectProperties().put(GridProducer.gridTextFontKey(gridName, l, c), newFont);
                        ++c;
                    }
                    ++l;
                }
            } else {
                cellFontsToUpdate = new int[size[0]];
                l = 0;
                while (l < size[0]) {
                    GridProducer.getObjectProperties().put(GridProducer.gridTextFontKey(gridName, l, column), newFont);
                    cellFontsToUpdate[l] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l, column));
                    ++l;
                }
            }
        } else if (column == -1) {
            cellFontsToUpdate = new int[size[1]];
            int c = 0;
            while (c < size[1]) {
                GridProducer.getObjectProperties().put(GridProducer.gridTextFontKey(gridName, line, c), newFont);
                cellFontsToUpdate[c] = GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, c));
                ++c;
            }
        } else {
            cellFontsToUpdate = new int[]{GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, line, column))};
            GridProducer.getObjectProperties().put(GridProducer.gridTextFontKey(gridName, line, column), newFont);
        }
        SetFont setFont = new SetFont(step, cellFontsToUpdate, 0, offset + duration, unit, newFont);
        BasicParser.addAnimatorToAnimation(setFont, anim);
        if (refresh) {
            GridProducer.refreshGrid(gridName, step, duration, offset, unit);
        }
    }

    public static void refreshGrid(String gridName, int step, int duration, int offset, String unit) {
        Point currentCoords;
        Point location = GridProducer.getObjectProperties().getPointProperty(GridProducer.gridLocationKey(gridName));
        int style = GridProducer.getObjectProperties().getIntProperty(GridProducer.gridStyleKey(gridName));
        int minHeight = GridProducer.getObjectProperties().getIntProperty(GridProducer.gridCellHeightKey(gridName));
        int maxHeight = GridProducer.getObjectProperties().getIntProperty(GridProducer.gridMaxCellHeightKey(gridName));
        int minWidth = GridProducer.getObjectProperties().getIntProperty(GridProducer.gridCellWidthKey(gridName));
        int maxWidth = GridProducer.getObjectProperties().getIntProperty(GridProducer.gridMaxCellWidthKey(gridName));
        int[] size = GridProducer.getObjectProperties().getIntArrayProperty(GridProducer.gridSizeKey(gridName));
        int[] lineHeights = new int[size[0]];
        int[] colWidths = new int[size[1]];
        String[][] values = new String[size[0]][size[1]];
        Font[][] fonts = new Font[size[0]][size[1]];
        int[][] alignments = new int[size[0]][size[1]];
        int[][][] textPositions = new int[size[0]][size[1]][2];
        int[][][] backPositions = new int[size[0]][size[1]][4];
        int[][] bracketPositions = new int[6][6];
        int l = 0;
        while (l < size[0]) {
            int c = 0;
            while (c < size[1]) {
                Font currentFont = GridProducer.getObjectProperties().getFontProperty(GridProducer.gridTextFontKey(gridName, l, c));
                String currentValue = GridProducer.getObjectProperties().getProperty(GridProducer.gridTextStringKey(gridName, l, c));
                if (currentFont == null) {
                    System.err.println("Font unter Key '" + GridProducer.gridTextFontKey(gridName, l, c) + "' gleich null");
                    System.err.println("Existiert Key? " + GridProducer.getObjectProperties().containsKey(GridProducer.gridTextFontKey(gridName, l, c)));
                }
                fonts[l][c] = currentFont;
                values[l][c] = currentValue;
                alignments[l][c] = GridProducer.getObjectProperties().getIntProperty(GridProducer.gridTextAlignmentKey(gridName, l, c));
                ++c;
            }
            ++l;
        }
        GridMath.calculateLineHeights(lineHeights, fonts, minHeight, maxHeight, style);
        GridMath.calculateColumnWidths(colWidths, values, fonts, minWidth, maxWidth, style);
        GridMath.calculateTextPositions(textPositions, values, fonts, alignments, colWidths, lineHeights, location, style);
        GridMath.calculateBackgroundPositions(backPositions, colWidths, lineHeights, location, style);
        GridMath.calculateBracketPositions(bracketPositions, colWidths, lineHeights, location, style);
        Hashtable<String, Vector<Integer>> collectedMoves = new Hashtable<String, Vector<Integer>>();
        Hashtable<String, Vector<Integer>> collectedResizes = new Hashtable<String, Vector<Integer>>();
        int l2 = 0;
        while (l2 < size[0]) {
            int c = 0;
            while (c < size[1]) {
                currentCoords = GridProducer.getObjectProperties().getPointProperty(GridProducer.gridTextPositionKey(gridName, l2, c));
                GridProducer.collectObjectMovements(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridTextKey(gridName, l2, c)), textPositions[l2][c][0] - currentCoords.x, textPositions[l2][c][1] - currentCoords.y, collectedMoves);
                GridProducer.getObjectProperties().put(GridProducer.gridTextPositionKey(gridName, l2, c), new Point(textPositions[l2][c][0], textPositions[l2][c][1]));
                currentCoords = GridProducer.getObjectProperties().getPointProperty(GridProducer.gridBackPositionKey(gridName, l2, c));
                GridProducer.collectObjectMovements(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l2, c)), backPositions[l2][c][0] - currentCoords.x, backPositions[l2][c][1] - currentCoords.y, collectedMoves);
                GridProducer.getObjectProperties().put(GridProducer.gridBackPositionKey(gridName, l2, c), new Point(backPositions[l2][c][0], backPositions[l2][c][1]));
                currentCoords = GridProducer.getObjectProperties().getPointProperty(GridProducer.gridBackSizeKey(gridName, l2, c));
                GridProducer.collectObjectMovements(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBackKey(gridName, l2, c)), backPositions[l2][c][2] - currentCoords.x, backPositions[l2][c][3] - currentCoords.y, collectedResizes);
                GridProducer.getObjectProperties().put(GridProducer.gridBackSizeKey(gridName, l2, c), new Point(backPositions[l2][c][2], backPositions[l2][c][3]));
                ++c;
            }
            ++l2;
        }
        if (style == 1) {
            int dy = bracketPositions[2][1] - GridProducer.getObjectProperties().getPointProperty((String)GridProducer.gridBracketPositionKey((String)gridName, (int)2)).y;
            int p = 0;
            while (p < 6) {
                currentCoords = GridProducer.getObjectProperties().getPointProperty(GridProducer.gridBracketPositionKey(gridName, p));
                GridProducer.collectObjectMovements(GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBracketKey(gridName, p)), bracketPositions[p][0] - currentCoords.x, bracketPositions[p][1] - currentCoords.y, collectedMoves);
                GridProducer.getObjectProperties().put(GridProducer.gridBracketPositionKey(gridName, p), new Point(bracketPositions[p][0], bracketPositions[p][1]));
                ++p;
            }
            if (dy != 0) {
                int[] nArray = new int[2];
                nArray[1] = dy;
                PTPolyline bracketStrechMoveBase = new PTPolyline(new int[2], nArray);
                Move bracketStrech = new Move(step, new int[]{GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBracketKey(gridName, 1)), GridProducer.getObjectIDs().getIntProperty(GridProducer.gridBracketKey(gridName, 4))}, duration, "translateNodes 2", bracketStrechMoveBase.getNum(true));
                bracketStrech.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                BasicParser.addGraphicObject(bracketStrechMoveBase, anim);
                BasicParser.addAnimatorToAnimation(bracketStrech, anim);
            }
        }
        Enumeration collectedMoveKeys = collectedMoves.keys();
        while (collectedMoveKeys.hasMoreElements()) {
            String currentMovementS = (String)collectedMoveKeys.nextElement();
            Vector objectIDsToMoveV = (Vector)collectedMoves.get(currentMovementS);
            String[] currentMovementArray = currentMovementS.split(",");
            int[] nArray = new int[2];
            nArray[1] = Integer.parseInt(currentMovementArray[0]);
            int[] nArray2 = new int[2];
            nArray2[1] = Integer.parseInt(currentMovementArray[1]);
            PTPolyline currentMoveBase = new PTPolyline(nArray, nArray2);
            currentMoveBase.setDepth(10);
            currentMoveBase.getNum(true);
            int[] objectIDsToMoveA = new int[objectIDsToMoveV.size()];
            int i = 0;
            while (i < objectIDsToMoveA.length) {
                objectIDsToMoveA[i] = (Integer)objectIDsToMoveV.get(i);
                ++i;
            }
            Move currentMoveAnimation = new Move(step, objectIDsToMoveA, duration, "translate", currentMoveBase.getNum(true));
            currentMoveAnimation.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addGraphicObject(currentMoveBase, anim);
            BasicParser.addAnimatorToAnimation(currentMoveAnimation, anim);
        }
        Enumeration collectedResizeKeys = collectedResizes.keys();
        while (collectedResizeKeys.hasMoreElements()) {
            String currentMovementS = (String)collectedResizeKeys.nextElement();
            Vector objectIDsToMoveV = (Vector)collectedResizes.get(currentMovementS);
            String[] currentMovementArray = currentMovementS.split(",");
            int[] nArray = new int[2];
            nArray[1] = Integer.parseInt(currentMovementArray[0]);
            PTPolyline currentMoveBaseX = new PTPolyline(nArray, new int[]{2, 2});
            currentMoveBaseX.setDepth(10);
            currentMoveBaseX.getNum(true);
            currentMoveBaseX.setColor(new Color(0.5f, 0.75f, 0.25f));
            PTPolyline currentMoveBaseY = new PTPolyline(new int[]{3, 3}, new int[]{4, 4 + Integer.parseInt(currentMovementArray[1])});
            currentMoveBaseY.setDepth(10);
            currentMoveBaseY.getNum(true);
            currentMoveBaseY.setColor(new Color(0.5f, 0.75f, 0.25f));
            int[] objectIDsToMoveA = new int[objectIDsToMoveV.size()];
            int i = 0;
            while (i < objectIDsToMoveA.length) {
                objectIDsToMoveA[i] = (Integer)objectIDsToMoveV.get(i);
                ++i;
            }
            Move currentMoveAnimationX = new Move(step, objectIDsToMoveA, duration, "translateNodes 3 4", currentMoveBaseX.getNum(true));
            Move currentMoveAnimationY = new Move(step, objectIDsToMoveA, duration, "translateNodes 2 3", currentMoveBaseY.getNum(true));
            currentMoveAnimationX.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            currentMoveAnimationY.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addGraphicObject(currentMoveBaseX, anim);
            BasicParser.addGraphicObject(currentMoveBaseY, anim);
            BasicParser.addAnimatorToAnimation(currentMoveAnimationX, anim);
            BasicParser.addAnimatorToAnimation(currentMoveAnimationY, anim);
        }
    }
}

