/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.editor.Editor;
import animal.editor.animators.AnimatorEditor;
import animal.gui.AnimalMainWindow;
import animal.gui.DrawWindow;
import animal.misc.MessageDisplay;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import translator.AnimalTranslator;

public class ObjectSelectionButton
extends JToggleButton
implements ActionListener {
    private static final long serialVersionUID = 4325851584622507314L;
    static ObjectSelectionButton activeButton = null;
    private boolean isWindowListener = false;
    private boolean multiSelection;
    private int[] objectNums = null;

    public ObjectSelectionButton(boolean isMultiSelection) {
        this.multiSelection = isMultiSelection;
        this.update(true);
        this.addActionListener(this);
    }

    private boolean checkMulti(boolean multi) {
        if (this.multiSelection && !multi) {
            return false;
        }
        return this.multiSelection || this.objectNums == null || this.objectNums.length <= 1;
    }

    public void setObjectNums(int[] objectNumArray) {
        int[] theArray = objectNumArray;
        if (theArray != null && (theArray.length == 0 || theArray.length == 1 && theArray[0] == 0)) {
            theArray = null;
        }
        boolean changed = theArray != this.objectNums;
        this.objectNums = theArray;
        this.checkMulti(true);
        this.update(changed);
    }

    public void setObjectNum(int objectNum) {
        this.checkMulti(false);
        boolean changed = this.getObjectNum() != objectNum;
        this.objectNums = (int[])(objectNum == 0 ? null : new int[]{objectNum});
        this.update(changed);
    }

    public int[] getObjectNums() {
        this.checkMulti(true);
        return this.objectNums;
    }

    public int getObjectNum() {
        this.checkMulti(false);
        if (this.objectNums == null) {
            return 0;
        }
        return this.objectNums[0];
    }

    private void update(boolean changed) {
        boolean multipleSelected;
        boolean bl = multipleSelected = this.getObjectNums() != null && this.getObjectNums().length > 1;
        if (this.multiSelection && multipleSelected) {
            this.setText(AnimalTranslator.translateMessage("osbSelectedMulti", ObjectSelectionButton.getNumArrayString(this.getObjectNums())));
        } else if (this.getObjectNum() != 0) {
            this.setText(AnimalTranslator.translateMessage("osbSelectedSingle", this.getObjectNum()));
        } else if (this.multiSelection) {
            this.setText(AnimalTranslator.translateMessage("osbRequestMulti"));
        } else {
            this.setText(AnimalTranslator.translateMessage("osbRequestSingle"));
        }
        if (changed) {
            ItemEvent e = new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2);
            this.fireItemStateChanged(e);
        }
        this.newLayout();
    }

    private AnimatorEditor getParentEditor() {
        return (AnimatorEditor)SwingUtilities.getAncestorOfClass(AnimatorEditor.class, this);
    }

    private void newLayout() {
        AnimatorEditor w = this.getParentEditor();
        if (w != null) {
            w.pack();
        }
    }

    public static void deselectActiveButton() {
        if (activeButton != null) {
            activeButton.setSelected(false);
            DrawWindow drawWin = AnimalMainWindow.getWindowCoordinator().getDrawWindow(false);
            drawWin.deselectAll();
            activeButton = null;
            drawWin.setExternalSelection(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isSelected()) {
            if (!this.isWindowListener) {
                this.isWindowListener = true;
                this.getParentEditor().addWindowListener(new OSBAdapter());
            }
            ObjectSelectionButton.deselectActiveButton();
            activeButton = this;
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).setExternalSelection(this);
        } else {
            ObjectSelectionButton.deselectActiveButton();
        }
        this.update(false);
    }

    public boolean objectsSelected(int step, int[] objects) {
        this.setObjectNums(objects);
        return true;
    }

    public static String getNumArrayString(int[] nums) {
        int[] theArray = nums;
        if (theArray == null) {
            theArray = new int[]{1};
            return "1";
        }
        Arrays.sort(theArray);
        StringBuilder s = new StringBuilder();
        int startNum = -1;
        int lastNum = -1;
        int a = 0;
        while (a <= theArray.length) {
            int newNum = a < theArray.length ? theArray[a] : -1;
            boolean series = newNum == lastNum + 1;
            boolean written = false;
            if (series) {
                ++lastNum;
            } else {
                if (lastNum != -1) {
                    if (startNum != lastNum) {
                        s.append(String.valueOf(startNum) + "-" + lastNum);
                    } else {
                        s.append(startNum);
                    }
                    written = true;
                }
                startNum = newNum;
                lastNum = newNum;
            }
            if (written && a < theArray.length) {
                s.append(',');
            }
            ++a;
        }
        return s.toString();
    }

    public boolean hasMultiSelection() {
        return this.multiSelection;
    }

    public boolean checkObjects() {
        if (this.objectNums == null) {
            return true;
        }
        int deletedItems = 0;
        int a = 0;
        while (a < this.objectNums.length) {
            if (Editor.getGraphicObject(this.objectNums[a]) == null) {
                MessageDisplay.message("osbDeleted", this.objectNums[a]);
                ++deletedItems;
                this.objectNums[a] = 0;
            }
            ++a;
        }
        if (deletedItems == 0) {
            return true;
        }
        int[] newObjects = new int[this.objectNums.length - deletedItems];
        int a2 = this.objectNums.length - 1;
        while (a2 >= 0) {
            if (this.objectNums[a2] != 0) {
                newObjects[a2 - deletedItems] = this.objectNums[a2];
            } else {
                --deletedItems;
            }
            --a2;
        }
        this.setObjectNums(newObjects);
        return false;
    }

    class OSBAdapter
    extends WindowAdapter {
        OSBAdapter() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (activeButton == ObjectSelectionButton.this) {
                ObjectSelectionButton.deselectActiveButton();
            }
        }
    }
}

