/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.Animator;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.gui.AnimationControlToolBar;
import animal.gui.AnimationDisplayToolBar;
import animal.gui.GraphicVector;
import animal.main.Animal;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.main.AnimationCanvas;
import animal.main.AnimationState;
import animal.main.ButtonController;
import animal.main.Link;
import animal.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnimationWindow
extends AnimalFrame
implements ActionListener {
    private static final long serialVersionUID = -5650098641898883312L;
    public static final double MAX_SPEED_FACTOR = 10.0;
    public static final int PADDING_SCROLLBAR_RIGHT = 20;
    public static final int PADDING_TOOLBARS_TOP_BOTTOM = 80;
    private AnimationState ani = null;
    private AnimationCanvas animationCanvas;
    private ScrollPane sp;
    private boolean pause = false;
    private boolean slideShowMode = false;
    private boolean forwardMode = true;
    private double ticks;
    private Timer timer;
    private double speed = 1.0;
    private boolean isSlowMode = false;
    private Vector<Image> animationImages = new Vector(50, 15);
    private Container workContainer = null;
    private AnimationControlToolBar animationControlToolBar;
    private AnimationDisplayToolBar displayControlToolBar;

    public AnimationWindow(Animal animalInstance, XProperties properties) {
        super(animalInstance, properties);
        this.setDependentContainer(this.getContentPane());
    }

    public AnimationWindow(Animal animalInstance, XProperties properties, Container aContainer) {
        super(animalInstance, properties);
        this.setDependentContainer(aContainer);
    }

    public void setDependentContainer(Container aContainer) {
        this.workContainer = aContainer;
    }

    @Override
    public Container workContainer() {
        return this.workContainer;
    }

    @Override
    public void init() {
        super.init();
        this.workContainer().setLayout(new BorderLayout(0, 0));
        this.animationControlToolBar = new AnimationControlToolBar("AnimationControls", this);
        this.workContainer().add("South", this.animationControlToolBar);
        this.displayControlToolBar = new AnimationDisplayToolBar("Animation Display Controls", this);
        this.workContainer().add("North", this.displayControlToolBar);
        if (this.animationCanvas == null) {
            this.animationCanvas = new AnimationCanvas();
        }
        this.animationCanvas.setProperties(this.props);
        if (this.sp == null) {
            this.sp = new ScrollPane();
            this.sp.add(this.animationCanvas);
        }
        this.workContainer().add("Center", this.sp);
        this.setTitle("Animal Animation");
        this.setProperties(this.props);
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible && this.ani == null) {
            this.setAnimation(Animation.get());
            this.setStep(this.ani.getStep(), true);
        }
    }

    void setProperties(XProperties properties) {
        this.setBounds(properties.getIntProperty("animationWindow.x", 50), properties.getIntProperty("animationWindow.y", 50), properties.getIntProperty("animationWindow.width", 400), properties.getIntProperty("animationWindow.height", 200));
    }

    void getProperties(XProperties properties) {
        Rectangle b = this.getBounds();
        if (b.width - 10 == properties.getIntProperty("animationWindow.width", 320) && b.height - 22 == properties.getIntProperty("animationWindow.height", 200)) {
            b.width -= 10;
            b.height -= 22;
        }
        properties.put("animationWindow.x", b.x);
        properties.put("animationWindow.y", b.y);
        properties.put("animationWindow.width", b.width);
        properties.put("animationWindow.height", b.height);
    }

    public void startOfAnimation() {
        this.setSlideShowMode(false);
        this.setStep(this.ani.getFirstRealStep(), true);
    }

    public void backwardAnimation() {
        this.setSlideShowMode(false);
        this.setStep(this.ani.getPrevStep(), true);
    }

    public void reversePlay() {
        this.setSlideShowMode(false);
        this.forwardMode = false;
        this.setReverseStep(this.ani.getStep(), false);
    }

    public void reverseSlideShow() {
        this.setSlideShowMode(true);
        this.forwardMode = false;
        this.pause = false;
        this.setReverseStep(this.ani.getStep(), false);
    }

    public void pauseAnimation() {
        this.pause = true;
        this.setSlideShowMode(false);
    }

    public void playAnimation() {
        this.setSlideShowMode(false);
        this.setStep(this.ani.getNextStep(), false);
    }

    public void slideShow() {
        this.setSlideShowMode(true);
        this.forwardMode = true;
        this.pause = false;
        this.setStep(this.ani.getNextStep(), false);
    }

    public void forwardAnimation() {
        this.setSlideShowMode(false);
        this.setStep(this.ani.getNextStep(), true);
    }

    public void endOfAnimation() {
        this.setSlideShowMode(false);
        this.setStep(this.ani.getLastStep(), true);
    }

    public void setSlideShowMode(boolean mode) {
        this.slideShowMode = mode;
    }

    public boolean getSlideShowMode() {
        return this.slideShowMode;
    }

    public void setMagnification(double factor) {
        this.animationCanvas.setMagnification(factor);
    }

    public ScrollPane getScrollPane() {
        return this.sp;
    }

    public double getMagnification() {
        return this.animationCanvas.getMagnification();
    }

    public void enableControls(boolean enabled) {
        this.animationControlToolBar.enableControls(enabled);
    }

    public void setButtonController(ButtonController controller) {
        this.animationControlToolBar.setButtonController(controller);
    }

    public void setStep(int step, boolean immediate) {
        int theStep = step;
        if (this.isVisible()) {
            int next = 0;
            if (this.ani.getAnimation() == null) {
                return;
            }
            theStep = this.ani.getAnimation().verifyStep(theStep);
            if (this.ani != null) {
                this.ani.setStep(theStep, !immediate);
            }
            AnimalMainWindow.getWindowCoordinator().getAnnotationEditor(false).setCurrentStep(theStep);
            this.animationControlToolBar.setStep(theStep, this.ani);
            if (immediate) {
                this.animationCanvas.repaintNow();
                next = Integer.MAX_VALUE;
            } else {
                next = this.nextStep();
                if (next != Integer.MAX_VALUE) {
                    theStep = next;
                }
            }
            this.animationControlToolBar.determineButtonState(theStep);
        }
    }

    public void setReverseStep(int step, boolean immediate) {
        int theStep = step;
        this.forwardMode = false;
        if (this.isVisible()) {
            int next = 0;
            theStep = this.ani.getAnimation().verifyStep(theStep);
            if (this.ani != null) {
                this.ani.setStep(theStep, !immediate);
            }
            AnimalMainWindow.getWindowCoordinator().getAnnotationEditor(false).setCurrentStep(theStep);
            this.animationControlToolBar.setStep(theStep, this.ani);
            if (immediate) {
                this.animationCanvas.repaintNow();
                next = Integer.MAX_VALUE;
            } else {
                next = this.reversePlayStep();
                if (next != 0) {
                    this.setStep(next, true);
                }
                theStep = next;
            }
            this.animationControlToolBar.determineButtonState(theStep);
        }
    }

    public int getStep() {
        return this.ani.getStep();
    }

    public int nextStep() {
        this.forwardMode = true;
        int step = this.ani.getStep();
        this.animationControlToolBar.enablePlayButton(false);
        Vector<Animator> animators = this.ani.getCurrentAnimators();
        long time = System.currentTimeMillis();
        int initTicks = (int)Math.round(this.ticks);
        int a = 0;
        while (a < animators.size()) {
            animators.elementAt(a).init(this.ani, time, initTicks);
            ++a;
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            time = System.currentTimeMillis();
            this.ticks += this.speed;
            int a2 = 0;
            while (a2 < animators.size()) {
                Animator animator = animators.elementAt(a2);
                if (animator == null) continue;
                animator.action(time, this.ticks);
                if (animator.hasFinished()) {
                    animators.removeElementAt(a2);
                    continue;
                }
                finished = false;
                ++a2;
            }
            this.animationCanvas.repaintNow();
            if (!this.isSlowMode) continue;
            this.animationImages.addElement(this.animationCanvas.getCurrentImage());
            this.animationCanvas.invalidateImage();
        }
        Link l = this.ani.getAnimation().getLink(step);
        if (this.getSlideShowMode() && !this.pause) {
            int targetDelay;
            int delay = l.getTime();
            if (delay == 0) {
                delay = Animal.getSlideShowDelay();
            }
            int n = targetDelay = this.speed < 0.01 ? delay : (int)Math.round((double)delay / this.speed);
            if (this.timer == null) {
                this.timer = new Timer(targetDelay, this);
            } else {
                this.timer.setDelay(targetDelay);
            }
            this.timer.setRepeats(false);
            this.timer.start();
            return l.getNextStep();
        }
        switch (l.getMode()) {
            case 1: {
                return Integer.MAX_VALUE;
            }
            case 2: {
                if (!this.pause) {
                    int targetDelay;
                    int delay = l.getTime();
                    if (delay == 0) {
                        delay = Animal.getSlideShowDelay();
                    }
                    int n = targetDelay = this.speed < 0.01 ? delay : (int)Math.round((double)delay / this.speed);
                    if (this.timer == null) {
                        this.timer = new Timer(targetDelay, this);
                    } else {
                        this.timer.setDelay(targetDelay);
                    }
                    this.timer.setRepeats(false);
                    this.timer.start();
                    return l.getNextStep();
                }
                this.pause = false;
                return Integer.MAX_VALUE;
            }
            case 4: {
                JOptionPane.showMessageDialog(this, l.getClickPrompt());
                return Integer.MAX_VALUE;
            }
        }
        this.animationControlToolBar.determineButtonState(step);
        return Integer.MAX_VALUE;
    }

    public int reversePlayStep() {
        int step = this.ani.getStep();
        this.animationControlToolBar.enablePlayButton(false);
        Vector<Animator> animators = this.ani.getCurrentAnimators();
        long time = System.currentTimeMillis();
        int a = 0;
        Link currentLink = this.ani.getAnimation().getLink(step);
        int lengthOfStep = currentLink.getDurationInTicks();
        int initialTicks = (int)Math.round(this.ticks);
        int referenceTicks = initialTicks + lengthOfStep;
        Animator currentAnimator = null;
        a = 0;
        while (a < animators.size()) {
            currentAnimator = animators.elementAt(a);
            if (currentAnimator != null) {
                currentAnimator.init(this.ani, time, initialTicks);
            }
            ++a;
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            time = System.currentTimeMillis();
            referenceTicks = (int)((double)referenceTicks - this.speed);
            this.ticks += this.speed;
            a = 0;
            while (a < animators.size()) {
                Animator animator = animators.elementAt(a);
                animator.setFinished(false);
                animator.action(time, referenceTicks);
                ++a;
            }
            this.animationCanvas.repaintNow();
            boolean bl = finished = initialTicks >= referenceTicks;
        }
        int prevStep = this.ani.getPrevStep();
        Link l = this.ani.getAnimation().getLink(this.ani.getPrevStep());
        if (this.getSlideShowMode() && !this.pause) {
            int delay = l.getTime();
            if (delay == 0) {
                delay = Animal.getSlideShowDelay();
            }
            if (this.timer == null) {
                this.timer = new Timer(delay, this);
            } else {
                this.timer.setDelay(delay);
            }
            this.timer.setRepeats(false);
            this.timer.start();
            return prevStep;
        }
        switch (l.getMode()) {
            case 1: {
                return prevStep;
            }
            case 2: {
                return prevStep;
            }
        }
        this.animationControlToolBar.determineButtonState(step);
        return prevStep;
    }

    public Rectangle determineImageSize() {
        Rectangle size = new Rectangle(0, 0, 1, 1);
        int step = 0;
        this.ani.setStep(0, false);
        step = this.ani.getNextStep();
        while (step != Integer.MAX_VALUE) {
            this.ani.setStep(step, false);
            Vector<Animator> animators = this.ani.getCurrentAnimators();
            long time = System.currentTimeMillis();
            int initialTicks = (int)Math.round(this.ticks);
            this.ticks = initialTicks;
            int a = 0;
            while (a < animators.size()) {
                animators.elementAt(a).init(this.ani, time, initialTicks);
                ++a;
            }
            boolean finished = false;
            int[] currentObjects = null;
            PTGraphicObject currentObject = null;
            while (!finished) {
                finished = true;
                time = System.currentTimeMillis();
                this.ticks += 1.0;
                int a2 = 0;
                while (a2 < animators.size()) {
                    Animator animator = animators.elementAt(a2);
                    animator.action(time, this.ticks);
                    currentObjects = animator.getObjectNums();
                    int i = 0;
                    while (i < currentObjects.length) {
                        currentObject = this.ani.getCloneByNum(currentObjects[i]);
                        size = SwingUtilities.computeUnion(0, 0, size.width, size.height, currentObject.getBoundingBox());
                        ++i;
                    }
                    if (animator.hasFinished()) {
                        animators.removeElementAt(a2);
                        continue;
                    }
                    finished = false;
                    ++a2;
                }
            }
            step = this.ani.getNextStep();
        }
        return size;
    }

    void setAnimation(Animation animation) {
        if (!this.isInitialized()) {
            this.init();
        }
        this.ani = new AnimationState(animation);
        GraphicVector objects = this.ani.getCurrentObjects();
        this.animationCanvas.setObjects(objects);
        this.setStep(this.ani.getStep(), true);
        this.ticks = 0.0;
        this.ani.reset();
        if (animation != null) {
            int w = animation.getWidth();
            int h = animation.getHeight();
            if (animation.getWidth() > 0 && animation.getHeight() > 0 && w > this.getWidth() - 20 && h > this.getHeight() - 80) {
                this.setSize(w, h);
            }
            this.animationControlToolBar.setNrOfSteps(animation.getNrOfSteps() - 1);
        }
        this.animationControlToolBar.enablePlayButton(true);
    }

    public String setLabelForStep(int stepNr) {
        return String.valueOf(stepNr);
    }

    public AnimationCanvas getAnimationCanvas() {
        return this.animationCanvas;
    }

    public Image getCurrentImage() {
        return this.animationCanvas.getCurrentImage();
    }

    public void setSlowMode(boolean isSlow) {
        this.isSlowMode = isSlow;
    }

    public void setSpeed(double speedValue) {
        if (speedValue > 0.0 && speedValue <= 10.0) {
            this.speed = speedValue;
        }
    }

    public boolean getSlowMode() {
        return this.isSlowMode;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer && !this.pause) {
            int nextStep = Integer.MAX_VALUE;
            nextStep = this.forwardMode ? this.ani.getNextStep() : this.ani.getPrevStep();
            if (this.forwardMode && nextStep != Integer.MAX_VALUE) {
                this.setStep(nextStep, false);
            } else if (!this.forwardMode && nextStep != 0) {
                this.setReverseStep(nextStep, false);
            }
        }
    }

    public AnimationState getAnimationState() {
        return this.ani;
    }

    protected AnimationControlToolBar getAnimationControlToolBar() {
        return this.animationControlToolBar;
    }

    public Image[] getAnimationImages() {
        if (this.animationImages.size() == 0) {
            return new Image[]{this.animationCanvas.getCurrentImage()};
        }
        Object[] images = new Image[this.animationImages.size()];
        this.animationImages.copyInto(images);
        this.animationImages.clear();
        return images;
    }
}

