/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.editor.Editor;
import animal.editor.graphics.GraphicEditor;
import animal.exchange.AnimationExporter;
import animal.exchange.AnimationImporter;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.gui.WindowCoordinator;
import animal.handler.GraphicObjectHandler;
import animal.handler.GraphicObjectHandlerExtension;
import animal.main.Animal;
import animal.misc.AnimalFileChooser;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import avinteraction.InteractionModule;
import avinteraction.backend.AnimalEvalBackend;
import avinteraction.backend.BackendInterface;
import avinteraction.parser.BadSyntaxException;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import translator.AnimalTranslator;

public class AnimalConfiguration {
    public static final String DEFAULT_FILENAME = "demo.aml";
    public static final String DEFAULT_FORMAT = "animation/animal-ascii-compressed";
    public static final long MS_PER_DAY = 86400000L;
    private static AnimalConfiguration defaultConfig;
    private static InteractionModule interactionHandler;
    private String currentDirectory;
    private String currentFilename;
    private String currentFormat;
    private Properties config;
    private XProperties xConfig;
    private XProperties animalProperties;
    private Font lastFontUsed = new Font("SansSerif", 0, 20);
    private BackendInterface backend;
    private boolean isInitialized;
    protected boolean editorsInitialized = false;
    private String versionInfo;
    private String versionDate;
    public AnimalFileChooser loadFileChooser;
    public AnimalFileChooser saveFileChooser;
    private Hashtable<String, String> registeredImportFormats = null;
    private Hashtable<String, AnimationImporter> defaultImportExtensions = null;
    private Hashtable<String, Editor> editors = null;
    private Hashtable<String, AnimationExporter> registeredExportFormats = null;
    private Hashtable<String, AnimationExporter> defaultExportExtensions = null;
    private double incrementValue = 1.0;

    public AnimalConfiguration() {
        this.loadProperties();
        this.readComponents();
    }

    public void readComponents() {
        this.config = null;
        try {
            InputStream in = this.getClass().getResourceAsStream("/components.dat");
            if (in != null) {
                BufferedInputStream bins = new BufferedInputStream(in);
                this.config = new Properties();
                this.config.load(bins);
                bins.close();
                in.close();
            }
        }
        catch (IOException ioex) {
            System.err.println(ioex.getMessage());
        }
        if (this.config != null) {
            this.xConfig = new XProperties(this.config);
            this.isInitialized = true;
            this.incrementValue = (100.0 - Animal.ProgressPanel.getCurrentPercentage()) / (double)this.config.size();
        }
    }

    public void removeExportFilter(String formatName) {
        this.registeredExportFormats.remove(formatName);
    }

    public void initializePrimitives() {
        Properties primitiveProps = this.getEntriesForPrefix("primitive");
        if (this.editors == null) {
            this.editors = new Hashtable(23);
        }
        if (primitiveProps != null) {
            Enumeration<Object> primitiveKeys = primitiveProps.keys();
            int cutPosition = "primitive.".length();
            int nr = 0;
            while (primitiveKeys.hasMoreElements()) {
                String key = (String)primitiveKeys.nextElement();
                Animal.ProgressPanel.addText("..." + key);
                this.insertPrimitive(key.substring(cutPosition), primitiveProps.getProperty(key), nr++, this.getProperties());
                Animal.advanceProgressDisplayBy(this.incrementValue);
            }
        }
    }

    public void initializeAnimators() {
        Properties animatorProps = this.getEntriesForPrefix("animator");
        if (animatorProps != null) {
            Enumeration<Object> animatorKeys = animatorProps.keys();
            int cutPosition = "animator.".length();
            int nr = 0;
            while (animatorKeys.hasMoreElements()) {
                String key = (String)animatorKeys.nextElement();
                Animal.ProgressPanel.addText("..." + key);
                this.insertAnimator(key.substring(cutPosition), animatorProps.getProperty(key), nr++, this.getProperties());
                Animal.advanceProgressDisplayBy(this.incrementValue);
            }
        }
    }

    public void initializeHandlerExtensions() {
        Properties handlerExtProps = this.getEntriesForPrefix("handlerExtension");
        if (handlerExtProps != null) {
            Enumeration<Object> handlerExtKeys = handlerExtProps.keys();
            while (handlerExtKeys.hasMoreElements()) {
                String key = (String)handlerExtKeys.nextElement();
                Animal.ProgressPanel.addText("..." + key);
                this.insertHandlerExtension(key.substring(key.lastIndexOf(".") + 1), handlerExtProps.getProperty(key));
                Animal.advanceProgressDisplayBy(this.incrementValue);
            }
        }
    }

    public void initializeAllEditors() {
        String resourceName = "i18n/I18NGenericEditor." + AnimalTranslator.getTranslator().getCurrentLocale();
        try {
            AnimalTranslator.addResource(resourceName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Resource not found (ignore for now) " + resourceName);
        }
        this.initializePrimitives();
        this.initializeAnimators();
        this.initializeHandlerExtensions();
        this.initializeSteps();
        this.editorsInitialized = true;
    }

    public void initializeSteps() {
        Properties animatorProps = this.getEntriesForPrefix("animationStep");
        if (animatorProps != null) {
            Enumeration<Object> animatorKeys = animatorProps.keys();
            int cutPosition = "animationStep.".length();
            int nr = 0;
            while (animatorKeys.hasMoreElements()) {
                String key = (String)animatorKeys.nextElement();
                Animal.ProgressPanel.addText("..." + key);
                this.insertAnimationStep(key.substring(cutPosition), animatorProps.getProperty(key), nr++, this.getProperties());
                Animal.advanceProgressDisplayBy(this.incrementValue);
            }
        }
    }

    public void insertPrimitive(String componentName, String handlerName, int componentNumber, XProperties props) {
        String resourceName = "i18n/I18N" + handlerName.substring(handlerName.lastIndexOf(46) + 3) + "Editor." + AnimalTranslator.getTranslator().getCurrentLocale();
        try {
            AnimalTranslator.addResource(resourceName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Resource not found (ignore for now) " + resourceName);
        }
        String editorBaseName = handlerName.replaceFirst(".graphics.PT", ".editor.graphics.");
        String editorName = editorBaseName + "Editor";
        try {
            Class<?> c = Class.forName(editorName);
            Editor ed = (Editor)c.newInstance();
            if (ed != null && ed instanceof GraphicEditor) {
                GraphicObjectHandler handler = null;
                PTGraphicObject ptgo = null;
                Class<?> ptgoClass = Class.forName(handlerName);
                try {
                    Method targetMethod = ptgoClass.getDeclaredMethod("initializeDefaultProperties", props.getClass());
                    targetMethod.invoke(null, props);
                }
                catch (NoSuchMethodException targetMethod) {
                }
                catch (InvocationTargetException e) {
                    MessageDisplay.message("mthdInvFail", new String[]{componentName, e.getMessage()});
                }
                ptgo = (PTGraphicObject)ptgoClass.newInstance();
                StringBuilder handlerClassName = new StringBuilder(editorName.length() + 10);
                handlerClassName.append("animal.handler.").append(componentName).append("Handler");
                Class<?> handlerClass = Class.forName(handlerClassName.toString());
                handler = (GraphicObjectHandler)handlerClass.newInstance();
                if (ptgo != null) {
                    PTGraphicObject.registeredHandlers.put(ptgo.getType(), handler);
                    String[] registered = ptgo.handledKeywords();
                    int i = 0;
                    while (i < registered.length) {
                        PTGraphicObject.registeredTypes.put(registered[i].toLowerCase(), handlerName);
                        ++i;
                    }
                }
            }
            this.insertEditor(componentNumber, ed);
        }
        catch (ClassNotFoundException e) {
            MessageDisplay.errorMsg("classNotFound", new String[]{editorName, e.getMessage()}, 8);
        }
        catch (InstantiationException e) {
            MessageDisplay.errorMsg("errorInstantiating", new String[]{editorName, e.getMessage()}, 16);
        }
        catch (IllegalAccessException e) {
            MessageDisplay.errorMsg("illegalAccessExc", new String[]{editorName, e.getMessage()}, 16);
        }
        catch (IllegalArgumentException e) {
            MessageDisplay.errorMsg("illegalArgumentExc", new String[]{editorName, e.getMessage()}, 16);
        }
    }

    private void insertEditor(int componentNumber, Editor editor) {
        int compNr = componentNumber;
        if (editor != null) {
            this.editors.put(editor.getName(), editor);
            if (compNr == 0) {
                compNr = this.getEditors().size();
            }
            editor.setNum(compNr);
        }
    }

    public void insertHandlerExtension(String key, String className) {
        try {
            Class<?> c = Class.forName(className);
            GraphicObjectHandlerExtension handlerExtension = (GraphicObjectHandlerExtension)c.newInstance();
            GraphicObjectHandler.insertHandlerExtension(handlerExtension);
            Animal.advanceProgressDisplayBy(this.incrementValue);
        }
        catch (ClassNotFoundException e) {
            MessageDisplay.errorMsg("classNotFound", new String[]{className, e.getMessage()}, 8);
        }
        catch (InstantiationException e) {
            MessageDisplay.errorMsg("errorInstantiating", new String[]{className, e.getMessage()}, 8);
        }
        catch (IllegalAccessException e) {
            MessageDisplay.errorMsg("illegalAccessExc", new String[]{className, e.getMessage()}, 8);
        }
        catch (IllegalArgumentException e) {
            MessageDisplay.errorMsg("illegalArgumentExc", new String[]{className, e.getMessage()}, 8);
        }
    }

    public void insertAnimator(String key, String componentName, int componentNumber, XProperties props) {
        String resourceName = "i18n/I18N" + componentName.substring(componentName.lastIndexOf(46) + 1) + "Editor." + AnimalTranslator.getTranslator().getCurrentLocale();
        try {
            AnimalTranslator.addResource(resourceName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Resource not found (ignore for now) " + resourceName);
        }
        StringBuilder className = new StringBuilder(58);
        className.append("animal.editor.animators.").append(componentName.substring(componentName.lastIndexOf(46) + 1));
        className.append("Editor");
        try {
            Class<?> c = Class.forName(className.toString());
            Editor ed = (Editor)c.newInstance();
            this.insertEditor(componentNumber, ed);
        }
        catch (ClassNotFoundException e) {
            MessageDisplay.errorMsg("classNotFound", new String[]{className.toString(), e.getMessage()}, 8);
        }
        catch (InstantiationException e) {
            MessageDisplay.errorMsg("errorInstantiating", new String[]{className.toString(), e.getMessage()}, 8);
        }
        catch (IllegalAccessException e) {
            MessageDisplay.errorMsg("illegalAccessExc", new String[]{className.toString(), e.getMessage()}, 8);
        }
        catch (IllegalArgumentException e) {
            MessageDisplay.errorMsg("illegalArgumentExc", new String[]{className.toString(), e.getMessage()}, 8);
        }
    }

    public void insertAnimationStep(String key, String componentName, int componentNumber, XProperties props) {
        String resourceName = "i18n/I18N" + componentName.substring("animal.main.".length()) + "Editor." + AnimalTranslator.getTranslator().getCurrentLocale();
        try {
            AnimalTranslator.addResource(resourceName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Resource not found (ignore for now) " + resourceName);
        }
        StringBuilder className = new StringBuilder(53);
        className.append("animal.editor.");
        className.append(componentName.substring("animal.main.".length()));
        className.append("Editor");
        try {
            Class<?> c = Class.forName(className.toString());
            Editor ed = (Editor)c.newInstance();
            this.insertEditor(componentNumber, ed);
            Animal.advanceProgressDisplayBy(this.incrementValue);
        }
        catch (ClassNotFoundException e) {
            MessageDisplay.errorMsg("classNotFound", new String[]{className.toString(), e.getMessage()}, 8);
        }
        catch (InstantiationException e) {
            MessageDisplay.errorMsg("errorInstantiating", new String[]{className.toString(), e.getMessage()}, 8);
        }
        catch (IllegalAccessException e) {
            MessageDisplay.errorMsg("illegalAccessExc", new String[]{className.toString(), e.getMessage()}, 8);
        }
        catch (IllegalArgumentException e) {
            MessageDisplay.errorMsg("illegalArgumentExc", new String[]{className.toString(), e.getMessage()}, 8);
        }
    }

    public Properties getConfiguration() {
        return this.config;
    }

    public Properties getEntriesForPrefix(String prefixCode) {
        if (this.xConfig == null) {
            return new Properties();
        }
        String[] keys = this.xConfig.getKeys(prefixCode);
        if (keys == null) {
            return new Properties();
        }
        Properties prefixProps = new Properties();
        int nrKeys = keys.length;
        int i = 0;
        while (i < nrKeys) {
            prefixProps.put(keys[i], this.xConfig.getProperty(keys[i]));
            ++i;
        }
        return prefixProps;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public Hashtable<String, Editor> getEditors() {
        return this.editors;
    }

    public static AnimalConfiguration getDefaultConfiguration() {
        if (defaultConfig == null || !defaultConfig.isInitialized()) {
            defaultConfig = new AnimalConfiguration();
            defaultConfig.readComponents();
        }
        return defaultConfig;
    }

    public AnimalFileChooser getImportFileChooser() {
        if (this.loadFileChooser == null) {
            this.initializeImportFormats();
        }
        return this.loadFileChooser;
    }

    public void initializeImportFormats() {
        Properties handlers = this.getEntriesForPrefix("import");
        if (this.registeredImportFormats == null) {
            this.registeredImportFormats = new Hashtable(29);
        }
        if (this.defaultImportExtensions == null) {
            this.defaultImportExtensions = new Hashtable(29);
        }
        this.loadFileChooser = new AnimalFileChooser(this);
        this.loadFileChooser.resetFilters();
        this.loadFileChooser.chooser.removeChoosableFileFilter(this.loadFileChooser.chooser.getAcceptAllFileFilter());
        if (handlers != null) {
            Enumeration<Object> importKeys = handlers.keys();
            Vector<String> formats = new Vector<String>(37);
            int cutPosition = "import.".length();
            while (importKeys.hasMoreElements()) {
                String key = (String)importKeys.nextElement();
                String formatKey = key.toLowerCase().substring(cutPosition);
                this.insertImportFilter(formatKey, handlers.getProperty(key));
                formats.add(formatKey);
            }
            Object[] supportedFormats = new String[formats.size()];
            formats.copyInto(supportedFormats);
        }
        this.loadFileChooser.chooser.setFileFilter(this.loadFileChooser.chooser.getChoosableFileFilters()[0]);
    }

    public InteractionModule initializeInteractionHandler() {
        interactionHandler = null;
        this.backend = new AnimalEvalBackend();
        try {
            interactionHandler = new InteractionModule(this.backend, true);
            InteractionModule.setTranslatorLocale(Animal.getCurrentLocale());
        }
        catch (BadSyntaxException e) {
            MessageDisplay.errorMsg("badBackendSyntax", this.backend.getClass().getName(), 4);
        }
        catch (Exception ee) {
            MessageDisplay.errorMsg("backendException", new String[]{ee.getClass().getName(), ee.getMessage()}, 4);
            ee.printStackTrace();
        }
        return interactionHandler;
    }

    public void initializeExportFormats() {
        Properties handlers = this.getEntriesForPrefix("export");
        if (this.registeredExportFormats == null) {
            this.registeredExportFormats = new Hashtable(29);
        }
        if (this.defaultExportExtensions == null) {
            this.defaultExportExtensions = new Hashtable(29);
        }
        this.saveFileChooser = new AnimalFileChooser(this);
        this.saveFileChooser.resetFilters();
        this.saveFileChooser.chooser.removeChoosableFileFilter(this.loadFileChooser.chooser.getAcceptAllFileFilter());
        if (handlers != null) {
            Enumeration<Object> exportKeys = handlers.keys();
            Vector<String> formats = new Vector<String>(37);
            int cutPosition = "export.".length();
            while (exportKeys.hasMoreElements()) {
                String key = (String)exportKeys.nextElement();
                String formatKey = key.toLowerCase().substring(cutPosition);
                this.insertExportFilter(key.toLowerCase().substring(cutPosition), handlers.getProperty(key));
                formats.add(formatKey);
            }
            Object[] supportedFormats = new String[formats.size()];
            formats.copyInto(supportedFormats);
        }
        this.saveFileChooser.chooser.setFileFilter(this.saveFileChooser.chooser.getChoosableFileFilters()[0]);
        AnimationExporter.animalConfig = this;
    }

    public void insertImportFilter(String formatName, String handlerName) {
        AnimationImporter handler = null;
        try {
            Class<?> c = Class.forName(handlerName);
            handler = (AnimationImporter)c.newInstance();
            if (handler != null) {
                handler.init(formatName);
                this.loadFileChooser.addFilter(handler.getDefaultExtension(), formatName);
                this.registeredImportFormats.put(formatName, handlerName);
                this.defaultImportExtensions.put(handler.getDefaultExtension(), handler);
                Animal.advanceProgressDisplayBy(this.incrementValue);
            }
        }
        catch (Exception e) {
            MessageDisplay.errorMsg("missingOrImproperImporter", new String[]{handlerName, formatName, e.getMessage()}, 4);
        }
    }

    public void insertExportFilter(String formatName, String handlerName) {
        AnimationExporter handler = null;
        AnimationExporter result = null;
        try {
            Class<?> c = Class.forName(handlerName);
            result = (AnimationExporter)c.newInstance();
        }
        catch (Exception e) {
            MessageDisplay.errorMsg("missingOrImproperImporter", new String[]{handlerName, formatName, e.getMessage()}, 4);
        }
        if (result != null) {
            handler = result;
        }
        if (handler != null) {
            handler.init(formatName);
            this.saveFileChooser.addFilter(handler.getDefaultExtension(), formatName);
            this.registeredExportFormats.put(formatName, handler);
            Animal.advanceProgressDisplayBy(this.incrementValue);
        }
    }

    public void setInitialized(boolean status) {
        this.isInitialized = status;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir != null && dir.length() >= 1 ? dir : ".";
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public void setCurrentFilename(String filename) {
        this.currentFilename = filename != null && filename.length() >= 1 ? filename : DEFAULT_FILENAME;
    }

    public String getCurrentFormat() {
        return this.currentFormat;
    }

    public void setCurrentFormat(String format) {
        this.currentFormat = format != null && format.length() >= 1 ? format : DEFAULT_FORMAT;
    }

    private boolean loadProperties() {
        InputStream is = null;
        Properties props = new Properties();
        try {
            is = this.getClass().getResourceAsStream("/default.properties");
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException ioExc) {
            MessageDisplay.errorMsg("couldNotLoadConfig", "default.properties", 2);
            return false;
        }
        try {
            is = this.getClass().getResourceAsStream("/animal.properties");
            if (is != null) {
                props.load(new BufferedInputStream(is));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("couldNotLoadConfig", "animal.properties", 2);
            return false;
        }
        this.animalProperties = new XProperties(props);
        this.setCurrentDirectory(this.animalProperties.getProperty("animal.defaultDirectory"));
        this.setCurrentFormat(this.animalProperties.getProperty("animal.fileFormat"));
        this.setCurrentFilename(this.animalProperties.getProperty("animal.filename"));
        return true;
    }

    public XProperties getProperties() {
        if (this.animalProperties == null) {
            this.loadProperties();
        }
        return this.animalProperties;
    }

    public Color getDefaultColor(String primitiveName, String key) {
        return this.getDefaultColor(String.valueOf(primitiveName) + "." + key, Color.BLACK);
    }

    public Color getDefaultColor(String primitiveName, String key, Color defaultColor) {
        return this.getDefaultColor(String.valueOf(primitiveName) + "." + key, defaultColor);
    }

    public Color getDefaultColor(String accessKey) {
        return this.getDefaultColor(accessKey, Color.BLACK);
    }

    public Color getDefaultColor(String accessKey, Color defaultColor) {
        return this.animalProperties.getColorProperty(accessKey, defaultColor);
    }

    public boolean getDefaultBooleanValue(String primitiveName, String key) {
        return this.getDefaultBooleanValue(String.valueOf(primitiveName) + "." + key, false);
    }

    public boolean getDefaultBooleanValue(String primitiveName, String key, boolean defaultValue) {
        return this.getDefaultBooleanValue(String.valueOf(primitiveName) + "." + key, defaultValue);
    }

    public boolean getDefaultBooleanValue(String accessKey) {
        return this.animalProperties.getBoolProperty(accessKey, false);
    }

    public boolean getDefaultBooleanValue(String accessKey, boolean defaultValue) {
        return this.animalProperties.getBoolProperty(accessKey, defaultValue);
    }

    public Font getDefaultFontValue(String accessKey) {
        return this.getDefaultFontValue(accessKey, this.lastFontUsed);
    }

    public Font getDefaultFontValue(String accessKey, Font defaultFont) {
        this.lastFontUsed = this.animalProperties.getFontProperty(accessKey, defaultFont);
        return this.lastFontUsed;
    }

    public Font getDefaultFontValue(String primitiveName, String key) {
        return this.getDefaultFontValue(String.valueOf(primitiveName) + "." + key, this.lastFontUsed);
    }

    public Font getDefaultFontValue(String primitiveName, String key, Font defaultValue) {
        return this.getDefaultFontValue(String.valueOf(primitiveName) + "." + key, defaultValue);
    }

    public int getDefaultIntValue(String primitiveName, String key) {
        return this.getDefaultIntValue(String.valueOf(primitiveName) + "." + key, 1);
    }

    public int getDefaultIntValue(String primitiveName, String key, int defaultValue) {
        return this.getDefaultIntValue(String.valueOf(primitiveName) + "." + key, defaultValue);
    }

    public int getDefaultIntValue(String accessKey) {
        return this.animalProperties.getIntProperty(accessKey, 1);
    }

    public int getDefaultIntValue(String accessKey, int defaultValue) {
        return this.animalProperties.getIntProperty(accessKey, defaultValue);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String fallBackValue) {
        return this.getProperties().getProperty(key, fallBackValue);
    }

    public String getVersionNumber() {
        if (this.versionInfo == null) {
            StringBuilder versionInfoBuffer = new StringBuilder(12);
            versionInfoBuffer.append(AnimalTranslator.translateMessage("version.major")).append('.');
            versionInfoBuffer.append(AnimalTranslator.translateMessage("version.minor")).append('.');
            versionInfoBuffer.append(AnimalTranslator.translateMessage("version.micro"));
            this.versionInfo = versionInfoBuffer.toString();
            Object var1_1 = null;
        }
        return this.versionInfo;
    }

    public String getVersionDate() {
        if (this.versionDate == null) {
            int year = new Integer(AnimalTranslator.translateMessage("version.year"));
            int month = new Integer(AnimalTranslator.translateMessage("version.month"));
            int day = new Integer(AnimalTranslator.translateMessage("version.day"));
            StringBuilder versionDateBuffer = new StringBuilder(20);
            versionDateBuffer.append(year).append('-').append(month);
            versionDateBuffer.append('-').append(day);
        }
        return this.versionDate;
    }

    public String getVersionLine() {
        return this.getVersionLine("versionInfoLine");
    }

    public String getVersionLine(String key) {
        String day = AnimalTranslator.translateMessage("version.day");
        String month = AnimalTranslator.translateMessage("version.month");
        String year = AnimalTranslator.translateMessage("version.year");
        String major = AnimalTranslator.translateMessage("version.major");
        String minor = AnimalTranslator.translateMessage("version.minor");
        String micro = AnimalTranslator.translateMessage("version.micro");
        return AnimalTranslator.translateMessage(key, new String[]{major, minor, micro, day, month, year});
    }

    public WindowCoordinator getWindowCoordinator() {
        return AnimalMainWindow.WINDOW_COORDINATOR;
    }

    public boolean validExportExtension(String extension) {
        return this.defaultExportExtensions.containsKey(extension.toLowerCase());
    }

    public boolean validExportFormat(String formatName) {
        return this.registeredExportFormats.containsKey(formatName.toLowerCase());
    }

    public boolean validImportExtension(String extension) {
        return this.defaultImportExtensions.containsKey(extension.toLowerCase());
    }

    public boolean validImportFormat(String formatName) {
        return this.registeredImportFormats.containsKey(formatName.toLowerCase());
    }

    public String[] getExportExtensions() {
        String[] extensions = new String[this.defaultExportExtensions.size()];
        Enumeration<String> extensionKeys = this.defaultExportExtensions.keys();
        int pos = 0;
        while (extensionKeys.hasMoreElements()) {
            String format = extensionKeys.nextElement();
            extensions[pos++] = format;
        }
        return extensions;
    }

    public AnimationExporter getExporterForExtension(String extensionName) {
        return this.defaultExportExtensions.get(extensionName);
    }

    public String[] getExportFormats() {
        String[] formatNames = new String[this.registeredExportFormats.size()];
        Enumeration<String> exportFormats = this.registeredExportFormats.keys();
        int pos = 0;
        while (exportFormats.hasMoreElements()) {
            String format = exportFormats.nextElement();
            formatNames[pos++] = format;
        }
        return formatNames;
    }

    public String[] getImportExtensions() {
        String[] extensions = new String[this.defaultImportExtensions.size()];
        Enumeration<String> extensionKeys = this.defaultImportExtensions.keys();
        int pos = 0;
        while (extensionKeys.hasMoreElements()) {
            String format = extensionKeys.nextElement();
            extensions[pos++] = format;
        }
        return extensions;
    }

    public AnimationImporter getImporterForExtension(String extensionName) {
        return this.defaultImportExtensions.get(extensionName);
    }

    public String[] getImportFormats() {
        String[] formatNames = new String[this.registeredImportFormats.size()];
        Enumeration<String> importFormats = this.registeredImportFormats.keys();
        int pos = 0;
        while (importFormats.hasMoreElements()) {
            String format = importFormats.nextElement();
            formatNames[pos++] = format;
        }
        return formatNames;
    }

    public AnimationExporter getExportHandlerFor(String formatName) {
        if (this.validExportFormat(formatName)) {
            return this.registeredExportFormats.get(formatName.toLowerCase());
        }
        MessageDisplay.errorMsg("unknownFormat", formatName, 4);
        return null;
    }

    public String getImportHandlerFor(String formatName) {
        if (this.validImportFormat(formatName)) {
            return this.registeredImportFormats.get(formatName.toLowerCase());
        }
        MessageDisplay.errorMsg("unknownFormat", formatName, 4);
        return null;
    }

    public BackendInterface getInteractionBackend() {
        return this.backend;
    }

    public void setInteractionBackend(BackendInterface backendInterface) {
        this.backend = backendInterface;
    }

    public void initDisplay() {
        WindowCoordinator wCoord = AnimalMainWindow.getWindowCoordinator();
        if (this.getProperties().getBoolProperty("animal.DrawWindowVisible")) {
            wCoord.getDrawWindow(true).setVisible(true);
        }
        if (this.getProperties().getBoolProperty("animal.AnimationWindowVisible")) {
            wCoord.getAnimationWindow(true).setVisible(true);
        }
        if (this.getProperties().getBoolProperty("animal.AnimationOverviewVisible")) {
            wCoord.getAnimationOverview(true).setVisible(true);
        }
        if (this.getProperties().getBoolProperty("animal.TimeLineWindowVisible")) {
            wCoord.getTimeLineWindow(true).setVisible(true);
        }
        if (this.getProperties().getBoolProperty("animal.ObjectsWindowVisible")) {
            wCoord.getObjectsWindow(true).setVisible(true);
        }
        if (this.getProperties().getBoolProperty("animal.AnnotationEditorVisible")) {
            wCoord.getAnnotationEditor(true).setVisible(true);
        }
    }

    public void setMouseType(int draw, int finish, int cancel) {
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).getDrawCanvas().setMouseType(draw, finish, cancel);
    }

    public boolean testIfUpToDate() {
        GregorianCalendar now = new GregorianCalendar();
        int year = new Integer(AnimalTranslator.translateMessage("version.year"));
        int month = new Integer(AnimalTranslator.translateMessage("version.month"));
        int day = new Integer(AnimalTranslator.translateMessage("version.day"));
        StringBuilder localVersionInfo = new StringBuilder(16);
        GregorianCalendar builtDate = new GregorianCalendar(year, month - 1, day);
        long difference = now.getTimeInMillis() - builtDate.getTimeInMillis();
        long nrDays = difference / 86400000L;
        long nrMonths = nrDays / 30L;
        localVersionInfo.append(AnimalTranslator.translateMessage("version.major")).append('.');
        localVersionInfo.append(AnimalTranslator.translateMessage("version.minor")).append('.');
        localVersionInfo.append(AnimalTranslator.translateMessage("version.micro"));
        if (nrMonths >= 6L) {
            String message = AnimalTranslator.translateMessage("checkForNewVersion", new String[]{localVersionInfo.toString(), String.valueOf(year), String.valueOf(month), String.valueOf(day), String.valueOf(now.get(1)), String.valueOf(now.get(2) + 1), String.valueOf(now.get(5)), String.valueOf(nrDays), String.valueOf(nrMonths)});
            MessageDisplay.message(message);
        }
        return true;
    }
}

