/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.animator.Animator;
import animal.graphics.PTGraphicObject;
import animal.handler.GraphicObjectHandlerExtension;
import animal.misc.MessageDisplay;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Vector;
import translator.AnimalTranslator;

public abstract class GraphicObjectHandler {
    protected static Hashtable<String, Vector<GraphicObjectHandlerExtension>> registeredHandlerExtensions = new Hashtable(47);

    public void addExtensionMethodsFor(PTGraphicObject ptgo, Object object, Vector<String> methodVector) {
        String key;
        Vector<GraphicObjectHandlerExtension> o;
        if (registeredHandlerExtensions != null && (o = registeredHandlerExtensions.get(key = ptgo.getType())) != null && o instanceof Vector) {
            Vector<GraphicObjectHandlerExtension> v = o;
            Vector<String> extensionVector = null;
            GraphicObjectHandlerExtension possibleHandler = null;
            GraphicObjectHandlerExtension extensionHandler = null;
            int i = 0;
            while (i < v.size()) {
                possibleHandler = v.elementAt(i);
                if (possibleHandler != null && possibleHandler instanceof GraphicObjectHandlerExtension) {
                    extensionHandler = possibleHandler;
                    extensionVector = extensionHandler.getMethods(ptgo, object);
                    methodVector.addAll(extensionVector);
                    extensionVector = null;
                    extensionHandler = null;
                }
                ++i;
            }
        }
    }

    public abstract Vector<String> getMethods(PTGraphicObject var1, Object var2);

    public static void insertHandlerExtension(GraphicObjectHandlerExtension handler) {
        if (handler == null) {
            return;
        }
        if (registeredHandlerExtensions == null) {
            registeredHandlerExtensions = new Hashtable(47);
        }
        String key = handler.getType();
        Vector<GraphicObjectHandlerExtension> entryVector = null;
        if (!registeredHandlerExtensions.containsKey(key)) {
            entryVector = new Vector(50, 15);
            entryVector.addElement(handler);
            registeredHandlerExtensions.put(key, entryVector);
        } else {
            entryVector = registeredHandlerExtensions.get(key);
            entryVector.addElement(handler);
        }
    }

    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        String what = e.getPropertyName();
        if (!what.equalsIgnoreCase("hide") && !what.equalsIgnoreCase("show")) {
            Vector<GraphicObjectHandlerExtension> v = null;
            if (registeredHandlerExtensions != null && (v = registeredHandlerExtensions.get(ptgo.getType())) != null && v instanceof Vector) {
                Vector<GraphicObjectHandlerExtension> handlers = v;
                int i = 0;
                int nr = handlers.size();
                while (i < nr) {
                    if (handlers.elementAt(i) instanceof GraphicObjectHandlerExtension) {
                        handlers.elementAt(i).propertyChange(ptgo, e);
                    }
                    ++i;
                }
            } else {
                StringBuilder sb = new StringBuilder(200);
                if (e.getSource() instanceof Animator) {
                    sb.append("Step ").append(((Animator)e.getSource()).getStep()).append(": ");
                }
                sb.append(AnimalTranslator.translateMessage("propertyChangeNotSupported", new Object[]{this.getClass().getName(), e.getPropertyName()}));
                MessageDisplay.errorMsg(sb.toString(), 16);
            }
        }
    }
}

