/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.gui.DrawWindow;
import animal.main.AnimationWindow;
import animal.main.ObjectPanel;
import animal.misc.MessageDisplay;
import animal.misc.ObjectSelectionButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class DrawControlsToolbar
extends JToolBar
implements ActionListener,
ItemListener {
    private static final String[] DEFAULT_MAGS = new String[]{"50%", "71%", "100%", "141%", "200%"};
    private static final long serialVersionUID = 2090022041469078494L;
    protected DrawWindow drawingWindow = null;
    private JComboBox choiceGrid;
    protected AbstractButton snapButton;
    protected AbstractButton showTempObjectsButton;
    protected AbstractButton repaintButton;
    protected AbstractButton undoButton;
    protected AbstractButton redoButton;
    protected AbstractButton cloneButton;
    protected AbstractButton deleteButton;
    protected AbstractButton writeBackButton;
    protected AbstractButton runStepButton;
    protected AbstractButton prevStepButton;
    protected AbstractButton nextStepButton;
    protected JTextField stepTF;
    protected JComboBox magnificationCB;
    protected ObjectPanel objectPanel;
    private boolean oldMultiSelection;
    private boolean oldUseEditors;

    public DrawControlsToolbar(DrawWindow aDrawWindow, ObjectPanel objects) {
        this.drawingWindow = aDrawWindow;
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addSeparator();
        this.add(this.buildCloneDeleteButtons(generator));
        this.add(this.buildUndoRedoButtons(generator));
        this.add(this.buildUpdateButtons(generator));
        this.addSeparator();
        this.add(this.buildGridBox(generator));
        this.add(this.buildDisplayComponents(generator));
        this.addSeparator();
        this.add(this.buildNavigationElements(generator));
        this.setSelection(false, false, false, null);
        this.addSeparator();
        this.objectPanel = objects;
        this.add(this.objectPanel);
    }

    private Box buildNavigationElements(TranslatableGUIElement generator) {
        Box contentBox = new Box(2);
        this.prevStepButton = generator.generateJButton("prevStep", null, false, this);
        contentBox.add(this.prevStepButton);
        this.stepTF = generator.generateJTextField("stepChoice", null, 3, "1");
        this.stepTF.setMinimumSize(new Dimension(30, 20));
        this.stepTF.addActionListener(this);
        contentBox.add(this.stepTF);
        this.nextStepButton = generator.generateJButton("nextStep", null, false, this);
        contentBox.add(this.nextStepButton);
        return contentBox;
    }

    private Box buildCloneDeleteButtons(TranslatableGUIElement generator) {
        Box contentBox = new Box(2);
        this.cloneButton = generator.generateJButton("clone", null, false, this);
        contentBox.add(this.cloneButton);
        this.deleteButton = generator.generateJButton("delete", null, false, this);
        contentBox.add(this.deleteButton);
        return contentBox;
    }

    private Box buildUpdateButtons(TranslatableGUIElement generator) {
        Box contentBox = new Box(2);
        this.writeBackButton = generator.generateJButton("writeBack", null, false, this);
        contentBox.add(this.writeBackButton);
        this.runStepButton = generator.generateJButton("runStep", null, false, this);
        contentBox.add(this.runStepButton);
        return contentBox;
    }

    private Box buildUndoRedoButtons(TranslatableGUIElement generator) {
        Box contentBox = new Box(2);
        this.undoButton = generator.generateJButton("undo", null, false, this);
        contentBox.add(this.undoButton);
        this.redoButton = generator.generateJButton("redo", null, false, this);
        contentBox.add(this.redoButton);
        return contentBox;
    }

    private Box buildDisplayComponents(TranslatableGUIElement generator) {
        Box contentBox = new Box(2);
        this.showTempObjectsButton = generator.generateJButton("showTempMode", null, true, this);
        this.showTempObjectsButton.setSelected(true);
        contentBox.add(this.showTempObjectsButton);
        this.repaintButton = generator.generateJButton("repaint", null, false, this);
        contentBox.add(this.repaintButton);
        this.magnificationCB = generator.generateJComboBox("magnificationBox", null, DEFAULT_MAGS, DEFAULT_MAGS[2]);
        contentBox.add(this.magnificationCB);
        this.magnificationCB.addActionListener(this);
        return contentBox;
    }

    private Box buildGridBox(TranslatableGUIElement generator) {
        Box contentBox = new Box(2);
        this.choiceGrid = generator.generateJComboBox("gridBox", null, new String[]{"0", "5", "10", "20", "25", "50"}, String.valueOf(this.drawingWindow.getDrawCanvas().getGrid()));
        contentBox.add(this.choiceGrid);
        this.snapButton = generator.generateJButton("snapMode", null, true, this);
        this.snapButton.setSelected(this.drawingWindow.getDrawCanvas().isSnap());
        contentBox.add(this.snapButton);
        this.choiceGrid.addItemListener(this);
        return contentBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.magnificationCB) {
            int i;
            String s = (String)this.magnificationCB.getSelectedItem();
            s = s.substring(0, s.length() - 1);
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e2) {
                MessageDisplay.errorMsg("illegalMagnification", s, 16);
                i = 1;
            }
            double factor = 0.01 * (double)i;
            this.drawingWindow.getDrawCanvas().setMagnification(factor);
        } else if (object == this.deleteButton) {
            this.drawingWindow.getDrawCanvas().deleteSelected();
        } else if (object == this.snapButton) {
            this.drawingWindow.getDrawCanvas().setSnap(this.snapButton.isSelected());
        } else if (object == this.showTempObjectsButton) {
            this.drawingWindow.getDrawCanvas().setShowTempObjects(this.showTempObjectsButton.isSelected());
        } else if (object == this.cloneButton) {
            this.drawingWindow.getDrawCanvas().cloneSelectedObjects();
        } else if (object == this.writeBackButton) {
            this.drawingWindow.setChanged();
            this.drawingWindow.writeBack();
        } else if (object == this.repaintButton) {
            this.drawingWindow.getDrawCanvas().repaintAll();
        } else if (object == this.undoButton) {
            this.drawingWindow.getDrawCanvas().getUndoAdapter().undo();
        } else if (object == this.redoButton) {
            this.drawingWindow.getDrawCanvas().getUndoAdapter().redo();
        } else if (object == this.prevStepButton) {
            this.drawingWindow.setStep(this.drawingWindow.getAnimationState().getPrevStep());
        } else if (object == this.nextStepButton) {
            int next = this.drawingWindow.getAnimationState().getNextStep();
            if (next != Integer.MAX_VALUE) {
                this.drawingWindow.setStep(next);
            }
        } else if (object == this.runStepButton) {
            AnimationWindow animWin = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false);
            if (!animWin.isVisible()) {
                animWin.setVisible(true);
                this.requestFocus();
            }
            this.drawingWindow.writeBack();
            animWin.setStep(this.drawingWindow.getAnimationState().getStep(), false);
        } else if (object == this.stepTF) {
            try {
                if (!this.drawingWindow.setStep(Integer.parseInt(this.stepTF.getText()))) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, AnimalTranslator.translateMessage("notAValidStep", this.stepTF.getText()), AnimalTranslator.translateMessage("illegalStepNumberFormat"), 0);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String grid = (String)((JComboBox)e.getSource()).getSelectedItem();
        if (grid.equals("none")) {
            grid = "0";
        }
        this.drawingWindow.getDrawCanvas().setGrid(Integer.parseInt(grid));
    }

    void setSelection(boolean selection, boolean multiSelection, boolean useEditors, ObjectSelectionButton osb) {
        boolean enableButtons = selection && osb == null;
        this.deleteButton.setEnabled(enableButtons);
        if (selection) {
            this.drawingWindow.getObjectPanel().setCurrentEditor(null);
        }
        this.drawingWindow.getDrawCanvas().setSelection(selection, multiSelection, useEditors, osb);
    }

    void setSelection(boolean selection) {
        this.setSelection(selection, true, true, null);
    }

    public void setStep(int step) {
        this.stepTF.setText(String.valueOf(step));
    }

    void setExternalSelection(ObjectSelectionButton osb) {
        if (osb != null) {
            this.setSelection(true, osb.hasMultiSelection(), false, osb);
        } else {
            this.setSelection(true, this.oldMultiSelection, this.oldUseEditors, null);
        }
    }
}

